/*
 *	Copyright 1990 by Nicholas H. Briggs, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

/* LINTLIBRARY */

#include "mailer.h"
#ifdef	USE_YP
#include <rpc/rpc.h>
#include <netdb.h>
#include <sys/socket.h>
#include <rpcsvc/yp_prot.h>
#include <rpcsvc/ypclnt.h>
#include <ctype.h>
#include "search.h"

/*
 * Query a Yellow Pages database
 */



struct conscell *
search_yp(sip)
	struct search_info *sip;
{
	int yperr;
	char *valptr;
	int vallen;
	struct conscell *tmp;
	char *ypdomainptr = NULL;
	char ypdomainname[YPMAXDOMAIN];
	extern void die();

	/* use -f specification for default domain */
	if (sip->file != NULL) {
	  ypdomainptr = sip->file;
	  if (strlen(ypdomainptr) > YPMAXDOMAIN) {
	    fprintf(stderr, "search_yp: domain name `%.10s...' exceeds maximum length of %d\n",
		    ypdomainptr, YPMAXDOMAIN);
	    return NULL;
	  }
	}
	else {
	  ypdomainptr = ypdomainname;
	  if ((yperr = yp_get_default_domain(&ypdomainptr)) != 0) {
	    fprintf(stderr, "search_yp: %s.\n", yperr_string(yperr));
	    die(1, "yp_get_default_domain failure");
	  }
	}
	/* map name is specified as the subtype of the relation */

	if (sip->subtype == NULL || *(sip->subtype) == '\0') {
	  fprintf(stderr, "search_yp: missing map name for YP query!\n");
	  return NULL;
	} else if (strlen(sip->subtype) > YPMAXMAP) {
	  fprintf(stderr, "search_yp: map name `%.10s...' exceeds maximum length of %d\n",
		  sip->subtype, YPMAXMAP);
	  return NULL;
	}
	valptr = NULL;
	vallen = 0;
	yperr = yp_match(ypdomainptr, sip->subtype, sip->key,
			       strlen(sip->key), &valptr, &vallen);
decode_result:
	switch (yperr) {
	case 0:
	  while (isspace(*valptr) && (vallen > 0)) {
	    valptr++; vallen--;
	  }
	  return newstring((u_char *)strnsave(valptr, vallen));
	case YPERR_KEY:
	  /* occasionally the terminating NULL is included in the key (lose!)
	     so if we failed for "key not found" then try again with the NULL
	   */
	  valptr = NULL;
	  vallen = 0;
	  yperr = yp_match(ypdomainptr, sip->subtype, sip->key,
			   strlen(sip->key)+1, &valptr, &vallen);
	  if (yperr != YPERR_KEY)
	    goto decode_result;
	  return NULL;
	default:
	  fprintf(stderr, "search_yp: %s\n", yperr_string(yperr));
	  return NULL;
	}

}
#endif	/* USE_YP */
