#!/bin/sh
#
# ZMailer startup and maintenance commands
#
# Do not edit this file, instead edit the source in proto/zmailer.sh
#
#	Copyright 1990 by Rayan S. Zachariassen, all rights reserved.
#	This will be free software, but only when it is finished.
#
PATH=/bin:/usr/bin:/usr/ucb
ZCONFIG=/etc/zmailer.conf

export PATH

case "`echo "foo\c"`" in
foo)	eopt='' ; eeol='\c' ;;
*)	eopt='-n' ; eeol='' ;;
esac

. $ZCONFIG || exit 1

case $POSTOFFICE in
/*)	;;
*)	echo "$0: panic!! can't initialize from $ZCONFIG"
	exit 1
	;;
esac

# set up the default arguments
case $# in
0)	set -$- router scheduler smtpserver ;;
esac

KILL=

for op in $@
do
	shift
	case "$op" in
	kill|nuke)	# print nothing
		;;
	*)	case $KILL in
		-TERM)	echo $eopt "kill $eeol" ;;
		-KILL)	echo $eopt "nuke $eeol" ;;
		*)	echo $eopt "start $eeol" ;;
		esac
		echo $eopt "${op}... $eeol"
		;;
	esac
	case "$op" in
	router)		case $KILL in
			-*)	if [ -f $POSTOFFICE/.pid.$op ]; then
					kill $KILL `cat $POSTOFFICE/.pid.$op`
#				else
#					echo $eopt "(warning: no .pid.$op file) $eeol"
				fi ;;
			*)	$MAILBIN/router -dk ;;
			esac
			;;
	scheduler)	case $KILL in
			-*)	kill $KILL `cat $POSTOFFICE/.pid.$op` ;;
			*)	cd $POSTOFFICE/scheduler
				# must send signal to scheduler to make it
				# stop reading the directory for new files
				PIDFILE=.pid.scheduler
				if [ -f ../$PIDFILE ]; then
					kill -TERM `cat ../$PIDFILE` 2>/dev/null
#				else
#					echo $eopt "(warning: no $PIDFILE file) $eeol"
				fi
				for dir in `echo */. | sed -e 's:/.::g'`
				do
					/bin/rm -rf $dir
				done
				$MAILBIN/scheduler
				;;
			esac
			;;
	smtp*)		case $KILL in
			-*)	if [ -f $POSTOFFICE/.pid.$op ]; then
					kill $KILL `cat $POSTOFFICE/.pid.$op`
#				else
#					echo $eopt "(warning: no .pid.$op file) $eeol"
				fi ;;
			*)	cd / ; $MAILBIN/smtpserver $SMTPOPTIONS
				;;
			esac
			;;
	newaliases)     $MAILBIN/router -f $MAILBIN/newaliases
			;;
	kill|nuke)	case $# in
			0)	exec $0 $op router scheduler smtpserver ;;
			esac
			case $op in
			kill)	KILL="-TERM" ;;
			nuke)	KILL="-KILL" ;;
			esac
			;;
	resubmit)	(cd $POSTOFFICE/deferred &&
			 mv -i [0-9]* ../router) 2> /dev/null
			;;
	bootclean)	rm -f $POSTOFFICE/.pid.* 2> /dev/null
			;;
	cleanup)	(cd $POSTOFFICE ;
			 find public -type f -mtime +2 -print |
				xargs rm -f
			 find postman -type f -mtime +7 -name '[0-9]*' -print |
				xargs rm -f
			)
			;;
	*)		echo $0: unknown option: $op
			errflg=1
			;;
	esac
done
echo
case $errflg in
1)	echo Usage: $0 "[ router | scheduler | smtpserver | kill | resubmit | bootclean | cleanup ]"
	exit 1
	;;
esac
exit 0
