/*
 *	Copyright 1988 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

/*
 * Perhaps a single interface to discovering the real system name.
 */

#include <stdio.h>
#include "libsupport.h"
#if	defined(USE_HOSTS) || defined(USE_RESOLV)
#include <netdb.h>
#endif	/* USE_HOSTS */
#ifdef	USE_UNAME
#include <sys/utsname.h>
#endif	/* USE_UNAME */


int
getmyhostname(namebuf, len)
	char *namebuf;
	int len;
{
	extern char *strcpy();
	extern int strlen();
#if	defined(USE_HOSTS) || defined(USE_RESOLV)
	struct hostent *hp;
#endif	/* USE_HOSTS */
#ifdef	USE_UNAME
	struct utsname id;
	extern int uname();

	if (uname(&id) < 0)
		return -1;
	if (strlen(id.sysname) < len)
		(void) strcpy(namebuf, id.sysname);
#else	/* !USE_UNAME */
	extern int gethostname();
	
	if (gethostname(namebuf, len) < 0)
		return -1;
#endif	/* USE_UNAME */
#if	defined(USE_HOSTS) || defined(USE_RESOLV)
	if ((hp = gethostbyname(namebuf)) != NULL) {
		if (strlen(hp->h_name) < len)
			(void) strcpy(namebuf, hp->h_name);
	}
#endif	/* USE_HOSTS */
	return 0;
}

