/*
 * Table of known system calls
 * question marks represent system calls with dubious info. Some of these
 * have now been filled in.
 *
 * The format of the return string is "systemcallname(arg_chars)return_char"
 * where arg_chars is a list of single characters representing the type of
 * that argument, and return_char is a single character for the return type.
 * Recognised types are:
 *	d decimal	%ld
 *	s string	
 *	o octal		0%o
 *	p pointer	0x%p
 *	b buffer (following argument is assumed to be length of buffer)
 *	v void		(void)
 *	? heuristics
 *	u unsigned dec	%uld
 *
 * printargs_gen , printret_gen() uses the return string to format a default output.
 * It can be replaced with printargs_foo() to handle a particular system
 * call (ala sun strace)
 *
 * $Id: sysname.c,v 1.11 1993/12/09 08:53:55 anthony Exp $
 *
 */

#include "trace.h"
#define SYS_unknown -1
#define SYS_obsolete -2

/* ENTRIES ARE IN NUMERIC ORDER OF SYSCALL NUMBER! */

struct syscallent sysent[] = 
{
{ SYS_syscall , "syscall(uuuuuu)d" , 6 , printargs_gen , printret_gen } ,
{ SYS_exit , "exit(d)v" , 1 , printargs_gen , printret_gen } ,
{ SYS_fork , "fork()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_read , "read(dpd)d" , 3 , printargs_read , printret_read } ,
{ SYS_write , "write(dbd)d" , 3 , printargs_write , printret_gen } ,
{ SYS_obsolete , "old_open(sdo)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_close , "close(d)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_wait4 , "wait4(dpdp)d" , 4 , printargs_gen , printret_gen } ,
{ SYS_obsolete , "old_creat(so)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_link , "link(ss)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_unlink , "unlink(s)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_execv , "execv(sp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_chdir , "chdir(s)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_fchdir , "fchdir(d)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_mknod , "mknod(sdd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_chmod , "chmod(so)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_chown , "chown(sdd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_obreak , "obreak(p)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_getfsstat , "getfsstat(pdd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_lseek , "lseek(ddd)d" , 3 , printargs_lseek , printret_lseek } ,
{ SYS_getpid , "getpid()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_mount , "mount(dsdp)d" , 4 , printargs_gen , printret_gen } ,
{ SYS_unmount , "unmount(sd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_setuid , "setuid(d)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_getuid , "getuid()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_exec_with_loader , "exec_with_loader(dssss)d" , 5 , printargs_gen , printret_gen } ,
{ SYS_ptrace , "ptrace(ddpb)d" , 4 , printargs_gen , printret_gen } ,
{ SYS_recvmsg , "recvmsg(dpd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_sendmsg , "sendmsg(dpd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_recvfrom , "recvfrom(dbddpp)d" , 6 , printargs_recvfrom , printret_recvfrom } ,
{ SYS_accept , "accept(dpp)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_getpeername , "getpeername(dpp)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_getsockname , "getsockname(dpp)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_access , "access(so)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_chflags , "chflags(uu)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_fchflags , "fchflags(uu)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_sync , "sync()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_kill , "kill(dd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_obsolete , "old_stat(sp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_setpgid , "setpgid(dd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_obsolete , "old_lstat(sp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_dup , "dup(d)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_pipe , "pipe(p)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_set_program_attributes , "set_program_attributes(uuuu)d" , 4 , printargs_gen , printret_gen } ,
{ SYS_profil , "profil(pddd)d" , 4 , printargs_gen , printret_gen } ,
{ SYS_open , "open(sdo)d" , 3 , printargs_open , printret_open } ,
{ SYS_obsolete , "osigaction()d" , 0 , printargs_gen , printret_gen } ,   /* gone in 2.0 */
{ SYS_getgid , "getgid()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_sigprocmask , "sigprocmask(dpp)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_getlogin , "getlogin(sd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_setlogin , "setlogin(s)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_acct , "acct(s)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_sigpending , "sigpending(p)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_unknown , "sigaltstack()d" , 0 , printargs_gen , printret_gen } , /* sigaltstack */
{ SYS_ioctl , "ioctl(ddp)d" , 3 , printargs_ioctl , printret_ioctl } ,
{ SYS_reboot , "reboot(d)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_revoke , "revoke(s)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_symlink , "symlink(ss)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_readlink , "readlink(spd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_execve , "execve(spp)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_umask , "umask(o)o" , 1 , printargs_gen , printret_gen } ,
{ SYS_chroot , "chroot(s)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_obsolete , "old_fstat(dp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_getpgrp , "getpgrp()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_getpagesize , "getpagesize()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_mremap , "mremap(uuuuu)d" , 5 , printargs_gen , printret_gen } ,
{ SYS_vfork , "vfork()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_stat , "stat(sp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_lstat , "lstat(sp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_sbrk , "sbrk(d)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_sstk , "sstk(u)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_mmap , "mmap(pddpdp)p" , 6 , printargs_mmap , printret_mmap } ,
{ SYS_ovadvise , "ovadvise(u)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_munmap , "munmap(pd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_mprotect , "mprotect(pdd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_madvise , "madvise(pdd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_obsolete , "old_vhangup()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_kmodcall , "kmodcall(uuuuuu)d" , 6 , printargs_gen , printret_gen } ,
{ SYS_mincore , "mincore(uuu)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_getgroups , "getgroups(dp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_setgroups , "setgroups(dp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_obsolete , "old_getpgrp()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_setpgrp , "setpgrp(dd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_setitimer , "setitimer(dpp)d" , 3 , printargs_setitimer , printret_setitimer } ,
{ SYS_obsolete , "old_wait(p)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_table , "table(uuuuu)d" , 5 , printargs_table , printret_table } ,
{ SYS_getitimer , "getitimer(dp)d" , 2 , printargs_getitimer , printret_getitimer } ,
{ SYS_gethostname , "gethostname(sd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_sethostname , "sethostname(sd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_getdtablesize , "getdtablesize()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_dup2 , "dup2(dd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_fstat , "fstat(dp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_fcntl , "fcntl(ddp)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_select , "select(dpppp)d" , 5 , printargs_select , printret_select } ,
{ SYS_poll , "poll(pdd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_fsync , "fsync(dq)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_setpriority , "setpriority(ddd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_socket , "socket(ddd)d" , 3 , printargs_socket , printret_socket } ,
{ SYS_connect , "connect(dpd)d" , 3 , printargs_connect , printret_gen } ,
{ SYS_accept , "accept(dpp)d" , 3 , printargs_accept , printret_accept } ,
{ SYS_getpriority , "getpriority(dd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_send , "send(dpuu)d" , 4 , printargs_recv , printret_send } ,
{ SYS_recv , "recv(dpuu)d" , 4 , printargs_send , printret_recv } ,
{ SYS_sigreturn , "sigreturn(p)d" , 1 , printargs_sigreturn , printret_sigreturn } ,
{ SYS_bind , "bind(dpd)d" , 3 , printargs_bind , printret_gen } ,
{ SYS_setsockopt , "setsockopt(ddd?d)d" , 5 , printargs_gen , printret_gen } ,
{ SYS_listen , "listen(dd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_plock , "plock(d)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_obsolete , "old_sigvec()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_obsolete , "old_sigblock()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_obsolete , "old_sigsetmask()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_sigsuspend , "sigsuspend(p)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_sigstack , "sigstack(pp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_recvmsg , "recvmsg(dpd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_sendmsg , "sendmsg(dpd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_obsolete , "old_vtrace()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_gettimeofday , "gettimeofday(pp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_getrusage , "getrusage(dp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_getsockopt , "getsockopt(ddd?p)d" , 5 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_readv , "readv(dpd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_writev , "writev(dpd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_settimeofday , "settimeofday(pp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_fchown , "fchown(ddd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_fchmod , "fchmod(do)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_recvfrom , "recvfrom(dbddpp)d" , 6 , printargs_recvfrom , printret_recvfrom } ,
{ SYS_setreuid , "setreuid(dd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_setregid , "setregid(dd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_rename , "rename(ss)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_truncate , "truncate(sd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_ftruncate , "ftruncate(dd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_flock , "flock(dd)d" , 2 , printargs_flock , printret_flock } ,
{ SYS_setgid , "setgid(d)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_sendto , "sendto(dbddpd)d" , 6 , printargs_sendto , printret_sendto } ,
{ SYS_shutdown , "shutdown(dd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_socketpair , "socketpair(dddp)d" , 4 , printargs_gen , printret_gen } ,
{ SYS_mkdir , "mkdir(so)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_rmdir , "rmdir(s)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_utimes , "utimes(sp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_obsolete , "old_sigreturn()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_adjtime , "adjtime(pp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_getpeername , "getpeername(dpp)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_gethostid , "gethostid()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_sethostid , "sethostid(d)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_getrlimit , "getrlimit(dp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_setrlimit , "setrlimit(dp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_obsolete , "old_killpg()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_setsid , "setsid()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_quotactl , "quotactl(sddp)d" , 4 , printargs_gen , printret_gen } ,
{ SYS_oldquota , "oldquota(uuuu)d" , 4 , printargs_gen , printret_gen } ,
{ SYS_getsockname , "getsockname(dpp)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_sigaction , "sigaction(dpp)d" , 3 , printargs_sigaction , printret_sigaction } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_nfssvc , "nfssvc(ddd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_getdirentries , "getdirentries(dpdp)d" , 4 , printargs_gen , printret_gen } ,
{ SYS_statfs , "statfs(spd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_fstatfs , "fstatfs(dpd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_async_daemon , "async_daemon()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_getfh , "getfh(sp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_getdomainname , "getdomainname(sd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_setdomainname , "setdomainname(sd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_exportfs , "exportfs(dpp)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_getmnt , "getmnt(ppdds)d" , 5 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_swapon , "swapon(sddd)d" , 4 , printargs_gen , printret_gen } ,
{ SYS_msgctl , "msgctl(ddp)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_msgget , "msgget(dd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_msgrcv , "msgrcv(dpddd)d" , 5 , printargs_gen , printret_gen } ,
{ SYS_msgsnd , "msgsnd(dpdd)d" , 4 , printargs_gen , printret_gen } ,
{ SYS_semctl , "semctl(dddp)d" , 4 , printargs_gen , printret_gen } ,
{ SYS_semget , "semget(ddd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_semop , "semop(dpd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_uname , "uname(p)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_lchown , "lchown(sdd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_shmat , "shmat(dpd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_shmctl , "shmctl(ddp)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_shmdt , "shmdt(p)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_shmget , "shmget(ddd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_mvalid , "mvalid(pdd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_getaddressconf , "getaddressconf(pd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_msleep , "msleep(u)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_mwakeup , "mwakeup(u)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_msync , "msync(pdd)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_signal , "signal(dp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_utc_gettime , "utc_gettime(u)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_utc_adjtime , "utc_adjtime(uu)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unknown_call()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unk:security()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_kloadcall , "kloadcall(uuuuu)d" , 5 , printargs_gen , printret_gen } ,
{ SYS_unknown, "unk_224()d", 0,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk_225()d", 0,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk_226()d", 0,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk_227()d", 0,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk_228()d", 0,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk_229()d", 0,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk_230()d", 0,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk_231()d", 0,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk_232()d", 0,  printargs_gen , printret_gen } ,
{ SYS_getpgid , "getpgid(d)d" , 1 , printargs_gen , printret_gen } ,
{ SYS_getsid , "getsid()d" , 0 , printargs_gen , printret_gen } ,
{ SYS_unknown, "unk:sigaltstack(pp)d", 2,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk:waitid(ddpd)d", 4,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk:priocntlset(pd)d", 2,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk:sigsendset(pd)d", 2,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk:set_speculative()d", 0,  printargs_gen , printret_gen } ,
{ SYS_msfs_syscall , "msfs_syscall(uuu)d" , 3 , printargs_gen , printret_gen } ,
{ SYS_unknown, "unk:sysinfo(dpd)d", 2,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk:uadmin(ddd)d", 3,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk:fuser(pdpd)d", 4,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk:proplist_syscall()d", 0,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk_245()d", 0,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk_246()d", 0,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk_247()d", 0,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk_248()d", 0,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk_249()d", 0,  printargs_gen , printret_gen } ,
{ SYS_uswitch , "uswitch(dd)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_usleep_thread , "usleep_thread(pp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_unknown, "unk:audctl()d", 0,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk:audgen(dpppp)d", 5,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk:sysfs(dpp)d", 3,  printargs_gen , printret_gen } ,
{ SYS_unknown, "unk:subsys_info()d", 0,  printargs_gen , printret_gen } ,
{ SYS_getsysinfo , "getsysinfo(dpdpp)d" , 5 , printargs_gen , printret_gen } ,
{ SYS_setsysinfo , "setsysinfo(dpdpd)d" , 5 , printargs_gen , printret_gen } ,
{ SYS_afs_syscall , "afs_syscall(uuuuuu)d" , 6 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unk:swapctl(dp)d" , 2 , printargs_gen , printret_gen } ,
{ SYS_unknown , "unk:memcntl(pddpdd)d" , 6 , printargs_gen , printret_gen } ,
};
