/* 
 * Print routines for time oriented system calls.
 *
 * $Id: print_time.c,v 1.4 1993/11/23 04:14:40 anthony Exp $
 */
#include <stdlib.h>
#include "trace.h"
#include "sysname.h"

extern FILE *outfp;
extern int max_string;

#include <sys/time.h>
static struct itimerval *ovalue;

/*
 *   int setitimer(
 *        int which,                    // which timer
 *        struct itimerval *value,      // new value 
 *        struct itimerval *ovalue) ;   // if non-zero, stores old value
 *    struct itimerval {
 *        struct timeval it_interval;   // reload val when curr timer expires 
 *        struct timeval it_value;      // time to next timer expiry
 *    };
 *    struct timeval {
 *        int tv_sec;                   // seconds
 *        int tv_usec;                  // microseconds
 *    };
 */
   
int printargs_setitimer(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
    int which=sysArgs[0];
    char *whichstr;
    struct itimerval *value = (struct itimerval *)rd_buf(sysArgs[1],sizeof(struct itimerval));

    ovalue = (struct itimerval *)sysArgs[2];   /* store away */

    switch(which) {
	case ITIMER_REAL:    whichstr="ITIMER_REAL"; break;
	case ITIMER_VIRTUAL: whichstr="ITIMER_VIRTUAL"; break;
	case ITIMER_PROF:    whichstr="ITIMER_PROF"; break;
	default: sprintf(whichstr,"?%d?",which);
    }
    fprintf(outfp,"setitimer (%s, {{%d,%d}, {%d,%d}}, ",whichstr,
		value->it_interval.tv_sec,value->it_interval.tv_usec,
		value->it_value.tv_sec,value->it_value.tv_usec);

    free(value);
}

int printret_setitimer(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{
    if(sysReturn!=-1)
	if(ovalue!=(struct itimerval *)0) {
    	    struct itimerval *oldvalue = 
		(struct itimerval *)rd_buf((long)ovalue,sizeof(struct itimerval));
	    fprintf(outfp,"{{%d,%d},{%d,%d}}) = %d\n",
		oldvalue->it_interval.tv_sec,oldvalue->it_interval.tv_usec,
		oldvalue->it_value.tv_sec,oldvalue->it_value.tv_usec,
		(int)sysReturn);
	    free(oldvalue);
	} else
	    fprintf(outfp,"(struct itimerval *)0) = %d\n",
		(int)sysReturn);
    else
	fprintf(outfp,"(struct itimerval *)0) = -1 (%s)\n",
		sys_errlist[sysErrno]);
    return(1);
} 

int printargs_getitimer(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
    int which=sysArgs[0];
    char *whichstr;

    ovalue = (struct itimerval *)sysArgs[1];   /* store away */

    switch(which) {
	case ITIMER_REAL:    whichstr="ITIMER_REAL"; break;
	case ITIMER_VIRTUAL: whichstr="ITIMER_VIRTUAL"; break;
	case ITIMER_PROF:    whichstr="ITIMER_PROF"; break;
	default: sprintf(whichstr,"?%d?",which);
    }
    fprintf(outfp,"getitimer (%s, ",whichstr);
    return(1);
}

int printret_getitimer(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{
    printret_setitimer(sysCallno, sysReturn, sysErrno, sysArgs);
}
