/* 
 * Output for signal routines - sigaction, sigreturn
 * $Id: print_signals.c,v 1.1 1993/11/23 03:16:07 anthony Exp $
 */

/* 
 * Output for sigaction.
 * 13/9/93 jkb
 */
#include <stdlib.h>
#include "trace.h"
#include "sysname.h"

#include <signal.h>

extern char *sig_name[];
extern FILE *outfp;
extern int max_string;

static void print_sastruct(struct sigaction *action) {
    if (action == (struct sigaction *)0) {
	fprintf(outfp, "(struct sigaction *)0");
    } else {
	char *hack = "";

	action=(struct sigaction *)rd_buf((long)action,sizeof(struct sigaction));

	fprintf(outfp, "{{0x%p,0x%x,",
		action->sa_handler,
		action->sa_mask,
		action->sa_flags);
	if (action->sa_flags == 0) {
	    fprintf(outfp, "0");
	} else {
	    if (action->sa_flags & SA_ONSTACK)
		fprintf(outfp, "SA_ONSTACK"), hack="| ";
	    if (action->sa_flags & SA_RESTART)
		fprintf(outfp, "%sSA_RESTART", hack), hack="| ";
	    if (action->sa_flags & SA_NOCLDSTOP)
		fprintf(outfp, "%sSA_NOCLDSTOP", hack);
	}

	fprintf(outfp, "}}");

	free(action);
    }
}


/*
 * int sigaction (
 *      int signal,
 *      const struct sigaction *action,
 *      struct sigaction *o_action );
 */
int printargs_sigaction(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{

    fprintf(outfp, "sigaction (%s, ", sig_name[sysArgs[0]]);
    print_sastruct((struct sigaction *)sysArgs[1]);
    fprintf(outfp, ", ");
    print_sastruct((struct sigaction *)sysArgs[2]);
    fprintf(outfp, ") = ");
    return 1;
}

/* 
 * Arguments are:
 *  sysCallno:  the number of the system call.
 *  sysReturn:  what it returned.
 *   sysErrno:  errno, if system call failed, else 0.
 */
int printret_sigaction(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{
    if(sysReturn!=-1)
	fprintf(outfp,"%d\n",(int)sysReturn);
    else
	fprintf(outfp,"-1 (%s)\n",sys_errlist[sysErrno]);
    return(1);
} 

/* 
 * Output for sigreturn. This is kinda strange, since its not always
 * going to return.
 */

int printargs_sigreturn(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
    fprintf(outfp,"sigreturn (0x%p)",sysArgs[0]);
    return 1;
}

int printret_sigreturn(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{
    if(sysErrno == -2)
	fprintf(outfp,"\n");
    else
	fprintf(outfp," = %d (%s)",sysErrno,sys_errlist[sysErrno]);
    return 1;
} 
