/* 
 * Template for print_ routines.
 *
 *
 *
 */
#include "trace.h"
#include "sysname.h"
#define _SOCKADDR_LEN	/* OSF/1 v3.2 (3.0?) got enchanged sockaddr.. */
#include <sys/socket.h>	/* struct sockaddr	*/
#include <netinet/in.h>	/* struct sockaddr_in	*/
#include <sys/un.h>	/* struct sockaddr_un	*/
#include <arpa/inet.h>

extern FILE *outfp;
extern int max_string;


static char * af_to_str(int addr_family)
{
    switch(addr_family) {
	case AF_UNIX:     return "AF_UNIX"; break;
	case AF_INET:     return "AF_INET"; break;
	case AF_IMPLINK:  return "AF_IMPLINK"; break;
	case AF_PUP:      return "AF_PUP"; break;
	case AF_CHAOS:    return "AF_CHAOS"; break;
	case AF_NS:       return "AF_NS"; break;
	case AF_ISO:      return "AF_ISO"; break;
	case AF_ECMA:     return "AF_ECMA"; break;
	case AF_DATAKIT:  return "AF_DATAKIT"; break;
	case AF_CCITT:    return "AF_CCITT"; break;
	case AF_SNA:      return "AF_SNA"; break;
	case AF_DECnet:   return "AF_DEC"; break;
	case AF_DLI:      return "AF_DLI"; break;
	case AF_LAT:      return "AF_LAT"; break;
	case AF_HYLINK:   return "AF_HYLINK"; break;
	case AF_APPLETALK: return "AF_APPLETALK"; break;
	case AF_ROUTE:    return "AF_ROUTE"; break;
	case AF_LINK:     return "AF_LINK"; break;
	case pseudo_AF_XTP: return "pseudo_AF_XTP"; break;
	case AF_NETMAN:   return "AF_NETMAN"; break;
	case AF_X25:      return "AF_X25"; break;
	case AF_CTF:      return "AF_CTF"; break;
	case AF_WAN:      return "AF_WAN"; break;
	default:          return "AF_???"; break;
    }
}

static char * socktype_to_str(int type)
{
    switch(type) {
	case SOCK_STREAM: return "STREAM"; break;
	case SOCK_DGRAM: return "DGRAM"; break;
	case SOCK_RAW:   return "RAW"; break;
	default: return "SOCK_???"; break;
    }
}

static char *protocol_to_str(int protocol)
{
    switch(protocol) {
	case PF_UNSPEC: return "PF_UNSPEC"; break;       
	case PF_UNIX: return "PF_UNIX"; break;        
	case PF_INET: return "PF_INET"; break;       
	case PF_IMPLINK: return "PF_IMPLINK"; break;   
	case PF_PUP: return "PF_PUP"; break;      
	case PF_CHAOS: return "PF_CHAOS"; break;   
	case PF_NS: return "PF_NS"; break;          
	case PF_ISO: return "PF_ISO"; break;         
	case PF_ECMA: return "PF_ECMA"; break;      
	case PF_DATAKIT: return "PF_DATAKIT"; break;  
	case PF_CCITT: return "PF_CCITT"; break;   
	case PF_SNA: return "PF_SNA"; break;    
	case PF_DECnet: return "PF_DECnet"; break; 
	case PF_DLI: return "PF_DLI"; break;   
	case PF_LAT: return "PF_LAT"; break;  
	case PF_HYLINK: return "PF_HYLINK"; break; 
	case PF_APPLETALK: return "PF_APPLETALK"; break;  
	case PF_ROUTE: return "PF_ROUTE"; break;     
	case PF_LINK: return "PF_LINK"; break;     
	case PF_XTP: return "PF_XTP"; break;     
	case PF_NETMAN: return "PF_NETMAN"; break; 
	case PF_X25: return "PF_X25"; break;   
	case PF_CTF: return "PF_CTF"; break;  
	case PF_WAN: return "PF_WAN"; break; 
	default: return "PF_???"; break;
    }
}

static void sockaddr_to_str(char *buf, struct sockaddr *address, int address_len)
{
	int family;
	int newfmt = 0;

	struct	osockaddr_un {
		u_short	sun_family;		/* AF_UNIX */
		char	sun_path[104];		/* path name */
	};
	struct osockaddr_in {
		u_short	sin_family;
		u_short	sin_port;
		struct	in_addr sin_addr;
		char	sin_zero[8];
	};

	if (address == NULL) {
	  strcpy(buf,"<NULL>");
	  return;
	}

	family = address->sa_family;
	if (address->sa_len != 0 && address->sa_family != 0) {
	  /* New-style sockaddr */
	  newfmt = 1;
	} else {
	  /* old style -- pre BSD-4.4 */
	  struct osockaddr *oaddr = (struct osockaddr *)address;
	  family = oaddr->sa_family;
	}

	switch (family) {
	    case AF_UNIX:
		if (newfmt) {
		  struct sockaddr_un *us = (struct sockaddr_un*)address;
		  sprintf(buf,"{%d,%s,\"%s\"}",
			  us->sun_len,af_to_str(us->sun_family),
			  us->sun_path);
		} else {
		  struct osockaddr_un *us = (struct osockaddr_un*)address;
		  sprintf(buf,"{%s,\"%s\"}",
			  af_to_str(us->sun_family),us->sun_path);
		}
		break;
	    case AF_INET:
		if (newfmt) {
		  struct sockaddr_in *is = (struct sockaddr_in*)address;
		  sprintf(buf,"{%d,%s,%d,%s}",
			  is->sin_len, af_to_str(is->sin_family),
			  ntohs(is->sin_port),inet_ntoa(is->sin_addr));
		} else {
		  struct osockaddr_in *is = (struct osockaddr_in*)address;
		  sprintf(buf,"{%s,%d,%s}",
			  af_to_str(is->sin_family),
			  ntohs(is->sin_port),inet_ntoa(is->sin_addr));
		}
		break;
	    default:
		if (newfmt) {
		  int i;
		  char *s;
		  sprintf(buf,"{%d,%s",
			  address->sa_len,af_to_str(address->sa_family));
		  s = buf + strlen(buf);
		  for (i = 0; i < address->sa_len; ++i)
		    sprintf(s+i*3,",%02x",address->sa_data[i]);
		  strcat(buf,"}");
		} else {
		  int i;
		  char *s;
		  sprintf(buf,"{%s",af_to_str(address->sa_family));
		  s = buf + strlen(buf);
		  for (i = 0; i < address_len-2; ++i)
		    sprintf(s+i*3,",%02x",address->sa_data[i]);
		  strcat(buf,"}");
		}
		break;
	}

}


/* socket(int addr_family, int type, int protocol); */
int printargs_socket(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
    int addr_family=sysArgs[0], type=sysArgs[1], protocol=sysArgs[2];
    char *famname, *typname, *protname;

    famname = af_to_str(addr_family);
    typname = socktype_to_str(type);
    protname = protocol_to_str(protocol);

    fprintf(outfp,"socket (%s,%s,%s) = ",famname,typname,protname);

    return(1);
}

int printret_socket(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{
    if(sysReturn!=-1)
	fprintf(outfp,"%d\n",(int)sysReturn);
    else
	fprintf(outfp,"-1 (%s)\n",sys_errlist[sysErrno]);
    return(1);
} 

/* connect(int socket, struct sockaddr *address, int address_len); */
int printargs_connect(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
    int socket = sysArgs[0], address_len = sysArgs[2];
    struct sockaddr *address = (void*)sysArgs[1];
    char sockaddrstr[256];
    char *sockaddrbuf = rd_buf((long)address, address_len);

    sockaddr_to_str(sockaddrstr,(void*)sockaddrbuf,address_len);
    free(sockaddrbuf);
    fprintf(outfp,"connect (%d,%p %s,%d) = ",
	    socket, address, sockaddrstr, address_len);
    return 1;
}

/* accept(int socket, struct sockaddr *address, int *address_len) */
int printargs_accept(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
	long address = sysArgs[1];
	if (address == 0)
	  fprintf(outfp,"accept (%d,NULL,xx) = ",sysArgs[0]);
	else {
	  long address_lenp = sysArgs[2];
	  int address_len;
	  char *buf = rd_buf(address_lenp,sizeof(long));
	  address_len = *(int*)buf;
	  free(buf);
	  fprintf(outfp,"accept (%d,%p,%p[%d]) = ",
		  sysArgs[0],address,address_lenp,address_len);
	}
	return 1;
}

int printret_accept(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{
    if(sysReturn!=-1) {

	long address_lenp = sysArgs[2];
	struct sockaddr *address = (void*)sysArgs[1];

	if (address != NULL) {
	  char sockaddrstr[256];
	  char * sockaddrbuf;
	  int address_len;

	  sockaddrbuf = rd_buf(address_lenp,sizeof(long));
	  address_len = *(int*)sockaddrbuf;
	  free(sockaddrbuf);

	  sockaddrbuf = rd_buf((long)address,address_len);
	  sockaddr_to_str(sockaddrstr,(void*)sockaddrbuf,address_len);
	  free(sockaddrbuf);

	  fprintf(outfp,"%d [addr=%s,%d]\n",
		  (int)sysReturn, sockaddrstr, address_len);
	} else {
	  fprintf(outfp,"%d\n",(int)sysReturn);
	}
    } else
	fprintf(outfp,"-1 (%s)\n",sys_errlist[sysErrno]);
    return 1;
}

/* bind(int socket, struct sockaddr *address, int address_len) */
int printargs_bind(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
    int socket = sysArgs[0], address_len = sysArgs[2];
    struct sockaddr *address = (void*)sysArgs[1];
    char sockaddrstr[256];
    char * sockaddrbuf;

    sockaddrbuf = rd_buf(sysArgs[1],address_len);
    sockaddr_to_str(sockaddrstr,(void*)sockaddrbuf,address_len);
    free(sockaddrbuf);

    fprintf(outfp,"bind (%d,%p %s,%d) = ",
	    socket, address, sockaddrstr, address_len);
    return 1;
}


static void print_selset(outfp, addr, nfds)
FILE *outfp;
long addr;
int nfds;
{
    if (addr == 0) {
      fprintf(outfp,"NULL, ");
    } else {
      fd_set *selset = (fd_set*)rd_buf(addr,sizeof(fd_set));
      int first = -1;
      int i;
      char *comma = "";

      fprintf(outfp,"0x%p [",addr);

      for (i = 0; i < nfds; ++i) {
	if (FD_ISSET(i,selset)) {
	  if (first < 0)
	    first = i;
	} else {
	  if (first >= 0) {
	    if (first == (i-1)) {
	      fprintf(outfp,"%s%d",comma,first);
	    } else {
	      fprintf(outfp,"%s%d-%d",comma,first,i-1);
	    }
	    comma = ",";
	    first = -1;
	  }
	}
      } /* for nfds bits .. */
      if (first > 0) {
	i = nfds - 1;
	if (first == (i-1)) {
	  fprintf(outfp,"%s%d",comma,first);
	} else {
	  fprintf(outfp,"%s%d-%d",comma,first,i-1);
	}
      }
      fprintf(outfp,"], ");
    }
}

static int nfds;
static long readaddr, writeaddr, exceptaddr, timeoutaddr;

/* select(int nfds, fd_set *readset, fd_set *writeset, fd_set exceptset, struct timeval *timeout) */
int printargs_select(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{

    nfds = sysArgs[0];
    readaddr = sysArgs[1];
    writeaddr = sysArgs[2];
    exceptaddr = sysArgs[3];
    timeoutaddr = sysArgs[4];

    fprintf(outfp,"select (%d, ",  nfds);
    print_selset(outfp,readaddr,   nfds);
    print_selset(outfp,writeaddr,  nfds);
    print_selset(outfp,exceptaddr, nfds);

    if (timeoutaddr) {
      struct timeval *tvp = (struct timeval *)rd_buf(timeoutaddr,sizeof(struct timeval));
      fprintf(outfp,"0x%p [%ld.%ld]) = ", timeoutaddr, tvp->tv_sec, tvp->tv_usec);
      
    } else {
      fprintf(outfp,"NULL) = ");
    }

    return(1);
}

int printret_select(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{

    if(sysReturn!=-1)
	fprintf(outfp,"%d",(int)sysReturn);
    else
	fprintf(outfp,"-1 (%s)",sys_errlist[sysErrno]);

    fprintf(outfp," <");
    print_selset(outfp,readaddr,   nfds);
    print_selset(outfp,writeaddr,  nfds);
    print_selset(outfp,exceptaddr, nfds);

    if (timeoutaddr) {
      struct timeval *tvp = (struct timeval *)rd_buf(timeoutaddr,sizeof(struct timeval));
      fprintf(outfp,"0x%p [%ld.%ld]", timeoutaddr, tvp->tv_sec, tvp->tv_usec);
      
    } else {
      fprintf(outfp,"NULL");
    }
    fprintf(outfp,">\n");
    return(1);
} 

static void print_msgflags(int flags)
{
	if (flags == 0)
	  fprintf(outfp, "0");
	else {
	  const char *bar = "";
	  if (flags & MSG_OOB) {
	    fprintf(outfp,"MSG_OOB");
	    bar = "|";
	  }
	  if (flags & MSG_PEEK) {
	    fprintf(outfp,"%sMSG_PEEK",bar);
	    bar = "|";
	  }
	  if (flags & MSG_DONTROUTE) {
	    fprintf(outfp,"%sMSG_DONTROUTE",bar);
	    bar = "|";
	  }
	}
}

	/* int send(int s, const char *msg, int len, int flags) */
int printargs_send(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
	fprintf(outfp,"send (%d, %p, %d, ", sysArgs[0],sysArgs[1],sysArgs[2]);
	print_msgflags(sysArgs[3]);
	fprintf(outfp,") = ");
	return 1;
}
int printret_send(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{

    if(sysReturn!=-1)
	fprintf(outfp,"%d",(int)sysReturn);
    else
	fprintf(outfp,"-1 (%s)",sys_errlist[sysErrno]);
    return 1;
}


	/* int sendto(int s, const char *msg, int len, int flags,
	              const struct sockaddr *to, int tolen) */
int printargs_sendto(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
	char sockaddrstr[256];
	struct sockaddr *address = (void*)sysArgs[4];
	int address_len = sysArgs[5];
	char *sockaddrbuf = rd_buf(sysArgs[4],address_len);

	sockaddr_to_str(sockaddrstr,(void*)sockaddrbuf,address_len);
	free(sockaddrbuf);
	fprintf(outfp,"sendto (%d, %p, %d, ", sysArgs[0],sysArgs[1],sysArgs[2]);
	print_msgflags(sysArgs[3]);
	fprintf(outfp,", %p %s, %d) = ", sysArgs[4], sockaddrstr, address_len);
	return 1;
}
int printret_sendto(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{

    if(sysReturn!=-1)
	fprintf(outfp,"%d",(int)sysReturn);
    else
	fprintf(outfp,"-1 (%s)",sys_errlist[sysErrno]);
    return 1;
}


	/* int recv(int s, const char *msg, int len, int flags) */
int printargs_recv(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
	fprintf(outfp,"recv (%d, %p, %d, ", sysArgs[0],sysArgs[1],sysArgs[2]);
	print_msgflags(sysArgs[3]);
	fprintf(outfp,") = ");
	return 1;
}
int printret_recv(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{

    if(sysReturn!=-1)
	fprintf(outfp,"%d",(int)sysReturn);
    else
	fprintf(outfp,"-1 (%s)",sys_errlist[sysErrno]);
    return 1;
}

	/* int recvfrom(int s, const char *msg, int len, int flags,
	              const struct sockaddr *to, int tolen) */
static long recv_address, recv_address_lenp;
int printargs_recvfrom(long sysCallno, long *sysArgs, int sysNumargs, char *sysFormat)
{
	recv_address     = sysArgs[4];

	fprintf(outfp,"recvfrom (%d, %p, %d, ", sysArgs[0],sysArgs[1],sysArgs[2]);
	print_msgflags(sysArgs[3]);
	if (recv_address == 0) {
	  fprintf(outfp,", NULL, xx");
	} else {
	  int address_len = -999999;
	  char *buf;

	  recv_address_lenp = sysArgs[5];

	  buf = rd_buf(recv_address_lenp, sizeof(long));

	  if (buf) address_len = *(int*)buf;
	  if (buf) free(buf);

	  fprintf(outfp,", %p, %d", sysArgs[4], address_len);
	}
	fprintf(outfp,") = ");
	return 1;
}
int printret_recvfrom(long sysCallno, long sysReturn, int sysErrno, long *sysArgs)
{
    if (sysReturn >= 0) {

	if (recv_address != NULL) {
	  char sockaddrstr[256];
	  char * sockaddrbuf;
	  int address_len;

	  sockaddrbuf = rd_buf(recv_address_lenp,sizeof(long));
	  address_len = *(int*)sockaddrbuf;
	  free(sockaddrbuf);

	  sockaddrbuf = rd_buf(recv_address,address_len);
	  sockaddr_to_str(sockaddrstr,(void*)sockaddrbuf,address_len);
	  free(sockaddrbuf);

	  fprintf(outfp,"%d [addr=%s,%d]\n",
		  (int)sysReturn, sockaddrstr, address_len);
	} else {
	  fprintf(outfp,"%d [addr=NULL]\n",(int)sysReturn);
	}

    } else
      fprintf(outfp,"-1 (%s)",sys_errlist[sysErrno]);
    return 1;
}
