#include <stdio.h>
#include <sys/types.h>
#include <sys/signal.h>

#include <sys/ioctl.h>
/* #include <sys/atm.h> */ /* too complex... */
#include <sys/audit.h>
#include <sys/cmupty.h>
#include <sys/disklabel.h>
#include <sys/eucioctl.h>
#include <sys/ioctl_compat.h>
#include <sys/old_rzdisk.h>
#include <sys/pfcntr.h>
#include <sys/prestoioctl.h>
#include <sys/procfs.h>
#include <sys/proc.h>
#include <sys/px.h>
/* #include <sys/sad.h> */
#include <sys/secioctl.h>
#include <sys/stropts.h>
#include <sys/vcmd.h>
#include <sys/vol.h>
#include <sys/volkint.h>
#include <sys/vsio.h>
#include <stropts.h>

#include <sys/workstation.h>
#include <sys/inputdevice.h>
#include <sys/tablet.h>
#include <sys/pcm.h>
#include <sys/pq.h>



/* ASSUMES ANSI-C/CPP (GNU-CC) */

#define _IOC_(name) { #name, name }

struct ionameval {
	char *name;
	int  val;
};

struct ionameval iocs[] =
{
#ifdef GIOC_MMI_PATH
  /* <sys/atm.h> */
  _IOC_(GIOC_MMI_PATH),
  _IOC_(GIOC_VCLIST_QUERY),
  _IOC_(GIOC_DRIVER_UP),
  _IOC_(GIOC_DRIVER_DOWN),
  _IOC_(GIOC_DRIVER_QUERY),
  _IOC_(GIOC_NEWPVC),
  _IOC_(GIOC_DELVC),
  _IOC_(GIOC_ADDESI),
  _IOC_(GIOC_DELESI),
  _IOC_(GIOC_DRIVER_FC),
  _IOC_(GIOC_SET_HOST_TYPE),
  _IOC_(GIOC_GET_HOST_TYPE),
  _IOC_(GIOC_GET_ARP_ENTRY_NUM),
  _IOC_(GIOC_GET_ARP_TABLE),
  _IOC_(GIOC_SET_ARP_ENTRY),
  _IOC_(GIOC_DEL_ARP_ENTRY),
  _IOC_(GIOC_GET_ARP_ENTRY),
  _IOC_(GIOC_SET_ARP_ENTRY_VC),
  _IOC_(GIOC_DEL_ARP_ENTRY_VC),
  _IOC_(GIOC_SET_ARP_ENTRY_FLAG),
  _IOC_(GIOC_SIG_GET_Q93B_STATS),
  _IOC_(GIOC_SIG_GET_QSAAL_STATS),
#endif
#ifdef AUDIOCGETN
  /* <sys/audit.h> */
  _IOC_(AUDIOCGETN),
  _IOC_(AUDIOCSETN),
#endif
#ifdef PIOCXIOC
  /* <sys/cmupty.h> */
  _IOC_(PIOCXIOC),
  _IOC_(PIOCSEOF),
  _IOC_(PIOCSSIG),
  _IOC_(PIOCCONN),
  _IOC_(PIOCSIM),
  _IOC_(PIOCNOSIM),
  _IOC_(PIOCCCMSG),
  _IOC_(PIOCNOCCMSG),
  _IOC_(PIOCENBS),
  _IOC_(PIOCMBIS),
  _IOC_(PIOCMBIC),
  _IOC_(PIOCSLOC),
  _IOC_(PIOCMGET),
  _IOC_(PIOCDGET),
#endif
#ifdef DIOCGDINFO
  /* <sys/disklabel.h> */
  _IOC_(DIOCGDINFO),
  _IOC_(DIOCSDINFO),
  _IOC_(DIOCWDINFO),
  _IOC_(DIOCGPART),
  _IOC_(DIOCRFORMAT),
  _IOC_(DIOCWFORMAT),
  _IOC_(DIOCSSTEP),
  _IOC_(DIOCSRETRIES),
  _IOC_(DIOCWLABEL),
  /* _IOC_(DIOCSBAD), */
  _IOC_(DIOCGDEFPT),
  _IOC_(DIOCGCURPT),
#endif
#ifdef EUC_WSET
  /* <sys/eucioctl.h> */
  _IOC_(EUC_WSET),
  _IOC_(EUC_WGET),
  _IOC_(EUC_IXLON),
  _IOC_(EUC_IXLOFF),
  _IOC_(EUC_OXLON),
  _IOC_(EUC_OXLOFF),
  _IOC_(EUC_MSAVE),
  _IOC_(EUC_MREST),
#endif
#ifdef GET_AND_MAP_EVENT_QUEUE
  /* <sys/inputdevice.h> */
  _IOC_(GET_AND_MAP_EVENT_QUEUE),
  _IOC_(SET_ESCAPE_BOX),
  _IOC_(SET_POINTER_BOX),
  _IOC_(SET_POINTER_POSITION),
  _IOC_(SET_POINTER_CONTROL),
  _IOC_(GET_POINTER_CONTROL),
  _IOC_(SET_DEVICE_MODE),
  _IOC_(GET_DEVICE_MODE),
  _IOC_(GET_DEVICE_TYPE),
  _IOC_(SET_KEYBOARD_CONTROL),
  _IOC_(GET_KEYBOARD_CONTROL),
  _IOC_(RING_KEYBOARD_BELL),
  _IOC_(GET_KEYBOARD_DEFINITION),
  _IOC_(PUT_EVENT_ON_QUEUE),
#endif
#ifdef _O_TIOCSSIZE
  /* <sys/ioctl.h> */
  _IOC_(_O_TIOCSSIZE),
  _IOC_(_O_TIOCGSIZE),
  _IOC_(_N_TIOCSSIZE),
  _IOC_(_N_TIOCGSIZE),
  _IOC_(TIOCMODG),
  _IOC_(TIOCMODS),
  _IOC_(TIOCEXCL),
  _IOC_(TIOCNXCL),
  _IOC_(TIOCFLUSH),
  _IOC_(TIOCGETA),
  _IOC_(TIOCSETA),
  _IOC_(TIOCSETAW),
  _IOC_(TIOCSETAF),
  _IOC_(TCGETA),
  _IOC_(TCSETA),
  _IOC_(TCSETAW),
  _IOC_(TCSETAF),
  _IOC_(TCSBREAK),
  _IOC_(TCXONC),
  _IOC_(TCFLSH),
  _IOC_(TIOCGETD),
  _IOC_(TIOCSETD),
  _IOC_(TIOCSBRK),
  _IOC_(TIOCCBRK),
  _IOC_(TIOCSDTR),
  _IOC_(TIOCCDTR),
  _IOC_(TIOCGPGRP),
  _IOC_(TIOCSPGRP),
  _IOC_(TIOCOUTQ),
  _IOC_(TIOCSTI),
  _IOC_(TIOCNOTTY),
  _IOC_(TIOCPKT),
  _IOC_(TIOCSTOP),
  _IOC_(TIOCSTART),
  _IOC_(TIOCMSET),
  _IOC_(TIOCMBIS),
  _IOC_(TIOCMBIC),
  _IOC_(TIOCMGET),
  _IOC_(TIOCREMOTE),
  _IOC_(TIOCGWINSZ),
  _IOC_(TIOCSWINSZ),
  _IOC_(TIOCUCNTL),
  _IOC_(UIOCCMD(n)),
  _IOC_(TIOCCONS),
  _IOC_(TIOCSCTTY),
  _IOC_(TIOCEXT),
  _IOC_(TIOCSIG),
  _IOC_(SLIOGUNIT),
  _IOC_(SLIOCSFLAGS),
  _IOC_(SLIOCGFLAGS),
  _IOC_(ISPTM),
  _IOC_(UNLKPT),
  _IOC_(ISPTS),
  _IOC_(TIOCGSID),
  _IOC_(FIOCLEX),
  _IOC_(FIONCLEX),
  _IOC_(FIONREAD),
  _IOC_(FIONBIO),
  _IOC_(FIOASYNC),
  _IOC_(FIOSETOWN),
  _IOC_(FIOGETOWN),
  _IOC_(FIOPIPESTAT),
  _IOC_(FIOFATTACH),
  _IOC_(FIOFDETACH),
  _IOC_(SIOCSHIWAT),
  _IOC_(SIOCGHIWAT),
  _IOC_(SIOCSLOWAT),
  _IOC_(SIOCGLOWAT),
  _IOC_(SIOCATMARK),
  _IOC_(SIOCSPGRP),
  _IOC_(SIOCGPGRP),
  _IOC_(SIOCGPEERPRIV),
  _IOC_(SIOCADDRT),
  _IOC_(SIOCDELRT),
  _IOC_(SIOCSIFADDR),
  _IOC_(SIOCSIFDSTADDR),
  _IOC_(SIOCSIFFLAGS),
  _IOC_(SIOCGIFFLAGS),
  _IOC_(SIOCSIFBRDADDR),
  _IOC_(SIOCSIFNETMASK),
  _IOC_(SIOCGIFMETRIC),
  _IOC_(SIOCSIFMETRIC),
  _IOC_(SIOCDIFADDR),
  _IOC_(SIOCAIFADDR),
  _IOC_(SIOCRDZCTRS),
  _IOC_(SIOCRDCTRS),
  _IOC_(SIOCPIFADDR),
  _IOC_(SIOCSARP),
  _IOC_(SIOCDARP),
  _IOC_(SIOCARPREQ),
  _IOC_(SIOCMANREQ),
  _IOC_(SIOCGETEVENTS),
  _IOC_(SIOCIFRESET),
  _IOC_(SIOCEEUPDATE),
  _IOC_(SIOCADDMULTI),
  _IOC_(SIOCDELMULTI),
  _IOC_(SIOCENABLBACK),
  _IOC_(SIOCDISABLBACK),
  _IOC_(SIOCRPHYSADDR),
  _IOC_(SIOCSPHYSADDR),
  _IOC_(SIOCIFSETCHAR),
  _IOC_(SIOCSMACSPEED),
  _IOC_(SIOCRMACSPEED),
  _IOC_(SIOCSIPMTU),
  _IOC_(SIOCRIPMTU),
  _IOC_(SIOCSRREQR),
  _IOC_(SIOCSRREQW),
  _IOC_(OSIOCGIFADDR),
  _IOC_(SIOCGIFADDR),
  _IOC_(OSIOCGIFDSTADDR),
  _IOC_(SIOCGIFDSTADDR),
  _IOC_(OSIOCGIFBRDADDR),
  _IOC_(SIOCGIFBRDADDR),
  _IOC_(OSIOCGIFCONF),
  _IOC_(SIOCGIFCONF),
  _IOC_(OSIOCGIFNETMASK),
  _IOC_(SIOCGIFNETMASK),
  _IOC_(OSIOCGARP),
  _IOC_(SIOCGARP),
  _IOC_(SIOCGIFADDR),
  _IOC_(SIOCGIFDSTADDR),
  _IOC_(SIOCGIFBRDADDR),
  _IOC_(SIOCGIFCONF),
  _IOC_(SIOCGIFNETMASK),
  _IOC_(SIOCGARP),
  _IOC_(MTIOCTOP),
  _IOC_(MTIOCGET),
  _IOC_(I_NREAD),
  _IOC_(I_PUSH),
  _IOC_(I_POP),
  _IOC_(I_LOOK),
  _IOC_(I_FLUSH),
  _IOC_(I_SRDOPT),
  _IOC_(I_GRDOPT),
  _IOC_(I_STR),
  _IOC_(I_SETSIG),
  _IOC_(I_GETSIG),
  _IOC_(I_FIND),
  _IOC_(I_LINK),
  _IOC_(I_UNLINK),
  _IOC_(I_ISASTREAM),
  _IOC_(I_PEEK),
  _IOC_(I_FDINSERT),
  _IOC_(I_SENDFD),
  _IOC_(I_RECVFD),
  _IOC_(I_FLUSHBAND),
  _IOC_(I_SWROPT),
  _IOC_(I_GWROPT),
  _IOC_(I_LIST),
  _IOC_(I_ATMARK),
  _IOC_(I_CKBAND),
  _IOC_(I_GETBAND),
  _IOC_(I_CANPUT),
  _IOC_(I_SETCLTIME),
  _IOC_(I_GETCLTIME),
  _IOC_(I_PLINK),
  _IOC_(I_PUNLINK),
  _IOC_(I_GETMSG),
  _IOC_(I_PUTMSG),
  _IOC_(I_GETPMSG),
  _IOC_(I_PUTPMSG),
  _IOC_(I_PIPE),
  _IOC_(I_FIFO),
  _IOC_(I_STR_ATTR),
  _IOC_(I_PEEK_ATTR),
  _IOC_(I_FDINSERT_ATTR),
  _IOC_(I_SENDFD_ATTR),
  _IOC_(I_RECVFD_ATTR),
  _IOC_(I_GETMSG_ATTR),
  _IOC_(I_PUTMSG_ATTR),
  _IOC_(BINLOG_ENABLE),
  _IOC_(BINLOG_DISABLE),
  _IOC_(BINLOG_ASCIIENABLE),
  _IOC_(BINLOG_ASCIIDISABLE),
  _IOC_(BINLOG_CLRCNTRS),
  _IOC_(BINLOG_SETPID),
  _IOC_(BINLOG_GETSTATUS),
#endif
#ifdef OTIOCGETD
  /* <sys/ioctl_compat.h> */
  _IOC_(TIOCSETD),
  _IOC_(OTIOCGETD),
  _IOC_(OTIOCSETD),
  _IOC_(TIOCHPCL),
  _IOC_(TIOCGETP),
  _IOC_(TIOCSETP),
  _IOC_(TIOCSETN),
  _IOC_(TIOCSETC),
  _IOC_(TIOCGETC),
  _IOC_(TIOCSMLB),
  _IOC_(TIOCCMLB),
  _IOC_(TIOCNMODEM),
  _IOC_(TIOCMODEM),
  _IOC_(DEVIOCGET),
  _IOC_(DEVGETGEOM),
  _IOC_(SRVC_REQUEST),
  _IOC_(DEVROOT),
  _IOC_(DIODCMD),
  _IOC_(DIODCDB),
  _IOC_(DIOCGETPT),
  _IOC_(DIOCSETPT),
  _IOC_(DIOCDGTPT),
  _IOC_(DKIOCHDR),
  _IOC_(DKIOCDOP),
  _IOC_(DKIOCGET),
  _IOC_(DKIOCACC),
  _IOC_(DKIOCEXCL),
  _IOC_(TIOCLBIS),
  _IOC_(TIOCLBIC),
  _IOC_(TIOCLSET),
  _IOC_(TIOCLGET),
  _IOC_(TIOCSLTC),
  _IOC_(TIOCGLTC),
#endif
#ifdef SCSI_FORMAT_UNIT
  /* <sys/old_rzdisk.h> */
  _IOC_(SCSI_FORMAT_UNIT),
  _IOC_(SCSI_REASSIGN_BLOCK),
  _IOC_(SCSI_READ_DEFECT_DATA),
  _IOC_(SCSI_VERIFY_DATA),
  _IOC_(SCSI_MODE_SELECT),
  _IOC_(SCSI_MODE_SENSE),
  _IOC_(SCSI_GET_SENSE),
  _IOC_(SCSI_GET_INQUIRY_DATA),
  _IOC_(SCSI_READ_LONG),
  _IOC_(SCSI_WRITE_LONG),
  _IOC_(SCSI_READ_CAPACITY),
  _IOC_(SCSI_STOP_UNIT),
  _IOC_(SCSI_START_UNIT),
  _IOC_(SCSI_ALLOW_REMOVAL),
  _IOC_(SCSI_PREVENT_REMOVAL),
  _IOC_(SCSI_SEEK_POSITION),
  _IOC_(SCSI_LOAD_UNIT),
  _IOC_(SCSI_UNLOAD_UNIT),
  _IOC_(SCSI_SEND_DIAGNOSTIC),
  _IOC_(SCSI_RECEIVE_DIAGNOSTIC),
  _IOC_(SCSI_READ_BUFFER),
  _IOC_(SCSI_WRITE_BUFFER),
#endif
#ifdef PIOSETKNOB
  /* <sys/pcm.h> */
  _IOC_(PIOSETKNOB),
  _IOC_(PIOSETLED),
#endif
#ifdef PCNTRDISABLE
  /* <sys/pfcntr.h> */
  _IOC_(PCNTRDISABLE),
  _IOC_(PCNTRENABLE),
  _IOC_(PCNTSETMUX),
  _IOC_(PCNTLOGALL),
  _IOC_(PCNTLOGSELECT),
  _IOC_(PCNTCLEARCNT),
  _IOC_(PCNTGETCNT),
  _IOC_(PCNTGETRSIZE),
  _IOC_(PCNTGETIPLHIS),
  _IOC_(PCNTSETITEMS),
  _IOC_(PCNTSETUADDR),
  _IOC_(PCNTSETKADDR),
  _IOC_(PCNT5CTXTS),
  _IOC_(PCNT5MUX),
  _IOC_(PCNT5FREQ),
  _IOC_(PCNT5DISABLE),
  _IOC_(PCNT5ENABLE),
  _IOC_(PCNT5CLEAR),
  _IOC_(PCNT5RESTART),
  _IOC_(PCNT5SETCNTRS),
  _IOC_(PCNT5GETCNTRS),
  _IOC_(PCNT5GETCNT),
#endif
#ifdef PQ_IOC_RESET
  /* <sys/pq.h> */
  _IOC_(PQ_IOC_RESET),
  _IOC_(PQ_IOC_START),
  _IOC_(PQ_IOC_INTR),
  _IOC_(PQ_IOC_MAP),
#endif
  /* <sys/prestoioctl.h> */
  _IOC_(PRGETSTATUS),
  _IOC_(PRNGETSTATUS),
  _IOC_(PRSETSTATE),
  _IOC_(PRSETMEMSZ),
  _IOC_(PRRESET),
  _IOC_(PRENABLE),
  _IOC_(PROENABLE),
  _IOC_(PRDISABLE),
  _IOC_(PRODISABLE),
  _IOC_(PRNEXTUPRTAB),
  _IOC_(PRGETUPRTAB),
  _IOC_(PRFLUSH),
  /* <sys/procfs.h> */
  _IOC_(PIOCCRED),
  _IOC_(PIOCGETPR),
  _IOC_(PIOCGETU),
  _IOC_(PIOCGROUPS),
  _IOC_(PIOCPSINFO),
  _IOC_(PIOCNICE),
  _IOC_(PIOCOPENM),
  _IOC_(PIOCRUN),
  _IOC_(PIOCSTATUS),
  _IOC_(PIOCSTOP),
  _IOC_(PIOCWSTOP),
  _IOC_(PIOCGTRACE),
  _IOC_(PIOCSTRACE),
  _IOC_(PIOCSSIG),
  _IOC_(PIOCKILL),
  _IOC_(PIOCUNKILL),
  _IOC_(PIOCGHOLD),
  _IOC_(PIOCSHOLD),
  _IOC_(PIOCCFAULT),
  _IOC_(PIOCGFAULT),
  _IOC_(PIOCSFAULT),
  _IOC_(PIOCGENTRY),
  _IOC_(PIOCSENTRY),
  _IOC_(PIOCGEXIT),
  _IOC_(PIOCSEXIT),
  _IOC_(PIOCRFORK),
  _IOC_(PIOCSFORK),
  _IOC_(PIOCRRLC),
  _IOC_(PIOCSRLC),
  _IOC_(PIOCGFPREG),
  _IOC_(PIOCSFPREG),
  _IOC_(PIOCGREG),
  _IOC_(PIOCSREG),
  _IOC_(PIOCMAXSIG),
  _IOC_(PIOCACTION),
  _IOC_(PIOCNMAP),
  _IOC_(PIOCMAP),
/* _IOC_(PIOCGETTK), */
  _IOC_(PIOCGSPCACT),
  _IOC_(PIOCSSPCACT),
  _IOC_(PIOCNTHR),
  _IOC_(PIOCTLIST),
/* _IOC_(PIOCGETUTK), */
  _IOC_(PIOCTRUN),
/* _IOC_(PIOCTGETTH), */
  _IOC_(PIOCTSTATUS),
  _IOC_(PIOCTSTOP),
  _IOC_(PIOCTGTRACE),
  _IOC_(PIOCTSTRACE),
  _IOC_(PIOCTSSIG),
  _IOC_(PIOCTKILL),
  _IOC_(PIOCTUNKILL),
  _IOC_(PIOCTCFAULT),
  _IOC_(PIOCTGFAULT),
  _IOC_(PIOCTSFAULT),
  _IOC_(PIOCTGFPREG),
  _IOC_(PIOCTSFPREG),
  _IOC_(PIOCTGREG),
  _IOC_(PIOCTSREG),
  _IOC_(PIOCTACTION),
  _IOC_(PIOCTTERM),
  _IOC_(PIOCTABRUN),
/* _IOC_(PIOCTGETUTH), */
  _IOC_(PIOCRTINH),
  _IOC_(PIOCSTINH),
  _IOC_(PIOCTGENTRY),
  _IOC_(PIOCTSENTRY),
  _IOC_(PIOCTGEXIT),
  _IOC_(PIOCTSEXIT),
  _IOC_(PIOCGFPCR),
  _IOC_(PIOCSFPCR),
  _IOC_(PIOCXPTH),
  _IOC_(PIOCARGUMENTS),
  /* <sys/px.h> */
  _IOC_(PX_IOC_MAP),
#ifdef SAD_SAP
  /* <sys/sad.h> */
  _IOC_(SAD_SAP),
  _IOC_(SAD_GAP),
  _IOC_(SAD_VML),
#endif
#ifdef AUDIOC_ENABLE
  /* <sys/secioctl.h> */
  _IOC_(AUDIOC_ENABLE),
  _IOC_(AUDIOC_SHUTDOWN),
  _IOC_(AUDIOC_DISABLE),
  _IOC_(AUDIOC_SYSMASK),
  _IOC_(AUDIOC_USERMASK),
  _IOC_(AUDIOC_DAEMON),
  _IOC_(AUDIOC_ACK),
  _IOC_(AUDIOC_STATS),
  _IOC_(AUDIOC_IDS),
  _IOC_(AUDIOC_SLEVEL),
  _IOC_(AUDIOC_INHERIT),
  _IOC_(AUDIOC_CSWITCH),
  _IOC_(SPIOC_INIT),
  _IOC_(SPIOC_INV_CACHE),
  _IOC_(SPIOC_INV_TAG),
  _IOC_(SPIOC_IMMUNE),
  _IOC_(SPIOC_SHUTDOWN),
  _IOC_(SPIOC_SET_CACHE_SIZE),
  _IOC_(SPIOC_GET_STATS),
  _IOC_(SPIOC_GETCONF),
  _IOC_(SPIOC_EXCL),
  _IOC_(SPIOC_REINIT),
#endif
#ifdef I_PUSH
  /* <sys/stropts.h> */
  _IOC_(I_NREAD),
  _IOC_(I_PUSH),
  _IOC_(I_POP),
  _IOC_(I_LOOK),
  _IOC_(I_FLUSH),
  _IOC_(I_SRDOPT),
  _IOC_(I_GRDOPT),
  _IOC_(I_STR),
  _IOC_(I_SETSIG),
  _IOC_(I_GETSIG),
  _IOC_(I_FIND),
  _IOC_(I_LINK),
  _IOC_(I_UNLINK),
  _IOC_(I_ISASTREAM),
  _IOC_(I_PEEK),
  _IOC_(I_FDINSERT),
  _IOC_(I_SENDFD),
  _IOC_(I_RECVFD),
  _IOC_(I_FLUSHBAND),
  _IOC_(I_SWROPT),
  _IOC_(I_GWROPT),
  _IOC_(I_LIST),
  _IOC_(I_ATMARK),
  _IOC_(I_CKBAND),
  _IOC_(I_GETBAND),
  _IOC_(I_CANPUT),
  _IOC_(I_SETCLTIME),
  _IOC_(I_GETCLTIME),
  _IOC_(I_PLINK),
  _IOC_(I_PUNLINK),
  _IOC_(I_TILDE),
  _IOC_(I_GETMSG),
  _IOC_(I_PUTMSG),
  _IOC_(I_GETPMSG),
  _IOC_(I_PUTPMSG),
  _IOC_(I_PIPE),
  _IOC_(I_FIFO),
  _IOC_(I_STR_ATTR),
  _IOC_(I_PEEK_ATTR),
  _IOC_(I_FDINSERT_ATTR),
  _IOC_(I_SENDFD_ATTR),
  _IOC_(I_RECVFD_ATTR),
  _IOC_(I_GETMSG_ATTR),
  _IOC_(I_PUTMSG_ATTR),
  _IOC_(I_GETPMSG_ATTR),
  _IOC_(I_PUTPMSG_ATTR),
#endif
#ifdef BIOSMODE
  /* <sys/tablet.h> */
  _IOC_(BIOSMODE),
  _IOC_(BIOGMODE),
  _IOC_(TBIOGETD),
  _IOC_(TBIOSETD),
  _IOC_(BIOSTYPE),
  _IOC_(BIOGTYPE),
/* _IOC_(TBIOGETC),
   _IOC_(TBIOSETC), */
#endif
#ifdef VGETSTATE
  /* <sys/vcmd.h> */
  _IOC_(VGETSTATE),
  _IOC_(VSETSTATE),
#endif
#ifdef VOL_INDIRECT_IOCTL
  /* <sys/vol.h> */
  _IOC_(VOL_INDIRECT_IOCTL),
  _IOC_(VOL_IO_DAEMON),
  _IOC_(VOL_IO_DAEMON_KILL),
  _IOC_(VOL_IO_DAEMON_CNT),
  _IOC_(VOL_LOG_IO_DAEMON),
#endif
#ifdef VOL_VOLD_IOCTL
  /* <sys/vilkint.h> */
  _IOC_(VOL_VOLD_IOCTL),
#endif
#ifdef VSIOINIT
  /* <sys/vsio.h> */
  _IOC_(VSIOINIT),
  _IOC_(VSIOSTART),
  _IOC_(VSIOABORT),
  _IOC_(VSIOPWRUP),
  _IOC_(VSIOGETVER),
  _IOC_(VSIOSYNC),
  _IOC_(VSIOBBACTL),
  _IOC_(VSIOFIBCTL),
  _IOC_(VSIOFIBRETRY),
  _IOC_(VSIOGETSTATS),
  _IOC_(VSIOGETIOA),
  _IOC_(VSIOUSERWAIT),
  _IOC_(VSIOWAITGO),
#endif
#ifdef WORKSTATION_PRIVATE
  /* <sys/workstation.h> */
  _IOC_(WORKSTATION_PRIVATE),
  _IOC_(GET_WORKSTATION_INFO),
  _IOC_(WRITE_COLOR_MAP),
  _IOC_(SET_CURSOR_POSITION),
  _IOC_(LOAD_CURSOR),
  _IOC_(RECOLOR_CURSOR),
  _IOC_(GET_SCREEN_INFO),
  _IOC_(GET_DEPTH_INFO),
  _IOC_(MAP_SCREEN_AT_DEPTH),
  _IOC_(GET_VISUAL_INFO),
  _IOC_(VIDEO_ON_OFF),
  _IOC_(SET_TABLET_OVERHANG),
  _IOC_(SET_EDGE_CONNECTION),
  _IOC_(GET_EDGE_CONNECTION),
  _IOC_(CURSOR_ON_OFF),
  _IOC_(SET_MONITOR_TYPE),
#endif
#ifdef I_PUSH
  /* <stropts.h> */
  _IOC_(I_NREAD),
  _IOC_(I_PUSH),
  _IOC_(I_POP),
  _IOC_(I_LOOK),
  _IOC_(I_FLUSH),
  _IOC_(I_SRDOPT),
  _IOC_(I_GRDOPT),
  _IOC_(I_STR),
  _IOC_(I_SETSIG),
  _IOC_(I_GETSIG),
  _IOC_(I_FIND),
  _IOC_(I_LINK),
  _IOC_(I_UNLINK),
  _IOC_(I_ISASTREAM),
  _IOC_(I_PEEK),
  _IOC_(I_FDINSERT),
  _IOC_(I_SENDFD),
  _IOC_(I_RECVFD),
  _IOC_(I_FLUSHBAND),
  _IOC_(I_SWROPT),
  _IOC_(I_GWROPT),
  _IOC_(I_LIST),
  _IOC_(I_ATMARK),
  _IOC_(I_CKBAND),
  _IOC_(I_GETBAND),
  _IOC_(I_CANPUT),
  _IOC_(I_SETCLTIME),
  _IOC_(I_GETCLTIME),
  _IOC_(I_PLINK),
  _IOC_(I_PUNLINK),
  _IOC_(I_TILDE),
  _IOC_(I_GETMSG),
  _IOC_(I_PUTMSG),
  _IOC_(I_GETPMSG),
  _IOC_(I_PUTPMSG),
  _IOC_(I_PIPE),
  _IOC_(I_FIFO),
  _IOC_(I_STR_ATTR),
  _IOC_(I_PEEK_ATTR),
  _IOC_(I_FDINSERT_ATTR),
  _IOC_(I_SENDFD_ATTR),
  _IOC_(I_RECVFD_ATTR),
  _IOC_(I_GETMSG_ATTR),
  _IOC_(I_PUTMSG_ATTR),
  _IOC_(I_GETPMSG_ATTR),
  _IOC_(I_PUTPMSG_ATTR)
#endif
};

int iocs_cnt = sizeof(iocs) / sizeof(iocs[0]);

int compare_iocs(p1,p2)
const void *p1, *p2;
{
	struct ionameval *i1 = p1;
	struct ionameval *i2 = p2;

	return (i1->val - i2->val);
}

main()
{
	int i;
	printf("\t/* %d ioctl entries -- generated with  buildioctl.c ... */\n",iocs_cnt);
	qsort(iocs, iocs_cnt, sizeof(iocs[0]), compare_iocs);
	--iocs_cnt; /* one less than all.. */
	for (i = 0; i < iocs_cnt; ++i)
	  printf("\t{ \"%s\", 0x%x },\n",iocs[i].name, iocs[i].val);
	printf("\t{ \"%s\", 0x%x }\n",iocs[iocs_cnt].name, iocs[iocs_cnt].val);

	return 0;
}
