/*
 * 30.4.93  Marko.Kaittola@funet.fi, Matti.Aarnio@funet.fi
 *          V0.1 and V0.2
 * 
 *  4.5.93  Jukka Ukkonen <ukkonen@csc.fi>
 *          V0.3
 *          If there is no host name defined as a part of
 *          an Internet address append the local FQDN.
 * 
 *  7.5.93  Marko.Kaittola@funet.fi
 *          V 1.0
 *          Added interactive part.
 *          Some cleaning up.
 *          A lot of messy code.
 * 
 * 19.5.93  Marko.Kaittola@funet.fi
 *          V 1.1
 *          Cleaned up the code.
 *          Now don't exit in interactive mode after the first
 *          address has been converted.
 * 
 * 17.9.93  Marko.Kaittola@funet.fi
 *          V 1.1.1
 * 	    Updated man page based on work by
 * 	    Veli-Matti.Junkkari@cc.tut.fi.
 * 
 * 20.9.93 Graeme Hairsine <G.Hairsine@mhs-relay.ac.uk>
 * 	   V 1.1.2
 * 	   Fixed the language on man page and help message.
 */

/*
 * As Lennart Lovstrand says in IDA sendmail docs:
 * "Use it, abuse it, but don't sell it."
 * 
 * You are free to use this with your own risk as long as you don't
 * ask any money for it.
 */

/*
 * Define USE_DNS if you want DNS to add append local host name
 * at the end of your RFC-822 address if there is no domain part
 * given.
 * 
 * Propably this should be done at Makefile.
 * 
 * #define USE_DNS
 */

/*
 * If you are using resolv++ or other resolver that provides herror()
 * define RESOLV_PLUS.
 * 
 * Propably this should be done at Makefile.
 * 
 * #define RESOLV_PLUS
 */

/*
 * Host to contact and ports for conversion.
 * 
 * Fot the time being funet.fi may be used. Alternatively you might want
 * to create your own conversion server. Protocol is easy: send in a line
 * you want to convert. When you are done either send "exit" or just close
 * the connection.
 */
#define HOST "funet.fi"
#define RFC2OR 2721
#define OR2RFC 2722


struct x400_addr { /* One byte is used for NULL */
  char c[3];
  char admd[17];
  char prmd[17];
  char o[65];
  char ou1[33];
  char ou2[33];
  char ou3[33];
  char ou4[33];
  char s[41];
  char g[17];
  char i[6];
  char gq[4];
  char dd1_type[9], dd1_value[129];
  char dd2_type[9], dd2_value[129];
  char dd3_type[9], dd3_value[129];
  char dd4_type[9], dd4_value[129];
  char rfc[1024];
#ifdef DEBUG
  char test[1024];
#endif
};


/*
 * Functions from convert.c
 */
#ifdef CONVERT
#define EXTERN_CONVERT
#else
#define EXTERN_CONVERT extern
#endif
EXTERN_CONVERT int help ();
EXTERN_CONVERT int usage ();
EXTERN_CONVERT char *convert ();
EXTERN_CONVERT char *rfc2or ();
EXTERN_CONVERT char *or2rfc ();
EXTERN_CONVERT char *fqdn ();



/*
 * Functions from screen.c
 */
#ifdef SCREEN
#define EXTERN_SCREEN
#else
#define EXTERN_SCREEN extern
#endif
EXTERN_SCREEN int interactive ();
EXTERN_SCREEN int start_curses ();
EXTERN_SCREEN int end_curses ();
EXTERN_SCREEN int too_small ();
EXTERN_SCREEN int make_form ();
EXTERN_SCREEN int fill_struct ();
EXTERN_SCREEN int read_struct ();
EXTERN_SCREEN int read_val ();
EXTERN_SCREEN struct x400_addr *init_addr ();
EXTERN_SCREEN int gen_slash_addr ();
EXTERN_SCREEN int gen_or_address ();
EXTERN_SCREEN int get_char ();
EXTERN_SCREEN int make_printable ();
EXTERN_SCREEN int block_signals ();
EXTERN_SCREEN void handler ();
EXTERN_SCREEN int my_position ();
