/* --------------------
	vmail -- defs.h

	Interactive screen-based mail handler that sits on top of MH.

	Copyright (C) J. Zobel, University of Melbourne, October 1987.
-------------------- */

#include <stdio.h>
#include <pwd.h>
#include <setjmp.h>
#include <sgtty.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/dir.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <curses.h>

#define COMP		"/usr/local/mh/comp"	/* MH utilities needed by vmail */
#define FORW		"/usr/local/mh/forw"
#define INC			"/usr/local/mh/inc"
#define REPL		"/usr/local/mh/repl"
#define PAGER		"/usr/ucb/more"			/* default pager */
#define EDITOR		"/usr/ucb/vi"			/* default editor */
#define SHELL		"/bin/csh"				/* default shell */
#define CAT			"/bin/cat"				/* used as `show' for pipes */

#define LEN			255						/* standard string length */
#define MAXITEMS	4097					/* number of items in folder */
#define FPROT		0755					/* standard file protection */
#define TITLE		0						/* title line */
#define STATUS		1						/* status line */
#define FIRST		2						/* first line of info */
#define PROFILE		".mh_profile"			/* default profile */
#define CURFOL		"inbox"					/* default current folder */
#define CONTEXT		"context"				/* default context file */
#define SEQU		".mh_sequences"			/* default .mh_sequences file */
#define MAILDIR		"Mail"					/* default mail directory */

#define	true		1
#define false		0
#define EMPTY		2						/* used to mark empty folders */
#define CTRL_L		'\014'
#define ESC			'\033'
#define DEL			'\177'

/* --------------------
	Data structures.

	Each folder is divided into pages of (_lines_-2) mail items, _lines_
	being the number of lines for the tty type.  Pages of folders are
	stored in a doubly-linked list of pages (struct mail_folder), mail
	items (struct mail_item) in doubly liked lists of mail.  Folders are
	sorted alphabetically, and pages of mail items are sorted numerically.
-------------------- */
struct mail_item {
	int		number;						/* number of item */
	char	*title;						/* header */
	struct mail_item *next, *prev;		/* links to other headers */
};
typedef struct mail_item *item;

struct mail_folder {
	char	*name;						/* folder name */
	int		pages, pagenum;				/* no. of pages, no. of page */
	bool	valid;						/* true if folder active */
	item	mail, last;					/* first and last mail items for page
										   - NULL if folder not active */
	struct mail_folder *next, *prev;	/* linked list of folders */
};
typedef struct mail_folder *folder;


extern folder	folders,				/* list of all folders */
				curflr,					/* current folder */
				alternate;				/* alternate folder */
extern item		curmail;				/* current mail */
extern char		**environ,
				*user,					/* user name */
				*pager,					/* desired pager */
				*editor,				/* desired editor */
				*shell,					/* desired shell */
				*mail_dir,				/* mail directory */
				*context;				/* context file */
extern int		y,						/* current Y co-ordinate (for curses) */
				folder_protect,			/* protection for folders */
				lines,					/* lines per screen */
				cols;					/* cols per screen */
extern bool		top_level,				/* flag used to see if process stopped
										   from within subprocess */
				do_flush,				/* true if input is to be flushed */
				comp_args,				/* true if calls to comp needs args */
				repl_args,				/* true if calls to repl needs args */
				forw_args;				/* true if calls to forw needs args */
extern jmp_buf	env;

#include "macro.h"

void	add_page_header(), addstatus(), choose(), comp(), create_mail_record(),
		cursor_down(), cursor_up(), display_page(), delete_item(), edit(),
		find_folders(), flatten(), forw(), get_env(), get_home(),
		read_profile(), get_string(), get_title(), goto_folder(), call_shell(),
		goto_incorp_folder(), goto_next_folder(), goto_prev_folder(),
		hold_end(), inactive(), inc(), init(), list_folders(),
		mark_valid_folders(), move_item(), next_page(), no_control(),
		prev_page(), repl(), save_item(), search(), show_folder(), show_mail(),
		show_title(), tint(), to_control(), to_normal(), tstp(), undo(), pack(),
		cursor_first(), cursor_middle(), cursor_last(), goto_first_page(),
		goto_last_page(), squash(), get_date(), process_args(), do_pipe();
