#! /bin/sh
#
#	myPreview.sh -- generate a preview release archive
#
#ident "@(#)smail:RELEASE-3_2_0_119:myPreview.sh,v 1.6 2004/08/18 08:22:52 woods Exp"

if [ -f conf/EDITME ]; then
	echo "$0: you can't do this while conf/EDITME is present!" 1>&2
	exit 1
fi
if [ -f conf/Makef.local ]; then
	echo "$0: you can't do this while conf/Make.local is present!" 1>&2
	exit 1
fi
if [ -f defs.sh -o -f src/defs.sh ]; then
	echo "$0: you must run 'make clobber' first!" 1>&2
	exit 1
fi

VERSION=$(awk '$1 ~ /^3.*-Pre/ {print $1}' level)
if [ -z "$VERSION" ]; then
	echo "$0: the current version doesn't seem to be a preview!" 1>&2
	exit 1
fi

if [ "$(echo /usr/pkgsrc/mail/smail/patches/p*)" != '/usr/pkgsrc/mail/smail/patches/p*' ]; then
	echo "$0: there should not be any patches in pkgsrc/mail/smail!" 1>&2
	exit 1
fi

DATE=$(date '+%Y%m%d')

ARCHIVE_DIR=/most/distfiles
ARCHIVE=${ARCHIVE_DIR}/smail-${VERSION}-${DATE}.tar.gz

echo "Creating ChangeLog-${VERSION} ..."

rm -f ChangeLog-${VERSION}.OLD
sh ./mkChangeLog.sh

echo -n "Creating preview release in ${ARCHIVE} ... "

find -L . \( -type f -a ! -name '.?*' -a ! -name '*~' -print \) -o -name CVS -prune | \
	pax -wz -s ,./,smail-${VERSION}-${DATE}/, -f ${ARCHIVE}

rm -f ${ARCHIVE_DIR}/smail-pkgsrc.shar
(
	cd /usr/pkgsrc/mail/smail
	#
	# Fix up the DISTNAME lines to fetch this new preview package.
	#
	# Note this script barfs if both are commented out....
	#
	ed Makefile <<_EOF_
,s/^DISTNAME/#DISTNAME/p
1
/-Pre-/p
s/[0-9]*$/${DATE}/p
s/^#*//p
w
q
_EOF_
	make makesum mps
)
(
	cd /usr/pkgsrc/mail/smail
	shar DESCR Makefile distinfo INSTALL PLIST files/ files/mailer.conf
) > ${ARCHIVE_DIR}/smail-pkgsrc.shar

echo "Done."

exit 0
