/*
#ident	"@(#)smail/src:RELEASE-3_2_0_113:smailconf.h,v 1.9 2001/07/30 02:41:24 woods Exp"
 */

/*
 *    Copyright (C) 1987, 1988 by Ronald S. Karr and Landon Curt Noll
 *    Copyright (C) 1992  Ronald S. Karr
 *
 * See the file COPYING, distributed with smail, for restriction
 * and warranty information.
 */
/*
 * smailconf.h:
 *	interface file for routines in smailconf.c.
 */

/* types used in smailconf.c */
/*
 * attribute tables are arrays of these structures.
 */
struct attr_table {
    char *name;				/* name of attribute */
    /* type of attribute */
    enum {
	t_string,			/* a string attribute */
	t_boolean,			/* boolean, on or off, attribute */
	t_char,				/* single character attribute */
	t_int,				/* integer attribute */
	t_mode,				/* file (permissions) mode - octal int */
	t_long,				/* long integer attribute */
	t_interval,			/* time interval (hour/min/sec) */
	t_double,			/* double precision attribute */
	t_proc,				/* attribute handled by procedure */
	t_infoproc			/* procedure which displays info */
    } type;
    char *value;			/* value to put in config file */
    union u_attr {
	char *v_string;			/* string variable */
	unsigned int  v_boolean;	/* boolean variable */
	int  v_char;			/* char variable, accessed as int */
	int  v_int;			/* integer variable */
	long v_long;			/* long variable */
	double v_double;		/* double variable */
	char *(*v_proc) __P((void));	/* procedure to handle attribute */
	char *(*v_infoproc) __P((void)); /* procedure for info attribute */
    } *uptr;				/* point to configuration variable */
    unsigned long offset;		/* offset into data structure */
};

/* convenience typedef for use in initializing conf_form tables */
typedef union u_attr tup;

/* external functions defined in smailconf.c */
extern char *read_config_file __P((char *));
extern char *quote_string_value __P((char *));
extern void print_config_variable __P((char *));
extern char *read_standard_file __P((FILE *, char *, unsigned int, int, int, int, struct attr_table *, struct attr_table *, char *(*)(char *, struct attribute *), char **));
extern void dump_standard_config __P((FILE *, char *, char *, long, struct attr_table *, struct attr_table *));
extern char *fill_attributes __P((char *, struct attribute *, long *, struct attr_table *, struct attr_table *));
extern struct attr_table *find_attribute __P((char *, struct attr_table *, struct attr_table *));
extern void add_config_stat __P((char *, struct stat *));
extern int is_newconf __P((void));
extern char *make_lib_fn __P((char *));
