/*-------------------------------------------------------------------------
 *  TULP - Unix Mailing List manager (sub-set of FRECP's
 *         Bitnet Listserv tool.
 *
 *  Copyright (C) 1991-1994  Kimmo Suominen, Christophe Wolfhugel
 *
 *  Please read the files COPYRIGHT and AUTHORS for the extended
 *  copyrights refering to this file.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------*/

static char rcsid[] = "@(#)$Id: str.c,v 1.1 94/07/11 18:34:52 listserv Exp Locker: listserv $";

/*
 * $Revision: 1.1 $
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "conf.h"

int strspacecmp(str1, str2)
char *str1, *str2;
{
   int c1, c2;

   while (1) {
      c1 = *str1++; 
      c2 = *str2++;
      if (isupper(c1)) c1 += 32;
      if (isupper(c2)) c2 += 32;
      if (c1==' ' || c1=='\t') c1=0;
      if (c2==' ' || c2=='\t') c2=0;
      if (c1 == c2) {
         if (c1==0)
            return(0);
         continue;
      } /* endif */
      if (c1 < c2)
         return -1;
      return 1;
   } /* endwhile */
}

/*
** Compares adresses, sorting by domain name instead of an alphabetic
** sort.
*/
int
stradrcmp(str1, str2)
char *str1, *str2;
{
   char *s1, *s2, *s3;
   int i, j, k, l, res;

   i = strlen(str1) + 1;
   j = strlen(str2) + 1;
   s1 = malloc(i); s2 = malloc(j);
   memcpy(s1, str1, i); memcpy(s2, str2, j);
   s3 = strchr(s1, ' ');
   if (s3 != NULL) { *s3 = '\0'; i = strlen(s1) + 1; }
   s3 = strchr(s2, ' ');
   if (s3 != NULL) { *s3 = '\0'; j = strlen(s2) + 1; }

   while (i > 0 && j > 0) {
      for (; s1[i] != '.' && s1[i] != '@' && i > 0; i--, k++);
      if (i > 0) s1[i] = 0;
      for (; s2[j] != '.' && s2[j] != '@' && j > 0; j--, l++);
      if (j > 0) s2[j] = 0;
      res = strcasecmp(&s1[i + 1 * (i > 0)], &s2[j + 1 * (j > 0)]);
      if (res != 0) { free(s1); free(s2); return(res); }
   }
   free(s1);
   free(s2);
   return(0);
}

#ifdef NEED_STRCASE

int strcasecmp(str1, str2)
char *str1, *str2;
{
   int c1, c2;

   while (1) {
      c1 = *str1++;
      c2 = *str2++;
      if (isupper(c1)) c1 += 32;
      if (isupper(c2)) c2 += 32;
      if (c1 == c2) {
         if (!c1)
            return(0);
         continue;
      } /* endif */
      if (c1 < c2)
         return -1;
      return 1;
   } /* endwhile */
}

int strncasecmp(str1, str2, n)
char *str1, *str2;
int n;
{
   int c1, c2;

   while (n--) {
      c1 = *str1++;
      c2 = *str2++;
      if (isupper(c1)) c1 += 32;
      if (isupper(c2)) c2 += 32;
      if (c1 == c2) {
         if (!c1)
            return(0);
         continue;
      } /* endif */
      if (c1 < c2)
         return -1;
      return 1;
   } /* endwhile */
   return(0);
}

#endif /* NEED_STRCASE */
