# latex2ps
#
# 29-May-92 weber@eitech.com
#
# Copyright (c)  1992 Enterprise Integration Technologies Corporation
#
# Permission to use, copy, modify, distribute, and sell this software and 
# its documentation for any purpose is hereby granted without fee, provided
# that (i) the above copyright notices and this permission notice appear in
# all copies of the software and related documentation, and (ii) the name of
# Enterprise Integration Technologies Corporation may not be used in any 
# advertising or publicity relating to the software without the specific, 
# prior written permission of Enterprise Integration Technologies Corporation.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
#
# IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION  BE
# LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF
# ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
# PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
# THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
#
# This service will run latex, then dvi2ps on a collection of source files.
# That is, the input message may contain one or more levels of multipart/mixed
# bodies; the source files are retrieved from the leaves.  The sources are
# named by their Content-id's.  The service result is normally a multipart
# of the latex log file and the dvi2ps postscript output.

proc dolatex { switches envelope inputs } {

    # default to latexing source in the first input, use the name in the
    # first switch if it exists; remove .tex extension in either case
    if {[llength $switches] == 0} {
	if {[getfield $inputs TYPE] == "multipart"} {
	    set src [getfield [lindex [getfield $inputs PARTS] 0] FILE]
	} {set src [getfield $inputs FILE]}
    } {set src [lindex $switches 0]}
    regsub "\.tex" $src "" src
    
    # run latex on the main source, and if the output says that labels may have
    # changed, run latex again. Then run dvi2ps
    if {[catch "exec latex $src < /dev/null" lout]} {
	setfield output FILE $src.log
	setfield output DESCRIPTION "log file showing error"
    	return [mailout [turnaround $envelope] $output]
    }
    if {[regexp -nocase "may have changed" $lout]} {
    	exec latex $src < /dev/null > /dev/null
    }
    exec dvips -o $src.ps $src.dvi
    
    # now build description of outgoing two-part message containing both the latex
    # log file and the postscript result
    setfield part1 FILE $src.log
    setfield part1 DESCRIPTION "log file"

    setfield part2 TYPE application
    setfield part2 SUBTYPE postscript
    setfield part2 FILE $src.ps
    setfield part2 DESCRIPTION "postscript result"

    setfield output TYPE multipart
    setfield output SUBTYPE mixed
    setfield output PARTS [list $part1 $part2]
    
    return [mailout [turnaround $envelope] $output]
}
