NAME

dis

SYNOPSIS

dis [[interspersed | separate]]
Contents: DIS commands

DESCRIPTION

This service will access DIS, the Distributed Information Service.  The input
is the language-independent version of DIS, e.g. 

(object?  foo) 

one command per line. Commands and return values in the
language-independent version are all delimited by parentheses.  The
results will be returned in a similar fashion. The answers can either
be

1) interspersed, in which case the resulting message alternates commands with
the results (the default); or
2) separate, in which case the response is a multipart message where the first
part contains the results and the second part contains the
corresponding commands.

DIS provides persistant object storage and object-based network services.
Here are some sample functions that can be used to navigate through the 
objects of DIS:

(object? foo) -- returns the name of foo if it is an object in DIS else ()
	OBJECT is the object at the root of the object hierarchy, so
	(object? OBJECT) will return (OBJECT)

(specializations-of foo) -- returns a list of subclasses of foo
(generalizations-of foo) -- returns a list of superclasses of foo

(slots-of foo) -- returns a list of slots of the object foo
(values-of foo (slots*)) -- returns the values of the named slots
(slots-and-values-of foo) -- returns a list of name-value pairs
(facets-of foo s1) -- returns a list of facets of slot s1 of object foo
(facet-values-of foo s1 (facets*)) -- returns the values of the named facets

there are many more functions, including those that create objects,
slots, etc., fill in their values, and manipulate
semiconductor-specific concepts