/* ************************************************************ *
 *								*
 *		CMD-INPUT					*
 *	The main piece of mail (and other) servers.		*
#
#  Copyright 1990-1993   Matti.Aarnio @ FUNET.FI
#  This software is free under similar rules as BSD copyrights.
#  (Definitely this is NOT Public Domain.  "Just" FREELY AVAILABLE.
#   Don't clain you did this..)
#  You can use this, but you shall not held us liable for anything.
#  You must not use our name in marketing, in case you decide to
#  use this.  We do appreciate bug-reports  -> mailserver-owner@nic.funet.fi
#  for improving this piece of software.
 *								*
 * ************************************************************ */

/* ************************************************************ *
   Invoked with args:
     mailserver:
	0: `MAIL', 1: Fromaddr, 2: Replyaddr, 3: MessageId, 4: Subject 5: UFrom
     BITNET msg server:
	0: `NMR'  -- not yet implementable (nor decided)

   File handles: 0: stdin (whatnot), 1: stdout, 3: headers from "path",
		 and alike..
 * ************************************************************ */

#define	HDRHANDLE 3	/* header output file handle */

#include <sys/param.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <pwd.h>

#include <netdb.h>
extern int h_errno;

#include <ctype.h>

#define CMD_INPUT_C
#include "config.h"
#include "input.h"

extern char *strchr();
extern char *malloc();
extern void  free();
extern int  errno;
extern char *sys_errlist[];
extern void usage();
extern int  process_input();
extern char *getenv();

extern char *rfc821_error_ptr;
extern char *rfc821_error;

char myhostname[200];

int	 DebugState	= 0;
char	*DebugStr	= NULL;
int	 DoneCommands	= 0;
int	 ftp_uid	= 0;
int	 ftp_gid	= 0;
char	 ftp_home[MAXPATHLEN]	= "";	/* Initial value, real one taken from
					   the  FILESTORE_OWNER's  pw_dir    */
int	 ftp_home_len	= 0;		/* this disables file store commands */
				     
static int replyto	= 0;


struct headers Hdr;

extern void sigsegv_handler();

int
main(argc,argv)
int argc;
char *argv[];
{
	int rc, lines, findreplyto;
	char inpline[1024];
	char *s;
	struct passwd *pwdp = NULL;
	struct hostent *hostent; /* For finding -- via BIND -- my real host name */

	signal(SIGSEGV,sigsegv_handler);
	signal(SIGBUS,sigsegv_handler);

	/* Figure out our domain */
	gethostname( myhostname,sizeof(myhostname) );
	hostent = gethostbyname( myhostname );
	if (hostent == NULL && h_errno == TRY_AGAIN)
	  /* Well, we try again -- once */
	  hostent = gethostbyname( myhostname );
	if (hostent != NULL)
	  strcpy( myhostname, hostent->h_name );


	DebugStr = getenv("DEBUG");	/* Find out our DEBUG environment */
	if (DebugStr && *DebugStr == '1')	/* Defined and not NULL */
	  DebugState = 1;


	SetupLogging();
#ifdef BSD
	setlinebuf(stdout);	/* make sure outputs go out in as much as
				   possible, while still having SOME
				   buffering */
#endif
	/* Grab header address info! */

	if (argc != 7 && (argc != 6))
	  usage("wrong arg cnt, expected 7, got %d\n arg[4]=`%s', arg[5]=`%s'",
		argc,argv[4],argv[5]);
	if (strcmp(*argv,"MAIL")!=0) usage("Arg 0 not `MAIL'");

	Hdr.From	= argv[1];
	Hdr.Reply	= argv[2];
	Hdr.LReply	= xsalloc(argv[2]);
	lowerstr(Hdr.LReply);
	Hdr.OrigReply	= argv[2];
	Hdr.MessageId	= argv[3];
	Hdr.Subject	= argv[4];
	Hdr.UFrom	= argv[5];
	Hdr.ReplyMsgId	= argv[6];
	Hdr.BITNET	= 0;
	s = strchr(Hdr.Reply,'@');
	if (s)
	  s = strchr(s,'.');
	if (s)
	  Hdr.BITNET = ( strcasecmp(s,".BITNET") ==0 );

#if 0
    {
    	int i;
	for(i=0;i<argc;++i)
	  fprintf(stderr,"Argv[%d] = `%s'\n",i,argv[i]);
	fprintf(stderr,"\n");
	fprintf(stderr,"fileno(stdin)=%d\n",fileno(stdin));
	fprintf(stderr,"fileno(stdout)=%d\n",fileno(stdout));
	if ((rc = fcntl(fileno(stdin),F_GETFL,&i)) < 0) {
	  fprintf(stderr,"Error from fcntl(fileno(stdin),F_GETFL,&i), errno=%d (%s)\n",
		  errno,sys_errlist[errno]);
	}
	if ((rc = fcntl(fileno(stdout),F_GETFL,&i)) < 0) {
	  fprintf(stderr,"Error from fcntl(fileno(stdout),F_GETFL,&i), errno=%d (%s)\n",
		  errno,sys_errlist[errno]);
	}
    }
#endif

	pwdp = (struct passwd *)getpwnam(FILESTORE_OWNER);
	if (pwdp) {
	  ftp_uid = pwdp->pw_uid;
	  ftp_gid = pwdp->pw_gid;
	  strcpy(ftp_home,pwdp->pw_dir);
	  ftp_home_len = strlen(ftp_home);
	}

	rc = 0;
	lines = 0;
	findreplyto = 0;

	/* Grab request lines from stdin, process them,
	   write responces to stdout! */
	while (!feof(stdin) && !ferror(stdin)) {
	  /* Get in a line, test EOF, strip NL. */
	  *inpline = 0;
	  if (fgets(inpline,sizeof inpline,stdin) ==NULL) break;
	  if (*inpline == 0) break; /* EOF in one way or another... */
	  ++lines;
	  s = strchr(inpline,'\n');
	  if (s) *s = 0;

	  /* Change tabs -> spaces */
	  s = inpline;
	  while ((s = strchr(s,'\t'))) *s=' ';

	  /* Strip trailing blanks */
	  s = inpline + strlen(inpline);
	  while (s >= inpline && *s == ' ') *s-- = 0;

	  /* See if it is blank line */
	  s = inpline;
	  while (*s && *s == ' ') ++s;
	  if (*s == 0) continue; /* Forget blanks... */

	  /* Right. Suspect it!  Strict RFC-821 compliance! */
	  if (!findreplyto && is_suspect_address(Hdr.Reply)) {
	    printf("\
* Foo!  Won't accept your present reply address (`%s')\n\
*                                                 ",Hdr.Reply);
	    {
	      char *ss = Hdr.Reply;
	      int cnt = 500;
	      while (ss < rfc821_error_ptr && --cnt > 0) printf(" "),++ss;
	      printf("^\n");
	    }
	    printf("* Analyzer report: %s\n",rfc821_error);
	    printf("* Looking for possible `REPLYTO/PATH'\n");
	    findreplyto = 1;
	    rc |= 128;
	  }
	  rc |= process_input(s,&Hdr,stdout,&findreplyto);
	}
	if (!replyto) {
	  FILE *hdrofile = fdopen(HDRHANDLE,"r+");
	  fprintf(hdrofile,"To:          %s\n",Hdr.Reply );
	  fflush(hdrofile);
	}
	printf("\nCount of input lines: %d\nDid %d command(s)\n",
	       lines,DoneCommands);
	if (DoneCommands == 0) {
	  printf("No commands done ???  I hope that is ok...\n");
	  if (rc == 0)
	    printf("No errors either, maybe you should try `help' command ?\n");
	}

	/* All done!  Leave us gracefully. */
	return rc;
}

void
sigsegv_handler()
{
	signal(SIGSEGV,SIG_DFL);
	signal(SIGBUS,SIG_DFL);
	if (!replyto) {
	  FILE *hdrofile = fdopen(HDRHANDLE,"r+");
	  fprintf(hdrofile,"To:          %s\n",Hdr.Reply );
	  fflush(hdrofile);
	}
}


void usage(va_alist) va_dcl
{
	va_list vvar;
	char *form;

	va_start(vvar);
	form = va_arg(vvar,char*);
	printf("\
CMD-INPUT-PROGRAM:\n\
  Many incarnations depening on value of argv[0]:\n\
   `MAIL': 1: Fromaddr, 2: Replyaddr, 3: MessageId, 4: Subject\n\
   others:  to be developed!\n\
For short:  USABLE ONLY VIA FRONT-END PROGRAMS!\n\
Call bug, error: ");
	vprintf(form,vvar);
	va_end(vvar);
	puts("\n");
	exit(2);
}


/* Sweet & simple.
   Find command with linear search.  No need to sort cmd table. */

struct command *
FindCmd(cmdname)
char *cmdname;
{
	struct command *C = Commands;

	while( C->name != NULL ) {
	  if (strcasecmp(cmdname,C->name)==0) return C;
	  ++C;
	}
	return NULL; /* Didn't find command... */
}



int
process_input(inpline,Hdr,outfile,findreplyto)
char *inpline;
struct headers *Hdr;
FILE *outfile;
int *findreplyto;
{
	static int SignatureFlag = 0;
	static int UnrecognizedCommand = 0;
	static int FailedCommand = 0;
	char *s1, *s2;
	struct command *Cmd;
	int rc;

	/* Print current input line */
	fputs("> ",outfile);
	fputs(inpline,outfile);
	fputs("\n",outfile);
	if (UnrecognizedCommand || FailedCommand)
	  /* Failed sometime.. */
	  return 1;
	if (*inpline == '*' || *inpline == '#' ||
	    *inpline == ';' || *inpline == '%')
	  return 0; /* Comment... */
	if (!SignatureFlag && (strcmp(inpline,"--")==0||
			       strcmp(inpline,"-- ")==0))
	  SignatureFlag = 1;
	if (SignatureFlag)
	  /* Well into UNIX style (common anyway) .signature in MAIL.. */
	  return 0;

	/* pick first (command) token */
	s1 = inpline; /* inpline points to first non-white already */
	s2 = inpline;
	while (*s1 && *s1 != ' ') ++s1;
	if (*s1)
	  *s1++ = 0; /* Terminate that first token - if not only token */
	/* If there is input, skip over white spaces.. */
	while (*s1 && *s1 == ' ') ++s1;
	/* Now  s1  points to begining of arguments - or EOS... */

	/* Search from command table */
	if ((Cmd = FindCmd(inpline)) == NULL) {
	  s1 = inpline;
	  while(*s1 && *s1 != ' ' && *s1 != '\t') {
	    if (!isalnum(*s1) && *s1 != '-' && *s1 == '_') break;
	    if (*s1 == ':') {
	      static int PossibleHeadersInBody = 0;
	      fprintf(outfile,"** `%s'%sis not a recognized command.  Try HELP.\n",inpline,strlen(inpline)>30 ? "\n**  ": " ");
	      if (!PossibleHeadersInBody)
		fputs("\
** However, it resembles mail header entry lost into wrong position (into\n\
** mail body that is) and therefore we just skip it.  Please check what your\n\
** mailer/mail gateways do to mails in transit.  There are some pathological\n\
** cases which really call for serious banging on heads of their managers, but\n\
** that is not our business...   YOU should do it! (If it applies here at all)\n\n",
		      outfile);
	      else
		fputs("\
** However, it resembles mail header entry lost into wrong position...\n",
		      outfile);
	      PossibleHeadersInBody = 1;
	      return 1;
	    }
	    ++s1;
	  }

	  UnrecognizedCommand = 1;
	  fprintf(outfile,"** `%s' is not a recognized command.  Try HELP.\n",inpline);
	  fputs("** Rest of the input is flushed.\n\n",outfile);
	  return 1;
	}

	/* Invoke processing subroutine with proper args... */
	if ((*findreplyto == 0)
	    || ((*findreplyto != 0) && (*Cmd->Routine == do_replyto))) {
	  if (*findreplyto != 0) *findreplyto = 0;
	  rc = (*Cmd->Routine)(Cmd,s1,Hdr,outfile);
	  if (rc >= 64) {
	    FailedCommand = 1;
	    fputs("** Previous command terminated with serious enough error,\n** Rest of the input is flushed.\n\n",outfile);
	  }
	} else {
	  fputs("** Accepting only  REPLYTO -command after detecting problems in reply address\n",outfile);
	}

	++DoneCommands;	/* Right, we found a command, lets count it */

	return rc;
}

/* ****************************************************************
 *
 *	do_replyto()  Do all header trickery things..
 *
 * **************************************************************** */
int
do_replyto(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	FILE *hdrofile;

	printf("* You have invoked KLUDGE system - are you sure you can't fix your own broken systems ?\n");

	if (replyto==0) {

	  /* Feature: Enable us to have a `REPLY-TO' COMMAND! */
	  int cracked = 0;
	  char addr[512],realname[512];
	  char *OldReplyTo;
	  *addr = 0; *realname = 0;

	  if (*argstr == 0) {
	    printf("* %s command needs email return address,\n* entire string AFTER command is taken to be one.\n",Cmd->name);
	    return 1;
	  }

	  OldReplyTo = Hdr->Reply;
	  Hdr->Reply = xsalloc(argstr);
	  cracked = crackfrom( addr,realname,Hdr->Reply );
	  strcpy(Hdr->Reply,addr);
	  if (is_suspect_address(Hdr->Reply)) {
	    printf("\
* Foo!  Won't accept your present reply address (`%s')\n\
*                                                 ",Hdr->Reply);
	    {
	      char *ss = Hdr->Reply;
	      int cnt = 500;
	      while (ss < rfc821_error_ptr && --cnt > 0) printf(" "),++ss;
	      printf("^\n");
	    }
	    printf("* Analyzer report: %s\n",rfc821_error);
	    free(Hdr->Reply);
	    Hdr->Reply = OldReplyTo;
	    if (!replyto) {
	      FILE *hdrofile = fdopen(HDRHANDLE,"r+");
	      fprintf(hdrofile,"To:          %s\n",Hdr->Reply );
	      replyto = 1;
	      fflush(hdrofile);
	    }
	    return 255;
	  }
	  free(Hdr->LReply);
	  Hdr->LReply = xsalloc(Hdr->Reply);
	  lowerstr(Hdr->LReply);

	  replyto = 1;

	  hdrofile = fdopen(HDRHANDLE,"r+");
	  fprintf(hdrofile,"To:          %s\n",Hdr->Reply );
	  fprintf(hdrofile,"X-Comment:   %s (Old address)\n",OldReplyTo );
	  fflush(hdrofile);

	  printf("* Rgr. reply to:  `%s'\n", Hdr->Reply);
	  if (strcasecmp(Hdr->Reply,OldReplyTo)==0)
	    printf("* Old address was the same, thus this command didn't change it.\n");
	  else
	    printf("* Old address was: `%s'\n\n", OldReplyTo);
	  return 0;	/* All ok */
	} else {
	  printf("* No good..  %s can be used only once!  Ignored!\n",
		 Cmd->name);
	}
	return 1;	/* Coming here -> something wrong */
}



/* ****************************************************************
 *
 *	FATAL() -- string argument is printed to STDOUT and expited.
 *
 * **************************************************************** */

void
fatal(str)
char *str;
{
	printf("\n** FATAL ERROR: %s\n",str);
	exit(255);
}
