/* ************************************************************* *
 *								 *
 *	FASTCD  database for fast chdir without complete path..	 *
#
#  Copyright 1990-1993   Matti.Aarnio @ FUNET.FI
#  This software is free under similar rules as BSD copyrights.
#  (Definitely this is NOT Public Domain.  "Just" FREELY AVAILABLE.
#   Don't clain you did this..)
#  You can use this, but you shall not held us liable for anything.
#  You must not use our name in marketing, in case you decide to
#  use this.  We do appreciate bug-reports  -> mailserver-owner@nic.funet.fi
#  for improving this piece of software.
 *								 *
 * ************************************************************* */

#define _FAST_CD_DATABASE	"/usr/local/lib/trickle/FastCd.Dbase"

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#ifndef BSD
#include <fcntl.h>
#endif
#include <ndbm.h>

extern int errno;

static DBM *FastCdDBM = NULL;

int
OpenFastCdDBM(flags)
{
	FastCdDBM = dbm_open(_FAST_CD_DATABASE,flags,0644);
if (!FastCdDBM) printf("Failed to open `%s'\n",_FAST_CD_DATABASE);
	return (!FastCdDBM);
}

char *
FindFastCdDir(dirname)
char *dirname;
{
	datum key, result;

	key.dptr = dirname;
	key.dsize = strlen(dirname);

	if (!FastCdDBM)
	  if (OpenFastCdDBM(O_RDONLY)) return NULL; /* RC != 0  --> failure */

	result = dbm_fetch(FastCdDBM,key);
	if (result.dptr)
	  return (char*)xsalloc(result.dptr);
	return NULL;				/* Failed to find anything -> NULL */
}

int
AddFastCdEntry(dirname,dirpath)
char *dirname;
char *dirpath;
{
	datum key;
	datum contents;
	int rc;

	key.dptr = dirname;
	key.dsize = strlen(dirname);
	contents.dptr = dirpath;
	contents.dsize = strlen(dirpath)+1;	/* Need that 0 ! */

	if (!FastCdDBM)
	  if (OpenFastCdDBM(O_CREAT|O_RDWR)) return -1;

	rc = dbm_store(FastCdDBM,key,contents,DBM_INSERT);
	if (rc && errno == 0) { /* Got duplicate ! */
	  contents.dptr = "*";
	  contents.dsize = 2;
	  rc = dbm_store(FastCdDBM,key,contents,DBM_REPLACE);
	}
	return rc;
}

void
CloseFastCdDBM()
{
	if (!FastCdDBM) return;

	dbm_close(FastCdDBM);
	FastCdDBM = NULL;
}

datum
FCdDBMfirstkey()
{
	return dbm_firstkey(FastCdDBM);
}
datum
FCdDBMnextkey()
{
	return dbm_nextkey(FastCdDBM);
}
datum
FCdDBMfetch(key)
datum key;
{
	return dbm_fetch(FastCdDBM,key);
}
