#!/usr/local/bin/perl -s
# testlock.pl -- test locking
# SCCS Status     : @(#)@ testlock	1.2
# Author          : Johan Vromans
# Created On      : Thu Jun  4 21:22:45 1992
# Last Modified By: Johan Vromans
# Last Modified On: Sun Jul 19 13:52:56 1992
# Update Count    : 65
# Status          : 

# Simpel testbed for mail server locking.
#
# To test, execute
#
#   % perl -s testlock.pl -test1 &
#
# It should say "Got the lock -- waiting ...".
# Then execute
#
#   % perl -s testlock.pl -test2 &
#
# It should say "Good. Could not lock -- waiting ...".
# Now kill the first process. The second process should print "ret = 1" 
# and exit.

$my_name = "testlock";
$my_version = "1.2";
#
################ Common stuff ################

$libdir = $ENV{"MSERVLIB"} || "/usr/local/lib/mserv";
unshift (@INC, $libdir);
require "ms_common.pl";

################ Main ################

$tf = "/usr/tmp/f1lock";

if ( defined $test1 ) {

    open ( F1, ">$tf");

    local ($ret) =  &locking (*F1, 0);
    if ( $ret == 1 ) {
	print ("Got the lock -- waiting ...\n");
	sleep 600;
	close (F1);
	unlink ($tf);
	exit (0);
    }

    print ("Locking problem: ret = $ret [$!]\n");
}

if ( defined $test2 ) {

    open (F2, "+<$tf") || print ("Cannot open $tf [$!]\n");

    local ($ret) = &locking (*F2, 0);
    if ( $ret == 0 ) {
	print ("Good, could not lock -- waiting ...\n");
	$ret = &locking (*F2, 1);
	print ("Ret = $ret\n");
	close (F2);
	unlink ($tf);
	exit (0);
    }

    print ("Cannot lock exclusive: ret = $ret [$!]\n");
    close (F2);
}
