echo 'Basic statistics

Explanation of terms: qtime is the time spent by a message in the queue.
xdelay is the latency for a delivery attempt---the time when the attempt
finished, minus the time when it started. ddelay is the latency for a
successful delivery to one recipient---the end of successful delivery,
minus the time when the message was queued.
'

nawk '
  /^m/ {
    ++messages
    mbytes += $4
    rbytes += $4 * $5
    qtime += ($3 - $2)
    recips += ($5 + $6)
    tries += ($5 + $6 + $7)
    if (seen) { if ($2 < first) first = $2 } else { first = $2 }
    if (seen) { if ($3 > last) last = $3 } else { last = $3 }
    seen = 1
  }
  /^d k/ { ++succ; ddelay += ($5 - $3) }
  /^d d/ { ++fail }
  /^d/ {
    ++deliveries
    xdelay += ($5 - $4)
    if (seen) { if ($3 < first) first = $3 } else { first = $3 }
    if (seen) { if ($5 > last) last = $5 } else { last = $5 }
    seen = 1
  }
  END {
    temp = deliveries - succ - fail

    print "Messages:", messages
    print "Recipients:", recips
    if (messages) {
      print "Average message tries:", tries / messages
    }
    print "Total delivery attempts:", deliveries
    print "  success:", succ
    print "  failure:", fail
    print "  deferral:", temp
    print "Message bytes:", mbytes
    print "Message bytes weighted by success:", rbytes
    if (seen && (last > first)) {
      print "Time span (days):", (last - first) / 86400
      if (messages) print "Average message qtime (s):", qtime / messages
      if (deliveries) print "Average xdelay (s):", xdelay / deliveries
      if (succ) print "Average ddelay (s):", ddelay / succ
      print "Average concurrency:", xdelay / (last - first)
    }
  }
'
