nawk '
  /^m/ {
    sender = $10"/"$8
    messages[sender] += 1
    succ[sender] += $5
    fail[sender] += $6
    temp[sender] += $7
    mbytes[sender] += $4
    sbytes[sender] += $4 * $5
    rbytes[sender] += $4 * ($5 + $6)
  }
  /^d/ {
    sender = $10"/"$7
    xdelay[sender] += ($5 - $4)
  }
  END {
    for (sender in messages) {
      print messages[sender],mbytes[sender],sbytes[sender],rbytes[sender],succ[sender] + fail[sender],succ[sender] + fail[sender] + temp[sender],sprintf("%.6f",xdelay[sender]),sender
    }
  }
'
