
# bytes[m]: number of bytes in message m
# qp[m]: qp for message m
# uid[m]: uid that queued message m
# sender[m]: sender of message m
# birth[m]: date of birth of message m
# numk[m]: successes for message m
# numd[m]: failures for message m
# numz[m]: deferrals for message m

# dstart[d]: beginning date of delivery d
# dmsg[d]: message number for delivery d
# dtarget[d]: recipient of delivery d

# XXX should really clear the d arrays on "running"

nawk '
  {
    when = $1
    if ($2 == "starting") {
      d = 0 + $4
      m = $6
      dstart[d] = when
      dmsg[d] = m
      dtarget[d] = $8"."$9
      next
    }
    if ($2 == "delivery") {
      d = 0 + $3
      if (!(d in dstart)) next
      m = dmsg[d]

      result = "?"
      reason = ""
      if ($4 == "success") { ++numk[m]; result = "k" }
      if ($4 == "success:") { ++numk[m]; result = "k"; reason = $5 }
      if ($4 == "deferral:") { ++numz[m]; result = "z"; reason = $5 }
      if ($4 == "report") { ++numz[m]; result = "z"; reason = "report_mangled" }
      if ($4 == "failure") { ++numd[m]; result = "d" }
      if ($4 == "failure:") { ++numd[m]; result = "d"; reason = $5 }
      if (m in sender) {
        print "d",result,birth[m],dstart[d],when,bytes[m],sender[m],dtarget[d],qp[m],uid[m],reason
      } else {
        print "d",result,dstart[d]"?",dstart[d],when,0"?","?",dtarget[d],"?","?",reason
      }
      delete dstart[d]
      delete dmsg[d]
      delete dtarget[d]
      next
    }

    if (($2 == "new") || ($2 == "end")) {
      m = $4
      if ((m in sender) && ($2 == "end")) {
	print "m",birth[m],when,bytes[m],numk[m],numd[m],numz[m],sender[m],qp[m],uid[m]
      }
      delete birth[m]
      delete bytes[m]
      delete qp[m]
      delete uid[m]
      delete sender[m]
      delete numk[m]
      delete numd[m]
      delete numz[m]
      next
    }
    if ($2 == "info") {
      m = 0 + $4
      birth[m] = when
      bytes[m] = $6
      sender[m] = $8
      qp[m] = $10
      uid[m] = $12
      numk[m] = 0
      numd[m] = 0
      numz[m] = 0
      next
    }

    if ($2 == "running") { next }
    if ($2 == "local") { next }
    if ($2 == "remote") { next }
    if ($2 == "number") { next }
    if ($2 == "exiting") { next }

    if ($2 == "bounce") { print "b",$0; next }
    if ($2 == "triple") { print "3",$0; next }
    if ($2 == "warning") { print "!",$0; next }
    if ($2 == "alert") { print "!",$0; next }

    print "?",$0
  }
'
