#include "strerr.h"
#include "subscribe.h"
#include "log.h"

#define FATAL "ezmlm-sub: fatal: "

void die_usage()
{
  strerr_die1x(100,"ezmlm-sub: usage: ezmlm-sub dir box@domain");
}

void main(argc,argv)
int argc;
char **argv;
{
  char *dir;
  char *addr;

  dir = argv[1];
  if (!dir) die_usage();
  addr = argv[2];
  if (!addr) die_usage();

  if (chdir(dir) == -1)
    strerr_die4sys(111,FATAL,"unable to switch to ",dir,": ");

  switch(subscribe(addr,1)) {
    case -2: strerr_die1(100,FATAL,&subscribe_err);
    case -1: strerr_die1(111,FATAL,&subscribe_err);
    case 1: log("+manual",addr);
  }

  _exit(0);
}
