.\"
.\" %nmhwarning%
.\" $Id$
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH MHSTORE %manext1% MH.6.8 [%nmhversion%]
.SH NAME
mhstore \- store contents of MIME messages into files
.SH SYNOPSIS
.in +.5i
.ti -.5i
mhstore \%[+folder] \%[msgs] \%[\-file file]
.br
\%[\-part number]... \%[\-type content]...
.br
\%[\-auto] \%[\-noauto]
\%[\-check] \%[\-nocheck]
.br
\%[\-rcache policy] \%[\-wcache policy]
.br
\%[\-verbose] \%[\-noverbose]
\%[\-version]
\%[\-help]
.in -.5i

.SH DESCRIPTION
The \fImhstore\fR command allows you to store the contents of a
collection of MIME (multi-media) messages into files or other
messages.

\fImhstore\fR manipulates multi-media messages as specified in
RFC\-2045 thru RFC\-2049.

By default, \fImhstore\fR will store all the parts of each message.
Each part will be store in a separate file.  The header fields of
the message are not stored.  By using the `\-part' and `\-type'
switches, you may limit the scope of \fImhstore\fR to particular
subparts (of a multipart content) and/or particular content types.

The option `\-file\ file' directs \fImhstore\fR to use the specified
file as the source message, rather than a message from a folder.
If you specify this file as \*(lq-\*(rq, then \fImhstore\fR will
accept the source message on the standard input.  Note that the
file, or input from standard input should be a validly formatted
message, just like any other \fInmh\fR message.  It should \fBNOT\fR
be in mail drop format (to convert a file in mail drop format to
a folder of \fInmh\fR messages, see \fIinc\fR\0(1)).

A part specification consists of a series of numbers separated by
dots.  For example, in a multipart content containing three parts,
these would be named as 1, 2, and 3, respectively.  If part 2 was
also a multipart content containing two parts, these would be named
as 2.1 and 2.2, respectively.  Note that the `\-part' switch is
effective for only messages containing a multipart content.  If a
message has some other kind of content, or if the part is itself
another multipart content, the `\-part' switch will not prevent
the content from being acted upon.

A content specification consists of a content type and a subtype.
The initial list of \*(lqstandard\*(rq content types and subtypes
can be found in RFC\-2046.
.ne 18
A list of commonly used contents is briefly reproduced here:
.sp
.nf
.in +.5i
.ta \w'application  'u
Type	Subtypes
----	--------
text	plain, enriched
multipart	mixed, alternative, digest, parallel
message	rfc822, partial, external-body
application	octet-stream, postscript
image	jpeg, gif, png
audio	basic
video	mpeg
.re
.in -.5i
.fi
.sp
A legal MIME message must contain a subtype specification.
.PP
To specify a content, regardless of its subtype, just use the name
of the content, e.g., \*(lqaudio\*(rq.  To specify a specific
subtype, separate the two with a slash, e.g., \*(lqaudio/basic\*(rq.
Note that regardless of the values given to the `\-type' switch,
a multipart content (of any subtype listed above) is always acted
upon.  Further note that if the `\-type' switch is used, and it is
desirable to act on a message/external-body content, then the
`\-type' switch must be used twice: once for message/external-body
and once for the content externally referenced.

.Uh "Checking the Contents"
The `\-check' switch tells \fImhstore\fR to check each content for
an integrity checksum.  If a content has such a checksum (specified
as a Content-MD5 header field), then \fImhstore\fR will attempt to
verify the integrity of the content.

.Uh "Storing the Contents"
The \fImhstore\fR will store the contents of the named messages in
\*(lqnative\*(rq (decoded) format.  Two things must be determined:
the directory to store the content, and the filenames.  Files are
written in the directory given by the \fBnmh-storage\fR profile
entry,
.ne 6
e.g.,
.sp
.in +.5i
nmh-storage: /tmp
.in -.5i
.sp
If this entry isn't present,
the current working directory is used.

If the `\-auto' switch is given, then \fImhstore\fR will check if
the message contains information indicating the filename that should
be used to store the content.  This information should be specified
as the attribute \*(lqname=filename\*(rq in the Content-Type header
for the content you are storing.  For security reasons, this filename
will be ignored if it begins with the character '/', '.', '|', or
'!', or if it contains the character '%'.  For the sake of security,
this switch is not the default, and it is recommended that you do
NOT put the `\-auto' switch in your \&.mh\(ruprofile file.

If the `\-auto' switch is not given (or is being ignored for security
reasons) then \fImhstore\fR will look in the user's profile for a
\*(lqformatting string\*(rq to determine how the different contents
should be stored.  First, \fImhstore\fR will look for an entry of
the form:
.sp
.in +.5i
mhn-store-<type>/<subtype>
.in -.5i
.sp
to determine the formatting string.  If this isn't found, \fImhstore\fR
will look for an entry of the form:
.sp
.in +.5i
mhn-store-<type>
.in -.5i
.sp
to determine the formatting string.

If the formatting string starts with a \*(lq+\*(rq character, then
content is stored in the named folder.  A formatting string consisting
solely of a \*(lq+\*(rq character is interpreted to be the current
folder.

If the formatting string consists solely of a \*(lq-\*(rq character,
then the content is sent to the standard output.

If the formatting string starts with a '|', then the display string
will represent a command for \fImhstore\fR to execute which should
ultimately store the content.  The content will be passed to the
standard input of the command.  Before the command is executed,
\fImhstore\fR will change to the appropriate directory, and any
escapes (given below) in the display string will be expanded.

Otherwise the formatting string will represent a pathname in which
to store the content.  If the formatting string starts with a '/',
then the content will be stored in the full path given, else the
file name will be relative to the value of \fBnmh-storage\fR or
the current working directory.  Any escapes (given below) will be
expanded, except for the a-escape.

A command or pathname formatting string may contain the following
escapes.  If the content isn't part of a multipart (of any subtype
listed above) content, the p-escapes are ignored.
.sp
.nf
.in +.5i
.ta \w'%P  'u
%a	Parameters from Content-type  (only valid with command)
%m	Insert message number
%P	Insert part number with leading dot
%p	Insert part number without leading dot
%t	Insert content type
%s	Insert content subtype
%%	Insert character %
.re
.in -.5i
.fi
.sp
If no formatting string is found, \fImhstore\fR will check to see
if the content is application/octet-stream with parameter
\*(lqtype=tar\*(rq.  If so, \fImhstore\fR will choose an appropriate
filename.  If the content is not application/octet-stream, then
\fImhstore\fR will check to see if the content is a message.  If
so, \fImhstore\fR will use the value \*(lq+\*(rq.  As a last resort,
\fImhstore\fR will use the value \*(lq%m%P.%s\*(rq.

.ne 10
Example profile entries might be:
.sp
.nf
.in +.5i
mhn-store-text: %m%P.txt
mhn-store-text: +inbox
mhn-store-message/partial: +
mhn-store-audio/basic: | raw2audio -e ulaw -s 8000 -c 1 > %m%P.au
mhn-store-image/jpeg: %m%P.jpg
mhn-store-application/PostScript: %m%P.ps
.in -.5i
.fi
.sp
.Uh "Reassembling Messages of Type message/partial"
\fImhstore\fR is also able to reassemble messages that have been
split into multiple messages of type \*(lqmessage/partial\*(rq.

When asked to store a content containing a partial message,
\fImhstore\fR will try to locate all of the portions and combine
them accordingly.  The default is to store the combined parts as
a new message in the current folder, although this can be changed
using formatting strings as discussed above.  Thus, if someone has
sent you a message in several parts (such as the output from
\fIsendfiles\fR), you can easily reassemble them all into a single
message in the following fashion:
.sp
.nf
.in +.5i
% mhlist 5-8
 msg part  type/subtype             size description
   5       message/partial           47K part 1 of 4
   6       message/partial           47K part 2 of 4
   7       message/partial           47K part 3 of 4
   8       message/partial           18K part 4 of 4
% mhstore 5-8
reassembling partials 5,6,7,8 to folder inbox as message 9
% mhlist -verbose 9
 msg part  type/subtype             size description
   9       application/octet-stream 118K
             (extract with uncompress | tar xvpf -)
             type=tar
             conversions=compress
.in -.5i
.fi
.sp
This will store exactly one message, containing the sum of the
parts.  It doesn't matter whether the partials are specified in
order, since \fImhstore\fR will sort the partials, so that they
are combined in the correct order.  But if \fImhstore\fR can not
locate every partial necessary to reassemble the message, it will
not store anything.

.Uh "External Access"
For contents of type message/external-body,
.ne 12
\fImhstore\fR supports these access-types:
.sp
.nf
.in +.5i
afs
anon-ftp
ftp
local-file
mail-server
.in -.5i
.fi
.sp
For the \*(lqanon-ftp\*(rq and \*(lqftp\*(rq access types,
\fImhstore\fR will look for the \fBmhn-access-ftp\fR
profile entry,
.ne 6
e.g.,
.sp
.in +.5i
mhn-access-ftp: myftp.sh
.in -.5i
.sp
to determine the pathname of a program to perform the FTP retrieval.
.ne 14
This program is invoked with these arguments:
.sp
.nf
.in +.5i
domain name of FTP-site
username
password
remote directory
remote filename
local filename
\*(lqascii\*(rq or \*(lqbinary\*(rq
.in -.5i
.fi
.sp
The program should terminate with an exit status of zero if the
retrieval is successful, and a non-zero exit status otherwise.

If this entry is not provided, then \fImhstore\fR will use a simple
built-in FTP client to perform the retrieval.

.Uh "The Content Cache"
When \fImhstore\fR encounters an external content containing a
\*(lqContent-ID:\*(rq field, and if the content allows caching, then
depending on the caching behavior of \fImhstore\fR, the content might be
read from or written to a cache.

The caching behavior of \fImhstore\fR is controlled with the `\-rcache'
and `\-wcache' switches, which define the policy for reading from,
and writing to, the cache, respectively.  One of four policies may be
specified: \*(lqpublic\*(rq, indicating that \fImhstore\fR should make use
of a publically-accessible content cache; \*(lqprivate\*(rq, indicating
that \fImhstore\fR should make use of the user's private content cache;
\*(lqnever\*(rq, indicating that \fImhstore\fR should never make use of
caching; and, \*(lqask\*(rq, indicating that \fImhstore\fR should ask
the user.

There are two directories where contents may be cached: the profile entry
\fBnmh-cache\fR names a directory containing world-readable contents, and,
the profile entry \fBnmh-private-cache\fR names a directory containing
private contents.  The former should be an absolute (rooted) directory
name.
.ne 6
For example,
.sp
.in +.5i
nmh-cache: /tmp
.in -.5i
.sp
might be used if you didn't care that the cache got wiped after each
reboot of the system.  The latter is interpreted relative to the user's
nmh directory, if not rooted,
.ne 6
e.g.,
.sp
.in +.5i
nmh-private-cache: .cache
.in -.5i
.sp
(which is the default value).

.Uh "User Environment"
Because the environment in which \fImhstore\fR operates may vary
for different machines, \fImhstore\fR will look for the environment
variable \fB$MHSTORE\fR.  If present, this specifies the name of
an additional user profile which should be read.  Hence, when a
user logs in on a machine, this environment variable should be set
to refer to a file containing definitions useful for that machine.
Finally, \fImhstore\fR will attempt to consult one other additional
user profile,
.ne 6
e.g.,
.sp
.in +.5i
%etcdir%/mhn.defaults
.in -.5i
.sp
which is created automatically during nmh installation.
.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
^$MHSTORE~^Additional profile entries
^%etcdir%/mhn.defaults~^System-default profile entries
.Pr
^Path:~^To determine the user's nmh directory
.Ps
^Current\-Folder:~^To find the default current folder
.Ps
^mhn-access-ftp:~^Program to retrieve contents via FTP
.Ps
^nmh-cache~^Public directory to store cached external contents
.Ps
^nmh-private-cache~^Personal directory to store cached external contents
.Ps
^nmh-storage~^Directory to store contents
.Ps
^mhn-store-<type>*~^Template for storing contents
.Sa
mhbuild(1), mhlist(1), mhshow(1), sendfiles(1)
.br
RFC\-2045:
.br
   \fIMultipurpose Internet Mail Extensions (MIME) Part One:
.br
   Format of Internet Message Bodies\fR,
.br
RFC\-2046:
.br
   \fIMultipurpose Internet Mail Extensions (MIME) Part Two:
.br
   Media Types\fR,
.br
RFC\-2047:
.br
   \fIMultipurpose Internet Mail Extensions (MIME) Part Three:
.br
   Message Header Extensions for Non-ASCII Text\fR,
.br
RFC\-2048:
.br
   \fIMultipurpose Internet Mail Extensions (MIME) Part Four:
.br
   Registration Procedures\fR,
.br
RFC\-2049:
.br
   \fIMultipurpose Internet Mail Extensions (MIME) Part Five:
.br
   Conformance Criteria and Examples\fR.
.De
`+folder' defaults to the current folder
.Ds
`msgs' defaults to cur
.Ds
`\-noauto'
.Ds
`\-nocheck'
.Ds
`\-rcache ask'
.Ds
`\-wcache ask'
.Ds
`\-noverbose'
.Co
If a folder is given, it will become the current folder.  The last
message selected will become the current message.
.Bu
Partial messages contained within a multipart content are not reassembled.
.En
