
/*
 * folder_pack.c -- pack (renumber) the messages in a folder
 *               -- into a contiguous range from 1 to n.
 *
 * $Id$
 */

#include <h/mh.h>

/*
 * Pack the message in a folder.
 * Return -1 if error, else return 0.
 */

int
folder_pack (struct msgs **mpp, int verbose)
{
    int hole, msgnum;
    char newmsg[BUFSIZ], oldmsg[BUFSIZ];
    struct msgs *mp;

    mp = *mpp;

    /*
     * Just return if folder is empty.
     */
    if (mp->nummsg == 0)
	return 0;

    /*
     * Make sure we have message status space allocated
     * for all numbers from 1 to current high message.
     */
    if (mp->lowoff > 1) {
	if ((mp = folder_realloc (mp, 1, mp->hghmsg)))
	    *mpp = mp;
	else {
	    advise (NULL, "unable to allocate folder storage");
	    return -1;
	}
    }

    for (msgnum = mp->lowmsg, hole = 1; msgnum <= mp->hghmsg; msgnum++) {
	if (does_exist (mp, msgnum)) {
	    if (msgnum != hole) {
		strcpy (newmsg, m_name (hole));
		strcpy (oldmsg, m_name (msgnum));
		if (verbose)
		    printf ("message %s becomes %s\n", oldmsg, newmsg);
		if (rename (oldmsg, newmsg) == -1) {
		    advise (newmsg, "unable to rename %s to", oldmsg);
		    return -1;
		}
		if (msgnum == mp->curmsg)
		    seq_setcur (mp, mp->curmsg = hole);
		copy_msg_flags (mp, hole, msgnum);
		mp->msgflags |= SEQMOD;
		if (msgnum == mp->lowsel)
		    mp->lowsel = hole;
		if (msgnum == mp->hghsel)
		    mp->hghsel = hole;
	    }
	    hole++;
	}
    }

    /* record the new number for high/low message */
    mp->lowmsg = 1;
    mp->hghmsg = hole - 1;

    return 0;
}
