
/*
 * seq_del.c -- delete message(s) from a sequence
 *
 * $Id$
 */

#include <h/mh.h>


/*
 * Delete all SELECTED messages from sequence
 */

int
seq_delsel (struct msgs *mp, char *cp, int public, int zero)
{
    int i, msgnum;

    if (!seq_nameok (cp))
	return 0;

    /* find the index for the sequence */
    for (i = 0; mp->msgattrs[i]; i++) {
	if (!strcmp (mp->msgattrs[i], cp))
	    break;
    }

    /*
     * If the zero flag is set, first add all existing
     * messages in this folder to the sequence.
     */
    if (zero) {
	/* create the sequence, if necessary */
	if (mp->msgattrs[i] == NULL) {
	    if (i >= NUMATTRS) {
		advise (NULL, "only %d sequences allowed (no room for %s)!", NUMATTRS, cp);
		return 0;
	    }
	    mp->msgattrs[i] = getcpy (cp);
	    mp->msgattrs[i + 1] = NULL;
	}
	/* now add sequence bit to all existing messages */
	for (msgnum = mp->lowmsg; msgnum <= mp->hghmsg; msgnum++) {
	    if (mp->msgstats[msgnum] & EXISTS)
		add_sequence (mp, i, msgnum);
	    else
		clear_sequence (mp, i, msgnum); /* probably not needed */
	}
    } else {
	if (mp->msgattrs[i] == NULL) {
	    advise (NULL, "no such sequence as %s", cp);
	    return 0;
	}
    }

    /*
     * Now clear the bit on all selected messages
     */
    for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++)
	if (is_selected (mp, msgnum))
	    clear_sequence (mp, i, msgnum);

    mp->msgflags |= SEQMOD;
    return 1;
}


/*
 * Delete message from sequence.
 */

int
seq_delmsg (struct msgs *mp, char *cp, int msgnum)
{
    int i;

    if (!seq_nameok (cp))
	return 0;

    for (i = 0; mp->msgattrs[i]; i++) {
	if (!strcmp (mp->msgattrs[i], cp)) {
	    clear_sequence (mp, i, msgnum);
	    mp->msgflags |= SEQMOD;
	    return 1;
	}
    }

    advise (NULL, "no such sequence as %s", cp);
    return 0;
}
