
/*
 * rcvtty.c -- a rcvmail program (a lot like rcvalert) handling IPC ttys
 *
 * $Id$
 */

#ifndef BSD42
# undef TTYD
#endif

#include <h/mh.h>
#include <h/signals.h>
#include <h/rcvmail.h>
#include <h/scansbr.h>
#include <zotnet/tws/tws.h>
#include <signal.h>
#include <fcntl.h>

#ifndef	TTYD
# include <utmp.h>
# ifndef UTMP_FILE
#  define UTMP_FILE "/etc/utmp"
# endif
#endif

#define	SCANFMT	\
"%2(hour{dtimenow}):%02(min{dtimenow}): %<(size)%5(size) %>%<{encrypted}E%>\
%<(mymbox{from})%<{to}To:%14(friendly{to})%>%>%<(zero)%17(friendly{from})%>  \
%{subject}%<{body}<<%{body}>>%>"

static struct swit switches[] = {
#define	BIFFSW	0
    { "biff", 0 },
#define	FORMSW	1
    { "form formatfile", 0 },
#define	FMTSW	2
    { "format string", 5 },
#define NLSW    3
    { "newline", 0 },
#define NNLSW   4
    { "nonewline", 0 },
#define BELSW	5
    { "bell", 0 },
#define	NBELSW	6
    { "nobell", 0 },
#define VERSIONSW 7
    { "version", 0 },
#define	HELPSW	8
    { "help", 4 },
    { NULL, 0 }
};

static jmp_buf myctx;
static int bell = 1;
static int newline = 1;
static int biff = 0;
static char *form = NULL;
static char *format = NULL;

/*
 * prototypes
 */
char *getusr(void);
static RETSIGTYPE alrmser (int);
static int message_fd (char **);
static int header_fd (void);
static void alert (char *, int);


main (int argc, char **argv)
{
    int md, vecp = 0;
    char *cp, *user, buf[100], **ap;
    char **argp, *arguments[MAXARGS], *vec[MAXARGS];

#ifndef	TTYD
    char tty[BUFSIZ];
    struct utmp ut;
    register FILE *uf;
#endif	/* not TTYD */

#ifdef LOCALE
    setlocale(LC_ALL, "");
#endif
    invo_name = r1bindex (argv[0], '/');
    mts_init (invo_name);
    if ((cp = m_find (invo_name)) != NULL) {
	ap = brkstring (cp = getcpy (cp), " ", "\n");
	ap = copyip (ap, arguments);
    }
    else
	ap = arguments;
    copyip (argv + 1, ap);
    argp = arguments;

    while ((cp = *argp++)) {
	if (*cp == '-')
	    switch (smatch (++cp, switches)) {
		case AMBIGSW: 
		    ambigsw (cp, switches);
		    done (1);
		case UNKWNSW: 
		    vec[vecp++] = --cp;
		    continue;

		case HELPSW: 
		    sprintf (buf, "%s [command ...]", invo_name);
		    print_help (buf, switches);
		    done (1);
		case VERSIONSW:
		    print_version(invo_name);
		    done (1);

		case BIFFSW:
		    biff = 1;
		    continue;

		case FORMSW: 
		    if (!(form = *argp++) || *form == '-')
			adios (NULL, "missing argument to %s", argp[-2]);
		    format = NULL;
		    continue;
		case FMTSW: 
		    if (!(format = *argp++) || *format == '-')
			adios (NULL, "missing argument to %s", argp[-2]);
		    form = NULL;
		    continue;

                case NLSW:
                    newline = 1;
                    continue;
                case NNLSW:
                    newline = 0;
                    continue;
                case BELSW:
                    bell = 1;
                    continue;
                case NBELSW:
                    bell = 0;
                    continue;

	    }
	vec[vecp++] = cp;
    }
    vec[vecp] = 0;

    if ((md = vecp ? message_fd (vec) : header_fd ()) == NOTOK)
	exit (RCV_MBX);

    user = getusr();
#ifndef	TTYD
    if ((uf = fopen (UTMP_FILE, "r")) == NULL)
	exit (RCV_MBX);
    while (fread ((char *) &ut, sizeof(ut), 1, uf) == 1)
	if (ut.ut_name[0] != 0
		&& strncmp (user, ut.ut_name, sizeof(ut.ut_name)) == 0) {
	    strncpy (tty, ut.ut_line, sizeof(ut.ut_line));
	    alert (tty, md);
	}
    fclose (uf);
#else /* TTYD */
    alert (user, md);
#endif /* TTYD */

    exit (RCV_MOK);
}


static RETSIGTYPE
alrmser (int i)
{
#ifndef RELIABLE_SIGNALS
    SIGNAL (SIGALRM, alrmser);
#endif

    longjmp (myctx, DONE);
}


static int
message_fd (char **vec)
{
    pid_t child_id;
    int bytes, fd;
    char tmpfil[BUFSIZ];
    struct stat st;

    unlink (mktemp (strcpy (tmpfil, "/tmp/rcvttyXXXXX")));
    if ((fd = open (tmpfil, O_RDWR | O_CREAT | O_TRUNC, 0600)) == NOTOK)
	return header_fd ();
    unlink (tmpfil);

    if ((child_id = vfork()) == NOTOK) {
	/* fork error */
	close (fd);
	return header_fd ();
    } else if (child_id) {
	/* parent process */
	if (!setjmp (myctx)) {
	    SIGNAL (SIGALRM, alrmser);
	    bytes = fstat(fileno (stdin), &st) != NOTOK ? (int) st.st_size : 100;
	    if (bytes <= 0)
		bytes = 100;
	    alarm ((unsigned) (bytes * 60 + 300));
	    pidwait(child_id, OK);
	    alarm (0);
	    if (fstat (fd, &st) != NOTOK && st.st_size > (off_t) 0)
		return fd;
	} else {
	    KILLPG(child_id, SIGKILL);
	}
	close (fd);
	return header_fd ();
    }

    /* child process */
    rewind (stdin);
    if (dup2 (fd, 1) == NOTOK || dup2 (fd, 2) == NOTOK)
	_exit (-1);
    closefds (3);
#ifdef BSD42
    setpgrp (0, getpid ());
#endif
    execvp (vec[0], vec);
    _exit (-1);
}


static int
header_fd (void)
{
    int fd;
    char tmpfil[BUFSIZ];

    strcpy (tmpfil, m_tmpfil (invo_name));
    if ((fd = open (tmpfil, O_RDWR | O_CREAT | O_TRUNC, 0600)) == NOTOK)
	return NOTOK;
    unlink (tmpfil);

    rewind (stdin);
    scan (stdin, 0, 0, new_fs (form, format, SCANFMT), 0, 0, 0, 0, 0L, 0);
    if (newline)
        write (fd, "\n\r", 2);
    write (fd, scanl, strlen (scanl));
    if (bell)
        write (fd, "\007", 1);

    return fd;
}


#ifndef	TTYD

static void
alert (char *tty, int md)
{
    int i, td, mask;
    char buffer[BUFSIZ], ttyspec[BUFSIZ];
    struct stat st;

    sprintf (ttyspec, "/dev/%s", tty);

    /*
     * The mask depends on whether we are checking for
     * write permission based on `biff' or `mesg'.
     */
    mask = biff ? S_IEXEC : (S_IWRITE >> 3);
    if (stat (ttyspec, &st) == NOTOK || (st.st_mode & mask) == 0)
	return;

    if (!setjmp (myctx)) {
	SIGNAL (SIGALRM, alrmser);
	alarm (2);
	td = open (ttyspec, 1);
	alarm (0);
	if (td == NOTOK)
	    return;
    } else {
	alarm (0);
	return;
    }

    lseek (md, (off_t) 0, SEEK_SET);

    while ((i = read (md, buffer, sizeof(buffer))) > 0)
	if (write (td, buffer, i) != i)
	    break;

    close (td);
}

#else /* TTYD */

static void
alert (char *user, int md)
{
    int i, td;
    char buffer[BUFSIZ];

    if ((td = ttyw ("notify", NULL, NULL, user)) == NOTOK)
	return;
    SIGNAL (SIGPIPE, SIG_IGN);

    lseek (md, (off_t), SEEK_SET);
    while ((i = read (md, buffer, sizeof(buffer))) > 0)
	if (write (td, buffer, i) != i)
	    break;

    close (td);
}

#endif /* TTYD */

