.\"
.\" %nmhwarning%
.\" $Id$
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH COMP %manext1% MH.6.8 [%nmhversion%]
.SH NAME
comp \- compose a message
.SH SYNOPSIS
.in +.5i
.ti -.5i
comp 
\%[+folder] \%[msg]
\%[\-draftfolder\ +folder] \%[\-draftmessage\ msg] \%[\-nodraftfolder]
\%[\-editor\ editor] \%[\-noedit]
\%[\-file\ file]
\%[\-form\ formfile]
\%[\-use] \%[\-nouse]
\%[\-whatnowproc\ program] \%[\-nowhatnowproc]
\%[\-version]
\%[\-help]
.in -.5i
.SH DESCRIPTION
\fIComp\fR is used to create a new message to be mailed.  It copies a
message form to the draft being composed and then invokes an editor on
the draft (unless `\-noedit' is given, in which case the initial edit
is suppressed).

The default message form contains the following elements:

.nf
.in +.5i
.ne 10
.eo
.so %etcdir%/components
.ec
.in -.5i
.fi

If the file named \*(lqcomponents\*(rq exists in the user's nmh directory,
it will be used instead of this form.  The file specified by `\-form\
formfile' will be used if given.  You may also start \fIcomp\fR using
the contents of an existing message as the form.  If you supply either
a `+folder' or `msg' argument, that message will be used as the form.
You may not supply both a `\-form\ formfile' and a `+folder' or \&`msg'
argument.  The line of dashes or a blank line must be left between the
header and the body of the message for the message to be identified
properly when it is sent (see \fIsend\fR\0(1)).  The switch `\-use'
directs \fIcomp\fR to continue editing an already started message.
That is, if a \fIcomp\fR (or \fIdist\fR, \fIrepl\fR, or \fIforw\fR\0)
is terminated without sending the draft, the draft can be edited again
via \*(lqcomp\ \-use\*(rq.

If the draft already exists, \fIcomp\fR will ask you as to the disposition
of the draft.  A reply of \fBquit\fR will abort \fIcomp\fR, leaving
the draft intact; \fBreplace\fR will replace the existing draft with
the appropriate form; \fBlist\fR will display the draft; \fBuse\fR will
use the draft for further composition; and \fBrefile\ +folder\fR will
file the draft in the given folder, and give you a new draft with the
appropriate form.  (The `+folder' argument to \fBrefile\fR is required.)

The `\-draftfolder\ +folder' and `\-draftmessage\ msg' switches invoke
the \fInmh\fR draft folder facility.  This is an advanced (and highly
useful) feature.  Consult the \fBAdvanced Features\fR section of the
\fInmh\fR manual for more information.

The `\-file\ file' switch says to use the named file as the message draft.

The `\-editor\ editor' switch indicates the editor to use for the
initial edit.  Upon exiting from the editor, \fIcomp\fR will invoke
the \fIwhatnow\fR program.  See \fIwhatnow\fR\0(1) for a discussion of
available options.  The invocation of this program can be inhibited
by using the `\-nowhatnowproc' switch.  (In truth of fact, it is
the \fIwhatnow\fR program which starts the initial edit.  Hence,
`\-nowhatnowproc' will prevent any edit from occurring.)
.Fi
^%etcdir%/components~^The message skeleton
^or <mh\-dir>/components~^Rather than the standard skeleton
^$HOME/\&.mh\(ruprofile~^The user profile
^<mh\-dir>/draft~^The draft file
.Pr
^Path:~^To determine the user's nmh directory
.Ps
^Draft\-Folder:~^To find the default draft\-folder
.Ps
^Editor:~^To override the default editor
.Ps
^Msg\-Protect:~^To set mode when creating a new message (draft)
.Ps
^fileproc:~^Program to refile the message
.Ps
^whatnowproc:~^Program to ask the \*(lqWhat now?\*(rq questions
.Sa
dist(1), forw(1), repl(1), send(1), whatnow(1), mh-profile(5)
.De
`+folder' defaults to the current folder
.Ds
`msg' defaults to the current message
.Ds
`\-nodraftfolder'
.Ds
`\-nouse'
.Co
None
.Bu
If \fIwhatnowproc\fR is \fIwhatnow\fR, then \fIcomp\fR uses a built\-in
\fIwhatnow\fR, it does not actually run the \fIwhatnow\fR program.
Hence, if you define your own \fIwhatnowproc\fR, don't call it
\fIwhatnow\fR since \fIcomp\fR won't run it.
.En
