
/*
 * advertise.c -- the heart of adios and advise
 */

#ifndef	lint
static char ident[] = "$Id$";
#endif	/* lint */

#include "../h/mh.h"
#include <stdio.h>

#ifdef HAVE_WRITEV
# include <sys/types.h>
# include <sys/uio.h>
#endif

/*
 * Use writev() if available, for slightly better performance.  Why?
 * Well, there are a couple of reasons.  Primarily, it gives a smoother
 * output...  More importantly though, it's a sexy syscall()...
 */

extern int errno;

#ifndef	BSD44	/* in <stdio.h> */
extern int sys_nerr;
extern char *sys_errlist[];
#endif


/* VARARGS3 */

void
advertise (char *what, char *tail, char *fmt, char *a,
           char *b, char *c, char *d, char *e, char *f)
{
    int	eindex = errno;

#ifdef HAVE_WRITEV
    char buffer[BUFSIZ], err[BUFSIZ];
    struct iovec iob[20], *iov;
#endif

    fflush (stdout);

#ifdef HAVE_WRITEV
    fflush (stderr);
    iov = iob;

    if (invo_name && *invo_name) {
	iov->iov_len = strlen (iov->iov_base = invo_name);
	iov++;
	iov->iov_len = strlen (iov->iov_base = ": ");
	iov++;
    }
    
    sprintf (buffer, fmt, a, b, c, d, e, f);
    iov->iov_len = strlen (iov->iov_base = buffer);
    iov++;
    if (what) {
	if (*what) {
	    iov->iov_len = strlen (iov->iov_base = " ");
	    iov++;
	    iov->iov_len = strlen (iov->iov_base = what);
	    iov++;
	    iov->iov_len = strlen (iov->iov_base = ": ");
	    iov++;
	}
	if (eindex > 0 && eindex < sys_nerr)
	    iov->iov_len = strlen (iov->iov_base = sys_errlist[eindex]);
	else {
	    sprintf (err, "Error %d", eindex);
	    iov->iov_len = strlen (iov->iov_base = err);
	}
	iov++;
    }
    if (tail && *tail) {
	iov->iov_len = strlen (iov->iov_base = ", ");
	iov++;
	iov->iov_len = strlen (iov->iov_base = tail);
	iov++;
    }
    iov->iov_len = strlen (iov->iov_base = "\n");
    iov++;
    writev (fileno (stderr), iob, iov - iob);
#else
    if (invo_name && *invo_name)
	fprintf (stderr, "%s: ", invo_name);
    fprintf (stderr, fmt, a, b, c, d, e, f);
    if (what) {
	if (*what)
	    fprintf (stderr, " %s: ", what);
	if (eindex > 0 && eindex < sys_nerr)
	    fprintf (stderr, "%s", sys_errlist[eindex]);
	else
	    fprintf (stderr, "Error %d", eindex);
    }
    if (tail)
	fprintf (stderr, ", %s", tail);
    fputc ('\n', stderr);
#endif
}
