.\"
.\" %nmhwarning%
.\" $Id$
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH MHN %manext1% MH.6.8 [%nmhversion%]
.SH NAME
mhn \- multi-media MH
.SH SYNOPSIS
.in +.5i
.ti -.5i
mhn
\%[\%[+folder] \%[msgs] | \%[\-file\0file]]
.br
\%[\-part\0number]... \%[\-type\0content]...
.br
\%[\-list\0\%[\-headers]\0\%[\-noheaders]
.br
       \%[\-realsize]\0\%[\-norealsize]] \%[-nolist]
.br
\%[\-show\0\%[\-serialonly]\0\%[\-noserialonly]
.br
       \%[\-form\0formfile]\0\%[\-pause]\0\%[\-nopause]] \%[\-noshow]
.br
\%[\-store\0\%[\-auto]\0\%[\-noauto]] \%[\-nostore]
.br
\%[\-cache] \%[\-nocache] \%[\-rcache\0policy] \%[\-wcache\0policy]
.br
\%[\-check]\0\%[\-nocheck]
.br
\%[\-ebcdicsafe]\0\%[\-noebcdicsafe]
.br
\%[\-rfc934mode]\0\%[\-norfc934mode]
.br
\%[\-verbose]\0\%[\-noverbose]
.br
\%[\-version]
.br
\%[\-help]
.in -.5i
.SH DESCRIPTION
The \fImhn\fR command manipulates multi-media messages as specified in
RFC 1521.

Four action switches direct the operation of \fImhn\fR,
namely `\-list', `\-show', `\-store', and `-cache'.
Any of these switches may be used concurrently.
Normally these action switches will operate on the content of each of the
named messages.
However,
by using the `\-part' and `\-type' switches,
the scope of the operation can be focused on particular
subparts (of a multipart content) and/or particular content types.

A part specification consists of a series of numbers separated by dots.
For example,
in a multipart content containing three parts,
these would be named as 1, 2, and 3, respectively.
If part 2 was also a multipart content containing two parts,
these would be named as 2.1 and 2.2, respectively.
Note that the `\-part' switch is effective for only messages
containing a multipart content.
If a message has some other kind of content,
or if the part is itself another multipart content,
the `\-part' switch will not prevent the content from being acted upon.

A content specification consists of a content type and a subtype.
The initial list of \*(lqstandard\*(rq content types and subtypes can be found
in RFC 1521.
.ne 18
A list of commonly used contents is briefly reproduced here:
.sp
.nf
.in +.5i
.ta \w'application  'u
Type	Subtypes
----	--------
text	plain
multipart	mixed, alternative, digest, parallel
message	rfc822, partial, external-body
application	octet-stream, postscript
image	jpeg, gif, x-pbm, x-pgm, x-ppm, x-xwd
audio	basic
video	mpeg
.re
.in -.5i
.fi
.sp
Subtypes are mandatory.
.PP
To specify a content,
regardless of its subtype,
just use the name of the content,
e.g.,
\*(lqaudio\*(rq.
To specify a specific subtype,
separate the two with a slash,
e.g.,
\*(lqaudio/basic\*(rq.
Note that regardless of the values given to the `\-type' switch,
a multipart content (of any subtype listed above) is always acted upon.
Further note that if the `\-type' switch is used,
and it is desirable to act on a message/external-body content,
then the `\-type' switch must be used twice:
once for message/external-body and once for the content externally referenced.

Each content may optionally have an integrity check associated with it.
If present and the `-check' switch is given,
then \fImhn\fR will attempt to verify the integrity of the content.

The option `\-file\ file' directs \fImhn\fR to use the specified
file as the source message, rather than a message from
a folder.
Note that the file should be a validly formatted message,
just like any other \fIMH\fR message.
It should \fBNOT\fR be in mail drop format
(to convert a file in mail drop format to a folder of \fIMH\fR messages,
see \fIinc\fR\0(1)).

.Uh "Listing the Contents"
The `\-list' switch tells \fImhn\fR to list the table of contents
associated with the named messages.
The `\-headers' switch indicates that a one-line banner should be
displayed above the listing.
The `\-realsize' switch tells \fImhn\fR to evaluate the \*(lqnative\*(rq
(decoded) format of each content prior to listing.
This provides an accurate count at the expense of a small delay.

.Uh "Showing the Contents"
The `\-show' switch tells \fImhn\fR to display the contents of the named
messages.
The headers of the message are displayed with the \fImhlproc\fR,
using format file \fImhl.headers\fR.
(The choice of format file can be overridden by the `\-form\0formfile' switch.)

\fImhn\fR will look for information in the user's profile to determine
how the different contents should be displayed.
This is accomplished by consulting a display string,
and executing it under \fB/bin/sh\fR,
with the standard input set to the content.
.ne 16
The display string may contain these escapes:
.sp
.nf
.in +.5i
.ta \w'%F  'u
%a	additional arguments
%e	exclusive execution
%f	filename containing content
%F	%e, %f, and stdin is terminal not content
%l	display listing prior to displaying content
%p	%l, and ask for confirmation
%s	subtype
%d	content description
.re
.in -.5i
.fi
.sp
For those display strings containing the e- or F-escape,
\fImhn\fR will execute at most one of these at any given time.
Although the F-escape expands to be the filename containing the content,
the e-escape has no expansion as far as the shell is concerned.

When the p-escape prompts for confirmation,
typing INTR (usually control-C) will tell \fImhn\fR not to display
that content.
(The p-escape can be disabled by specifying `\-nopause'.)
Further,
when \fImhn\fR is display a content,
typing QUIT (usually control-\\) will tell \fImhn\fR to wrap things up
immediately.

Note that if the content being displayed is multipart,
but not one of the subtypes listed above,
then the f- and F-escapes expand to multiple filenames,
one for each subordinate content.
Further,
stdin is not redirected from the terminal to the content.

First,
\fImhn\fR will look for an entry of the form:
.sp
.in +.5i
mhn-show-<type>/<subtype>
.in -.5i
.sp
to determine the command to use to display the content.
If this isn't found,
\fImhn\fR will look for an entry of the form:
.sp
.in +.5i
mhn-show-<type>
.in -.5i
.sp
to determine the display command.
.ne 10
If this isn't found,
\fImhn\fR has two default values:
.sp
.nf
.in +.5i
mhn-show-text/plain: %pmoreproc '%F'
mhn-show-message/rfc822: %pshow -file '%F'
.in -.5i
.fi
.sp
If neither apply,
\fImhn\fR will check to see if the message has a application/octet-stream
content with parameter \*(lqtype=tar\*(rq.
If so,
\fImhn\fR will use an appropriate command.
If not,
\fImhn\fR will complain.

.ne 10
Example entries might be:
.sp
.nf
.in +.5i
mhn-show-audio/basic: raw2audio 2>/dev/null | play
mhn-show-image: xv '%f'
mhn-show-application/PostScript: lpr -Pps
.in -.5i
.fi
.sp
Note that when using the f- or F-escape,
it's a good idea to use single-quotes around the escape.
This prevents misinterpretation by the shell of any funny characters
that might be present in the filename.

Because the text content might be in a non-ASCII character set,
when \fImhn\fR encounters a \*(lqcharset\*(rq parameter for this content,
it checks to see whether the environment variable $MM_CHARSET is set
and whether the value of this environment variable is equal to the value of
the charset parameter.
If not,
then
\fImhn\fR will look for an entry of the form:
.sp
.in +.5i
mhn-charset-<charset>
.in -.5i
.sp
which should contain a command creating an environment to render the
character set.
This command string should containing a single \*(lq%s\*(rq,
which will be filled-in with the command to display the content.

An example entry might be:
.sp
.in +.5i
mhn-charset-iso-8859-1: xterm -fn '-*-*-medium-r-normal-*-*-120-*-*-c-*-iso8859-*' -e %s
.in -.5i
.sp
Note that many pagination programs strip off the high-order bit.
However,
newer releases of the \fIless\fR program have modest support for
single-octet character sets.
The source to \fIless\fR version 177,
which has such support,
is found in the MH source tree under \fBmiscellany/less-177\fR.
In order to view messages sent in the ISO 8859/1 character set using
\fIless\fR,
.ne 9
put these lines in your \&.login file:
.sp
.nf
.in +.5i
setenv LESSCHARSET latin1
setenv LESS "-f"
.in -.5i
.fi
.sp
The first line tells \fIless\fR to use 8859/1 definition for determing
whether a character is \*(lqnormal\*(rq, \*(lqcontrol\*(lq, or
\*(lqbinary\*(rq.
The second line tells \fIless\fR not to warn you if it encounters a
file that has non-ASCII characters.
Then,
simply set the \fBmoreproc\fR profile entry to \fIless\fR,
and it will get called automatically.
(To handle other single-octet character sets,
look at the \fIless\fR\0(1) manual entry for information about the
\fBLESSCHARDEF\fR environment variable.)

Finally,
\fImhn\fR will process each message serially\0--\0it won't start showing
the next message until all the commands executed to display the
current message have terminated.
In the case of a multipart content (of any subtype listed above),
the content contains advice indicating if the parts should be
displayed serially or in parallel.
Because this may cause confusion,
particularly on uni-window displays,
the `\-serialonly' switch can be given to tell \fImhn\fR to never
display parts in parallel.

.Uh "Storing the Contents"
The `\-store' switch tells \fImhn\fR to store the contents of the
named messages in \*(lqnative\*(rq (decoded) format.
Two things must be determined:
the directory to store the content,
and the filenames.
Files are written in the directory given by the \fBmhn-storage\fR
profile entry,
.ne 6
e.g.,
.sp
.in +.5i
mhn-storage: /tmp
.in -.5i
.sp
If this entry isn't present,
the current working directory is used.

\fImhn\fR will look for information in the user's profile to determine
how the different contents should be stored.
This is achieved through the use of a formatting string,
.ne 13
which may contain these escapes:
.sp
.nf
.in +.5i
.ta \w'%P  'u
%m	message number
%P	.part
%p	part
%s	subtype
.re
.in -.5i
.fi
.sp
If the content isn't part of a multipart (of any subtype listed above) content,
the p-escapes are ignored.
Note that if the formatting string starts with a \*(lq+\*(rq character,
then these escapes are ignored,
and the content is stored in the named folder.
(A formatting string consisting solely of a \*(lq+\*(rq character
indicates the current folder.)
Further,
a formatting string consisting solely of a \*(lq-\*(rq character
indicates the standard-output.

First,
\fImhn\fR will look for an entry of the form:
.sp
.in +.5i
mhn-store-<type>/<subtype>
.in -.5i
.sp
to determine the formatting string.
If this isn't found,
\fImhn\fR will look for an entry of the form:
.sp
.in +.5i
mhn-store-<type>
.in -.5i
.sp
to determine the formatting string.
If this isn't found,
\fImhn\fR will check to see if the content is application/octet-stream
with parameter \*(lqtype=tar\*(rq.
If so,
\fImhn\fR will choose an appropriate filename.
If the content is not application/octet-stream,
then \fImhn\fR will check to see if the content is a message.
If so,
\fImhn\fR will use the value \*(lq+\*(rq.
If not,
\fImhn\fR will use the value \*(lq%m%P.%s\*(rq.

Note that if the formatting string starts with a '/',
then content will be stored in the full path given
(rather than using the value of \fBmhn-storage\fR or the current working
directory.)
Similarly,
if the formatting string starts with a '|',
then \fImhn\fR will execute a command which should ultimately store
the content.
Note that before executing the command,
\fImhn\fR will change to the appropriate directory.
Also note that if the formatting string starts with a '|',
then \fImhn\fR will also honor the a-escape when processing the
formatting string.

.ne 10
Example entries might be:
.sp
.nf
.in +.5i
mhn-store-text: %m%P.txt
mhn-store-audio/basic: | raw2audio -e ulaw -s 8000 -c 1 > %m%P.au
mhn-store-application/PostScript: %m%P.ps
.in -.5i
.fi
.sp
Further,
note that when asked to store a content containing a partial message,
\fImhn\fR will try to locate all of the portions and combine them accordingly.
Thus,
if someone's sent you a message in several parts,
you might put them all in their own folder and do:
.sp
.in +.5i
mhn all -store
.in -.5i
.sp
This will store exactly one message,
containing the sum of the parts.
Note that if \fImhn\fR can not locate each part,
it will not store anything.

Finally,
if the `\-auto' switch is given and the content contains information
indicating the filename the content should be stored as
(and if the filename doesn't begin with a '/'),
then the filename from the content will be used instead.

.Uh "External Access"
For contents of type message/external-body,
.ne 12
\fImhn\fR supports these access-types:
.sp
.nf
.in +.5i
afs
anon-ftp
ftp
local-file
mail-server
.in -.5i
.fi
.sp
For the \*(lqanon-ftp\*(rq and \*(lqftp\*(rq access types,
if your system supports a SOCKETs interface to TCP/IP,
then \fImhn\fR will use a built-in FTP client.
Otherwise,
\fImhn\fR will look for the \fBmhn-access-ftp\fR profile entry,
.ne 6
e.g.,
.sp
.in +.5i
mhn-access-ftp: myftp.sh
.in -.5i
.sp
to determine the pathname of a program to perform the FTP retrieval.
.ne 14
This program is invoked with these arguments:
.sp
.nf
.in +.5i
domain name of FTP-site
username
password
remote directory
remote filename
local filename
\*(lqascii\*(rq or \*(lqbinary\*(rq
.in -.5i
.fi
.sp
The program should terminate with a zero-valued exit-status if the
retrieval is successful.

.Uh "The Content Cache"
When \fImhn\fR encounters an external content containing a
\*(lqContent-ID:\*(rq field,
and if the content allows caching,
then depending on the caching behavior of \fImhn\fR,
the content might be read from or written to a cache.

The caching behavior of \fImhn\fR is controlled with
the `\-rcache' and `\-wcache' switches,
which define the policy for reading from,
and writing to,
the cache, respectively.
One of four policies may be specified:
\*(lqpublic\*(rq,
indicating that \fImhn\fR should make use of a
publically-accessible content cache;
\*(lqprivate\*(rq,
indicating that \fImhn\fR should make use of the user's
private content cache;
\*(lqnever\*(rq,
indicating that \fImhn\fR should never make use of caching;
and,
\*(lqask\*(rq,
indicating that \fImhn\fR should ask the user.

There are two directories where contents may be cached:
the profile entry \fBmhn-cache\fR names a directory containing
world-readable contents,
and,
the profile entry \fBmhn-private-cache\fR names a directory containing
private contents.
The former should be an absolute (rooted) directory name.
.ne 6
For example,
.sp
.in +.5i
mhn-cache: /tmp
.in -.5i
.sp
might be used if you didn't care that the cache got wiped after each reboot
of the system.
The latter is interpreted relative to the user's MH directory,
if not rooted,
.ne 6
e.g.,
.sp
.in +.5i
mhn-private-cache: .cache
.in -.5i
.sp
(which is the default value).

.Uh "Caching the Contents"
When you encounter a content of type message/external-body with access type
\*(lqmail-server\*(rq,
\fImhn\fR will ask you if may send a message to a mail-server
requesting the content,
.ne 14
e.g.,
.sp
.nf
.in +.5i
% show 1
Retrieve content by asking mail-server@...

SEND file

? yes
mhn: request sent
.in -.5i
.fi
.sp
Regardless of your decision,
\fImhn\fR can't perform any other processing on the content.

However,
if \fImhn\fR is allowed to request the content,
then when it arrives,
there should be a top-level \*(lqContent-ID:\*(rq field which
corresponds to the value in the original message/external-body content.
You should now use the `-cache' switch to tell \fImhn\fR to enter the
arriving content into the content cache,
.ne 8
e.g.,
.sp
.nf
.in +.5i
% mhn -cache 2
caching message 2 as file ...
.in -.5i
.fi
.sp
You can then re-process the original message/external-body content,
and \*(lqthe right thing should happen\*(rq,
.ne 8
e.g.,
.sp
.nf
.in +.5i
% show 1
\0...
.in -.5i
.fi

.Uh "Composing the Contents"
The \fImhn\fR program can also be used as a simple editor to aid in
composing multi-media messages.
When invoked by a \fIwhatnow\fR program,
\fImhn\fR will expect the body of the draft to be formatted as an
\*(lq\fImhn\fR composition file.\*(rq

.ne 59
The syntax of this is straight-forward:
.sp
.nf
.in +.5i
   body         ::=     1*(content | EOL)

   content      ::=     directive | plaintext

   directive    ::=     "#" type "/" subtype
                            0*(";" attribute "=" value)
                            [ "(" comment ")" ]
                            [ "<" id ">" ]
                            [ "[" description "]" ]
                            [ filename ]
                            EOL

                      | "#@" type "/" subtype
                            0*(";" attribute "=" value)
                            [ "(" comment ")" ]
                            [ "<" id ">" ]
                            [ "[" description "]" ]
                            external-parameters
                            EOL

                      | "#forw"
                            [ "<" id ">" ]
                            [ "[" description "]" ]
                            [ "+"folder ] [ 0*msg ]
                            EOL

                      | "#begin"
                              [ "<" id ">" ]
                              [ "[" description "]" ]
                              [   "alternative"
                                | "parallel"
                                | something-else    ]
                              EOL
                            1*body
                        "#end" EOL

   plaintext    ::=     [ "Content-Description:"
                              description EOL EOL ]
                            1*line
                        [ "#" EOL ]

                      | "#<" type "/" subtype
                            0*(";" attribute "=" value)
                            [ "(" comment ")" ]
                            [ "[" description "]" ]
                            EOL
                            1*line
                        [ "#" EOL ]

   line         ::=     "##" text EOL
                        -- interpreted as "#"text EOL
                      | text EOL
.in -.5i
.fi
.sp
Basically,
the body contains one or more contents.
A content consists of either a directive,
indicated with a \*(lq#\*(rq as the first character of a line;
or,
plaintext (one or more lines of text).
The continuation character, \*(lq\\\*(lq, may be used to enter a single
.ne 11
directive on more than one line,
e.g.,
.sp
.nf
.in +.5i
#@application/octet-stream; \\
    type=tar; \\
    x-conversions=compress
.in -.5i
.fi
.sp
There are four kinds of directives:
\*(lqtype\*(rq directives,
which name the type and subtype of the content;
\*(lqexternal-type\*(rq directives,
which also name the type and subtype of the content;
the \*(lqforw\*(rq directive,
which is used to forward a digest of messages;
and,
the \*(lqbegin\*(rq directive,
which is used to create a multipart content.

For the type directives,
the user may optionally specify the name of a file containing the
contents in \*(lqnative\*(rq (decoded) format.
(If the filename starts with the \*(lq|\*(rq character,
then this gives a command whose output is captured accordingly.)
If a filename is not given,
\fImhn\fR will look for information in the user's profile to determine
how the different contents should be composed.
This is accomplished by consulting a composition string,
and executing it under \fB/bin/sh\fR,
with the standard output set to the content.
.ne 13
The composition string may contain these escapes:
.sp
.nf
.in +.5i
.ta \w'%P  'u
%a	additional arguments
%f	filename containing content
%F	%f, and stdout is not re-directed
%s	subtype
.re
.in -.5i
.fi
.sp
First,
\fImhn\fR will look for an entry of the form:
.sp
.in +.5i
mhn-compose-<type>/<subtype>
.in -.5i
.sp
to determine the command to use to compose the content.
If this isn't found,
\fImhn\fR will look for an entry of the form:
.sp
.in +.5i
mhn-compose-<type>
.in -.5i
.sp
to determine the composition command.
If this isn't found,
\fImhn\fR will complain.

An example entry might be:
.sp
.in +.5i
mhn-compose-audio/basic: record | raw2audio -F
.in -.5i
.sp
Because commands like these will vary,
depending on the display environment used for login,
composition strings for different contents should probably be put in
the file specified by the \fB$MHN\fR environment variable,
instead of directly in your user profile.

The external-type directives are used to provide a reference to a content,
rather than enclosing the contents itself.
Hence,
instead of providing a filename as with the type directives,
external-parameters are supplied.
These look like regular parameters,
.ne 15
so they must be separated accordingly,
e.g.,
.sp
.nf
.in +.5i
#@application/octet-stream; \\
    type=tar; \\
    x-conversions=compress [] \\
    access-type=anon-ftp; \\
    name="mh-mime.tar.Z"; \\
    directory="mrose/mh-mime"; \\
    site="ftp.ics.uci.edu"
.in -.5i
.fi
.sp
By specifying \*(lq[]\*(rq,
an empty description string is given,
and the start of the external-parameters is identified.
.ne 19
These parameters are of the form:
.sp
.nf
.in +.5i
.ta \w'access-type=  'u
access-type=	usually \fIanon-ftp\fR or \fImail-server\fR
name=	filename
permission=	read-only or read-write
site=	hostname
directory=	directoryname (optional)
mode=	usually \fIascii\fR or \fIimage\fR (optional)
size=	number of octets
server=	mailbox
subject=	subject to send
body=	command to send for retrieval
.re
.in -.5i
.fi
.sp

For the forw directive,
the user may optionally specify the name of the folder and which
messages are to be forwarded.
if a folder is not given,
it defaults to the current folder.
Similarly,
if a message is not given,
it defaults to the current message.
Hence,
the forw directive is similar to the \fIforw\fR\0(1) command,
except that the former uses the MIME rules for encapsulation
rather than those specified in RFC 934.
Usage of the `\-rfc934mode' switch indicates whether \fImhn\fR should
attempt to utilize the encapsulation rules in such a way as to appear
that RFC 934 is being used.
If given,
then RFC 934-compliant user-agents should be able to burst the message on
reception\0--\0providing that the messages being encapsulated do not
contain encapsulated messages themselves.
The drawback of this approach is that the encapsulations are generated
by placing an extra newline at the end of the body of each message.

For the begin directive,
the user must specify at least one content between
the begin and end pairs.

For all of these directives,
the user may include a brief description of the content between
the \*(lq[\*(rq character and the \*(lq]\*(rq character.
By default,
\fImhn\fR will generate a unique \*(lqContent-ID:\*(rq for each directive;
however,
the user may override this by defining the ID using the
\*(lq<\*(rq and \*(lq>\*(rq characters.
Putting this all together,
.ne 15
here is a brief example of what a user's components file might look like:
.sp
.nf
.in +.5i
To:
cc:
Subject:
--------
#audio/basic [Flint phone]  \\
    |raw2audio -F < /home/mrose/lib/multi-media/flint.au
#image/gif   [MTR's photo] \\
                    /home/mrose/lib/multi-media/mrose.gif
.in -.5i
.fi
.sp
For a later example,
we'll call this components file \fImhncomps\fR.

As noted earlier,
in addition to directives,
plaintext can be present.
Plaintext is gathered,
until a directive is found or the draft is exhausted,
and this is made to form a text content.
If the plaintext must contain a \*(lq#\*(rq at the beginning of a line,
simply double it,
.ne 6
e.g.,
.sp
.in +.5i
##when sent, this line will start with only one #
.in -.5i
.sp
If you want to end the plaintext prior to a directive,
e.g.,
to have two plaintext contents adjacent,
simply insert a line containing a single \*(lq#\*(rq character,
.ne 10
e.g.,
.sp
.nf
.in +.5i
this is the first content
#
and this is the second
.in -.5i
.fi
.sp
Finally,
if the plaintext starts with a line of the form:
.sp
.in +.5i
Content-Description: text
.in -.5i
.sp
then this will be used to describe the plaintext content.
\fBNOTE WELL:\fR you must follow this line with a blank line before
starting your text.

By default,
plaintext is captured as a text/plain content.
You can override this by starting the plaintext with \*(lq#<\*(rq
followed by a content-type specification,
.ne 11
e.g.,
.sp
.nf
.in +.5i
#<text/richtext
this content will be tagged as text/richtext
#
and this content will be tagged as text/plain
.in -.5i
.fi
.sp
Note that if you use the \*(lq#<\*(rq plaintext-form,
then the content-description must be on the same line which identifies
the content type of the plaintext.

If \fImhn\fR is successful,
it renames the original draft to start with the \*(lq,\*(rq character
and end with the string \*(lq.orig\*(rq,
e.g.,
if you are editing the file \*(lqdraft\*(rq,
it will be renamed to \*(lq,draft.orig\*(rq.
This allows you to easily recover the \fImhn\fR composition file.

If the `-check' switch is given,
\fImhn\fR will associate an integrity check with each content.

.Uh "Automatic Composition"
Note that MH will not invoke \fImhn\fR automatically,
unless you add this line to your \&.mh\(ruprofile file:
.sp
.in +.5i
automhnproc: mhn
.in -.5i
.sp
Otherwise,
you must specifically give the command
.sp
.in +.5i
What now? edit mhn
.in -.5i
.sp
prior to sending the draft.

You can easily tailor MH to help you remember to do this.
.ne 10
Suppose you have these lines in your profile:
.sp
.nf
.in +.5i
mcomp:          -editor mprompter -form mhncomps
mprompter:      -noprepend -norapid
mprompter-next: mhn
.in -.5i
.fi
.sp
where \fImcomp\fR is a link to \fIcomp\fR\0(1),
and \fImprompter\fR is a link to \fIprompter\fR\0(1).
Then to send a message using the \fImhncomps\fR components file above,
.ne 26
the sequence is:
.sp
.nf
.in +.5i
% \fBmcomp\fR
To: \fBuser@host\fR
cc:
Subject: \fBmulti-media message\fR
--------
#audio/basic [Flint phone]  \\
    |raw2audio -F < /home/mrose/lib/multi-media/flint.au
#image/gif   [MTR's photo] \\
                    /home/mrose/lib/multi-media/mrose.gif

--------Enter additional text

\fBThis message contains three contents.\fR
\fB<CTRL-D>\fR
--------

What now? \fBedit\fR (this invokes \fImhn\fR)

What now? \fBsend\fR
.in -.5i
.fi
.sp
You have to remember to type the additional edit command,
but it should be fairly obvious from the interaction.

Finally,
you should consider adding this line to your profile:
.sp
.in +.5i
lproc: show
.in -.5i
.sp
This way,
if you decide to \fBlist\fR after invoking \fImhn\fR as your editor,
the command
.sp
.in +.5i
What now? list
.in -.5i
.sp
will work as you expect.

.Uh "Sending Files via Mail"
When you want to send a bunch of files to someone,
you can run the \fIviamail\fR shell script,
which is similar the tarmail command:
.sp
.in +.5i
%libdir%/viamail mailpath \*(lqsubject\*(rq files\0...
.in -.5i
.sp
\fIviamail\fR will archive the directories/files you name with \fItar\fR\0(1),
and then mail the compressed archive to the `mailpath' with the given
`subject'.
The archive will be automatically split up into as many messages as
necessary in order to get past most mailers.

Sometimes you want \fIviamail\fR to pause after posting a partial message.
This is usually the case when you are running \fIsendmail\fR and
expect to generate a lot of partial messages.
If the first argument given to \fIviamail\fR starts with a dash,
then it is interpreted as the number of seconds to pause in between postings,
.ne 6
e.g.,
.sp
.in +.5i
%libdir%/viamail -300 mailpath \*(lqsubject\*(rq files\0...
.in -.5i
.sp
will pause 5 minutes in between each posting.

When these messages are received,
invoke \fImhn\fR once,
with the list of messages,
and the `\-store' command.
The \fImhn\fR program will then store exactly one message containing the
archive.
You can then use `\-show' to find out what's inside;
possibly  followed by `\-store' to write the archive to a file where you
.ne 26
can subsequently uncompress and untar it, e.g.,
.sp
.nf
.in +.5i
% mhn -list all
 msg part  type/subtype             size description
   1       message/partial           47K part 1 of 4
   2       message/partial           47K part 2 of 4
   3       message/partial           47K part 3 of 4
   4       message/partial           18K part 4 of 4
% mhn -store all
% mhn -list -verbose last
 msg part  type/subtype             size description
   5       application/octet-stream 118K
             (extract with uncompress | tar xvpf -)
             type=tar
             x-conversions=compress
% mhn -show last
 msg part  type/subtype             size description
   5       application/octet-stream 118K
-- headers of message, followed by \fItar\fR listing appears here
% mhn -store last
% uncompress < 5.tar.Z | tar xvpf -
.in -.5i
.fi
.sp
Alternately,
by using the `\-auto' switch,
\fImhn\fR will automatically do the extraction for you,
.ne 26
e.g.,
.sp
.nf
.in +.5i
% mhn -list all
 msg part  type/subtype             size description
   1       message/partial           47K part 1 of 4
   2       message/partial           47K part 2 of 4
   3       message/partial           47K part 3 of 4
   4       message/partial           18K part 4 of 4
% mhn -store all
% mhn -list -verbose last
 msg part  type/subtype             size description
   5       application/octet-stream 118K
             (extract with uncompress | tar xvpf -)
             type=tar
             x-conversions=compress
% mhn -show last
 msg part  type/subtype             size description
   5       application/octet-stream 118K
-- headers of message, followed by \fItar\fR listing appears here
% mhn -store -auto last
-- \fItar\fR listing appears here as files are extracted
.in -.5i
.fi
.sp
As the second \fItar\fR listing is generated,
the files are extracted.
A prudent user will never put `\-auto' in the \&.mh\(ruprofile file.
The correct procedure is to first use `\-show',
to find out what will be extracted.
Then \fImhn\fR can be invoked with  `\-store' and `\-auto' to perform
the extraction.

.Uh "User Environment"
Because the display environment in which \fImhn\fR operates may vary
for a user,
\fImhn\fR will look for the environment variable \fB$MHN\fR.
If present,
this specifies the name of an additional user profile which should be read.
Hence,
when a user logs in on a particular display device,
this environment variable should be set to refer to a file containing
definitions useful for the display device.
Normally,
only entries of the form
.sp
.in +.5i
mhn-show-<type>/<subtype>
.br
mhn-show-<type>
.in -.5i
.sp
need be present.
Finally,
\fImhn\fR will attempt to consult one other additional user profile,
.ne 6
e.g.,
.sp
.in +.5i
%libdir%/mhn_defaults
.in -.5i
.sp
which is created automatically during MH installation.
.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
^$MHN~^Additional profile entries
^%libdir%/mhn_defaults~^System-default profile entries
^%etcdir%/mhl.headers~^The headers template
.Pr
^Path:~^To determine the user's MH directory
.Ps
^Current\-Folder:~^To find the default current folder
.Ps
^mhlproc:~^Default program to display message headers
.Ps
^mhn-access-ftp:~^Program to retrieve contents via FTP
.Ps
^mhn-cache~^Public directory to store cached external contents
.Ps
^mhn-charset-<charset>~^Template for environment to render character sets
.Ps
^mhn-compose-<type>*~^Template for composing contents
.Ps
^mhn-private-cache~^Personal directory to store cached external contents
.Ps
^mhn-show-<type>*~^Template for displaying contents
.Ps
^mhn-storage~^Directory to store contents
.Ps
^mhn-store-<type>*~^Template for storing contents
.Ps
^moreproc:~^Default program to display text/plain content
.Sa
mhl(1)
.br
\fIMIME: Mechanisms for Specifying and Describing the Format of
Internet Message Bodies\fR
(RFC 1521),
.br
\fIProposed Standard for Message Encapsulation\fR
(RFC 934).
.De
`+folder' defaults to the current folder
.Ds
`msgs' defaults to cur
.Ds
`\-noauto'
.Ds
`\-nocache'
.Ds
`\-nocheck'
.Ds
`\-noebcdicsafe'
.Ds
`\-form\0mhl.headers'
.Ds
`\-headers'
.Ds
`\-pause'
.Ds
`\-rcache\0ask'
.Ds
`\-realsize'
.Ds
`\-rfc934mode'
.Ds
`\-noserialonly'
.Ds
`\-show'
.Ds
`\-noverbose'
.Ds
`\-wcache\0ask'
.Co
If a folder is given,
it will become the current folder.
The last message selected will become the current message.
.Bu
Partial messages contained within a multipart content are not reassembled
with the `\-store' switch.
.En
