
/*
 * signals.h -- header file for nmh signal interface
 */

#include "../config.h"

/*
 * If not a POSIX machine, then we create our
 * own POSIX style signal sets functions. This
 * currently assumes you have 32 signals, which
 * should be true on most pure BSD machines.
 */
#ifndef POSIX_SIGNALS
# define sigemptyset(s)    (*(s) = 0)
# define sigfillset(s)     (*(s) = ~((sigset_t) 0), 0)
# define sigaddset         (*(s) |=  (1 << ((n) - 1)), 0)
# define sigdelset(s,n)    (*(s) &= ~(1 << ((n) - 1)), 0)
# define sigismember(s,n)  ((*(s) & (1 << ((n) - 1))) != 0)
#endif
