
/*
 * config.c - master MH configuration file
 */

#ifndef	lint
static char ident[] = "$Id$";
#endif	/* lint */

#include "../config.h"
#include "../h/mh.h"

#ifdef MHRC
# include <pwd.h>
#endif

#include <stdio.h>

#define nmhbindir(file) NMHBINDIR#file
#define nmhetcdir(file) NMHETCDIR#file
#define nmhlibdir(file) NMHLIBDIR#file

#ifndef	__STDC__
# ifdef	MHRC
#  ifdef SYS5
struct passwd *getpwnam();
#  endif /* SYS5 */
# endif /* MHRC */
#endif

static char lpath[BUFSIZ];

char *
libpath (char *file)
{
    char *cp;
#ifdef MHRC
    char *pp;
    struct passwd *pw;
#endif /* MHRC */

#ifdef MHRC
    m_getdefs();
#endif /* MHRC */

    switch (*file) {
	case '/': 
	    return file;

#ifdef MHRC
	case '~': 
	    if (cp = strchr(pp = file + 1, '/'))
		*cp++ = '\0';
	    if (*pp == '\0')
		pp = mypath;
	    else
		if (pw = getpwnam (pp))
		    pp = pw -> pw_dir;
		else {
		    if (cp)
			*--cp = '/';
		    goto try_it;
		}

	    (void) sprintf (lpath, "%s/%s", pp, cp ? cp : "");
	    if (cp)
		*--cp = '/';

	    if (access (lpath, 04) != NOTOK)
		return lpath;	/* else fall */
    try_it: ;
#endif /* MHRC */

	default: 
	    if (access ((cp = m_mailpath (file)), 04) != NOTOK)
		return cp;
    }
    sprintf (lpath, nmhetcdir(/%s), file);
    return (access (lpath, 04) != NOTOK ? lpath : file);
}

/* 
 * Standard yes/no switches structure
 */

struct swit anoyes[] = {
    "no", 0,
    "yes", 0,
    NULL, 0
};

/* 
 * MH constants
 */

char   *components = "components";
char   *current = "cur";
char   *defalt = "inbox";
char   *digestcomps = "digestcomps";
char   *distcomps = "distcomps";
char   *draft = "draft";
char   *forwcomps = "forwcomps";
char   *inbox = "inbox";
char   *mh_defaults = nmhetcdir (/mh.profile);
char   *mh_profile = ".mh_profile";
char   *mhlformat = "mhl.format";
char   *mhlforward = "mhl.forward";
char   *nsequence = "Sequence-Negation";
char   *pfolder = "Current-Folder";
char   *psequence = "Previous-Sequence";
char   *rcvdistcomps = "rcvdistcomps";
char   *replcomps = "replcomps";
char   *usequence = "Unseen-Sequence";
char   *mhlibdir = NMHLIBDIR;

/* 
 * MH not-so constants
 */

char   *context = "context";

#ifndef	NOMHSEQ
char   *mh_seq = ".mh_sequences";
#else
char   *mh_seq = NULL;
#endif

/* 
 * MH globals
 */

char    ctxflags;		/* status of user's context */

char   *invo_name;		/* pgm invocation name */
char   *mypath;			/* user's $HOME */
char   *defpath;		/* pathname of user's profile */
char   *ctxpath;		/* pathname of user's context */

struct node *m_defs;		/* profile/context structure */

/* 
 * MH processes
 */

/*
 * mhl runs this program as a visual-end.
 */

char *faceproc = NULL;

/*
 * This program is usually called directly by users, but it is
 * also invoked by the post program to process an "fcc".
 */

char *fileproc = nmhbindir (/refile);

/* 
 * This program is called to incorporate messages into a folder.
 */

char *incproc = nmhbindir (/inc);

/*
 * When a user runs an MH program for the first time, this program
 * is called to create his MH profile, and mail directory.
 */

char *installproc = nmhlibdir (/install-mh);

/*
 * This is the program invoked by a "list" response to "What now?"
 *  whereas, showproc is the program invoked by show, next, prev.
 */

char *lproc = DEFAULT_PAGER;

/*
 * This is the path for the Bell equivalent mail program.
 */

char *mailproc = nmhbindir (/mhmail);

/*
 * mhl runs this program as a front-end.
 */

char *moreproc = DEFAULT_PAGER;

/* 
 * This program is mhl - the nifty message lister
 */

char *mhlproc = nmhlibdir (/mhl);

/* 
 * This is the super handy BBoard reading program, which is really just the MH
 * shell program
 */

char *mshproc = nmhbindir (/msh);

/* 
 * This program is called to pack a folder.  
 */

char *packproc = nmhbindir (/packf);

/*
 * This is the delivery program called through send to
 * actually deliver mail to users.  This is the interface to
 * the MTS.
 */

#if BERK && SENDMTS && !SMTP
char *postproc = nmhlibdir (/spost);
#else
char *postproc = nmhlibdir (/post);
#endif /* BERK */

/* 
 * This program is called to remove a folder.  
 */

char *rmfproc = nmhbindir (/rmf);

/* 
 * This program is called to remove a message by rmm or refile -nolink.
 * It's usually empty, which means to rename the file to a backup name.
 */

char *rmmproc = NULL;

/*
 * This program is usually called by the user's whatnowproc, but it
 * may also be called directly to send a message previously composed.
 */

char *sendproc = nmhbindir (/send);

/*
 * This program is called to list messages by the show program.
 * By setting showproc to mhl, the user can run mhl instead.
 */

char *showproc = DEFAULT_PAGER;

/* 
 * This program is called under stand-alone MH to deliver a message to
 * a local user.  Under other MTS's it can be used to emulate a
 * MMDF-II .maildelivery mechanism.
 */

char *slocalproc = nmhlibdir (/slocal);

/* 
 * This program is called by vmh as the back-end to the window management
 * protocol
 */

char *vmhproc = nmhbindir (/msh);

/* 
 * This program is called after comp, et. al., have built a draft
 */

char *whatnowproc = nmhbindir (/whatnow);

/* 
 * This program is called to list/validate the addresses in a message.
 */

char *whomproc = nmhbindir (/whom);

/*
 * This is the editor invoked by the various message
 * composition programs.  It SHOULD be a full screen
 * editor, such as vi or emacs, but any editor will work.
 */

char *sysed = DEFAULT_EDITOR;

/* 
 * This is the Global MH alias file.  It is somewhat obsolete, since
 * global aliases should be handled by the Mail Transport Agent (MTA).
 */

char *AliasFile = nmhetcdir (/MailAliases);

/* 
 * File protections
 */

/*
 * Folders (directories) are created with this protection (mode)
 */

char *foldprot = DEFAULT_FOLDER_MODE;

/*
 * Every NEW message will be created with this protection.  When a
 * message is filed it retains its protection, so this only applies
 * to messages coming in through inc.
 */

char *msgprot = DEFAULT_MESSAGE_MODE;

