/*
 * Copyright (C) 2001 Thomas Roessler <roessler@does-not-exist.org>
 * 
 *     This program is free software; you can redistribute it
 *     and/or modify it under the terms of the GNU General Public
 *     License as published by the Free Software Foundation; either
 *     version 2 of the License, or (at your option) any later
 *     version.
 * 
 *     This program is distributed in the hope that it will be
 *     useful, but WITHOUT ANY WARRANTY; without even the implied
 *     warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *     PURPOSE.  See the GNU General Public License for more
 *     details.
 * 
 *     You should have received a copy of the GNU General Public
 *     License along with this program; if not, write to the Free
 *     Software Foundation, Inc., 59 Temple Place - Suite 330,
 *     Boston, MA  02111, USA.
 */ 


#define MAIN_C

#include "global.h"

#ifdef HAVE_GETOPT_H
# include <getopt.h>
#endif

static void print_notice (void);

int main (int argc, char *argv[])
{
  int c;

  /* initialize options */
  memset (&Opt, 0, sizeof (Opt));
  Opt.charset  = "iso-8859-1";
  Opt.sendmail = "/usr/sbin/sendmail";
  Opt.port     = getenv ("PILOTPORT");
  Opt.dispose  = DISP_DELETE;
  Opt.path     = NULL;

  /* parse command line arguments */
  while ((c = getopt (argc, argv, "hc:DKFs:f:p:")) != EOF)
  {
    switch (c)
    {
      case 'c': Opt.charset = optarg; break;
      case 's': Opt.sendmail = optarg; break;
      case 'f': Opt.from = optarg; break;
      case 'D': Opt.dispose = DISP_DELETE; break;
      case 'K': Opt.dispose = DISP_KEEP; break;
      case 'F': Opt.dispose = DISP_FILE; break;
      case 'p': Opt.port = optarg ; break;
      case 'h': 
      default: 
      	print_notice ();
    }
  }
  
  argc -= optind;
  argv += optind;
  
  if (argc)
    Opt.path = argv[0];
  
  if (!Opt.port)
  {
    fputs ("No port specified.\n", stderr);
    exit (1);
  }
  
  /* go */
  
  pm_setup_context (Opt.port);
  pm_send_mail ();
  if (Opt.path) 
    pm_sync_maildir (Opt.path);
  pm_destroy_context ();
  
  return 0;
}
  
static void print_notice (void)
{
  printf ("%s %s \n", PACKAGE, VERSION);
  puts ("Copyright (C) 2001 Thomas Roessler <roessler@does-not-exist.org>");
  puts ("pilot-maildir comes with ABSOLUTELY NO WARRANTY. pilot-maildir");
  puts ("is free software, and you are welcome to distribute it under");
  puts ("certain conditions.  See the file COPYING for details.");
  exit (0);
}
