/* demoimp.c  1994 may 19  [gh]
+-----------------------------------------------------------------------------
| Abstract:
|    Demonstrator of importing messages using the mimelite library.
|
| History:
|    2.0 94 may 19 [gh] Release of version 2.0
|    1.1 94 feb 01 [gh] Improved documentation and MIME support.
|    1.0 94 jan 03 [gh] Wrote first version.
|
| Authorship:
|    Copyright (c) 1994 Gisle Hannemyr.
|    Permission is granted to hack, make and distribute copies of this program
|    as long as this copyright notice is not removed.
|    Flames, bug reports, comments and improvements to:
|       snail: Gisle Hannemyr, Brageveien 3A, 0452 Oslo, Norway
|       email: gisle@oslonett.no, gisle@ifi.uio.no
+---------------------------------------------------------------------------*/

#define MAIN

#include <stdio.h>
#include <string.h>
#include "mimelite.h"

#define LSIZ 128


/*---( samples )------------------------------------------------------------*/

unsigned char Jumbo[10000];


unsigned char *datamsg = (unsigned char *)"\
From: turing@van.de (Dieter Turing)\n\
Newsgroups: news.software.nntp\n\
Subject: Binary data in a double box.\n\
Mime-Version: 1.0\n\
Content-Type: text/plain; charset=x-unknown\n\
Content-Transfer-Encoding: base64\n\
\n\
yc3Nzc3NzbsKukJJTkFSWboKzM3Nzc3NzbkKuv5EQVRB/roKyM3Nzc3Nzbz=\n";


unsigned char *unencd7 = (unsigned char *)"\
Path: ifi.uio.no!nntp.uio.no!elvis.de!noris.de!not-for-mail\n\
From: turing@elvis.de (Dieter Turing)\n\
Newsgroups: news.software.nntp\n\
Subject: A message from Nurnberg\n\
Date: 17 Jan 1994 15:10:48 +0100\n\
Organization: Nerds Inc., Nuernberg, FRG\n\
Message-ID: <2he698$3t7@elvis.de>\n\
References: <Pnews.bruce.758596240.17719@billy.uucp>\n\
NNTP-Posting-Host: localhost\n\
\n\
This body contains an equals-sign [=]. It also mentions a town named Nurnberg.\n\
--\n\
Dieter Turing            \\ Gate-POP Nurnberg | EMail: turing@elvis.de\n\
Schleiermacherstrasse 13  \\ Unix+Linux+Mac   | Phone: please use email.\n\
90491 Nurnberg (Germany)   \\ Consulting+Networking+Programming+etc'ing\n";


unsigned char *unencd8 = (unsigned char *)"\
Path: ifi.uio.no!nntp.uio.no!elvis.de!noris.de!not-for-mail\n\
From: turing@elvis.de (Dieter T\374ring)\n\
Newsgroups: news.software.nntp\n\
Subject: A message from N\374rnberg\n\
Date: 17 Jan 1994 15:10:48 +0100\n\
Organization: Nerds Inc., N\374rnberg, FRG\n\
Message-ID: <2he698$3t7@elvis.de>\n\
References: <Pnews.bruce.758596240.17719@billy.uucp>\n\
NNTP-Posting-Host: localhost\n\
\n\
This body contains an equals-sign [=]. It also mentions a town named N\374rnberg.\n\
--\n\
Dieter T\374ring           \\ Gate-POP N\374rnberg | EMail: turing@elvis.de\n\
Schleiermacherstra\337e 13  \\ Unix+Linux+Mac   | Phone: please use email.\n\
90491 N\374rnberg (Germany)  \\ Consulting+Networking+Programming+etc'ing\n";


unsigned char *usascii = (unsigned char *)"\
Path: ifi.uio.no!nntp.uio.no!elvis.de!noris.de!not-for-mail\n\
From: turing@elvis.de (Dieter Turing)\n\
Content-Type: text/plain; charset=US-Ascii\n\
Newsgroups: news.software.nntp\n\
Subject: A message from Nurnberg\n\
Date: 17 Jan 1994 15:10:48 +0100\n\
Content-Transfer-Encoding: 7bit\n\
Organization: Nerds Inc., Nuernberg, FRG\n\
Message-ID: <2he698$3t7@elvis.de>\n\
References: <Pnews.bruce.758596240.17719@billy.uucp>\n\
NNTP-Posting-Host: localhost\n\
Mime-Version: 1.0\n\
\n\
This body contains an equals-sign [=]. It also mentions a town named Nurnberg.\n\
--\n\
Dieter Turing            \\ Gate-POP Nurnberg | EMail: turing@elvis.de\n\
Schleiermacherstrasse 13  \\ Unix+Linux+Mac   | Phone: please use email.\n\
90491 Nurnberg (Germany)   \\ Consulting+Networking+Programming+etc'ing\n";


unsigned char *isol1_8 = (unsigned char *)"\
Path: ifi.uio.no!nntp.uio.no!trane.uninett.no!sunic!EU.net!howland.reston.an\
s.net!xlink.net!rz.uni-karlsruhe.de!subnet.sub.net!elvis.de!noris.de!not-for\
-mail\n\
From: turing@elvis.de (Dieter T\374ring)\n\
Newsgroups: news.software.nntp\n\
Subject: A message from N\374rnberg\n\
Date: 17 Jan 1994 15:10:48 +0100\n\
Organization: Nerds Inc., N\374rnberg, FRG\n\
Message-ID: <2he698$3t7@elvis.de>\n\
References: <2g1emi$gl1@ns1.arlut.utexas.edu> <Pnews.bruce.75833709.62178@b\
illy.uucp> <2h3pm1$ro@elvis.de> <Pnews.bruce.7585962240.17719@billy.uucp>\n\
NNTP-Posting-Host: localhost\n\
Mime-Version: 1.0\n\
Content-Type:text/plain; charset=iso-8859-1\n\
Content-Transfer-Encoding: 8bit\n\
\n\
This body contains an equals-sign [=]. It also mentions a town named N\374rnberg.\n\
--\n\
Dieter T\374ring           \\ Gate-POP N\374rnberg | EMail: turing@elvis.de\n\
Schleiermacherstra\337e 13  \\ Unix+Linux+Mac   | Phone: please use email.\n\
90491 N\374rnberg (Germany)  \\ Consulting+Networking+Programming+etc'ing\n";


unsigned char *isol1qp = (unsigned char *)"\
Date: Fri, 11 Jun 1993 13:19:55 +0200\n\
Mime-Version: 1.0\n\
From: Dieter Turing <turing@elvis.de>\n\
To: john.doe@surfnet.us\n\
Subject: A message from Nurnberg\n\
Organization: Nerds Inc., Nurnberg, FRG\n\
Content-Type: text/plain; charset=\"iso-8859-1\"\n\
Content-Transfer-Encoding: quoted-printable\n\
\n\
This body contains an equals-sign [=3D]. It also mentions a town named N=FC=\n\
rnberg.\n\
=20\n\
- Dieter T=FCring  (Nerds Inc.)\n\
  OSI:   C=3Dde;PRMD=3Dnerdnet;O=3Dfhi;S=3DT=FCring;G=3DDieter (X.400 SA =\n\
format)\n\
------------------------------------------------\n";

unsigned char *base_64 = (unsigned char *)"\
Date: Sat, 2 Apr 1994 22:44:42 +0800 (HKT)\n\
From: turing@elvis.de (Dieter Turing)\n\
Subject: Information request\n\
To: john.doe@surfnet.us\n\
Mime-Version: 1.0\n\
Content-Type: TEXT/PLAIN; charset=iso-8859-1\n\
Content-Transfer-Encoding: BASE64\n\
Content-ID: <Pine.3.87.9404022203.D26426@elvis.de>\n\
Content-Description: sample text message encoded using BASE64\n\
\n\
VGhpcyBib2R5IGNvbnRhaW5zIGFuIGVxdWFscy1zaWduICg9KS4gSXQgYWxzbyBtZW50aW9ucyBh\n\
IHRvd24gbmFtZWQgTvxybmJlcmcuDQotLSAgICANCistLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0t\n\
Ky0tLS0tLS0tLS0tLS0tLS0tLS0tKy0tLS0tLS0tLS0tLS0tLS0tLS0tLS0rDQp8IERpZXRlciBU\n\
/HJpbmcgICAgICAgICAgIHwgR2F0ZS1QT1AgTvxybmJlcmcgIHwgRU1haWw6IHR1cmluZ0B2YW4u\n\
ZGUgfA0KfCBTY2hsZWllcm1hY2hlcnN0cmHfZSAxMyB8IFVuaXgrTGludXgrTWFjICAgICB8IFBo\n\
b25lOiArNDkgOTExIDQ2MzIzIHwNCnwgOTA0OTEgTvxybmJlcmcsIEdlcm1hbnkgfCBDb25zdWx0\n\
aW5nK2hhY2tpbmcgfCBGYXg6ICAgKzQ5IDkxMSA2NDczOSB8DQorLS0tLS0tLS0tLS0tLS0tLS0t\n\
LS0tLS0tLSstLS0tLS0tLS0tLS0tLS0tLS0tLSstLS0tLS0tLS0tLS0tLS0tLS0tLS0tKw0K\n\
--\n\
Some random (signaturelike) junk at the end, _not_ in BASE64 encoding.\n";


#if 0
Subject: =?iso-8859-1?Q?V=E5re_norske_tegn_b=F8r_=E6res.?= \n\
Subject: Equals=?
Subject: =?US-ASCII?q?2 + 2 =3d 4?=\n\
--
#endif

unsigned char *rfc1522 = (unsigned char *)"\
Mime-Version: 1.0\n\
Date: Fri, 11 Jun 1993 13:19:55 +0200\n\
From: =?iso-8859-1?Q?Dieter_T=FCring?= (=?iso-8859-1?Q?N=FCrnberg?=)\n\
Subject: =?iso-8859-1?B?QSBtZXNzYWdlIGZyb20gTvxybmJlcmd=?=\n\
Content-Type:text/plain; charset=iso-8859-1\n\
Content-Transfer-Encoding: 8bit\n\
\n\
This body contains an equals-sign [=]. It also mentions a town named N\374rnberg.\n\
--\n\
Dieter T\374ring           \\ Gate-POP N\374rnberg | EMail: turing@elvis.de\n\
Schleiermacherstra\337e 13  \\ Unix+Linux+Mac   | Phone: please use email.\n\
90491 N\374rnberg (Germany)  \\ Consulting+Networking+Programming+etc'ing\n";


unsigned char *isoir60 = (unsigned char *)"\
Newsgroups: no.general,no.mail\n\
Path: oslonett.no!telepost.no!news.eunet.no!nuug!falch!falch!steinarb\n\
From: steinarb@falch.no (Steinar Bang)\n\
Subject: This message is in norwegian\n\
Content-Type: text/plain; charset=\"x-iso-ir-60\"\n\
Message-ID: <STEINARB.94Jan20155501@falch.falch.no>\n\
Followup-To: no.general\n\
Sender: Falch Newsfeed <usenet@falch.no>\n\
Content-Transfer-Encoding: 7bit\n\
Organization: Falch Hurtigtrykk, Oslo, Norway\n\
Mime-Version: 1.0\n\
Date: Thu, 20 Jan 1994 14:55:01 GMT\n\
\n\
Finnes det noen MIME-sak ala X.400 til SMTP gateway, som kj|rer p}\n\
Sparc/PC/Novell/Mac, } f} kj|pt (eller som finnes fritt tilgjengelig)\n\
idag? Hvem tar man is}fall kontakt med?\n";


unsigned char *rfc1049 = (unsigned char *)"\
Date: Wed, 19 Jan 94 13:42:58 MET\n\
From: Arne.Sommerfelt@si.sintef.no\n\
Content-Type: x-uuencode-apple-single\n\
To: otto@oslonett.no\n\
Subject: The address list you requested.\n\
\n\
The following is an attached File item from cc:Mail.  It contains\n\
eight bit information which had to be encoded to insure successful trans-\n\
mission through various mail systems.  To decode the file use the UUDECODE\n\
program.\n\
--------------------------------- Cut Here ---------------------------------\n\
begin 644 deltager.txt\n\
M36%T=&AI87,@5)]R:6YG(\" @(\" @4V-H;&5I97)M86-H97)S=')AIV4@,C$@\n\
M(\" @.3 T.3$@3I]R;F)E<F<*1G)A;HUO:7,@5F%LCG)I92 @(\" @4G5E(%*.\n\
I=F]L=71I;VX@,3<@(\" @(\" @(\" @,C,X-S8@0YET92!D=2!2:)EN90IE\n\
 \n\
end\n";



/*---( debug )--------------------------------------------------------------*/

/*
| Abs: This function prints five lines which shows what mimelite think about
|      the message.  The five lines are:
|         1: Header type (RFC-822, RFC-1049, or MIME version).
|         2: Content type
|         3: Character set
|         4: Encoding
|         5: Conversions required (input -> output)
| Des: These special symbols are used when displaying attributes.
|         - Values shown in *STARS* are diagnostics.
|         - Values shown [square brackets] are private values.
*/
static void showstate(void)
{
    fputs("Message type:  ", stderr);
    if (MimeVers < 0) {
	if	(MimeVers == MV_R0822) fputs("RFC-822",  stderr);
	else if (MimeVers == MV_R1049) fputs("RFC-1049", stderr);
	else			       fputs("*BOGUS*",  stderr);
    } else fprintf(stderr, "MIME-Version: %d.%d", MimeVers / 100, MimeVers % 100);

    fputs("\nContent-type:  ", stderr);
    switch (ContType) {
      case CT_UNKNOWN: fputs("*UNKNOWN*",stderr);	break;
      case CT_ASCTEXT: fputs("text",	 stderr);	break;
      case CT_NOTIMPL: fputs("*NOT IMP*",stderr);	break;
      case CT_PRIVATE: fprintf(stderr,"[%s]",PrivCTyp); break;
      default:	       fputs("*BOGUS*",  stderr);
    } /* switch */

    fputc('/', stderr);
    switch (CSubType) {
      case ST_UNKNOWN: fputs("*UNKNOWN*",stderr);	break;
      case ST_PLAINTX: fputs("plain",	 stderr);	break;
      case ST_NOTIMPL: fputs("*NOT IMP*",stderr);	break;
      case ST_PRIVATE: fprintf(stderr,"[%s]",PrivSTyp); break;
      default:	       fputs("*BOGUS*",  stderr);
    } /* switch */

    fputs("\nCharacter set: ", stderr);
    switch (Charset) {
      case CS_IGNOR: fputs("*IGNORE*",   stderr);	break;
      case CS_UNKWN: fputs("*UNKNOWN*",  stderr);	break;
      case CS_PRIVT: fprintf(stderr,"[%s]",PrivCSet);	break;
      case CS_IR002: fputs("US-ASCII",   stderr);	break;
      case CS_IR060: fputs("ISO-IR-60",  stderr);	break;
      case CS_ISOL1: fputs("ISO-8859-1", stderr);	break;
      case CS_CP437: fputs("IBM-CP-437", stderr);	break;
      case CS_CP850: fputs("IBM-CP-850", stderr);	break;
      case CS_APPLE: fputs("Macintosh",  stderr);	break;
      default:	     fputs("*BOGUS*",    stderr);
    } /* switch */
    fputs("\nEncoding:      ", stderr);
    switch (Encoding) {
      case CE_UNCODED: fputs("none",		 stderr);	break;
      case CE_QUOTEDP: fputs("quoted-printable", stderr);	break;
      case CE_BASE064: fputs("base64",		 stderr);	break;
      case CE_BINCODE: fputs("binary",		 stderr);	break;
      case CE_NOTIMPL: fputs("*NOT IMP*",	 stderr);	break;
      case CE_PRIVATE: fprintf(stderr,"[%s]",  PrivEncd);	break;
      default:	       fputs("*BOGUS*",		 stderr);
    } /* switch */

#ifdef SHOWFOLD
    ml_printfold(); /* Debug function within mimelite library */
#endif
    fputc('\n', stderr);

} /* showstate */


/*---( demonstrator )-------------------------------------------------------*/

/*
| Abs: Determine some common (at least in Norway) private character sets.
| Ret: Character set token (or CS_UNKWN if unknown).
*/
static int privcharset(unsigned char *token)
{
    if (!strncmp(token, "x-iso-ir-60", 11)) return(CS_IR060);
    if (!strncmp(token, "x-ibm-cp-437",12)) return(CS_CP437);
    if (!strncmp(token, "x-ibm-cp-850",12)) return(CS_CP850);
    return(CS_UNKWN);
} /* privcharset */


/*
| Abs: This is the meat of the demonstrator.  It shows who you should use
|      the mimelite library to import messages containing European
|      charcters.
| Par: cset  = target character set (usually user's computer's default
|              character set).
| Des: To make things simple, buffer Jumbo contains message to import.
*/
static void demonstrator(int cset)
{
    unsigned char *ss;
    unsigned char buff[LSIZ];
    int chset1, chset2, xx, state;


    /*
    | Set up translation parameters for folding.  The input character set
    | for the body is to be set later (by parsing the MIME header, but news
    | sometimes contains ISO Latin 1 headers, so that is what we set iset
    | to for headers processing.  The target character set should be set to
    | the default native set of the computer it is running on (e.g. the code
    | page the machine is set up to use).  I want this demonstrator to be
    | easy portable, so I ask the user about this at runtime.
    */
    if (!ml_foldinit(CS_ISOL1, cset)) {
        fputs("*** bad o/p charset\n", stderr);
	return;
    } /* if */

    /*
    | Set up for parsing header and unmiming a new message.
    */
    ml_unmimsetup(CS_ISOL1, CE_PRSHEAD);


    fputs("============================================================================\n",  stdout);
    /*
    | And feed entire message to ml_unmimeline, one line at the time.
    */
    ss = Jumbo;
    xx = 0;
    while (*ss) {
        buff[xx++] = *ss;
        if ((*ss == '\n') || (xx == (LSIZ-1))) {
	    buff[xx++] = '\0';
	    state = ml_unmimeline(buff);
	    if (state == 1) {
		fputs("----------------------------------------------------------------------------",  stdout);

		/* Here is an example of how to deal with a private type */
		if (Charset == CS_PRIVT) {
		    chset1 = privcharset(PrivCSet);
		    if (chset1 == CS_UNKWN) chset2 = CS_UNKWN;
		    else		    chset2 = CS_IGNOR;
		    if (!ml_foldinit(chset1, chset2))	{ fputs("*** bad i/p cset\n", stderr); return; }
		} /* if (private token) */
		/* End of example                                        */

	    } /* if (end of header */
	    fputs(buff, stdout);
            /* printf("%2d| %s", xx, buff); */
            xx = 0;
        } /* eoln */
	ss++;
    } /* while */
    if (xx) {
	buff[xx++] = '\0';
	fputs(buff, stdout);
	/* printf("DB: [%d#\\%03o\\%03o#%s]", xx, buff[0], buff[1], buff); */
    } /* if */

    xx = strlen(buff);
    if (xx) xx--;
    if (buff[xx] != '\n') fputc('\n', stdout);
    fputs("============================================================================\n",  stdout);
    fputs("Press <enter> to continue: ",  stdout); fflush(stdout);
    getchar();				/* Borland's LINT gripe about this. */
    showstate();			/* Display what mimelite think it.  */
    fputs("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n",  stdout);
    
} /* demonstrator */


/*---( main )---------------------------------------------------------------*/

int main(/* int  argc, char *argv[] */)
{
    char buff[80];
    unsigned char *ss;
    int ii, jj;

    fputs("\n\n\
First, select your default character set.  This should normally be the\n\
default character set for whatever equipment you are running this\n\
demonstrator on.  The same character set will be retained for the full\n\
run of the demonstrator.\n\n\
Please select one off:\n\
    1) ISO-IR-02  (7 bit US-ASCII)\n\
    2) ISO-IR-60  (7 bit Norwegian)\n\
    3) ISO-8859/1 (8 bit ISO Latin 1)\n\
    4) IBM CP 437 (8 bit IBM PC for USA)\n\
    5) IBM CP 850 (8 bit IBM PC multinational)\n\
    6) Macintosh  (8 bit Apple MacIntosh)\n\
    0) (Exit)\n\
Select one (0-6) : ", stdout);
    fflush(stdout);
    fgets(buff, 10, stdin);
    sscanf(buff, "%d", &ii);
    if ((ii <= 0) || (ii > 6)) return(0);
    ii += CS_PRIVT; /* CS_PRIVT is 2 */

    fputs("\n\n\
Now, the demonstrator will let you select various sample messages to be\n\
decoded and presented to you in the chosen default character set.\n\
Please peruse the actual source code to see the strategy used by the\n\
mimelite library to deal with the different types of encoding.\n", stdout);
    for (;;) {
	fputs("\n\
Please select one off these sample messages:\n\
       (description)    (encoding)\n\
    1) binary data      b-64\n\
    2) No MIME headers  7 bit\n\
    3) No MIME headers  8 bit\n\
    4) US-ASCII         7 bit\n\
    5) ISO-8859/1       8 bit\n\
    6) ISO-8859/1       q-p.\n\
    7) ISO-8859/1       b-64\n\
    8) RFC-1522         q-p.\n\
    9) ISO-IR60 (Norw.) 7 bit\n\
   10) RFC-1049         priv.\n\
    0) (Exit)\n\
Select one (0-9) : ", stdout);
	fflush(stdout);
	fgets(buff, 10, stdin);
	sscanf(buff, "%d", &jj);
	if ((jj <= 0) || (jj > 10)) break;

	switch (jj) {
	  case  1:  ss = datamsg; break;
	  case  2:  ss = unencd7; break;
	  case  3:  ss = unencd8; break;
	  case  4:  ss = usascii; break;
	  case  5:  ss = isol1_8; break;
	  case  6:  ss = isol1qp; break;
	  case  7:  ss = base_64; break;
	  case  8:  ss = rfc1522; break;
	  case  9:  ss = isoir60; break;
	  case 10:  ss = rfc1049; break;
	  default: fputs("*** Unknown demo.\n", stderr); return(1);
	} /* switch */

	/* Copy to a global message buffer to keep demonstrator simple. */
	strcpy(Jumbo, ss);

	demonstrator(ii);
    } /* forever */


    return(0);

} /* main */

/* EOF */
