#ifdef hpux
#include <stdio.h>
#include <sys/time.h>
#include <sys/times.h>
#include <sys/types.h>
#include <sys/resource.h>
#include <utime.h>

char *getcwd();
char *getwd(dir)
	char *dir;
{
	return getcwd(dir,1024);
}

setbuffer(fp,b,s)
	FILE *fp;
	char *b;
{
	setvbuf(fp,b,_IOFBF,s);
}
setlinebuf(fp)
	FILE *fp;
{
	setvbuf(fp,NULL,_IOLBF,128);
}

/*
 *	SIGNAL HANDLING
 */
char *sys_siglist[] = {
   "1", "2", "3", "4", "5", "6", "7", "8", "9","10",
  "11","12","13","14","15","16","17","18","19","20",
  "21","22","23","24","25","26","27","28","29","30",
  "31","32",0
};
psignal(msg)
	char *msg;
{
	fprintf(stderr,"%s: SIGNAL ?\n");
}
killpg(pgrp,sig)
{
	return kill(-pgrp,sig);
}
sigvec(sig,vec,ovec){
	return sigvector(sig, vec, ovec);
}

/*
 *
 */

setreuid(ruid,euid)
{
	setresuid(ruid,euid,-1);
}

utimes(file,tvp)
	char *file;
	struct timeval *tvp;
{	struct utimbuf times;
	int time0;

	if( tvp == 0 ){
		time0 = time(0);
		times.actime = time0;
		times.modtime = time0;
	}else{
		times.actime = tvp[0].tv_sec;
		times.modtime = tvp[1].tv_sec;
	}
	return utime(file,&times);
}

getrusage(who, rusage)
	struct rusage *rusage;
{	struct tms tbuf;
	static struct rusage iru;

	times(&tbuf);

	*rusage = iru;
	rusage->ru_utime.tv_sec = tbuf.tms_utime;
	rusage->ru_stime.tv_sec = tbuf.tms_stime;
/*
	tbuf.tms_cutime;
	tbuf.tms_cstime;
*/
	return -1;
}

random(){
	return rand();
}
srandom(seed)
	unsigned int seed;
{
	return srand(seed);
}

/*
 *	REGULAR EXPRESSION
 */
#include <regex.h>
static regex_t REXP;
re_comp(s)
	char *s;
{
	if( *(int*)&REXP != 0 )
		regfree(&REXP);
	regcomp(&REXP, s, REG_NOSUB);
	return 0;
}
re_exec(s)
	char *s;
{
	if(s == 0) return 0;
	return regexec(&REXP,s,strlen(s),(size_t)0,NULL,0) == 0;
}

#else
static int dummy;
#endif
