# fax
#
# Fri Jan  1 15:31:10 1993 Salil Deshpande
#
# This service scans through a message body for postscript source, and
# sends what it found to the printer.  If the input is a multipart, it
# scans through the last body in the multipart.  It also does a check
# to see if the address is local (it won't print otherwise).
#
proc fax {switches envelope inputs} {
    if {[local [getfield $envelope FROM]]} {
      if {[getfield $inputs TYPE] == "multipart"} {
	set parts [getfield $inputs PARTS]
	return [fax $switches $envelope [lindex $parts [expr [llength $parts] - 1]]]
      } {
	set user [getfield $envelope FROM]
	set userdb [glob ~$user/.faxdb]
	exec /bin/rm -f [glob ~services/.faxdb]
	exec ln -s $userdb [glob ~services/.faxdb]
    	exec sendfax -m -d $switches [getfield $inputs FILE]
	exec /bin/rm -f [glob ~services/.faxdb]
	setfield response STRING "Message sent to Fax Machine."
	return [mailout [turnaround $envelope] $response]
      }
    } {
      setfield response STRING "Sorry, I can only fax for locals."
      return [mailout [turnaround $envelope] $response]
    }
}
