# ps2paper
#
# 25-Jun-92 weber@eitech.com updated for new parameter format
# 29-May-92 weber@eitech.com
#
# This service scans through a message body for postscript source, and
# sends what it found to the printer.  If the input is a multipart, it
# scans through the last body in the multipart.  It also does a check
# to see if the address is local (it won't print otherwise).
#
proc doprint {switches envelope inputs} {
    if {[local [getfield $envelope FROM]]} {
      if {[getfield $inputs TYPE] == "multipart"} {
	set parts [getfield $inputs PARTS]
	return [doprint $switches $envelope [lindex $parts [expr [llength $parts] - 1]]]
      } {
    	exec awk "/^%\\!/,/^%%EOF\$/" [getfield $inputs FILE] | lpr -Preal
	setfield response STRING "Postscript sent to printer."
	return [mailout [turnaround $envelope] $response]
      }
    } {
      setfield response STRING "Sorry, I can only print for locals."
      return [mailout [turnaround $envelope] $response]
    }
}
