/*Copyright (c)  1993 Enterprise Integration Technologies Corporation

Permission to use, copy, modify, distribute, and sell this software and
its documentation for any purpose is hereby granted without fee, provided
that (i) the above copyright notices and this permission notice appear in
all copies of the software and related documentation, and (ii) the name of
Enterprise Integration Technologies Corporation may not be used in any
advertising or publicity relating to the software without the specific,
prior written permission of Enterprise Integration Technologies Corporation.

THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.

IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION  BE
LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF
ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
*/
#include "pdinq.h"
#include "pdmain.h"

int main (argc,argv)
  int argc; 
  char **argv;
  {
    char *line;
    int fd,priority;
#ifdef USESYSLOG
    openlog("pdinq",(LOG_PID | LOG_CONS),FACILITY);
#endif    
    strcpy(spooldir,"./spool");
    procopts(argc,argv);

    if(chdir(spooldir)<0)
      error(E_CHDIR,spooldir);
      
    fname=makenam(spooldir,SPOOLPREF);

    if((fd=open(fname,O_CREAT | O_WRONLY,1<<7))<0)
      error(E_NOOPEN,fname);

    while(line=rwl(stdin,fd))
    {
      if(header>0)
        procl(line);
      if(!header)
      {
        priority=getpriority(defpri);
        setname(priority);
        logmsg();
      }
    }

    if(fchmod(fd,384)<0)
      error(E_CHMOD,fname);
    if(close(fd)<0)
      error(E_CLOSE,fname);
      
     exit(0);
  }

char *rwl(fp,fd)
  FILE *fp;
  int fd;
  {
    static int alloced;
    static char b;
    static char c=0;
    static char *buf;
    int cur;
    
    if(!alloced)
    {
      alloced=DEFALLOC;
      buf=(char *)malloc(sizeof(char)*DEFALLOC);        
      if(!buf)
      {
        error(E_NOMEM,NULL);
        buf=&c;
        return(buf);
      }
    }
    if(b==EOF)
      return(NULL);

    if(b=='\n')
    {
      if(header>0)
        header=0;
      buf[0]='\n';
      buf[1]='\0';
      b=0;
      return(buf);
    }
      
    if(b)
    {
      buf[0]=b;
      cur=1;
    }
    else
      cur=0;

    while(1)
    {
      while(((b=rwc(fp,fd))!=EOF)&&(b!='\n'))
      {
        if(!addchar(&buf,&alloced,&cur,b))
          goto carry;
      } 
      if(b=='\n')
      {
        /*Check for header field folding as per RFC822*/
        if(header>0)
        {
          if(((b=rwc(fp,fd))==' ')||(b=='\t'))
          { 
            if(addchar(&buf,&alloced,&cur,b))
              continue;
            else
              goto carry;
          }
          buf[cur++]='\n';
          buf[cur++]='\0';
          return(buf);
        }
        buf[cur++]='\n';
        buf[cur++]='\0';
        b=0;
        return(buf);
      }
      buf[cur]='\0';
      return(buf);
    }
    
   carry:
      buf[cur]='\0';
      return(buf);
  }
          
char rwc(fp,fd)
  FILE *fp;
  int fd;
  {
    static char buffer[BUFFERSIZE];
    static int position;
    char foo;

    if(position<BUFFERSIZE)
    if((foo=getc(fp))!=EOF)
      buffer[position++]=foo;
    
    if((position==BUFFERSIZE)||(foo==EOF))
    {
      writeb(buffer,fd,position);
      position=0;
    }

    return(foo);
  }
    
addchar(sp,sz,pos,c)
  char **sp;
  int *sz,*pos;
  char c;
  {
     char *tp;

     if((*pos)<(*sz-3))
     {
       (*sp)[(*pos)++]=c;
       return(1);
     }
     else
     {
       (*sz)*=2;
       if(tp=(char *)realloc(*sp,sizeof(char)*(*sz)))
       {  
          *sp=tp;
          *sp[(*pos)++]=c;
          return(1);
       }
     }
     error(E_NOMEM,NULL);      
     return(0);
  }      
    
writeb(line,fd,btw)
  char *line;
  int fd;
  int btw;
  {
    int bwr;
    char *cur;

    cur=line;

    while(btw)
    {
     if((bwr=write(fd,line,btw))<0)
        error(E_WRITE,fname);
      cur+=bwr;
      btw-=bwr;
    }
  }      

procopts(argc,argv)
  int argc;
  char **argv;
  {
    extern char *optarg;
    extern int optind;
    int ret;
    while((ret=getopt(argc,argv,"d:p:"))!=-1)
    {
      switch(ret)
      {
        case 'd':
          if(strlen(optarg)>=MAXPATHLEN)
            error(E_TOOLONG,optarg);
          else
            strcpy(spooldir,optarg);
          break;
        case 'p':
          defpri=atoi(optarg);
          break;
        case '?':
          break;
        default:
          break;
      }
    }
  }
error(e,c)
  int e;
  char *c;
  {
    string line;

    strcpy(line,err[e].msg);
    if(c)
      strcat(line,c);
    if(err[e].status & SYSTEM)
      strcat(line," because %m");
#ifdef USESYSLOG
    syslog(FACILITY | err[e].level,line);
#endif    
    if(err[e].status & FATAL)
    {
      fprintf(stderr,"PD was unable to process your transaction.\n");
      fprintf(stderr,"Error %d\n",e);
      exit(1);
    }
  }      
        
procl(buf)
char *buf;
  {
    static lnum=0;

    if(!lnum++)
      sendmaildata(buf);
    else
    {
      if(usefrom(buf))
         line2from(buf);
      if(!strncasecmp("Date",buf,4))
        line2date(buf);
      if(!strncasecmp("Message-Id",buf,10))
        line2msgid(buf);
    }
    stashline(buf); 
  }

logmsg()
{
   char line[1024],buf[1024];

   time_t foo;
   strftime(buf,1024,"%TZ%D",gmtime(&hdata.date));
   sprintf(line,"%s\t%s\t%s\t%s",
    fname,hdata.msgid,buf,hdata.from);
#ifdef USESYSLOG
   syslog(LOG_INFO,line);
#endif   
   header=-1;   
}
  
getpriority(pri)
  int pri;
  {
    return(pri);
  }

char *makenam(dir,pref)
  char *dir,*pref;
  {
    static string name;
    long t;
    int i;
    t=time(NULL);

    i=t%65536;
    
    sprintf(name,"%.3s%.4x%.5d",pref,i,getpid());
    return(name);
  }
    
setname(priority)
  int priority;

  {
    static string name;

    sprintf(name,"%d_%s",priority,fname);
    rename(fname,name);
    fname=name;
  }    

    
    
        
  
