#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

typedef unsigned long u_32;
typedef struct {
	u_32		magic;		/* magic number */
	u_32		hdr_size;	/* size of this header */
	u_32		data_size;	/* length of data (optional) */
	u_32		encoding;	/* data encoding format */
	u_32		sample_rate;	/* samples per second */
	u_32		channels;	/* number of interleaved channels */
} Audio_filehdr;

main(argc, argv)
char **argv;
{
	Audio_filehdr hdr;
	struct stat sbuf;
	int f;

	if (argc != 2) {
		fprintf(stderr, "Usage: fixlen file\n");
		exit(1);
	}

	f = open(argv[1], 2);
	if (f < 0) {
		perror(argv[1]);
		exit(2);
	}

	stat(argv[1], &sbuf);

	read(f, &hdr, sizeof hdr);
	/* printf("old size %d\n", hdr.data_size); */
	hdr.data_size = sbuf.st_size - 0x20;
	/* printf("new size %d\n", hdr.data_size); */
	lseek(f, 0L, 0);
	write(f, &hdr, sizeof hdr);
	exit(0);
}
