#if	!defined(lint) && !defined(DOS)
static char rcsid[] = "$Id: mswin.c,v 4.64 1996/05/22 17:40:46 mikes Exp $";
#endif
/*---------------------------------------------------------------------------
 *
 *  Module: mswin.c
 *
 * Thomas Unger
 * Networks and Distributed Computing
 * Computing and Communications
 * University of Washington
 * Administration Builiding, AG-44
 * Seattle, Washington, 98195, USA
 * Internet: tunger@cac.washington.edu
 *
 *
 * Pine and Pico are registered trademarks of the University of Washington.
 * No commercial use of these trademarks may be made without prior written
 * permission of the University of Washington.
 * 
 * Pine, Pico, and Pilot software and its included text are Copyright
 * 1989-1996 by the University of Washington.
 * 
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this distribution.
 *--------------------------------------------------------------------------*/

#define WIN31 
#define STRICT

#include <windows.h>
#include <commdlg.h>
#ifndef	WIN32
#include <print.h>
#include <toolhelp.h>
#endif
#include <cderr.h>
#include <winsock.h>
#include <shellapi.h>

#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <errno.h>
#include <signal.h>
#include <setjmp.h>
/*#include <conio.h>*/
#include <time.h>
/*#include <signal.h>*/
#include <fcntl.h>

#define	termdef	1			/* don't define "term" external */

#include "osdep.h"
#include "pico.h"
#include "estruct.h"
#include "efunc.h"
#include "edef.h"
#include "msmenu.h"


/* Windows only version and resource defines. */
#include "resource.h"




/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *			Defines
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


#define ICON


/* For debugging, export locals so debugger can see them. */
#ifdef DEBUG
#define LOCAL
#else
#define LOCAL		static
#endif


/* 
 * Define which debugging is deisred.  Generally only FDEBUG. 
 */
#define FDEBUG		/* Standard file debugging. */

#undef SDEBUG		/* Verbose debugging of startup and windows handling*/
#undef CDEBUG		/* Verbose debugging of character input timeing. */

#undef OWN_DEBUG_FILE	/* Define if we want to write to our own debug file, 
			 * not pine's. */




/* Max size permitted for the screen.  Larger than ever expec, but small
 * enough to prevent errors.  And small enough that the size of the
 * screen strucure is less than 64K. */
#define MAXNROW			180
#define MAXNCOLUMN		256

#define MINNROW			10	/* Minimum screen size */
#define MINNCOLUMN		32

#define MARGINE_LEFT		3
#define MARGINE_TOP		1

#define FRAME_3D_SIZE		1

#define WIN_MIN_X_SIZE		190	/* Minimum window size. */
#define WIN_MIN_Y_SIZE		180

#define WIN_X_BORDER_SIZE	8	/* Space taked by window frame. */
#define WIN_Y_BORDER_SIZE	65

#define FONT_MIN_SIZE		5
#define FONT_MAX_SIZE		21

#define PRINT_TAB_SIZE		8	/* Tab size used by print code. */


#define TB_HEIGHT		32	/* Tool Bar Height. */
#define TB_BUTTONHEIGHT		16	/* Button Height. */
#define TB_BUTTONSPACING	8	/* Space between buttons. */





/* Some string lengths. */
#define MAXLEN_TEMPSTR		256	/* Max size for temp storage. */

#define WIN_POS_STR_MAX_LEN	20	/* Max length for window-position
					 * string. */

#define MENU_ITEM_NAME_LEN	32	/* Menu item name lengths. */




/* Length of keyboard input queue. */
#define CHARACTER_QUEUE_LENGTH	32
#define MOUSE_QUEUE_LENGTH	32


/* Number of resize callback functions we can keep track of. */
#define RESIZE_CALLBACK_ARRAY_SIZE	3


/* Number of bytes held in the write accumulator. */
#define WRITE_ACCUM_SIZE		200



/* Max time that may pass between calls to GetMessage.  See mswin_charavail()
 */
#define GM_MAX_TIME	3000		/* In milliseconds.*/


/* My Timer Message */
#define MY_TIMER_ID	33
#define MY_TIMER_PERIOD (UINT)60000	/* timeout period in miliseconds. */
#define MY_TIMER_SHORT_PERIOD (UINT)5000  /* used when there is a task in
					     the OnTask list. */
#define MY_TIMER_VERY_SHORT_PERIOD (UINT)500  /* used when SIGALRM and alarm()
						 is set. */
#define MY_TIMER_EXCEEDINGLY_SHORT_PERIOD (UINT)80 /* used when 
						 gAllowMouseTracking is set */

#define TIMER_FAIL_MESSAGE "Failed to get all necessary Windows resoruce (timers).  Pine will run, but may not be able to keep the connection to the server alive.  Quiting other applications and restarting Pine may solve the problem."




/*
 * Below here are fixed constancs that really should not be changed.
 */

/* Cursor states. */
#define CS_SHOW         0x01		/* Cursor is not hidden. */
#define CS_FOCUSED	0x02		/* Window is focused. */
#define CS_VISIBLE	0x03		/* When above two bits set, cursor is
					 * visible. */

/* Auto Wrap States. */
#define WRAP_OFF	0		/* Never wrap to next line. */
#define WRAP_ON		1		/* Wrap to next line. */
#define WRAP_NO_SCROLL	2		/* Wrap to next line but DON'T scroll
					   screen to do it. */

/* Speicial keys in the Character Queue. */
#define CQ_FLAG_DOWN		0x01
#define CQ_FLAG_EXTENDED	0x02
#define CQ_FLAG_ALT		0x04



/* Special ASCII characters. */
#define ASCII_BEL       0x07
#define ASCII_BS        0x08
#define ASCII_TAB	0x09
#define ASCII_LF        0x0A
#define ASCII_CR        0x0D
#define ASCII_XON       0x11
#define ASCII_XOFF      0x13




/* Character Attributes. */
#define CHAR_ATTR_NORM	0x00		/* Normal. */
#define CHAR_ATTR_REV	0x01		/* Reverse Video. */
#define CHAR_ATTR_SEL	0x02		/* Selected text. */
#define CHAR_ATTR_NOT   0x80		/* No attributes. */


/*
 * Different applications that we know about.
 */
#define APP_UNKNOWN		0
#define APP_PICO		1
#define APP_PICO_IDENT		"pico"
#define APP_PINE		2
#define APP_PINE_IDENT		"pine"



/*
 * Control values for call to AccelCtl.
 */
#undef ACCELERATORS
#define ACCEL_UNLOAD		0	/* Unload the accelerators. */
#define ACCEL_LOAD		1	/* Load the accelerators. */
#define ACCEL_TOGGLE		2	/* Toggle the accelerators. */



/* Offsets to objects in window extra storage. */
#define GWL_PTTYINFO		0	/* Offset in Window extra storage. */
#define GWL_PTEXTINFO		0	/* Offset in Window extra storage. */

#define ABOUTDLG_USEBITMAP	1



/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *			Typedefs
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/* Type that the screen array is made up of. */
#define	CHAR	unsigned char

/* Type that the attribute array is made up of. */
typedef BYTE			CharAttrib;
typedef int			(*ResizeCallBackProc)();
typedef	int			(*FileDropCallBackProc)();
typedef short			CORD;


/* NOTE:  There is currently code that assumes that CHAR and CharAttrib
 *	are one byte in size.  All this code is flaged with a preceeding
 *	assert () */


/* Struct that defines command menu entries. */
typedef struct tagMenuItem {
    BOOL	miActive;
    WORD	miKey;
} MenuItem;


/* List of child window IDs and previous window procedures. */
typedef struct tagBtnList {
    WORD	wndID;
    WNDPROC	wndProc;
} BtnList;


/* General info. */
typedef struct tagTTYINFO {
    CHAR	*pScreen;	/* Screen. */
    BYTE	*pAttrib;	/* Attributes. */
    BOOL	screenDirty;	/* TRUE if screen needs update. */
    BOOL	eraseScreen;	/* TRUE if need to erase whole screen */
    CHAR	writeAccum[WRITE_ACCUM_SIZE];
    int		writeAccumCount;
    WORD	wCursorState;	/* Is cursor displayed? */
    int		scrollRange;	/* Current scroll bar range. */
    long	scrollPos;	/* Current scroll position. */
    long	scrollTo;	/* Possition of last scroll to. */
    float	scrollScale;	/* Scaleing for scroll range. */
    HFONT	hTTYFont;
    LOGFONT	lfTTYFont;
    DWORD	rgbFGColor;	/* Normal forground color. */
    DWORD	rgbBGColor;	/* Normal background color. */
    DWORD	rgbRFGColor;	/* Reverse forground color. */
    DWORD	rgbRBGColor;	/* Reverse background color */
    BOOL	fMinimized;	/* True when window is minimized. */
    BOOL	fFocused;	/* True when we have focus. */
    BOOL	fNewLine;	/* Auto LF on CR. */
    BOOL	fMassiveUpdate;	/* True when in Massive screen update. */
    BOOL	fNewMailIcon;	/* True when new mail has arrived. */
    ResizeCallBackProc  resizer[RESIZE_CALLBACK_ARRAY_SIZE];
    FileDropCallBackProc dndhandler;
    int		autoWrap;	/* Auto wrap to next line. */
    CharAttrib	curAttrib;	/* Current character attributes. */
    int		actNRow, actNColumn;	/* Actual number of rows and comumns
					 * displayed. */
    CORD	xSize, ySize;		/* Size of screen in pixels */
    CORD	xScroll, yScroll;	/* ?? */
    CORD	xOffset, yOffset;	/* Offset from the left and top of
					 * window contents. */
    CORD	nColumn, nRow;		/* Current position of cursor in 
				         * cells. */
    CORD	xChar, yChar;		/* Width of a char in pixels. */
    CORD	fDesiredSize;		/* TRUE when there is a specific size
					 * the window should be expanded to
					 * after being minimized. */
    CORD	xDesPos, yDesPos;	/* Desired position. */
    CORD	xDesSize, yDesSize;	/* Desired window position. */
    int		curWinMenu;		/* Current window menu. */
    HACCEL	hAccel;			/* Handle to accelorator keys. */
    CORD	toolBarSize;		/* Size of toolbar. */
    BOOL	toolBarTop;		/* Toolbar on top? */
    int		curToolBarID;
    BtnList	*toolBarBtns;
    HWND	hTBWnd;
    BOOL	menuItemsCurrent;
    MenuItem	menuItems[KS_COUNT];
} TTYINFO, *PTTYINFO ;



typedef struct MSWINColor {
    char		*colorName;
    COLORREF		colorRef;
} MSWINColor;


/*
 * Entry in the OnTask list.  This is a list of actions to perform
 * when a task exits.  Currently, the only thing we do is delete
 * files.  if that changes this structure will get more complex.
 *
 * hTask == NULL means "This program" and can be used to arrange for
 * deletion of files when this program exits.
 */
typedef struct ontask {
    struct ontask	*next;
    HTASK		hTask;
    char		path[PATH_MAX+1];
} OnTaskItem;


typedef void (__cdecl *SignalType)(int);


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *			Forward function declarations.
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/



#ifdef	WIN32
#define	GET_HINST( hWnd )  ((HINSTANCE) GetWindowLong( hWnd, GWL_HINSTANCE ))
#define	GET_ID( hWnd )  ((WORD) GetWindowLong( hWnd, GWL_ID ))
#else
#define GET_HINST( hWnd )  ((HINSTANCE) GetWindowWord( hWnd, GWW_HINSTANCE ))
#define	GET_ID( hWnd )  ((WORD) GetWindowWord( hWnd, GWW_ID ))
#endif

#define MIN(x,y)	((x) < (y) ? (x) : (y))
#define MAX(x,y)	((x) > (y) ? (x) : (y))
#define CONSTRAIN(v,min,max)	((v) = (v) < (min) ? (min) : (v) > (max) ? (max) : (v))


// function prototypes (private)

void		WinExit (void);
LOCAL BOOL	InitApplication (HANDLE);
LOCAL HWND	InitInstance (HANDLE, int);
LOCAL void	MakeArgv (HINSTANCE hInstance, LPSTR cmdLine, int *pargc, 
				char ***pargv);
LOCAL LRESULT NEAR	CreateTTYInfo (HWND hWnd);
LOCAL BOOL NEAR	DestroyTTYInfo (HWND hWnd);
LOCAL int	ResizeTTYScreen (HWND hWnd, PTTYINFO pTTYInfo, 
					int newNRow, int newNColumn);
LOCAL BOOL	ResetTTYFont (HWND, PTTYINFO, LOGFONT *);
LOCAL BOOL	EraseTTY (HWND, HDC);
LOCAL BOOL	PaintTTY (HWND);
LOCAL BOOL	GetMinMaxInfoTTY (HWND hWnd, MINMAXINFO __far *lpmmi);
LOCAL BOOL	AboutToSizeTTY (HWND hWnd, WINDOWPOS *winPos);
LOCAL BOOL	SizeTTY (HWND, int, CORD, CORD);
LOCAL void	FrameRect3D(HDC hdc, RECT * pRC, int width, BOOL raised);
LOCAL void	FillRectColor(HDC hDC, RECT * pRC, COLORREF color);


LOCAL BOOL	MoveTTY (HWND hWnd, int xPos, int yPos);
LOCAL void	ScrollTTY (HWND hWnd, int wScrollCode, int nPos, HWND hScroll);
BOOL CALLBACK	NoMsgsAreSent (void);
LOCAL BOOL	SetTTYFocus (HWND);
LOCAL BOOL	KillTTYFocus (HWND);
LOCAL BOOL	MoveTTYCursor (HWND);
LOCAL BOOL	ProcessTTYKeyDown (HWND hWnd, WORD bOut, DWORD keyData);
LOCAL BOOL	ProcessTTYKeyUp (HWND hWnd, WORD key, DWORD keyData);
LOCAL BOOL	ProcessTTYCharacter (HWND hWnd, WORD bOut, DWORD keyData);
LOCAL BOOL	ProcessTTYMouse (int mevent, int button, CORD xPos, 
					CORD yPos, WPARAM keys);
LOCAL BOOL	ProcessTTYFileDrop (HANDLE wParam);
LOCAL void	ProcessTimer (void);
LOCAL BOOL	WriteTTYBlock (HWND, LPSTR, int);
LOCAL BOOL	WriteTTYText (HWND, LPSTR, int);
LOCAL BOOL	WriteTTYChar (HWND, char);

LOCAL VOID	GoModalDialogBoxParam (HINSTANCE, LPCSTR, HWND, 
					DLGPROC, LPARAM);
LOCAL BOOL	SelectTTYFont (HWND);
LOCAL void	SetColorAttribute (COLORREF *cf, char *colorName);
LOCAL BOOL	ConvertRGBString (char *colorName, COLORREF *cf);
LOCAL BOOL	ScanInt (char *str, int min, int max, int *val);

LOCAL void	TBToggle (HWND);
LOCAL void	TBPosToggle (HWND);
LOCAL void	TBShow (HWND);
LOCAL void	TBHide (HWND);
LOCAL void	TBSwap (HWND, int);

#ifdef ACCELERATORS
LOCAL void	AccelCtl (HWND hWnd, int ctl, BOOL saveChange);
#endif

LOCAL void	SelStart (int nRow, int nColumn);
LOCAL void	SelFinish (int nRow, int nColumn);
LOCAL void	SelClear (void);
LOCAL void	SelTrackXYMouse (int xPos, int yPos);
LOCAL void	SelTrackMouse (int nRow, int nColumn);
LOCAL BOOL	SelAvailable (void);
LOCAL void	SelDoCopy (HANDLE hCB, DWORD lenCB);

LOCAL void	FlushWriteAccum (void);



		/* ... interface routines ... */


void		ProcessMenuItem (HWND hWnd, WPARAM wParam);

void		AlarmDeliver (void);
void		HUPDeliver (void);

void		PrintFontSameAs (HWND hWnd);
void		PrintFontSelect (HWND hWnd);
void		ExtractFontInfo (LOGFONT *pFont, char *fontName, 
			int *fontSize, char *fontStyle, int ppi);

LOCAL void	DidResize (PTTYINFO pTTYInfo);

LOCAL void	UpdateMenu (HWND hWnd);
LOCAL void	EditCut (void);
LOCAL void	EditCopy (void);
LOCAL void	EditCopyAppend (void);
LOCAL void	EditDoCopyData (HANDLE hCB, DWORD lenCB);
LOCAL void	EditPaste (void);
LOCAL void	EditCancelPaste (void);
LOCAL WORD	EditPasteGet (void);
LOCAL BOOL	EditPasteAvailable (void);

LOCAL void	ShowHelp (void);

LOCAL void	MyTimerSet (void);

LOCAL void	ProcessOnTask (void);
LOCAL void	ProcessOnExit (void);

LOCAL LRESULT	ConfirmExit (void);

LOCAL BOOL	TWErase (HWND hWnd, HDC hDC);
LOCAL void	TWPaint (HWND hWnd);
LOCAL void	TWScroll (HWND hWnd, int wScrollCode, int nPos);
LOCAL int	TWMeasureLine (char *text);
LOCAL void	TWChar (HWND hWnd, WORD , DWORD keyData);
LOCAL BOOL	TWKeyDown (HWND hWnd, WORD key, DWORD keyData);
LOCAL BOOL	TWMouseDown (HWND hWnd, int button, CORD xPos, CORD yPos, 
			WPARAM keys);
LOCAL BOOL	TWMouseUp (HWND hWnd, int button, CORD xPos, CORD yPos, 
			WPARAM keys);
LOCAL BOOL	TWMouseTrack (HWND hWnd, CORD xPos, CORD yPos);
LOCAL BOOL	TWEditCopy (HWND hWnd);

LOCAL void	TWSetSize (HWND hWnd, UINT wParam, UINT height, UINT width);
LOCAL void	TWPrint (HWND hWnd);


LOCAL void	CQInit (void);
LOCAL BOOL	CQAvailable (void);
LOCAL BOOL	CQAdd (WORD c, DWORD keyData);
LOCAL BOOL	CQAddUniq (WORD c, DWORD keyData);
LOCAL WORD	CQGet ();

LOCAL void	MQInit (void);
LOCAL BOOL	MQAvailable (void);
LOCAL BOOL	MQAdd (int mevent, int button, int nRow, int nColumn, 
				int keys, int flags);
LOCAL BOOL	MQGet (MEvent * pmouse);
LOCAL BOOL	MQClear (int flag);

LOCAL int	MapVKtoMS (WORD c, WORD flags);



/* Functions exported to MS Windows. */

LRESULT FAR PASCAL __export PWndProc (HWND, UINT, WPARAM, LPARAM);
LRESULT FAR PASCAL __export TWWndProc (HWND, UINT, WPARAM, LPARAM);
BOOL FAR PASCAL __export ToolBarProc (HWND, UINT, WPARAM, LPARAM);
LRESULT FAR PASCAL __export TBBtnProc (HWND, UINT, WPARAM, LPARAM);
BOOL FAR PASCAL __export AboutDlgProc (HWND, UINT, WPARAM, LPARAM);







/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *			Exported Globals
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/



/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *			Imported Globals
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/



/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *			Module globals.
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


PTTYINFO		gpTTYInfo;
HWND			ghTTYWnd;
HINSTANCE		ghInstance;
BOOL			gfUseDialogs;
FILE			*mswin_debugfile = NULL;
int			mswin_debug = 0;
char			gszAppName[45];

LOCAL BOOL		gUse3DFrame = FALSE;

LOCAL char		TempBuf [MAXLEN_TEMPSTR];

LOCAL char		gszTTYClass[] = "PineWnd";
LOCAL char		gszTextClass[] = "PineText";
LOCAL int		gAppIdent = APP_UNKNOWN;

LOCAL HCURSOR		ghCursorArrow = NULL;
LOCAL HCURSOR		ghCursorBusy = NULL;
LOCAL HCURSOR		ghCursorCurrent = NULL;



/* Used for Pasting text. */
LOCAL HANDLE		ghPaste = NULL;		/* Handle to Paste data. */
LOCAL char		*gpPasteNext = NULL;	/* Pointer to current char. */
LOCAL size_t		gPasteBytesRemain = 0;	/* Count of bytes left. */
LOCAL BOOL		gPasteWasCR = FALSE;	/* Previous char was CR. */
LOCAL int		gPasteEnabled = MSWIN_PASTE_DISABLE;
LOCAL getc_t		gCopyCutFunction = NULL;
LOCAL scroll_t		gScrollCallback = NULL;
LOCAL BOOL		gScrolling = FALSE;	/* Keeps track of when we are
						 * in scroll routine. */
LOCAL BOOL		gMouseTracking = FALSE;	/* Keeps track of when we are
						 * tracking the mouse. */
LOCAL FARPROC		gWSBlockingProc = NULL;
LOCAL DLGPROC		gToolBarProc = NULL;
LOCAL WNDPROC		gTBBtnProc = NULL; 

LOCAL BOOL		gAllowCopy = FALSE;
LOCAL BOOL		gAllowCut = FALSE;

LOCAL BOOL		gAllowMouseTrack = FALSE;/* Upper layer interested in
						 * mouse tracking. */
LOCAL MEvent		gMTEvent;

LOCAL BOOL		gKeyControlDown = FALSE;/* Keep track of the control
						 * key position. */

LOCAL char		*gpHelpTitle;		/* Title of help. */
LOCAL char		*gpHelpText;		/* Pointer to help text. */
LOCAL size_t		gpHelpLen;		/* Length of text. */
LOCAL char		**gpHelpLines;		/* Alternate view. */
LOCAL BOOL		gfHelpMenu = FALSE;	/* TRUE when help menu 
						 * installed. */
LOCAL char		*gpCloseText;

LOCAL DWORD		gGMLastCall = 0;	/* Last time I called
						 * GetMessage. */
LOCAL OnTaskItem	*gOnTaskList = NULL;	/* Things to do when a task
						 * exits. */
LOCAL OnTaskItem	*gOnExitList = NULL;	/* Things to do when I 
						 * exit. */
LOCAL BOOL		gConfirmExit = FALSE;
LOCAL HICON		ghNormalIcon = NULL;
LOCAL HICON		ghNewMailIcon = NULL;

LOCAL int		gPrintFontSize;
LOCAL char		gPrintFontName[LF_FACESIZE+1];
LOCAL char		gPrintFontStyle[64];
LOCAL BOOL		gPrintFontSameAs = TRUE;

LOCAL UINT		gTimerCurrentPeriod = 0;

LOCAL callback_t	gPeriodicCallback = NULL; /* Function to call. */
LOCAL DWORD		gPeriodicCBTimeout = 0;   /* Time of next call. */
LOCAL DWORD		gPeriodicCBTime = 0;	  /* Delay between calls. */

/* Currently only implement one SIGNAL so only need single variable. */
LOCAL SignalType	gSignalAlarm = SIG_DFL;
LOCAL DWORD		gAlarmTimeout = 0;	/* Time alarm expires in 
						 * seconds 
						 * (GetTickCount()/1000) */
LOCAL SignalType	gSignalHUP = SIG_DFL;



LOCAL MSWINColor  MSWINColorTable[] =  {
	"black",	RGB(0,0,0),
	"blue",		RGB(0,0,255),
	"green",	RGB(0,255,0),
	"cyan",		RGB(0,255,255),
	"red",		RGB(255,0,0),
	"magenta",	RGB(255,0,255),
	"yellow",	RGB(255,255,0),
	"white",	RGB(255,255,255),
	"ltgray",	RGB(192,192,192),
	"gray",		RGB(128,128,128),
	"dkgray",	RGB(64,64,64),
	NULL,		0,
};






/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *			Windows Functions.
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*---------------------------------------------------------------------------
 *  int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance,
 *                      LPSTR lpszCmdLine, int nCmdShow )
 *
 *  Description:
 *     This is the main window loop!
 *
 *  Parameters:
 *     As documented for all WinMain() functions.
 *
 *--------------------------------------------------------------------------*/

int PASCAL
WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow )
{
    char		**argv;
    int			argc;
    MSG			msg;

    ghInstance = hInstance;
    if (!hPrevInstance)
	if (!InitApplication( hInstance ))
	    return ( FALSE ) ;
    
#ifdef OWN_DEBUG_FILE	/* Want to write to seperate memdebug.txt file. */
    mswin_debugfile = fopen ("memdebug.txt", "w");
    fprintf (mswin_debugfile, "Beginning of mswin debug log\n");
    if (mswin_debugfile != NULL) {
	mswin_debug = 4;
	MemDebug (mswin_debug, mswin_debugfile);
	fprintf (mswin_debugfile, "Show window as:  %d\n", nCmdShow);
	fflush (mswin_debugfile);
    }
#endif

    if (NULL == (ghTTYWnd = InitInstance (hInstance, nCmdShow)))
	return (FALSE);


    MakeArgv (hInstance, lpszCmdLine, &argc, &argv);
    
    atexit (WinExit);
    
    app_main (argc, argv);

    return (TRUE);
}



void
WinExit (void)
{
    MSG			msg;
    
    if (ghTTYWnd == NULL)
	return;
	
    /* Destroy main window and process remaining events. */
    DestroyWindow (ghTTYWnd);
    while (GetMessage (&msg, NULL, 0, 0)) {
	TranslateMessage (&msg);
	DispatchMessage (&msg);
    }

#ifdef OWN_DEBUG_FILE
    fclose (mswin_debugfile);
#endif
    /* Take one last look at the task list. */
    ProcessOnTask ();
    ProcessOnExit ();
    if (gWSBlockingProc != NULL)
	FreeProcInstance (gWSBlockingProc);
    MemFreeAll ();
    ghTTYWnd = NULL;
}



/*---------------------------------------------------------------------------
 *  BOOL  InitApplication( HANDLE hInstance )
 *
 *  Description:
 *     First time initialization stuff.  This registers information
 *     such as window classes.
 *
 *  Parameters:
 *     HANDLE hInstance
 *        Handle to this instance of the application.
 *
 *--------------------------------------------------------------------------*/

LOCAL BOOL  
InitApplication (HANDLE hInstance)
{
    WNDCLASS  wndclass;
    DWORD	vers;
    int		winMajorVers;
    int		winMinorVers;
    
    vers = GetVersion ();
    winMajorVers = LOBYTE(LOWORD(vers));
    winMinorVers = HIBYTE(LOWORD(vers));
    gUse3DFrame =  winMajorVers > 3 || 
			(winMajorVers == 3 && winMinorVers >= 95);
    

    /* 
     * Register tty window class.
     */
    wndclass.style =         0;//CS_NOCLOSE;
    wndclass.lpfnWndProc =   PWndProc;
    wndclass.cbClsExtra =    0;
    wndclass.cbWndExtra =    sizeof (LONG);
    wndclass.hInstance =     hInstance ;
    wndclass.hIcon =         NULL;
    wndclass.hCursor =       LoadCursor (NULL, IDC_ARROW);
    wndclass.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
    wndclass.lpszMenuName =  MAKEINTRESOURCE (PINEMENU);
    wndclass.lpszClassName = gszTTYClass ;

    if (!RegisterClass (&wndclass))
	    return (FALSE);

    
    /* 
     * Register tty window class.
     */
    wndclass.style =         CS_BYTEALIGNWINDOW;
    wndclass.lpfnWndProc =   TWWndProc;
    wndclass.cbClsExtra =    0;
    wndclass.cbWndExtra =    sizeof (LONG);
    wndclass.hInstance =     hInstance ;
    wndclass.hIcon =         LoadIcon (hInstance, MAKEINTRESOURCE( PINEICON));
    wndclass.hCursor =       LoadCursor (NULL, IDC_ARROW);
    wndclass.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
    wndclass.lpszMenuName =  MAKEINTRESOURCE (TEXTWINMENU);
    wndclass.lpszClassName = gszTextClass ;

    return (RegisterClass (&wndclass));
}



/*---------------------------------------------------------------------------
 *  HWND  InitInstance( HANDLE hInstance, int nCmdShow )
 *
 *  Description:
 *     Initializes instance specific information.
 *
 *  Parameters:
 *     HANDLE hInstance
 *        Handle to instance
 *
 *     int nCmdShow
 *        How do we show the window?
 *
/*--------------------------------------------------------------------------*/

LOCAL HWND  
InitInstance (HANDLE hInstance, int nCmdShow)
{
    HWND  hTTYWnd;
    char  appIdent[32];

#ifdef SDEBUG
    if (mswin_debug >= 5) 
	fprintf (mswin_debugfile, "InitInstance:::  entered, nCmdShow %d\n",
		nCmdShow);
#endif

    LoadString (hInstance, IDS_APPNAME, gszAppName, sizeof (gszAppName));

    /* create the TTY window */
    hTTYWnd = CreateWindow (gszTTYClass, gszAppName,
		       WS_OVERLAPPEDWINDOW | WS_VSCROLL,
		       CW_USEDEFAULT, CW_USEDEFAULT,
		       CW_USEDEFAULT, CW_USEDEFAULT,
		       HWND_DESKTOP, NULL, hInstance, NULL);
	       
    SetScrollRange (hTTYWnd, SB_VERT, 0, 1, FALSE);
    EnableScrollBar (hTTYWnd, SB_VERT, ESB_DISABLE_BOTH);
    SetScrollPos (hTTYWnd, SB_VERT, 0, FALSE);

    
    

    if (NULL == hTTYWnd) 
	    return (NULL);

    ghTTYWnd = hTTYWnd;

    ghNormalIcon = LoadIcon (hInstance, MAKEINTRESOURCE (PINEICON));
    ghNewMailIcon = LoadIcon (hInstance, MAKEINTRESOURCE (NEWMAILICON));

    ghCursorArrow = LoadCursor (NULL, IDC_ARROW);
    ghCursorBusy = LoadCursor (NULL, IDC_WAIT);
    ghCursorCurrent = ghCursorArrow;
    
    

    ShowWindow (hTTYWnd, nCmdShow);
    UpdateWindow (hTTYWnd);

    CQInit ();
    MQInit ();

    
    /*
     * Load a resource with the name of the application.  Compare to 
     * known applications to determine who we are running under.
     * currently, only differentiation is the WINSOCK blocking hook.
     */
    LoadString (hInstance, IDS_APPIDENT, appIdent, sizeof (appIdent));
    if (strcmp (appIdent, APP_PINE_IDENT) == 0) {
	gAppIdent = APP_PINE;
	gWSBlockingProc = MakeProcInstance ( (FARPROC) NoMsgsAreSent,
					      hInstance);
    }
    else if (strcmp (appIdent, APP_PICO_IDENT) == 0) 
	gAppIdent = APP_PICO;
    else
	gAppIdent = APP_UNKNOWN;


    return (hTTYWnd);
}


/*---------------------------------------------------------------------------
 *  void MakeArgv ()
 *
 *  Description:
 *	Build a standard C argc, argv pointers into the command line string.
 *
 *
 *  Parameters:
 *	cmdLine		- Command line.
 *	*argc		- Count of words.
 *	***argc		- Pointer to Pointer to array of pointers to 
 *			  characters.
 *
 *--------------------------------------------------------------------------*/
LOCAL void
MakeArgv (HINSTANCE hInstance, LPSTR cmdLine, int *pargc, char ***pargv)
{
    int			argc;
    char		**argv;
    LPSTR		c;
    BOOL		inWord;
    int			wordCount;
#define CMD_PATH_LEN    128
    char		*modPath;
    char		mpLen;
    

    /* Count words in cmdLine. */
    wordCount = 0;
    inWord = FALSE;
    for (c = cmdLine; *c != '\0'; ++c) {
	if (inWord) {
	    if (*c == ' ' || *c == '\t') 
		inWord = FALSE;
	}
	else {
	    if (*c != ' ' && *c != '\t') {
		inWord = TRUE;
		++wordCount;
	    }
        }
    }

    ++wordCount;				/* One for program name. */
    argv = (char **) MemAlloc (sizeof (char _far *) * (wordCount + 1));
    *pargv = argv;
    *pargc = wordCount;

    modPath = (char *) MemAlloc (CMD_PATH_LEN);
    mpLen = GetModuleFileName (hInstance, modPath, CMD_PATH_LEN);
    if (mpLen > 0) {
	*(modPath + mpLen) = '\0';
        *(argv++) = modPath;
    }
    else {
	MemFree (modPath);
	*(argv++) = "Pine/Pico";
    }
    
    /* Now break up command line. */
    inWord = FALSE;
    for (c = cmdLine; *c != '\0'; ++c) {
	if (inWord) {
	    if (*c == ' ' || *c == '\t') {
		inWord = FALSE;
		*c = '\0';
	    }
	}
	else {
	    if (*c != ' ' && *c != '\t') {
		inWord = TRUE;
		*(argv++) = c;
	    }
        }
    }

    *argv = NULL;			/* tie off argv */
}




/*---------------------------------------------------------------------------
 *  LRESULT FAR PASCAL __export PWndProc( HWND hWnd, UINT uMsg,
 *                                 WPARAM wParam, LPARAM lParam )
 *
 *  Description:
 *     This is the TTY Window Proc.  This handles ALL messages
 *     to the tty window.
 *
 *  Parameters:
 *     As documented for Window procedures.
 *
/*--------------------------------------------------------------------------*/

LRESULT FAR PASCAL __export 
PWndProc (HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
#ifdef CDEBUG
    if (mswin_debug > 12) {
        fprintf (mswin_debugfile, "PWndProc::  uMsg = 0x%x\n", uMsg);
	fflush (mswin_debugfile);
    }
#endif
    switch (uMsg) {
    case WM_CREATE:
	 MyTimerSet ();
         return (CreateTTYInfo (hWnd));

    case WM_COMMAND: 
	switch ((WORD) wParam) {

        case IDM_OPT_SETFONT:
	    SelectTTYFont (hWnd);
	    break ;
	    
	case IDM_OPT_FONTSAMEAS:
	    PrintFontSameAs (hWnd);
	    break;
	    
	case IDM_OPT_TOOLBAR:
	    TBToggle (hWnd);
	    break;
	    
	case IDM_OPT_TOOLBARPOS:
	    TBPosToggle (hWnd);
	    break;
	    
	case IDM_OPT_USEDIALOGS: {
	    PTTYINFO	pTTYInfo;
	    
	    gfUseDialogs = !gfUseDialogs;
	    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
	    if (pTTYInfo) 
		DidResize (pTTYInfo);
	    break;
            }

#ifdef ACCELERATORS
	case IDM_OPT_USEACCEL:
	    AccelCtl (hWnd, ACCEL_TOGGLE, TRUE);
	    break;
#endif	    
	    
	case IDM_OPT_SETPRINTFONT:
	    PrintFontSelect (hWnd);
	    break;

        case IDM_ABOUT:
            GoModalDialogBoxParam ( GET_HINST( hWnd ),
                                       MAKEINTRESOURCE( ABOUTDLGBOX ),
                                       hWnd,
                                       AboutDlgProc, (LPARAM) 0 ) ;
            break;
	
	case IDM_EDIT_CUT:
	    EditCut ();
	    break;
	    
	case IDM_EDIT_COPY:
	    EditCopy ();
	    break;
	    
	case IDM_EDIT_COPY_APPEND:
	    EditCopyAppend ();
	    break;
	    
	case IDM_EDIT_PASTE:
	    EditPaste ();
	    break;
	    
	case IDM_EDIT_CANCEL_PASTE:
	    EditCancelPaste ();
	    break;
	    
	case IDM_HELP:
	    ShowHelp ();
	    break;
	    
	    
#if 0	/* No exit menu item. */
        case IDM_EXIT:
            PostMessage( hWnd, WM_CLOSE, NULL, 0L ) ;
            break;
#endif
	default:
	    /* value falling within the menu item range are handled here. */
	    if (wParam >= KS_RANGESTART && wParam <= KS_RANGEEND){
		ProcessMenuItem (hWnd, wParam);
		break;
	    }
	    break;
        }
	break ;
	
    case WM_VSCROLL:
#ifdef	WIN32
	ScrollTTY (hWnd, LOWORD(wParam), HIWORD(wParam), (HWND) lParam);
#else
	ScrollTTY (hWnd, wParam, LOWORD (lParam), (HWND) HIWORD (lParam));
#endif
	break;

    case WM_ERASEBKGND:
	if (IsIconic (hWnd)) 
	    return (DefWindowProc (hWnd, WM_ICONERASEBKGND, wParam, lParam));
	else
	    EraseTTY (hWnd, (HDC) wParam);
	break;
	
    case WM_QUERYDRAGICON:
	return ((DWORD)ghNormalIcon);

    case WM_PAINT:
	PaintTTY (hWnd);
        break ;
	 
    case WM_GETMINMAXINFO:
	GetMinMaxInfoTTY (hWnd, (MINMAXINFO __far *)lParam);
	break;

    case WM_SIZE:
	SizeTTY (hWnd, wParam, HIWORD(lParam), LOWORD(lParam));
        break ;
	
    case WM_MOVE:
	MoveTTY (hWnd, (int) LOWORD(lParam), (int) HIWORD(lParam));
	break;
	
    case WM_WINDOWPOSCHANGING:
	/* Allows us to adjust new size of window. */
	AboutToSizeTTY (hWnd, (WINDOWPOS FAR *) lParam);
	break;
		 

    /*
     * WM_KEYDOWN is sent for every "key press" and reports on they
     * keyboard key, with out processing shift and control keys.
     * WM_CHAR is a synthetic event, created from KEYDOWN and KEYUP
     * events.  It includes processing or control and shift characters.
     * But does not get generated for extended keys suchs as arrow
     * keys. 
     * I'm going to try to use KEYDOWN for processing just extended keys
     * and let CHAR handle the the rest.
     *
     * The only key combo that is special is ^-space.  For that, I'll use
     * WM_KEYDOWN and WM_KEYUP to track the state of the control key.
     */
    case WM_CHAR:
        ProcessTTYCharacter (hWnd, LOBYTE (wParam), (DWORD)lParam);
        break ;
	 
    case WM_KEYDOWN:
	if (ProcessTTYKeyDown (hWnd, LOBYTE (wParam), (DWORD)lParam))
	    return (0);
        return( DefWindowProc( hWnd, uMsg, wParam, lParam ) ) ;

    case WM_KEYUP:
	if (ProcessTTYKeyUp (hWnd, LOBYTE (wParam), (DWORD)lParam))
	    return (0);
        return( DefWindowProc( hWnd, uMsg, wParam, lParam ) ) ;
	
	
    case WM_SYSCHAR:
	if (LOBYTE (wParam) == VK_F10) {
	    ProcessTTYCharacter (hWnd, LOBYTE (wParam), (DWORD)lParam);
	    return (0);
        }
        return( DefWindowProc( hWnd, uMsg, wParam, lParam ) ) ;
	    
    case WM_SYSKEYDOWN:
	if (LOBYTE (wParam) == VK_F10) 
	    if (ProcessTTYKeyDown (hWnd, LOBYTE (wParam), (DWORD)lParam))
		return (0);
        return( DefWindowProc( hWnd, uMsg, wParam, lParam ) ) ;

    case WM_SYSKEYUP:
	if (LOBYTE (wParam) == VK_F10) 
	    if (ProcessTTYKeyUp (hWnd, LOBYTE (wParam), (DWORD)lParam))
		return (0);
        return( DefWindowProc( hWnd, uMsg, wParam, lParam ) ) ;
	

    case WM_LBUTTONDOWN:
	ProcessTTYMouse (M_EVENT_DOWN, M_BUTTON_LEFT, LOWORD (lParam), 
			 HIWORD (lParam), wParam);
	break;

    case WM_LBUTTONUP:
	if (ProcessTTYMouse (M_EVENT_UP, M_BUTTON_LEFT, LOWORD (lParam),
			 HIWORD (lParam), wParam))
	    goto callDef;
	break;

    case WM_MBUTTONDOWN:
	ProcessTTYMouse (M_EVENT_DOWN, M_BUTTON_MIDDLE, LOWORD (lParam), 
		 HIWORD (lParam), wParam);
	break;

    case WM_MBUTTONUP:
	ProcessTTYMouse (M_EVENT_UP, M_BUTTON_MIDDLE, LOWORD (lParam), 
			 HIWORD (lParam), wParam);
	break;

    case WM_RBUTTONDOWN:
	ProcessTTYMouse (M_EVENT_DOWN, M_BUTTON_RIGHT, LOWORD (lParam), 
			 HIWORD (lParam), wParam);
	break;

    case WM_RBUTTONUP:
	ProcessTTYMouse (M_EVENT_UP, M_BUTTON_RIGHT, LOWORD (lParam), 
			 HIWORD (lParam), wParam);
	break;
	
    case WM_MOUSEMOVE:
	ProcessTTYMouse (M_EVENT_TRACK, 0, LOWORD (lParam), 
			HIWORD (lParam), wParam);
	break;


    case WM_SETFOCUS:
        SetTTYFocus (hWnd);
        break;

    case WM_KILLFOCUS:
        KillTTYFocus (hWnd);
        break;
	
    case WM_SETCURSOR:
	/* Set cursor.  If in client, leave as is.  Otherwise, pass to 
	 * DefWindow Proc */
	if (LOWORD(lParam) == HTCLIENT) {
	    SetCursor (ghCursorCurrent);
	    return (TRUE);
        }
        return( DefWindowProc( hWnd, uMsg, wParam, lParam ) ) ;

    case WM_INITMENU:
	UpdateMenu (hWnd);
	break;
	
    case WM_TIMER:
	/* Really just used so that we continue to receive messages even while
	 * in background.  Causes mswin_getc() to process message and return
	 * to caller so that it can get some periodic processing in. */
	ProcessTimer ();
	break;
	
    case WM_QUERYENDSESSION:
	/* Returns non-zero if I can exit, otherwize zero, and the end
	 * session operation stops. */
	return ((LRESULT)ConfirmExit ());
	
    case WM_ENDSESSION:
	/* Sent with wParam == TRUE when windows session is ending.
	 * (wParam == FALSE means session is not ending). */
	if (wParam == TRUE) 
	    ProcessOnExit ();
	break;

    case WM_DESTROY:
	KillTimer (hWnd, MY_TIMER_ID);
	DestroyTTYInfo (hWnd);
	PostQuitMessage (0);
	break;


    case WM_DROPFILES:
       if(ProcessTTYFileDrop((HANDLE) wParam))
	 return(0);

       break;


    case WM_CLOSE:
	/* If the quit menu is active then insert the quit command
	 * Otherwise, abort. */
	if (gpTTYInfo->menuItems[KS_EXIT - KS_RANGESTART].miActive) {
	    CQAdd (gpTTYInfo->menuItems[KS_EXIT - KS_RANGESTART].miKey, 0);
	}
	else if (gSignalHUP != SIG_DFL && gSignalHUP != SIG_IGN) {
	    if (MessageBox (hWnd, 
		  "Abort PINE/PICO, possibly losing current work?",
		  gszAppName, MB_OKCANCEL | MB_ICONQUESTION) == IDOK) 
		HUPDeliver ();
	}
	break;	    


    default:
callDef:	   
        return( DefWindowProc( hWnd, uMsg, wParam, lParam ) ) ;
    }
    return 0L ;

} // end of PWndProc()




/*---------------------------------------------------------------------------
 *  LRESULT NEAR CreateTTYInfo( HWND hWnd )
 *
 *  Description:
 *     Creates the tty information structure and sets
 *     menu option availability.  Returns -1 if unsuccessful.
 *
 *  Parameters:
 *     HWND  hWnd
 *        Handle to main window.
 *
 *-------------------------------------------------------------------------*/

LOCAL LRESULT NEAR 
CreateTTYInfo (HWND hWnd)
{
    HMENU		hMenu;
    PTTYINFO		pTTYInfo;
    LOGFONT		newFont;
    int			i;
    
#ifdef SDEBUG
    if (mswin_debug >= 5) 
	fprintf (mswin_debugfile, "CreateTTYInfo:::  entered\n");
#endif

    pTTYInfo = (PTTYINFO) MemAlloc (sizeof (TTYINFO));
    if (pTTYInfo == NULL)
	return ((LRESULT) - 1);
    gpTTYInfo = pTTYInfo;

    /* initialize TTY info structure */
    memset (pTTYInfo, 0, sizeof (TTYINFO));
    pTTYInfo->wCursorState		= CS_SHOW;/* Shown but not focused. */
    pTTYInfo->scrollRange		= 0;
    pTTYInfo->scrollPos			= 0;
    pTTYInfo->scrollTo			= 0;
    pTTYInfo->scrollScale		= 0.0;
    pTTYInfo->fMinimized		= FALSE;
    pTTYInfo->fFocused			= FALSE;
    pTTYInfo->fNewLine			= FALSE;
    pTTYInfo->fMassiveUpdate		= FALSE;
    pTTYInfo->fNewMailIcon		= FALSE;
    pTTYInfo->autoWrap			= WRAP_NO_SCROLL;
    pTTYInfo->writeAccumCount		= 0;
    pTTYInfo->actNRow			= 0;
    pTTYInfo->actNColumn		= 0;
    pTTYInfo->xSize			= 0;
    pTTYInfo->ySize			= 0;
    pTTYInfo->xScroll			= 0;
    pTTYInfo->yScroll			= 0;
    pTTYInfo->xOffset			= MARGINE_LEFT;
    pTTYInfo->yOffset			= MARGINE_TOP;
    pTTYInfo->nColumn			= 0;
    pTTYInfo->nRow			= 0;
    pTTYInfo->xChar			= 0;
    pTTYInfo->yChar			= 0;
    pTTYInfo->fDesiredSize		= FALSE;
    pTTYInfo->hTTYFont			= NULL;
    pTTYInfo->rgbFGColor		= GetSysColor (COLOR_WINDOWTEXT);
    pTTYInfo->rgbBGColor		= GetSysColor (COLOR_WINDOW);
    pTTYInfo->rgbRFGColor		= GetSysColor (COLOR_HIGHLIGHTTEXT);
    pTTYInfo->rgbRBGColor		= GetSysColor (COLOR_HIGHLIGHT);
    pTTYInfo->hTBWnd			= NULL;
    pTTYInfo->toolBarSize		= 0;
    pTTYInfo->toolBarTop		= TRUE;
    pTTYInfo->curToolBarID		= IDD_TOOLBAR;
    pTTYInfo->hTBWnd			= NULL;

    /* Clear menu item array. */
    pTTYInfo->curWinMenu = PINEMENU;
    for (i = 0; i < KS_COUNT; ++i) 
	pTTYInfo->menuItems[i].miActive = FALSE;
    pTTYInfo->menuItemsCurrent = FALSE;

    /* Clear resize callback procs. */
    for (i = 0; i < RESIZE_CALLBACK_ARRAY_SIZE; ++i) 
	pTTYInfo->resizer[i] = NULL;


    /* clear screen space */
    pTTYInfo->pScreen = NULL;
    pTTYInfo->pAttrib = NULL;

    /* setup default font information */

    newFont.lfHeight =         12;
    newFont.lfWidth =          0;
    newFont.lfEscapement =     0;
    newFont.lfOrientation =    0;
    newFont.lfWeight =         0;
    newFont.lfItalic =         0;
    newFont.lfUnderline =      0;
    newFont.lfStrikeOut =      0;
    newFont.lfCharSet =        OEM_CHARSET;
    newFont.lfOutPrecision =   OUT_DEFAULT_PRECIS;
    newFont.lfClipPrecision =  CLIP_DEFAULT_PRECIS;
    newFont.lfQuality =        DEFAULT_QUALITY;
    newFont.lfPitchAndFamily = FIXED_PITCH | FF_MODERN;
    newFont.lfFaceName[0] =    '\0';

    /* set TTYInfo handle before any further message processing. */

    SetWindowLong (hWnd, GWL_PTTYINFO, (LPARAM) pTTYInfo);

    /* reset the character information, etc. */

    ResetTTYFont (hWnd, pTTYInfo, &newFont);
    


    hMenu = GetMenu (hWnd);
    EnableMenuItem (hMenu, IDM_EDIT_CUT, MF_BYCOMMAND | MF_GRAYED);
    EnableMenuItem (hMenu, IDM_EDIT_COPY, MF_BYCOMMAND | MF_GRAYED);
    EnableMenuItem (hMenu, IDM_EDIT_COPY_APPEND, MF_BYCOMMAND | MF_GRAYED);
    EnableMenuItem (hMenu, IDM_EDIT_PASTE, MF_BYCOMMAND | MF_GRAYED);
    return ((LRESULT) TRUE);
}



/*---------------------------------------------------------------------------
 *  BOOL NEAR DestroyTTYInfo( HWND hWnd )
 *
 *  Description:
 *     Destroys block associated with TTY window handle.
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
 *-------------------------------------------------------------------------*/

LOCAL BOOL NEAR 
DestroyTTYInfo (HWND hWnd)
{
    PTTYINFO			pTTYInfo;

    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	return (FALSE);


    DeleteObject (pTTYInfo->hTTYFont);

    MemFree (pTTYInfo);
    return (TRUE);
}



/*---------------------------------------------------------------------------
 *  void  ResizeTTYScreen( HWND hWnd, PTTYINFO pTTYInfo, 
 *					int newNrow, int newNColumn);
 *
 *  Description:
 *		Resize the screen to new size, copying data.
 *
 *  Parameters:
 *     PTTYINFO  pTTYInfo
 *        pointer to TTY info structure
 *		newNCo.umn, newNRow
 *			new size of screen.
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL
ResizeTTYScreen (HWND hWnd, PTTYINFO pTTYInfo, int newNRow, int newNColumn)
{
    BYTE		*	pNewAttrib;
    CHAR		*	pNewScreen;
    void		*	source;
    void		*	dest;
    size_t			len;
    int				cells;
    int				r;
    extern TERM			term;

    
    if (newNColumn < MINNCOLUMN)
	    newNColumn = MINNCOLUMN;
    if (newNRow < MINNROW)
	    newNRow = MINNROW;

#ifdef SDEBUG
    if (mswin_debug >= 5) 
	fprintf (mswin_debugfile, "ResizeTTYScreen:::  entered, new row %d, col %d\n",
		newNRow, newNColumn);
#endif
    
	
    SelClear ();
    cells = newNColumn * newNRow;
    pNewScreen = (CHAR *)MemAlloc (cells * sizeof (CHAR));
    if (pNewScreen == NULL)
	return (FALSE);
    pNewAttrib = (CharAttrib *)MemAlloc (cells * sizeof (CharAttrib));
    if (pNewAttrib == NULL) {
	MemFree ((void *)pNewScreen);
	return (FALSE);
    }


    /* 
     * Clear new screen. 
     */

    assert (sizeof (CHAR) == 1);
    assert (sizeof (CharAttrib) == 1);
    memset ((void *)pNewScreen, ' ', cells);
    memset ((void *)pNewAttrib, 0, cells);


    /* 
     * Copy old screen onto new screen. 
     */
    if (pTTYInfo->pScreen != NULL) {

	for (r = 1; r <= newNRow && r <= pTTYInfo->actNRow; ++r) {

		
	    source = pTTYInfo->pScreen + ((pTTYInfo->actNRow - r) * 
						    pTTYInfo->actNColumn);
	    dest = pNewScreen + ((newNRow - r) * newNColumn);
	    len = MIN (newNColumn, pTTYInfo->actNColumn) * sizeof (CHAR);
	    memcpy (dest, source, len);

	    
	    source = pTTYInfo->pAttrib + ((pTTYInfo->actNRow - r) * 
						    pTTYInfo->actNColumn);
	    dest = pNewAttrib + ((newNRow - r) * newNColumn);
	    len = MIN (newNColumn, pTTYInfo->actNColumn) * sizeof(CharAttrib);
	    memcpy (dest, source, len);

	}
	pTTYInfo->nColumn = MIN (pTTYInfo->nColumn, newNColumn);
	pTTYInfo->nRow = MAX (0, 
			pTTYInfo->nRow + (newNRow - pTTYInfo->actNRow));
	MemFree (pTTYInfo->pScreen);
	MemFree (pTTYInfo->pAttrib);
    }
    else {
	pTTYInfo->nColumn = MIN (pTTYInfo->nColumn, newNColumn);
	pTTYInfo->nRow = MIN (pTTYInfo->nRow, newNRow);
    }
    pTTYInfo->pScreen = pNewScreen;
    pTTYInfo->pAttrib = pNewAttrib;
    pTTYInfo->actNColumn = newNColumn;
    pTTYInfo->actNRow = newNRow;
    
    
    /* Repaint whole screen. */
    pTTYInfo->screenDirty = TRUE;
    pTTYInfo->eraseScreen = TRUE;
    InvalidateRect (hWnd, NULL, FALSE);

    
    
    /* Pico specific. */
    if (term.t_nrow == 0) {
	term.t_nrow = newNRow - 1;
	term.t_ncol = newNColumn;
    }
    

    return (TRUE);
}
		
		




/*---------------------------------------------------------------------------
 *  BOOL  ResetTTYFont( HWND hWnd, PTTYINFO pTTYInfo, LOGFONT *newFont)
 *
 *  Description:
 *     Resets the TTY character information and causes the
 *     screen to resize to update the scroll information.
 *
 *  Parameters:
 *     PTTYINFO  pTTYInfo
 *        pointer to TTY info structure
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL  
ResetTTYFont (HWND hWnd, PTTYINFO pTTYInfo, LOGFONT *newFont)
{
    HDC			hDC;
    HFONT		hFont;
    TEXTMETRIC		tm;
    int			newNRow;
    int			newNColumn;
    BOOL		newsize;
    int			i;
/*	RECT		rcWindow;*/


#ifdef SDEBUG
    if (mswin_debug >= 5) 
	fprintf (mswin_debugfile, "ResetTTYFont:::  entered, curent window size X %d, Y %d\n",
		pTTYInfo->xSize, pTTYInfo->ySize);
#endif


    if (NULL == pTTYInfo)
	    return (FALSE);
    
    SelClear ();

    /*
     * Create new font.
     */
    hFont = CreateFontIndirect (newFont);
    if (hFont == NULL)
	    return (FALSE);
    hDC = GetDC (hWnd);
    SelectObject (hDC, hFont);
    GetTextMetrics (hDC, &tm);
    ReleaseDC (hWnd, hDC);

    
    /*
     * Replace old font.
     */
    if (NULL != pTTYInfo->hTTYFont)
	    DeleteObject (pTTYInfo->hTTYFont);
    pTTYInfo->hTTYFont = hFont;
    memcpy (&pTTYInfo->lfTTYFont, newFont, sizeof (LOGFONT));

    
    /* Update the char cell size. */
    pTTYInfo->xChar = tm.tmAveCharWidth;
    pTTYInfo->yChar = tm.tmHeight + tm.tmExternalLeading;

    /* Update the current number of rows and cols.  Don't allow
     * either to be less than zero. */
    newNRow = MAX (MINNROW, 
	    MIN (MAXNROW, 
		(pTTYInfo->ySize - pTTYInfo->toolBarSize - (2 * MARGINE_TOP))/
				pTTYInfo->yChar));
    newNColumn = MAX (MINNCOLUMN, 
	    MIN (MAXNCOLUMN, (pTTYInfo->xSize - (2 * pTTYInfo->xOffset))/
				    pTTYInfo->xChar));

    newsize = newNRow != pTTYInfo->actNRow || 
		    newNColumn != pTTYInfo->actNColumn;
    if (newsize)
	    ResizeTTYScreen (hWnd, pTTYInfo, newNRow, newNColumn);

    /* Resize the carrot as well. */
    if (pTTYInfo->wCursorState == CS_VISIBLE) {
	    HideCaret (hWnd);
	    DestroyCaret();
	    CreateCaret (hWnd, NULL, pTTYInfo->xChar, pTTYInfo->yChar);
	    SetCaretPos ((pTTYInfo->nColumn * pTTYInfo->xChar) + pTTYInfo->xOffset,
		    (pTTYInfo->nRow * pTTYInfo->yChar) + pTTYInfo->yOffset);
	    ShowCaret (hWnd);
    }

    /* Redraw screen and, if the "size" changed, tell the upper layers. */
    pTTYInfo->screenDirty = TRUE;
    pTTYInfo->eraseScreen = TRUE;
    InvalidateRect (hWnd, NULL, FALSE);

    /* Always call the resize functions - even if the screen size
     * has not changed, the font style may have. */
    DidResize (pTTYInfo);

    return (TRUE);
}



/*---------------------------------------------------------------------------
 *  BOOL  EraseTTY (HWND hWnd, HDC hDC)
 *
 *  Description:
 *     Erase the tty background.
 *     
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window (as always)
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL
EraseTTY (HWND hWnd, HDC hDC)
{
    RECT	erect;
    HBRUSH	hBrush;
    

    GetClientRect (hWnd, &erect);
    hBrush = CreateSolidBrush (gpTTYInfo->rgbBGColor);
    if (hBrush != NULL) {
	FillRect (hDC, &erect, hBrush);
	DeleteObject (hBrush);
    }
    return (TRUE);
}




/*---------------------------------------------------------------------------
 *  BOOL  PaintTTY( HWND hWnd )
 *
 *  Description:
 *     Paints the rectangle determined by the paint struct of
 *     the DC.
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window (as always)
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL
PaintTTY (HWND hWnd) 
{
    int          nRow, nCol;		/* Top right corner of update. */
    int		 nEndRow, nEndCol;	/* lower right corner of update. */
    int		 nCount;		/* Number of columns in each row. */
    int		 nHorzPos, nVertPos;	/* Position of each text write. */
    int		 col;			/* start col of run of similar attr */
    int		 count;			/* count of run of similar attrib. */
    int		 endCount;		/* How far to count. */
    CharAttrib	*pAttrib;
    HDC          hDC;
    HFONT        hOldFont;
    PTTYINFO    pTTYInfo;
    PAINTSTRUCT  ps;
    RECT         rect;
    RECT	 erect;
    HBRUSH	 hBrush;
    long	 offset;		/* Offset into screen and attrib */
    CharAttrib	 lastAttrib;		/* Attributes of last text write. */
    CharAttrib	 newAttrib;		/* Attributes of this text write. */


#ifdef CDEBUG
    if (mswin_debug >= 9) 
	fprintf (mswin_debugfile, "PaintTTY:::  entered\n");
#endif
    
    
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	return (FALSE);

    if (IsIconic (hWnd)) {
	int pmm;

	hDC = BeginPaint (hWnd, &ps);
	pmm = SetMapMode (hDC, MM_TEXT);
	if (pTTYInfo->fNewMailIcon && ghNewMailIcon != NULL) 
	    DrawIcon (hDC, 0, 0, ghNewMailIcon);
	else
	    DrawIcon (hDC, 0, 0, ghNormalIcon);
	SetMapMode (hDC, pmm);
	EndPaint (hWnd, &ps);
	return (TRUE);
    }
	    

    hDC = BeginPaint (hWnd, &ps);
    rect = ps.rcPaint;
    
    
    
    hOldFont = SelectObject (hDC, pTTYInfo->hTTYFont);
    SetTextColor (hDC, pTTYInfo->rgbFGColor);
    SetBkColor (hDC, pTTYInfo->rgbBGColor);
    SetBkMode (hDC, OPAQUE);

#if 0    
    nRow = min (pTTYInfo->actNRow - 1,
	   max (0, (rect.top - pTTYInfo->yOffset) / pTTYInfo->yChar));
#endif
    nRow = (rect.top - pTTYInfo->yOffset) / pTTYInfo->yChar;
    CONSTRAIN (nRow, 0, pTTYInfo->actNRow - 1);

    nEndRow = min (pTTYInfo->actNRow - 1,
	    ((rect.bottom - pTTYInfo->yOffset - 1) / pTTYInfo->yChar));
    nCol = min (pTTYInfo->actNColumn - 1,
	    max (0, (rect.left - pTTYInfo->xOffset) / pTTYInfo->xChar));
    nEndCol = min (pTTYInfo->actNColumn - 1,
	    ((rect.right - pTTYInfo->xOffset - 1) / pTTYInfo->xChar));

    nCount = nEndCol - nCol + 1;
    lastAttrib = CHAR_ATTR_NOT;
    
    
    /* Erase screen if necessary. */
    if (pTTYInfo->eraseScreen) {
	erect.top = 0;
	erect.left = 0;
	erect.bottom = pTTYInfo->ySize;
	erect.right = pTTYInfo->xSize;
	hBrush = CreateSolidBrush (pTTYInfo->rgbBGColor);
	if (hBrush != NULL) {
	    FillRect (hDC, &erect, hBrush);
	    DeleteObject (hBrush);
	}
	pTTYInfo->eraseScreen = FALSE;
    }
#if 0
    else {
	/* If not erasing entire screen, erase just the rect to be painted. */
	hBrush = CreateSolidBrush (pTTYInfo->rgbBGColor);
	if (hBrush != NULL) {
	    FillRect (hDC, &rect, hBrush);
	    DeleteObject (hBrush);
	}
	pTTYInfo->eraseScreen = FALSE;
    }
#endif


    /* Paint an inset frame around the text region. */
    if (gUse3DFrame) {
	/* Draw a inset 3d frame around the text area. */
	if (pTTYInfo->toolBarSize == 0) {
	    erect.top = 0;
	    erect.bottom = pTTYInfo->ySize;
	}
	else if (pTTYInfo->toolBarTop) {
		erect.top = pTTYInfo->toolBarSize;
		erect.bottom = pTTYInfo->ySize;
	    }
	    else {
		erect.top = 0;
		erect.bottom = pTTYInfo->ySize - pTTYInfo->toolBarSize;
	    }
	erect.left = 0;
	erect.right = pTTYInfo->xSize;
	FrameRect3D (hDC, &erect, FRAME_3D_SIZE, FALSE);
    }
    else {
	/* Draw a thin line separator between the tool bar and the
	 * text area. */
	if (pTTYInfo->toolBarSize > 0) {

	    nHorzPos = (pTTYInfo->toolBarTop ? pTTYInfo->toolBarSize :
			    pTTYInfo->ySize - pTTYInfo->toolBarSize - 1);
#ifdef	WIN32
	    MoveToEx (hDC, 0, nHorzPos, NULL);
#else
	    MoveTo (hDC, 0, nHorzPos);
#endif
	    LineTo (hDC, pTTYInfo->xSize, nHorzPos);
	}
    }
    

    
    
    
    /* Paint rows of text. */
    for (; nRow <= nEndRow; nRow++)    {
	nVertPos = (nRow * pTTYInfo->yChar) + pTTYInfo->yOffset;
	rect.top = nVertPos;
	rect.bottom = nVertPos + pTTYInfo->yChar;
	
	/* Paint runs of similar attributes. */
	col = nCol;				/* Start at left. */
	while (col <= nEndCol) {		/* While not past right. */

	    /* Starting with Character at nRow, col, what is its attribute? */
	    offset = (nRow * pTTYInfo->actNColumn) + col;
	    newAttrib = *(pTTYInfo->pAttrib + offset);
	    
	    if (newAttrib != lastAttrib) {
		/* Set new attributes.  If Reverse or Selected, then
		 * show in reverse colors.  But if neither, or both, then
		 * normal colors. */
		if (newAttrib > 0 && newAttrib 
			< (CHAR_ATTR_REV | CHAR_ATTR_SEL)) {
		    SetTextColor (hDC, pTTYInfo->rgbRFGColor);
		    SetBkColor (hDC, pTTYInfo->rgbRBGColor);
		}
		else {
		    SetTextColor (hDC, pTTYInfo->rgbFGColor);
		    SetBkColor (hDC, pTTYInfo->rgbBGColor);
		}
	    }
	    
	    /* Find run of similar attributes. */
	    count = 1;
	    pAttrib = pTTYInfo->pAttrib + offset + 1;
	    endCount = nEndCol - col;
	    while (count <= endCount && *pAttrib++ == newAttrib) 
		++count;
	
	    /* Paint run of characters from nRow, col to nRow, col + count 
	     * rect.top and rect.bottom have already been calculated. */
	    nHorzPos = (col * pTTYInfo->xChar) + pTTYInfo->xOffset;
	    rect.left = nHorzPos;
	    rect.right = nHorzPos + pTTYInfo->xChar * count;
	    ExtTextOut (hDC, nHorzPos, nVertPos, ETO_OPAQUE | ETO_CLIPPED, &rect,
		(LPSTR)(pTTYInfo->pScreen + offset),
		count, NULL);
	
	    /* Move pointer to end of this span of characters. */
	    col += count;
	    lastAttrib = newAttrib;
        }
    }

    SelectObject (hDC, hOldFont);
    EndPaint (hWnd, &ps);
    MoveTTYCursor (hWnd);
    pTTYInfo->screenDirty = FALSE;
    return (TRUE);
}






/* FillRectColor
 *
 *
 * Description:
 *		FillRectColor is similar to PatB in toolbar.c
 *
 *		Code based on MFC source code, so presumably efficient.
 *
 */
LOCAL void
FillRectColor(HDC hDC, RECT * pRC, COLORREF color)
{
    SetBkColor(hDC, color);
    ExtTextOut(hDC, 0, 0, ETO_OPAQUE, pRC, NULL, 0, NULL);
}


/** FrameRect3D
 *
 *
 * Inputs:
 *		hdc			- HDC
 *		pRC			- pointer to rectangle
 *		width		- width for frame (usually one)
 *		raised		- TRUE for raised effect, FALSE for sunken effect
 *
 * Outputs:
 *		none
 *
 * Returns:
 *		void
 *
 * Description
 *		Draws a frame with a 3D effect.
 *
 *		If 'raised' is true, the rectangle will look raised (like
 *		a button); otherwise, the rectangle will look sunk.
 *
 */
void 
FrameRect3D(HDC hdc, RECT * pRC, int width, BOOL raised)
{
    COLORREF	hilite, shadow;
    RECT		rcTemp;

    shadow		= GetSysColor(COLOR_BTNSHADOW);
    hilite		= GetSysColor(COLOR_BTNHIGHLIGHT);

    rcTemp		= *pRC;

    rcTemp.right	= rcTemp.left + width;
    FillRectColor(hdc, &rcTemp, raised ? hilite : shadow);
    rcTemp.right	= pRC->right;

    rcTemp.bottom	= rcTemp.top + width;
    FillRectColor(hdc, &rcTemp, raised ? hilite : shadow);
    rcTemp.bottom	= pRC->bottom;

    rcTemp.left		= rcTemp.right - width;
    FillRectColor(hdc, &rcTemp, raised ? shadow : hilite);
    rcTemp.left		= pRC->left;

    rcTemp.top		= rcTemp.bottom - width;
    FillRectColor(hdc, &rcTemp, raised ? shadow : hilite);
}



/*---------------------------------------------------------------------------
 *  BOOL  GetMinMaxInfoTTY (HWND hWnd, (MINMAXINFO __far *)lParam)
 *
 *  Description:
 *     Return the min and max size that the window can be.
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
 *     MINMAXINFO
 *	  Info structure that Windows would like us to fill.
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL  
GetMinMaxInfoTTY (HWND hWnd, MINMAXINFO __far *lpmmi)
{
    PTTYINFO		pTTYInfo;
    
    
#ifdef SDEBUG
    if (mswin_debug >= 5) 
	fprintf (mswin_debugfile, "GetMinMaxInfoTTY:::  entered\n");
#endif
    
    
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	return (FALSE);

    lpmmi->ptMaxTrackSize.x = lpmmi->ptMaxSize.x = MIN (lpmmi->ptMaxSize.x,
			    pTTYInfo->xChar * MAXNCOLUMN + WIN_X_BORDER_SIZE);
    lpmmi->ptMaxTrackSize.y = lpmmi->ptMaxSize.y = MIN (lpmmi->ptMaxSize.y, 
			    pTTYInfo->yChar * MAXNROW + WIN_Y_BORDER_SIZE);

    lpmmi->ptMinTrackSize.x = MAX (WIN_MIN_X_SIZE, 
		    pTTYInfo->xChar * MINNCOLUMN + WIN_X_BORDER_SIZE);
    lpmmi->ptMinTrackSize.y = MAX (WIN_MIN_Y_SIZE,
		    pTTYInfo->yChar * MINNROW + WIN_Y_BORDER_SIZE);
    return (TRUE);
}



/*---------------------------------------------------------------------------
 *  BOOL  AboutToSizeTTY (HWND hWnd, WINDOWPOS *winPos)
 *
 *  Description:
 *      Called just before Windows resizes our window.  We can change the
 *	values in 'winPos' to change the new size of the window.
 *
 *	If mswin_setwindow() was called when the window was minimized we
 *	set the new size here.
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
 *     WORD wVertSize
 *        new vertical size
 *
 *     WORD wHorzSize
 *        new horizontal size
 *
/*--------------------------------------------------------------------------*/
LOCAL BOOL  
AboutToSizeTTY (HWND hWnd, WINDOWPOS *winPos)
{
    PTTYINFO	pTTYInfo;

    
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	    return ( FALSE );

#ifdef SDEBUG
    if (mswin_debug >= 5) 
	fprintf (mswin_debugfile, "AboutToSizeTTY:::  After x%lx, pos %d, %d, size %d, %d, flags x%x\n", 
	    winPos->hwndInsertAfter, winPos->x, winPos->y, winPos->cx,
	    winPos->cy, winPos->flags);

#endif

    /*
     * Was the window minimized AND is there a desired new size for it?
     * AND is this a call that specifies a new size and position.
     */
    if (pTTYInfo->fMinimized && pTTYInfo->fDesiredSize &&
	    (winPos->flags & (SWP_NOSIZE | SWP_NOMOVE)) == 0) {
#ifdef SDEBUG
	if (mswin_debug >= 5) 
	    fprintf (mswin_debugfile, "AboutToSizeTTY:::  substitue pos (%d, %d), size (%d, %d)\n",
		    pTTYInfo->xDesPos, pTTYInfo->yDesPos,
		    pTTYInfo->xDesSize, pTTYInfo->yDesSize);
#endif
	pTTYInfo->fDesiredSize = FALSE;
	winPos->x = pTTYInfo->xDesPos;
	winPos->y = pTTYInfo->yDesPos;
	winPos->cx = pTTYInfo->xDesSize;
	winPos->cy = pTTYInfo->yDesSize;
    }
    return (TRUE);
}


/*---------------------------------------------------------------------------
 *  BOOL  SizeTTY( HWND hWnd, int fwSizeType, CORD wVertSize, 
 *					CORD wHorzSize)
 *
 *  Description:
 *     Sizes TTY and sets up scrolling regions.
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
 *     WORD wVertSize
 *        new vertical size
 *
 *     WORD wHorzSize
 *        new horizontal size
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL  
SizeTTY (HWND hWnd, int fwSizeType, CORD wVertSize, CORD wHorzSize)
{
/*  int		nScrollAmt ;*/
    PTTYINFO	pTTYInfo;
    int		newNColumn;
    int		newNRow;
    int		i;


#ifdef SDEBUG
    if (mswin_debug >= 5) 
	fprintf (mswin_debugfile, "SizeTTY:::  entered, sizeType %d, New screen size %d, %d pixels\n",
		fwSizeType, wHorzSize, wVertSize);
#endif

    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	    return ( FALSE );

    
    /*
     * Is the window being minimized?
     */
    pTTYInfo->fNewMailIcon = FALSE;
    if (fwSizeType == SIZE_MINIMIZED) {
	pTTYInfo->fMinimized = TRUE;
	return (TRUE);
    }
    
    pTTYInfo->fMinimized = FALSE;
	    
	    
    pTTYInfo->ySize = (int) wVertSize;
    newNRow = max (MINNROW, min (MAXNROW, 
	    (pTTYInfo->ySize - pTTYInfo->toolBarSize - (2 * MARGINE_TOP)) / 
				    pTTYInfo->yChar));
    if (pTTYInfo->toolBarTop)		    
	pTTYInfo->yOffset = MARGINE_TOP + pTTYInfo->toolBarSize;
    else
	pTTYInfo->yOffset = MARGINE_TOP;
	    

    pTTYInfo->xSize = (int) wHorzSize;
    newNColumn = max (MINNCOLUMN, 
		    min (MAXNCOLUMN, (pTTYInfo->xSize - (2 * MARGINE_LEFT)) / 
		    pTTYInfo->xChar));
    pTTYInfo->xOffset = MARGINE_LEFT;


    ResizeTTYScreen (hWnd, pTTYInfo, newNRow, newNColumn);
    pTTYInfo->screenDirty = TRUE;
    pTTYInfo->eraseScreen = TRUE;
    InvalidateRect (hWnd, NULL, FALSE);

    if (pTTYInfo->hTBWnd) {
	if (pTTYInfo->toolBarTop) 
	    /* Position at top of window. */
	    SetWindowPos (pTTYInfo->hTBWnd, HWND_TOP, 
		    0, 0, 
		    wHorzSize, pTTYInfo->toolBarSize, 
		    SWP_NOZORDER | SWP_NOACTIVATE | SWP_SHOWWINDOW);
	else
	    /* Position at bottom of window. */
	    SetWindowPos (pTTYInfo->hTBWnd, HWND_TOP, 
		    0, pTTYInfo->ySize - pTTYInfo->toolBarSize, 
		    wHorzSize, pTTYInfo->toolBarSize, 
		    SWP_NOZORDER | SWP_NOACTIVATE | SWP_SHOWWINDOW);
    }


    DidResize (pTTYInfo);

    return (TRUE);
}



/*---------------------------------------------------------------------------
 *  BOOL  MoveTTY (HWND hWnd, int xPos, int yPos)
 *
 *  Description:
 *     Notes the fact that the window has moved. 
 *     Only real purpose is so we can tell pine which can the write the
 *     new window position to the 'pinerc' file.
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
 *     int xPos, yPos
 *	  New position of the top left corner. 
 *
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL  
MoveTTY (HWND hWnd, int xPos, int yPos)
{
    int		i;
    
#ifdef SDEBUG
    if (mswin_debug >= 5) 
	fprintf (mswin_debugfile, "MoveTTY:::  entered\n");
#endif

    DidResize (gpTTYInfo);
    return (TRUE);
}



/*---------------------------------------------------------------------------
 *  void  ScrollTTY ()
 *
 *  Description:
 *      Respond to a scroll message by either calling the scroll
 *      callback or inserting a scroll character into the input
 *      stream.
 *
 *	Scrolling in the TTY window is complicated by the way pine
 *      process events.  Normal windows applications are entirly event
 *      driven.  The top level does nothing but dispatch events.  In
 *      pine, the top level implements the logic.  Events are only
 *      dispatched by the lowest levels.
 *
 *	In normal applications, mouse down in the scroll bar causes
 *	an internal scroll function to be entered.  It tracks the
 *	mouse and issues scroll messages as needed.  If the
 *	application redraws the screen the scroll function also
 *	dispatches the WM_PAINT message to the application.  The
 *	important thing is that this internal scroll function does
 *	not exit until the mouse is released.
 *
 *	We implement two methods for pine's screen managers to deal
 *	with scroll events.  They can receive scroll events as
 *	characters in the normal input stream or they can register a
 *	callback function.
 *
 *	In the "insert a character in the queue" mode, the scroll
 *	event never gets process until the mouse is release.  Auto
 *	repeat scroll events (generated as the mouse is held down)
 *	will cause multiple chars to be inserted in the queue, none
 *	of which will get processed till the mouse is release.  In a
 *	compromise, we allow only one scroll char in the queue,
 *	which prevents makes for a more friendly and controllable
 *	behavior.
 *
 *	In the callback mode, the callback repaints the screen, and
 *	then it calls mswin_flush() which PROCESSES EVENTS!  The
 *	Windows internal scroll function does NOT expect that.  This
 *	behavior can confuses the scroll function, causing it to
 *	miss mouse up events.  We avoid this by setting gScrolling TRUE
 *	when this routine is entered and FALSE when this routine exits
 *	All PeekMessage processors avoid processing any message when 
 *	gScrolling is TRUE.
 *
/*--------------------------------------------------------------------------*/

LOCAL void
ScrollTTY (HWND hWnd, int wScrollCode, int nPos, HWND hScroll)
{    
    PTTYINFO	pTTYInfo;
    POINT	pos;
    WORD	cmd;
    long	scroll_pos;
    int		hitCode;
    BOOL	noAction = FALSE;
    BOOL	didScroll;
    FARPROC	prevBlockingProc;
	    

    
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);

    if (pTTYInfo == NULL || gScrolling)
	return;

    gScrolling = TRUE;
    if (gWSBlockingProc != NULL) 
	prevBlockingProc = WSASetBlockingHook (gWSBlockingProc);
    
    
    
    
    switch (wScrollCode) {
    case SB_BOTTOM:
	cmd = MSWIN_KEY_SCROLLTO;
	scroll_pos = pTTYInfo->scrollTo = 0;
	break;
	
    case SB_TOP:
	cmd = MSWIN_KEY_SCROLLTO;
	scroll_pos = pTTYInfo->scrollTo = pTTYInfo->scrollRange;
	break;
	
    case SB_LINEDOWN:
	cmd = MSWIN_KEY_SCROLLDOWNLINE;
	scroll_pos = 1;
        break;

    case SB_LINEUP:
	cmd = MSWIN_KEY_SCROLLUPLINE;
	scroll_pos = 1;
        break;

    case SB_PAGEDOWN:
	cmd = MSWIN_KEY_SCROLLDOWNPAGE;
	scroll_pos = 1;
        break;

    case SB_PAGEUP:
	cmd = MSWIN_KEY_SCROLLUPPAGE;
	scroll_pos = 1;
        break;
	
    case SB_THUMBTRACK:
    case SB_THUMBPOSITION:
	cmd = MSWIN_KEY_SCROLLTO;
	scroll_pos = pTTYInfo->scrollTo = 
		        (long) ((float)nPos * pTTYInfo->scrollScale);
	break;

    default:
	noAction = TRUE;
	break;
    }

    
    /*
     * If there is a scroll callback call that.  If there is no scroll 
     * callback or the callback says it did not handle the event (returned,
     * FALSE) queue the scroll cmd.
     */
    if (!noAction) {
	SelClear ();
	didScroll = FALSE;
	if (gScrollCallback != NULL) {
	    /* Call scrolling callback.  Set blocking hook to our routine
	     * which prevents messages from being dispatched. */
	    if (gWSBlockingProc != NULL) 
		WSASetBlockingHook (gWSBlockingProc);
	    didScroll = gScrollCallback (cmd, scroll_pos);
	    if (gWSBlockingProc != NULL) 
		WSAUnhookBlockingHook ();
        }
	/*
	 * If no callback or callback did not do the scrolling operation,
	 * insert a scroll cmd in the input stream.
	 */
	if (!didScroll)
	    CQAddUniq (cmd, 0);
    }


    gScrolling = FALSE;
    return;
}



/*
 * This routine is inserted as the winsock blocking hook.  It's main perpos
 * is to NOT dispatch messages.
 */
/*BOOL CALLBACK __export  --  MSC 7.0 choked */
BOOL CALLBACK
NoMsgsAreSent (void)
{
    return (FALSE);
}



/*---------------------------------------------------------------------------
 *  BOOL  SetTTYFocus( HWND hWnd )
 *
 *  Description:
 *     Sets the focus to the TTY window also creates caret.
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL  
SetTTYFocus (HWND hWnd)
{
    PTTYINFO  pTTYInfo;

#ifdef SDEBUG
    if (mswin_debug >= 5) 
	fprintf (mswin_debugfile, "SetTTYFocus:::  entered\n");
#endif

    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	    return (FALSE);

    pTTYInfo->fFocused = TRUE;
    pTTYInfo->wCursorState |= CS_FOCUSED;
    gKeyControlDown = FALSE;

    if (pTTYInfo->wCursorState == CS_VISIBLE) {
	    CreateCaret (hWnd, NULL, pTTYInfo->xChar, pTTYInfo->yChar);
	    ShowCaret (hWnd);
    }

    MoveTTYCursor (hWnd);
    return (TRUE);
}




/*---------------------------------------------------------------------------
 *  BOOL  KillTTYFocus( HWND hWnd )
 *
 *  Description:
 *     Kills TTY focus and destroys the caret.
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL  
KillTTYFocus (HWND hWnd)
{
    PTTYINFO  pTTYInfo;

#ifdef SDEBUG
    if (mswin_debug >= 5) 
	fprintf (mswin_debugfile, "KillTTYFocus:::  entered\n");
#endif
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	    return (FALSE);

    if (pTTYInfo->wCursorState == CS_VISIBLE) {
	    HideCaret (hWnd);
	    DestroyCaret();
    }

    pTTYInfo->wCursorState &= ~CS_FOCUSED;
    pTTYInfo->fFocused = FALSE;
    gKeyControlDown = FALSE;

    return (TRUE);
}




/*---------------------------------------------------------------------------
 *  BOOL  MoveTTYCursor( HWND hWnd )
 *
 *  Description:
 *     Moves caret to current position.
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL  
MoveTTYCursor (HWND hWnd)
{
    PTTYINFO  pTTYInfo;

    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	    return (FALSE);

    if (pTTYInfo->wCursorState == CS_VISIBLE && 
	    !pTTYInfo->fMassiveUpdate) {
	HideCaret (hWnd);
	SetCaretPos ((pTTYInfo->nColumn * pTTYInfo->xChar) + pTTYInfo->xOffset,
		(pTTYInfo->nRow * pTTYInfo->yChar) + pTTYInfo->yOffset);
	ShowCaret (hWnd);
    }

    return (TRUE);
}




/*---------------------------------------------------------------------------
 *  BOOL  ProcessTTYKeyDown ( HWND hWnd, WORD bOut, DWORD keyData )
 *
 *  Description:
 *	Called to process MW_KEYDOWN message.  We are only interested in 
 *	virtual keys that pico/pine use.  All others get passed on to 
 *	the default message handler.  Regular key presses will return 
 *	latter as a WM_CHAR message, with SHIFT and CONTROL processing
 *	already done.
 *
 *	We do watch for VK_CONTROL to keep track of it's state such
 *	that we can implement ^_space.
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
 *     BYTE key
 *	  Virtual key code.
 *
 *     DWORD keyData
 *	  Additional flags passed in lParam for WM_KEYDOWN
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL  
ProcessTTYKeyDown (HWND hWnd, WORD key, DWORD keyData)
{
    WORD		myKey;
    
    
    if (key == VK_CONTROL) 
	gKeyControlDown = TRUE;

    /* Special keys. */
    if (keyData & 0X20000000)
	return (FALSE);			/* Message NOT handled. */

    switch (key) {
	case VK_UP:		myKey = MSWIN_KEY_UP;		break;
	case VK_DOWN:		myKey = MSWIN_KEY_DOWN;		break;
	case VK_RIGHT:		myKey = MSWIN_KEY_RIGHT;	break;
	case VK_LEFT:		myKey = MSWIN_KEY_LEFT;		break;
	case VK_PRIOR:		myKey = MSWIN_KEY_PREVPAGE;	break;
	case VK_NEXT:		myKey = MSWIN_KEY_NEXTPAGE;	break;
	case VK_HOME:		myKey = MSWIN_KEY_HOME;		break;
	case VK_END:		myKey = MSWIN_KEY_END;		break;
	case VK_DELETE:		myKey = MSWIN_KEY_DELETE;	break;
	case VK_F1:		myKey = MSWIN_KEY_F1;		break;
	case VK_F2:		myKey = MSWIN_KEY_F2;		break;
	case VK_F3:		myKey = MSWIN_KEY_F3;		break;
	case VK_F4:		myKey = MSWIN_KEY_F4;		break;
	case VK_F5:		myKey = MSWIN_KEY_F5;		break;
	case VK_F6:		myKey = MSWIN_KEY_F6;		break;
	case VK_F7:		myKey = MSWIN_KEY_F7;		break;
	case VK_F8:		myKey = MSWIN_KEY_F8;		break;
	case VK_F9:		myKey = MSWIN_KEY_F9;		break;
	case VK_F10:		myKey = MSWIN_KEY_F10;		break;
	case VK_F11:		myKey = MSWIN_KEY_F11;		break;
	case VK_F12:		myKey = MSWIN_KEY_F12;		break;
	
#if 0		
	/* Control is special - I keep track, but do not claim to handle. */
	case VK_CONTROL:	gKeyControlDown = TRUE;
				return (FALSE);
#endif
	case '6':
	    /*
	     * Ctrl-^ is used to set and clear the mark in the
	     * composer (pico) On most other systems Ctrl-6 does the
	     * same thing.  Allow that on windows too.  If we detect
	     * '6' key down while the control key is pressed we then
	     * insert a ctrl-^ character.  Position of the shift key
	     * is not checked so this code handles both combinations.
	     * There is one more trick: ctrl-shift-6 will result in a
	     * WM_CHAR message for 0x1e.  But that will be a
	     * duplicate control character because this code already
	     * generated a control character.  So, in ProcessTTYChar
	     * is ignore the 0x1e characters.
	     */
	    if (gKeyControlDown) 
		myKey = 0x1e;
	    else
		return (FALSE);
	    break;
	default:		return (FALSE);	/* Message NOT handled.*/
    }

    CQAdd (myKey, 0);
    return (TRUE);			/* Message handled .*/
}



/*---------------------------------------------------------------------------
 *  BOOL  ProcessTTYKeyUp ( HWND hWnd, WORD bOut, DWORD keyData )
 *
 *  Description:
 *	Called to process MW_KEYDOWN message. 
 *	Used only to detect when the control key goes up.
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
 *     BYTE key
 *	  Virtual key code.
 *
 *     DWORD keyData
 *	  Additional flags passed in lParam for WM_KEYDOWN
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL  
ProcessTTYKeyUp (HWND hWnd, WORD key, DWORD keyData)
{
    WORD		myKey;
    
    
    if (key == VK_CONTROL) 
	gKeyControlDown = FALSE;

#if 0
    /* Special keys. */
    if (keyData & 0X20000000)
	return (FALSE);			/* Message NOT handled. */
#endif
				
    return (FALSE);	/* Message NOT handled.*/
}




/*---------------------------------------------------------------------------
 *  BOOL  ProcessTTYCharacter( HWND hWnd, WORD bOut, DWORD keyData )
 *
 *  Description:
 *		Place the character into a queue.
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
 *     BYTE bOut
 *        byte from keyboard
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL  
ProcessTTYCharacter (HWND hWnd, WORD bOut, DWORD keyData)
{

    /*
     * Map Ctrl-space to the null character.  Window's does not do
     * this for us.
     */
    if (bOut == ' ' && gKeyControlDown)
	bOut = '\0';

    /*
     * This is the second half of the code to handle ctrl-6 and
     * ctrl-shift-6 (ctrl-^).  Here, we ignore the WM_CHAR message
     * generated by ctrl-shift-6.
     */
    if (bOut == 0x1e)
	return (TRUE);
    CQAdd (bOut, keyData);
    return (TRUE);		/* Message handled. */
}





/*---------------------------------------------------------------------------
 *  BOOL  ProcessTTYMouse(int mevent, int button, int xPos, int yPos, 
 *				WPARAM keys)
 *
 *  Description:
 *	This is the central control for all mouse events.  Every event
 *	gets put into a queue to wait for the upper layer.  
 * 
 *	The upper's input routine calls checkmouse() which pulls the
 *	mouse event off the input queue.  checkmouse() has a list of
 *	of screen regions.  Some regions correspond to a "menu" item
 *	(text button at bottom of screen).  There is generally one
 *	region for the central region of the screen.
 *
 *	Because pine/pico do not interpret mouse drags, we do that here.
 *	When the user presses the button and drags the mouse across the
 *	screen this select the text in the region defined by the drag.
 *	The operation is local to mswin.c, and can only get what text
 *	is on the screen.
 *
 *	The one exception is that now pico interprets mouse drag events
 *	in the body.  pico signals that it wants to track the mouse
 *	by calling mswin_allowmousetrack().  This will 1) turn off
 *	our mouse tracking and 2) cause mouse movement events to 
 *	be put on the mouse queue.
 *
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
 *     BYTE bOut
 *        byte from keyboard
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL  
ProcessTTYMouse (int mevent, int button, CORD xPos, CORD yPos, WPARAM winkeys)
{
    int		nRow;
    int		nColumn;
    int		keys;

    /* 
     * Convert to cell position.
     */
    nColumn = (xPos - gpTTYInfo->xOffset) / gpTTYInfo->xChar;
    if (xPos < gpTTYInfo->xOffset)
	--nColumn;
    nRow = (yPos - gpTTYInfo->yOffset) / gpTTYInfo->yChar;
    if (yPos < gpTTYInfo->yOffset)
	--nRow;
#if 0
    nColumn = max (0, nColumn);
    nColumn = min (gpTTYInfo->actNColumn-1, nColumn);
    nRow = max (0, nRow);
    nRow = min (gpTTYInfo->actNRow-1, nRow);
#endif

    /*
     * Convert window's keys. 
     */
    keys = 0;
    if (winkeys & MK_CONTROL)
	    keys |= M_KEY_CONTROL;
    if (winkeys & MK_SHIFT)
	    keys |= M_KEY_SHIFT;

    
    /* 
     * Tracking event or mouse up/down?
     */
    if (mevent != M_EVENT_TRACK) {

	/*
	 * Tracking.  Only start tracking mouse down in the text region
	 * But allow mouse up anywhere. 
	 */
	if ( (nRow >= 0 && nRow < gpTTYInfo->actNRow &&
	      nColumn >= 0 && nColumn < gpTTYInfo->actNColumn)
	    || mevent == M_EVENT_UP) {
	    /*
	     * Insert event into queue.
	     */
	    MQAdd (mevent, button, nRow, nColumn, keys, 0);


	    /*
	     * Mouse tracking.  When the mouse goes down we start
	     * capturing all mouse movement events.  If no one else wants
	     * them we will start defining a text selection.
	     */
	    if (mevent == M_EVENT_DOWN) {
		gMouseTracking = TRUE;
		SetCapture (ghTTYWnd);
		if (!gAllowMouseTrack && button == M_BUTTON_LEFT)
		    SelStart (nRow, nColumn);
	    }
	    else {
		ReleaseCapture ();
		if (!gAllowMouseTrack && button == M_BUTTON_LEFT)
		    SelFinish (nRow, nColumn);
		gMouseTracking = FALSE;
	    }
        }
    }
    else {
	/*
	 * Who is doing the tracking?
	 */
	if (gAllowMouseTrack) {
	    /* For tracking, Button info is different. */
	    if (keys & MK_LBUTTON) 
		button = M_BUTTON_LEFT;
	    else if (keys & MK_MBUTTON) 
		button = M_BUTTON_MIDDLE;
	    else if (keys & MK_RBUTTON) 
		button = M_BUTTON_RIGHT;
	    MQAdd (mevent, button, nRow, nColumn, keys, 
		    MSWIN_MF_REPLACING);
        }
	else 
	    SelTrackMouse (nRow, nColumn);
    }

    return (0);		/* Message handled. */
}




/*---------------------------------------------------------------------------
 *  BOOL  ProcessTimer ()
 *
 *  Description:
 *     Process the periodic timer calls.
 *     
 *
 *  Parameters:
 *	None.
 *
/*--------------------------------------------------------------------------*/
LOCAL void
ProcessTimer (void)
{
    /* Check the OnTaskList. */
    if (gOnTaskList != NULL)
	ProcessOnTask ();

    /* Time to deliver an alarm signal? */
    if (gAlarmTimeout != 0 && GetTickCount () / 1000 > gAlarmTimeout)
	AlarmDeliver ();

    /* Time to make the periodic callback. */
    if (gPeriodicCallback != NULL && 
	    GetTickCount() / 1000 > gPeriodicCBTimeout) {
	gPeriodicCBTimeout = GetTickCount() / 1000 + 
						gPeriodicCBTime;
	gPeriodicCallback ();
    }
    
    /* 
     * If tracking the mouse, insert a fake mouse tracking message
     * At the last know location of the mouse.
     */
    if (gAllowMouseTrack) {
	gMTEvent.event = M_EVENT_TRACK;
	MQAdd (gMTEvent.event, gMTEvent.button, gMTEvent.nRow, 
		gMTEvent.nColumn, gMTEvent.keys, MSWIN_MF_REPLACING);
    }
}


/*---------------------------------------------------------------------------
 *  BOOL  WriteTTYBlock( HWND hWnd, LPSTR lpBlock, int nLength )
 *
 *  Description:
 *     Writes block to TTY screen.  Nothing fancy - just
 *     straight TTY.
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
 *     LPSTR lpBlock
 *        far pointer to block of data
 *
 *     int nLength
 *        length of block
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL  
WriteTTYBlock (HWND hWnd, LPSTR lpBlock, int nLength)
{
    int				i;
    PTTYINFO			pTTYInfo;
    RECT			rect;
    BOOL			fNewLine;
    long			offset;

    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	    return (FALSE);

    for (i = 0 ; i < nLength; i++) {
	switch (lpBlock[i]) {
	case ASCII_BEL:
	    // Bell
	    MessageBeep (0) ;
	    break ;

	case ASCII_BS:
	    // Backspace
	    if (pTTYInfo->nColumn > 0)
		    --pTTYInfo->nColumn;
	    MoveTTYCursor (hWnd);
	    break;

	case ASCII_CR:
	    // Carriage return
	    pTTYInfo->nColumn = 0 ;
	    MoveTTYCursor (hWnd);
	    if (!pTTYInfo->fNewLine)
		    break;

	    // fall through

	case ASCII_LF:
	    // Line feed
	    if (++pTTYInfo->nRow == pTTYInfo->actNRow) {
		/* Scroll the Screen. */
		memmove ((LPSTR)pTTYInfo->pScreen,
			(LPSTR) (pTTYInfo->pScreen + pTTYInfo->actNColumn),
			((pTTYInfo->actNRow - 1) * pTTYInfo->actNColumn) *
				sizeof (CHAR));
		assert (sizeof (CHAR) == 1);
		memset ((LPSTR) (pTTYInfo->pScreen + 
			    (pTTYInfo->actNRow - 1) * pTTYInfo->actNColumn),
			' ', pTTYInfo->actNColumn);

		/* Scroll the Attributes. */
		memmove ((LPSTR)pTTYInfo->pAttrib,
			(LPSTR) (pTTYInfo->pAttrib + pTTYInfo->actNColumn),
			((pTTYInfo->actNRow - 1) * pTTYInfo->actNColumn) *
				sizeof (CharAttrib));
		assert (sizeof (CharAttrib) == 1);
		memset ((LPSTR) (pTTYInfo->pScreen + 
			    (pTTYInfo->actNRow - 1) * pTTYInfo->actNColumn),
			0, pTTYInfo->actNColumn);


		pTTYInfo->screenDirty = TRUE;
		pTTYInfo->eraseScreen = TRUE;
		InvalidateRect (hWnd, NULL, FALSE);
		--pTTYInfo->nRow;
	    }
	    MoveTTYCursor (hWnd);
	    break;



	default:
	    offset = (pTTYInfo->nRow * pTTYInfo->actNColumn) +
		    pTTYInfo->nColumn;
	    *(pTTYInfo->pScreen + offset) = lpBlock[i];
	    *(pTTYInfo->pAttrib + offset) = pTTYInfo->curAttrib;
	    rect.left = (pTTYInfo->nColumn * pTTYInfo->xChar) +
		    pTTYInfo->xOffset;
	    rect.right = rect.left + pTTYInfo->xChar;
	    rect.top = (pTTYInfo->nRow * pTTYInfo->yChar) +
		    pTTYInfo->yOffset;
	    rect.bottom = rect.top + pTTYInfo->yChar;
	    pTTYInfo->screenDirty = TRUE;
	    InvalidateRect (hWnd, &rect, FALSE);

	    /* Line Wrap. */
	    if (pTTYInfo->nColumn < pTTYInfo->actNColumn - 1)
		    pTTYInfo->nColumn++ ;
	    else if (pTTYInfo->autoWrap == WRAP_ON || 
		    (pTTYInfo->autoWrap == WRAP_NO_SCROLL && 
			    pTTYInfo->nRow < pTTYInfo->actNRow - 1)) {
		    fNewLine = pTTYInfo->fNewLine;
		    pTTYInfo->fNewLine = FALSE;
		    WriteTTYBlock (hWnd, "\r\n", 2);
		    pTTYInfo->fNewLine = fNewLine;
	    }
	    break;
	}
    }
    return (TRUE);
}




/*---------------------------------------------------------------------------
 *  BOOL  WriteTTYText ( HWND hWnd, LPSTR lpBlock, int nLength )
 *
 *  Description:
 *	Like WriteTTYBlock but optimized for strings that are text only,
 *	no carrage control characters. 
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
 *     LPSTR lpBlock
 *        far pointer to block of data
 *
 *     int nLength
 *        length of block
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL  
WriteTTYText (HWND hWnd, LPSTR lpText, int nLength)
{
    int				i;
    PTTYINFO			pTTYInfo;
    RECT			rect;
    BOOL			fNewLine;
    long			offset, endOffset;
    long			colEnd;
    long			screenEnd;
    BOOL			wraper;

    
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	    return ( FALSE );

    
    /* Calculate offset of cursor, end of current column, and end of screen */
    offset = (pTTYInfo->nRow * pTTYInfo->actNColumn) + pTTYInfo->nColumn;
    colEnd = (pTTYInfo->nRow + 1) * pTTYInfo->actNColumn;
    screenEnd = pTTYInfo->actNRow * pTTYInfo->actNColumn;
    
    
    /* Text is allowed to wrap around to subsequent lines, but not past end
     * of screen */
    endOffset = offset + nLength;
    if (endOffset >= screenEnd) {
	nLength = screenEnd - offset;
	endOffset = offset + nLength - 1;  /* Last cell, not one past last */
    }


    /* Calculate bounding rectangle. */
    if (endOffset <= colEnd) {
	/* Single line. */
	rect.left = (pTTYInfo->nColumn * pTTYInfo->xChar) + pTTYInfo->xOffset;
	rect.right = rect.left + (pTTYInfo->xChar * nLength);
	rect.top = (pTTYInfo->nRow * pTTYInfo->yChar) + pTTYInfo->yOffset;
	rect.bottom = rect.top + pTTYInfo->yChar;
	/* Advance cursor on cur line but not past end. */
	pTTYInfo->nColumn = min (pTTYInfo->nColumn + nLength, 
				pTTYInfo->actNColumn - 1);
    }
    else {
	/* Wraps across multiple lines.  Calculate one rect to cover all 
	 * lines. */
	rect.left = 0;
	rect.right = pTTYInfo->xSize;
	rect.top = (pTTYInfo->nRow * pTTYInfo->yChar) + pTTYInfo->yOffset;
	rect.bottom = ((((offset + nLength) / pTTYInfo->actNColumn) + 1) * 
			pTTYInfo->yChar) + pTTYInfo->yOffset;
	pTTYInfo->nRow = endOffset / pTTYInfo->actNColumn;
	pTTYInfo->nColumn = endOffset % pTTYInfo->actNColumn;
    }
    
    
    /* Apply text and attributes to screen in one smooth motion. */
    memcpy (pTTYInfo->pScreen + offset, lpText, nLength);
    memset (pTTYInfo->pAttrib + offset, pTTYInfo->curAttrib, nLength);



    /* Invalidate rectangle */
    pTTYInfo->screenDirty = TRUE;
    InvalidateRect (hWnd, &rect, FALSE);
    return (TRUE);
}


/*---------------------------------------------------------------------------
 *  BOOL  WriteTTYChar (HWND hWnd, char ch)
 *
 *  Description:
 *	Write a single character to the cursor position and advance the
 *	cursor.  Does not handle carage control.
 *
 *  Parameters:
 *     HWND hWnd
 *        handle to TTY window
 *
 *     char ch
 *	  character being written.
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL  
WriteTTYChar (HWND hWnd, char ch)
{
    int				i;
    PTTYINFO			pTTYInfo;
    RECT			rect;
    BOOL			fNewLine;
    long			offset;
    long			colEnd;
    long			screenEnd;

    
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	return (FALSE);

    offset = (pTTYInfo->nRow * pTTYInfo->actNColumn) +
	    pTTYInfo->nColumn;
    
    *(pTTYInfo->pScreen + offset) = ch;
    *(pTTYInfo->pAttrib + offset) = pTTYInfo->curAttrib;

    rect.left = (pTTYInfo->nColumn * pTTYInfo->xChar) + pTTYInfo->xOffset;
    rect.right = rect.left + pTTYInfo->xChar;
    rect.top = (pTTYInfo->nRow * pTTYInfo->yChar) + pTTYInfo->yOffset;
    rect.bottom = rect.top + pTTYInfo->yChar;
    pTTYInfo->screenDirty = TRUE;
    InvalidateRect (hWnd, &rect, FALSE);
    
    

    /* Line Wrap. */
    if (pTTYInfo->nColumn < pTTYInfo->actNColumn - 1)
	pTTYInfo->nColumn++ ;
    else if ((pTTYInfo->autoWrap == WRAP_ON || 
	      pTTYInfo->autoWrap == WRAP_NO_SCROLL) && 
		    pTTYInfo->nRow < pTTYInfo->actNRow - 1) {
       pTTYInfo->nRow++;
       pTTYInfo->nColumn = 0;
    }
    return (TRUE);
}

/*---------------------------------------------------------------------------
 *  VOID  GoModalDialogBoxParam( HINSTANCE hInstance,
 *                                   LPCSTR lpszTemplate, HWND hWnd,
 *                                   DLGPROC lpDlgProc, LPARAM lParam )
 *
 *  Description:
 *     It is a simple utility function that simply performs the
 *     MPI and invokes the dialog box with a DWORD paramter.
 *
 *  Parameters:
 *     similar to that of DialogBoxParam() with the exception
 *     that the lpDlgProc is not a procedure instance
 *
/*--------------------------------------------------------------------------*/

LOCAL VOID  
GoModalDialogBoxParam( HINSTANCE hInstance, LPCSTR lpszTemplate,
                                 HWND hWnd, DLGPROC lpDlgProc, LPARAM lParam )
{
   DLGPROC  lpProcInstance ;

   lpProcInstance = (DLGPROC) MakeProcInstance( (FARPROC) lpDlgProc,
                                                hInstance ) ;
   DialogBoxParam( hInstance, lpszTemplate, hWnd, lpProcInstance, lParam ) ;
   FreeProcInstance( (FARPROC) lpProcInstance ) ;
}





/*---------------------------------------------------------------------------
 *  BOOL FAR PASCAL __export AboutDlgProc( HWND hDlg, UINT uMsg,
 *                                WPARAM wParam, LPARAM lParam )
 *
 *  Description:
 *     Simulates the Windows System Dialog Box.
 *
 *  Parameters:
 *     Same as standard dialog procedures.
 *
/*--------------------------------------------------------------------------*/

BOOL FAR PASCAL __export 
AboutDlgProc (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
   switch (uMsg) {
      case WM_INITDIALOG:
      {
         int          idModeString ;
         char         szTemp [81];
         DWORD        dwFreeMemory, dwWinFlags ;
         WORD         wFreeResources, wRevision, wVersion ;

#ifdef ABOUTDLG_USEBITMAP
         // if we are using the bitmap, hide the icon

         ShowWindow( GetDlgItem( hDlg, IDD_ABOUTICON ), SW_HIDE ) ;
#endif
         // sets up the version number for Windows

         wVersion = LOWORD (GetVersion());
         switch (HIBYTE (wVersion)) {
            case 10:
               wRevision = 1;
               break;

            default:
               wRevision = 0;
               break;
         }
         wVersion &= 0xFF;

	 
         /* sets up version number for PINE */

         GetDlgItemText (hDlg, IDD_VERSION, szTemp, sizeof (szTemp));
         wsprintf (TempBuf, szTemp, mswin_majorver(), mswin_minorver(),
		   mswin_compilation_date());
         SetDlgItemText (hDlg, IDD_VERSION, (LPSTR) TempBuf);

         // get by-line

         LoadString (GET_HINST (hDlg), IDS_BYLINE, TempBuf,
                     sizeof (TempBuf));
         SetDlgItemText (hDlg, IDD_BYLINE, TempBuf);

      }
      return ( TRUE ) ;

#ifdef ABOUTDLG_USEBITMAP
      // used to paint the bitmap

      case WM_PAINT:
      {
         HBITMAP      hBitMap ;
         HDC          hDC, hMemDC ;
         PAINTSTRUCT  ps ;

         // load bitmap and display it

         hDC = BeginPaint( hDlg, &ps ) ;
         if (NULL != (hMemDC = CreateCompatibleDC( hDC )))
         {
            hBitMap = LoadBitmap( GET_HINST( hDlg ),
                                  MAKEINTRESOURCE( PINEBITMAP ) ) ;
            hBitMap = SelectObject( hMemDC, hBitMap ) ;
            BitBlt( hDC, 10, 10, 64, 64, hMemDC, 0, 0, SRCCOPY ) ;
            DeleteObject( SelectObject( hMemDC, hBitMap ) ) ;
            DeleteDC( hMemDC ) ;
         }
         EndPaint( hDlg, &ps ) ;
      }
      break ;
#endif

      case WM_COMMAND:
         if ((WORD) wParam == IDD_OK)
         {
            EndDialog( hDlg, TRUE ) ;
            return ( TRUE ) ;
         }
         break;
   }
   return ( FALSE ) ;

} // end of AboutDlgProc()









/*---------------------------------------------------------------------------
 *  BOOL  SelectTTYFont( HWND hDlg )
 *
 *  Description:
 *     Selects the current font for the TTY screen.
 *     Uses the Common Dialog ChooseFont() API.
 *
 *  Parameters:
 *     HWND hDlg
 *        handle to settings dialog
 *
/*--------------------------------------------------------------------------*/

BOOL  
LOCAL SelectTTYFont (HWND hWnd)
{
    CHOOSEFONT		cfTTYFont;
    LOGFONT		newFont;
    PTTYINFO		pTTYInfo;

    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	return (FALSE);

    memcpy (&newFont, &gpTTYInfo->lfTTYFont, sizeof (LOGFONT));

    cfTTYFont.lStructSize    = sizeof (CHOOSEFONT);
    cfTTYFont.hwndOwner      = hWnd ;
    cfTTYFont.hDC            = NULL ;
    cfTTYFont.rgbColors      = pTTYInfo->rgbFGColor;
    cfTTYFont.lpLogFont      = &newFont;
    cfTTYFont.Flags          = CF_SCREENFONTS | CF_FIXEDPITCHONLY |
	    CF_EFFECTS | CF_INITTOLOGFONTSTRUCT | CF_ANSIONLY | 
	    CF_FORCEFONTEXIST | CF_LIMITSIZE;
    cfTTYFont.nSizeMin	     = FONT_MIN_SIZE;
    cfTTYFont.nSizeMax	     = FONT_MAX_SIZE;
    cfTTYFont.lCustData      = (long) 0 ;
    cfTTYFont.lpfnHook       = NULL ;
    cfTTYFont.lpTemplateName = NULL ;
    cfTTYFont.hInstance      = GET_HINST (hWnd);



    if (ChooseFont (&cfTTYFont)) {
	pTTYInfo->rgbFGColor = cfTTYFont.rgbColors;
	ResetTTYFont (hWnd, pTTYInfo, &newFont);
    }

    return (TRUE);
}



/*
 * Set a specific color (forground, background, reverse, normal) to
 * the color specified by name. 
 */
LOCAL void
SetColorAttribute (COLORREF *cf, char *colorName)
{
    MSWINColor		*ct;
    int			i;
    
    for (ct = MSWINColorTable; ct->colorName != NULL; ++ct) {
	if (strcmpi (colorName, ct->colorName) == 0) goto FoundColor;
    }
    
    /* color name not in table.  Try converting RGB string. */
    ConvertRGBString (colorName, cf);
    return;
    
FoundColor:
    *cf = ct->colorRef;

    /* Redraw screen. */
    gpTTYInfo->screenDirty = TRUE;
    gpTTYInfo->eraseScreen = TRUE;
    InvalidateRect (ghTTYWnd, NULL, FALSE);
}



/*
 * Convert a string to an integer.
 */
LOCAL BOOL
ScanInt (char *str, int min, int max, int *val)
{
    char	*c;
    int		v;
    int		neg = 1;
    
    
    if (str == NULL) return (FALSE);
    if (*str == '\0' || strlen (str) > 9) return (FALSE);

    /* Check for a negative sign. */
    if (*str == '-') {
	neg = -1;
	++str;
    }

    /* Check for all digits. */
    for (c = str; *c != '\0'; ++c) {
	if (!isdigit((unsigned char)*c))
	    return (FALSE);
    }

    /* Convert from ascii to int. */
    v = atoi (str) * neg;

    /* Check constraints. */
    if (v < min || v > max) 
	return (FALSE);
    *val = v;
    return (TRUE);
}



/*
 * Convert a RGB string to a color ref.  The string should look like:
 *    rrr,ggg,bbb
 * where rrr, ggg, and bbb are numbers between 0 and 255 that represent
 * red, gree, and blue values.  Must be comma seperated.
 * Returns:
 *	TRUE	- Successfully converted string.
 *	FALSE	- Bad format, 'cf' unchanged.
 */

LOCAL BOOL
ConvertRGBString (char *colorName, COLORREF *cf)
{
    int		cv;
    char	*c;
    char	*s;
    char	*p;
    char	cpy[16];
    int		rgb[3];
   
    /* Some basic tests. */
    if (colorName == NULL) return (FALSE);		/* Not Null? */
    if (strlen (colorName) > 11) return (FALSE);	/* Not too long? */
    for (s = colorName; *s != '\0'; ++s) {
	if (!isdigit ((unsigned char)*s) && *s != ',')	/* Valid characters?*/
	  return (FALSE);
    }
    
    /* Work with a copy of string. */
    strcpy (cpy, colorName);
    s = cpy;				/* Start at beginning. */
    for (cv = 0; cv < 3; ++cv) {	/* Get three digits. */
	if (cv < 2) {			/* Expect only two commas. */
	    c = strchr (s, ',');		/* Find next comma. */
	    if (c == NULL) return (FALSE);
	    *c = '\0';
	}
	if (*s == ',' || *s == '\0') return (FALSE);
	if (strlen (s) > 3) return (FALSE);
	rgb[cv] = atoi (s);
	if (rgb[cv] < 0 || rgb[cv] > 255) return (FALSE);
	s = c + 1;
    }

    *cf = RGB (rgb[0], rgb[1], rgb[2]);
    printf ("%d, %d, %d  ", rgb[0], rgb[1], rgb[2]);
    return (TRUE);
}




/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *                  Toolbar setup routines.
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

LOCAL void
TBToggle (HWND hWnd)
{
    PTTYINFO		pTTYInfo;

    
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	return;

    if (pTTYInfo->toolBarSize > 0) 
	TBHide (hWnd);
    else
	TBShow (hWnd);
}



LOCAL void
TBPosToggle (HWND hWnd)
{
    PTTYINFO		pTTYInfo;
    RECT		rc;

    
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	return;

    pTTYInfo->toolBarTop = !pTTYInfo->toolBarTop;
    
    GetClientRect (hWnd, &rc);			/* Get TTY window size. */
    SizeTTY (hWnd, 0, (CORD)rc.bottom, (CORD)rc.right);
}




LOCAL void
TBShow (HWND hWnd)
{
    PTTYINFO		pTTYInfo;
    RECT		rc;

    
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	return;

    
    /*
     * Make sure the tool bar not already shown.
     */
    if (pTTYInfo->toolBarSize > 0)
	return;



    /*
     * Make procinstance for dialog funciton.
     */
    HideCaret (hWnd);
    if (gToolBarProc == NULL) 
	gToolBarProc = (DLGPROC) MakeProcInstance( (FARPROC) ToolBarProc,
                                                ghInstance ) ;
    if (gTBBtnProc == NULL) 
	gTBBtnProc = (WNDPROC) MakeProcInstance( (FARPROC) TBBtnProc,
						ghInstance ) ;

	
    /*
     * Create the dialog box.
     */
    pTTYInfo->hTBWnd = CreateDialog (ghInstance,
		    MAKEINTRESOURCE (pTTYInfo->curToolBarID),
		    hWnd,
		    gToolBarProc);
    if (pTTYInfo->hTBWnd == NULL) {
	ShowCaret (hWnd);
	return;
    }

    SetFocus (hWnd);


    /*
     * Adjust the window size.
     */
    GetWindowRect (pTTYInfo->hTBWnd, &rc);	/* Get Toolbar size. */
    pTTYInfo->toolBarSize = rc.bottom - rc.top;

    GetClientRect (hWnd, &rc);			/* Get TTY window size. */
    SizeTTY (hWnd, 0, (CORD)rc.bottom, (CORD)rc.right);
    ShowCaret (hWnd);
}




LOCAL void
TBHide (HWND hWnd)
{
    PTTYINFO		pTTYInfo;
    RECT		rc;
    
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	return;


    if (pTTYInfo->toolBarSize == 0)
	return;

    DestroyWindow (pTTYInfo->hTBWnd);
    pTTYInfo->hTBWnd = NULL;
    if (pTTYInfo->toolBarBtns != NULL) 
	MemFree (pTTYInfo->toolBarBtns);
    pTTYInfo->toolBarBtns = NULL;

    
    /*
     * Adjust the window size.
     */
    pTTYInfo->toolBarSize = 0;
    GetClientRect (hWnd, &rc);
    SizeTTY (hWnd, 0, (CORD)rc.bottom, (CORD)rc.right);
}



LOCAL void
TBSwap (HWND hWnd, int newID)
{
    PTTYINFO		pTTYInfo;
    RECT		rc;
    
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	return;

    if (pTTYInfo->toolBarSize == 0 || pTTYInfo->curToolBarID == newID)
	return;

    /*
     * Dispose of old tool bar window.
     */
    HideCaret (hWnd);

    DestroyWindow (pTTYInfo->hTBWnd);
    pTTYInfo->hTBWnd = NULL;
    if (pTTYInfo->toolBarBtns != NULL) 
	MemFree (pTTYInfo->toolBarBtns);
    pTTYInfo->toolBarBtns = NULL;
    
    

    /*
     * Create the new dialog box.
     */
    pTTYInfo->hTBWnd = CreateDialog (ghInstance,
		    MAKEINTRESOURCE (newID),
		    hWnd,
		    gToolBarProc);
    if (pTTYInfo->hTBWnd == NULL) {
	ShowCaret (hWnd);
	return;
    }
    pTTYInfo->curToolBarID = newID;
    SetFocus (hWnd);		/* Return focus to parent. */

    
    /*
     * Fit new tool bar into old tool bars position.  This assumes that
     * all tool bars are about the same height.
     */
    GetClientRect (hWnd, &rc);			/* Get TTY window size. */
    if (pTTYInfo->toolBarTop) 
	/* Position at top of window. */
	SetWindowPos (pTTYInfo->hTBWnd, HWND_TOP, 
		0, 0, 
		rc.right, pTTYInfo->toolBarSize, 
		SWP_NOZORDER | SWP_NOACTIVATE | SWP_SHOWWINDOW);
    else
	/* Position at bottom of window. */
	SetWindowPos (pTTYInfo->hTBWnd, HWND_TOP, 
		0, pTTYInfo->ySize - pTTYInfo->toolBarSize, 
		rc.right, pTTYInfo->toolBarSize, 
		SWP_NOZORDER | SWP_NOACTIVATE | SWP_SHOWWINDOW);
    
    ShowCaret (hWnd);
}

    



BOOL FAR PASCAL __export 
ToolBarProc (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    RECT		rc;
    BOOL		ret;
    int			height;
    HBRUSH		hBrush;
    HWND		hCld;
    int			btnCount;
    int			i;
    PTTYINFO		pTTYInfo;
    
    
    pTTYInfo = gpTTYInfo;
    
    ret = FALSE;
    switch (msg) {
	    
    case WM_INITDIALOG:
	/* Fit dialog to window. */
	GetWindowRect (hWnd, &rc);
	height = rc.bottom - rc.top;
	GetClientRect (GetParent (hWnd), &rc);
	SetWindowPos (hWnd, HWND_TOP, 0, 0, rc.right, height, 
			SWP_NOZORDER | SWP_NOACTIVATE);

	/* Count child windows.*/
	btnCount = 0;
	for (hCld = GetWindow (hWnd, GW_CHILD); 
	     hCld; 
	     hCld = GetWindow (hCld, GW_HWNDNEXT))
		++btnCount;

	/* Allocate a list of previous child procs. */
	if (pTTYInfo->toolBarBtns != NULL)
	    MemFree (pTTYInfo->toolBarBtns);
	pTTYInfo->toolBarBtns = MemAlloc (sizeof (BtnList) * (btnCount + 1));
	
	/* Subclass all child windows. */
	for (i = 0, hCld = GetWindow (hWnd, GW_CHILD); 
	    hCld; 
	    ++i, hCld = GetWindow (hCld, GW_HWNDNEXT)) {
	    pTTYInfo->toolBarBtns[i].wndID = GET_ID (hCld);
	    pTTYInfo->toolBarBtns[i].wndProc = (WNDPROC) GetWindowLong (hCld, 
						    GWL_WNDPROC);
	    SetWindowLong (hCld, GWL_WNDPROC, (DWORD)TBBtnProc);
        }
        pTTYInfo->toolBarBtns[i].wndID = 0;
	pTTYInfo->toolBarBtns[i].wndProc = NULL;

	ret = FALSE;
	break;
	

    case WM_COMMAND:
	if (wParam >= KS_RANGESTART && wParam <= KS_RANGEEND){
	    ProcessMenuItem (GetParent (hWnd), wParam);
	    /* Set input focus back to parent. */
	    SetFocus (GetParent (hWnd));
	    ret = TRUE;
	    break;
	}
	break;

#ifdef	WIN32
    case WM_CTLCOLORBTN:
#else
    case WM_CTLCOLOR:
#endif
	if (HIWORD (lParam) == CTLCOLOR_DLG) {
	    hBrush = CreateSolidBrush (GetSysColor (COLOR_ACTIVEBORDER));
	    return ((BOOL) hBrush);
        }
    }
    return (ret);
}





/*
 * Subclass toolbar button windows.
 *
 * These buttons will automatically return the input focus to 
 * the toolbar's parent
 */
LRESULT FAR PASCAL __export
TBBtnProc (HWND hBtn, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    PTTYINFO		pTTYInfo;
    HWND		hPrnt;
    int			i;
    WORD		id;
    LRESULT		ret;
    WNDPROC		wndProc;
    
    
    /*
     * Find previous window proc.
     */
    pTTYInfo = gpTTYInfo;
    id = GET_ID (hBtn);
    for (i = 0; pTTYInfo->toolBarBtns[i].wndID != 0; ++i)
	if (pTTYInfo->toolBarBtns[i].wndID == id)
	    goto FoundWindow;
    /* Whoops!  Didn't find window, don't know how to pass message. */
    return (0);
    
    
FoundWindow:
    wndProc = pTTYInfo->toolBarBtns[i].wndProc;
     
    

    if (uMsg == WM_LBUTTONUP || uMsg == WM_MBUTTONUP || uMsg == WM_RBUTTONUP) {
	/*
	 * On mouse button up restore input focus to IDC_RESPONCE, which
	 * processes keyboard input.
	 */
	ret = CallWindowProc (wndProc, hBtn, uMsg, wParam, lParam);
	hPrnt = GetParent (GetParent (hBtn));
	if (hPrnt)
	    SetFocus (hPrnt);
	return (ret);
    }
    
    return (CallWindowProc (wndProc, hBtn, uMsg, wParam, lParam));
}


#ifdef ACCELERATORS
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *      Accelorator key routines.
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
LOCAL void
AccelCtl (HWND hWnd, int ctl, BOOL saveChange)
{
    PTTYINFO		pTTYInfo;
    BOOL		load, changed;
    
    
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	return;

    load = FALSE;
    if (ctl == ACCEL_LOAD) {
	load = TRUE;
    }
    else if (ctl == ACCEL_TOGGLE) {
	load = pTTYInfo->hAccel == NULL;
    }
    
    
    changed = FALSE;
    if (load && pTTYInfo->hAccel == NULL) {
	/* Load em up. */
	pTTYInfo->hAccel = LoadAccelerators (ghInstance, 
					MAKEINTRESOURCE (IDR_ACCEL_PINE));
	changed = TRUE;
    }
    else {
	/* unload em. */
	FreeResource (pTTYInfo->hAccel);    
	pTTYInfo->hAccel = NULL;
	changed = TRUE;
    }
    
    if (changed && saveChange) 
	DidResize (pTTYInfo);
}
#endif		



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *                  Mouse Selection routines
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

LOCAL BOOL	SelSelected = FALSE;
LOCAL BOOL	SelTracking = FALSE;
LOCAL int	SelAnchorRow;
LOCAL int	SelAnchorCol;
LOCAL int	SelPointerRow;
LOCAL int	SelPointerCol;
typedef struct {
    CHAR	*pRow;
    int		len;
} CopyRow;

LOCAL void
SelRSet (int oStart, int oEnd)
{
    CharAttrib	*pca;
    
    for (pca = gpTTYInfo->pAttrib + oStart; oStart < oEnd; ++pca, ++oStart)
	*pca |= CHAR_ATTR_SEL;
}


LOCAL void
SelRClear (int oStart, int oEnd)
{
    CharAttrib	*pca;
    
    for (pca = gpTTYInfo->pAttrib + oStart; oStart < oEnd; ++pca, ++oStart)
	*pca &= ~CHAR_ATTR_SEL;
}


LOCAL void
SelRInvalidate (int oStart, int oEnd)
{
    RECT	rect;
    int		sRow, sCol;
    int		eRow, eCol;
    
    sRow = oStart / gpTTYInfo->actNColumn;
    sCol = oStart % gpTTYInfo->actNColumn;
    eRow = oEnd   / gpTTYInfo->actNColumn;
    eCol = oEnd   % gpTTYInfo->actNColumn;
    
    rect.top = (sRow * gpTTYInfo->yChar) + gpTTYInfo->yOffset;
    rect.bottom = ((eRow+1) * gpTTYInfo->yChar) + gpTTYInfo->yOffset;
    if (sRow == eRow) {
	rect.left = (sCol * gpTTYInfo->xChar) + gpTTYInfo->xOffset;
	rect.right = ((eCol+1) * gpTTYInfo->xChar) + gpTTYInfo->xOffset;
    } else {
	rect.left = gpTTYInfo->xOffset;
	rect.right = (gpTTYInfo->actNColumn * gpTTYInfo->xChar) + 
			gpTTYInfo->xOffset;
    }
    InvalidateRect (ghTTYWnd, &rect, FALSE);
}



/*
 * Start a mouse selection.
 */
LOCAL void
SelStart (int nRow, int nColumn)
{
    SelClear ();
    SelTracking = TRUE;
    SelSelected = TRUE;
    SelPointerRow = SelAnchorRow = nRow;
    SelPointerCol = SelAnchorCol = nColumn;
    return;
}


/*
 * Finish a mouse selection.
 */
LOCAL void
SelFinish (int nRow, int nColumn)
{
    if (nRow == SelAnchorRow && nColumn == SelAnchorCol) {
	/* Mouse up in same place it went down - no selection. */
	SelClear ();
    }
    else {
	/* Update screen selection and set final position of mouse
	 * then turn of mouse tracking.  Selection remains in effect
	 * until SelClear is called. */
	SelTrackMouse (nRow, nColumn);
	SelTracking = FALSE;
    }
}

LOCAL void
SelClear (void)
{
    int		a, p;
    int		s, e;
    CharAttrib	*pca;

    
    if (!SelSelected) 
	return;


    /* Convert the anchor and point coordinates to offsets then
     * order the offsets. */
    a = (SelAnchorRow * gpTTYInfo->actNColumn) + SelAnchorCol;
    p = (SelPointerRow * gpTTYInfo->actNColumn) + SelPointerCol;
    if (a < p) {
	s = a;
	e = p;
    } else {
	s = p;
	e = a;
    }

    /* Clear selected attribute of those cells in range. */
    SelRClear (s, e);
    SelRInvalidate (s, e);
    SelSelected = FALSE;
    SelTracking = FALSE;
}


/*
 * Update the position of the mouse point.
 */
LOCAL void
SelTrackXYMouse (int xPos, int yPos)
{
    int		nRow;
    int		nColumn;
    
    nColumn = (xPos - gpTTYInfo->xOffset) / gpTTYInfo->xChar;
    nRow = (yPos - gpTTYInfo->yOffset) / gpTTYInfo->yChar;

    SelTrackMouse (nRow, nColumn);
}


/*
 * Update the position of the mouse point.
 */
LOCAL void
SelTrackMouse (int nRow, int nColumn)
{
    int		a, p, n;
    int		s, e;
    
    if (!SelTracking)
	return;

    /* Constrain the cel position to be on the screen.  But allow
     * for the Column to be one past the right edge of the screen so
     * the user can select the right most cel of a row. */
    nColumn = max (0, nColumn);
    nColumn = min (gpTTYInfo->actNColumn, nColumn);
    nRow = max (0, nRow);
    nRow = min (gpTTYInfo->actNRow-1, nRow);


    /* Convert the anchor, previous mouse position, and new mouse
     * position to offsets. */
    a = (SelAnchorRow * gpTTYInfo->actNColumn) + SelAnchorCol;
    p = (SelPointerRow * gpTTYInfo->actNColumn) + SelPointerCol;
    n = (nRow * gpTTYInfo->actNColumn) + nColumn;
    
    /* If previous position same as current position, do nothing. */
    if (p == n)
	return;

    /* there are six possible orderings of the points, each with
     * a different action:
     *	order		clear		set		redraw
     *	n p a				n - p		n - p
     *	p n a		p - n				p - n
     *	p a n		p - a		a - n		p - n
     *	a p n				p - n		p - n
     *  a n p		n - p				n - p
     *  n a p		a - p		n - a		n - p
     */
    if (p < a) {
	if (n < a) {
	    if (n < p) {
		SelRSet (n, p);
		SelRInvalidate (n, p);
	    } else {
		SelRClear (p, n);
		SelRInvalidate (p, n);
	    }
	} else {
	    SelRClear (p, a);
	    SelRSet (a, n);
	    SelRInvalidate (p, n);
        }
    } else {
	if (n > a) {
	    if (n > p) {
		SelRSet (p, n);
		SelRInvalidate (p, n);
	    } else {
		SelRClear (n, p);
		SelRInvalidate (n, p);
	    }
	} else {
	    SelRClear (a, p);
	    SelRSet (n, a);
	    SelRInvalidate (n, p);
        }
    }

    /* Set new pointer. */
    SelPointerRow = nRow;
    SelPointerCol = nColumn;
}



LOCAL BOOL
SelAvailable (void)
{
    return (SelSelected);
}

/*
 * Copy screen data to clipboard.  Actually appends data from screen to 
 * existing handle so as we can implement a "Copy Append" to append to
 * existing clipboard data.  
 *
 * The screen does not have real line terminators.  We decide where the 
 * actual screen data ends by scanning the line (row) from end backwards
 * to find the first non-space.
 * 
 * I don't know how many bytes of data I'll be appending to the clipboard.
 * So I implemented in two passes.  The first finds all the row starts
 * and length while the second copies the data.
 */

LOCAL void
SelDoCopy (HANDLE hCB, DWORD lenCB)
{
    HANDLE		newCB;		/* Used in reallocation. */
    CHAR		*pCB;		/* Points to CB data. */	
    CHAR		*p2;		/* Temp pointer to screen data. */
    int			sRow, eRow;	/* Start and End Rows. */
    int			sCol, eCol;	/* Start and End columns. */
    int			row, c1, c2;	/* temp row and column indexes. */
    int			totalLen;	/* total len of new data. */
    CopyRow		*rowTable, *rp;	/* pointers to table of rows. */
    BOOL		noLastCRLF;
    

    if (OpenClipboard (ghTTYWnd)) {		/* ...and we get the CB. */
      if (EmptyClipboard ()) {		/* ...and clear previous CB.*/


	/* Find the start and end row and column. */
	if ( (SelAnchorRow * gpTTYInfo->actNColumn) + SelAnchorCol < 
	     (SelPointerRow * gpTTYInfo->actNColumn) + SelPointerCol) {
	    sRow = SelAnchorRow;
	    sCol = SelAnchorCol;
	    eRow = SelPointerRow;
	    eCol = SelPointerCol;
	}
	else {
	    sRow = SelPointerRow;
	    sCol = SelPointerCol;
	    eRow = SelAnchorRow;
	    eCol = SelAnchorCol;
	}

	/* Allocate a table in which we store info on rows. */
	rowTable = (CopyRow *) MemAlloc (sizeof (CopyRow) * (eRow-sRow+1));
	if (rowTable == NULL)
	    goto Fail1;

	/* Find the start and length of each row. */
	totalLen = 0;
	for (row = sRow, rp = rowTable; row <= eRow; ++row, ++rp) {
	    /* Find beginning and end columns, which depends on if
	     * this is the first or last row in the selection. */
	    c1 = (row == sRow ? sCol : 0);
	    c2 = (row == eRow ? eCol : gpTTYInfo->actNColumn);

	    /* Calculate pointer to beginning of this line. */
	    rp->pRow = gpTTYInfo->pScreen + 
		    ((row * gpTTYInfo->actNColumn) + c1);

	    /* Back down from end column to find first non space. 
	     * noLastCRLF indicates if it looks like the selection
	     * should include a CRLF on the end of the line.  It
	     * gets set for each line, but only the setting for the
	     * last line in the selection is remembered (which is all
	     * we're interested in). */
	    p2 = gpTTYInfo->pScreen + 
		    ((row * gpTTYInfo->actNColumn) + c2);
	    noLastCRLF = TRUE;
	    while (c2 > c1) {
		if (*(p2-1) != ' ')
		    break;
		noLastCRLF = FALSE;
		--c2;
		--p2;
	    }

	    /* Calculate size of line, then increment totalLen plus 2 for
	     * the CRLF which will terminate each line. */
	    rp->len = c2 - c1;
	    totalLen += rp->len + 2;
	}

	/* Reallocate the memory block.  Add one byte for null terminator. */
	newCB = GlobalReAlloc (hCB, lenCB + totalLen + 1, 0);
	if (newCB == NULL)
	    goto Fail2;
	hCB = newCB;

	pCB = GlobalLock (hCB);
	if (pCB == NULL)
	    goto Fail2;

	/* Append each of the rows, deliminated by a CRLF. */
	pCB += lenCB;
	for (row = sRow, rp = rowTable; row <= eRow; ++row, ++rp) {
	    if (rp->len > 0) {
		memcpy (pCB, rp->pRow, rp->len);
		pCB += rp->len;
	    }
	    if (row < eRow || !noLastCRLF) {
		*pCB++ = ASCII_CR;
		*pCB++ = ASCII_LF;
	    }
	}
	*pCB = '\0';			/* Null terminator. */
	MemFree (rowTable);
	GlobalUnlock (hCB);

	/* Attempt to pass the data to the clipboard, then release clipboard
	 * and exit function. */
	if (SetClipboardData (CF_TEXT, hCB) == NULL)
		      /* Failed!  Free the data. */
		      GlobalFree (hCB);
	CloseClipboard ();
      }
    }
    return;
    
    
	/* Error exit. */
Fail2:	MemFree (rowTable);
Fail1:	GlobalFree (hCB);
	CloseClipboard ();
	return;
}




    

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *                  Upper Layer Screen routines.
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*
 * Flush the write accumulator buffer.
 */
LOCAL void
FlushWriteAccum (void)
{
    if (gpTTYInfo->writeAccumCount > 0) {
	WriteTTYText (ghTTYWnd, gpTTYInfo->writeAccum, 
					gpTTYInfo->writeAccumCount);
	gpTTYInfo->writeAccumCount = 0;
    }
}



/*
 * Return the application instance.
 */
WINHAND
mswin_gethinstance ()
{
    return ((WINHAND)ghInstance);
}


WINHAND
mswin_gethwnd ()
{
    return ((WINHAND)ghTTYWnd);
}



/*
 *	Called to get mouse event.
 */
int
mswin_getmouseevent (MEvent * pMouse)
{
	return (MQGet (pMouse));
}


/*
 * Set up debugging stuff.
 */
mswin_setdebug (int debug, FILE *debugfile)
{
    /* Accept new file only if we don't already have a file. */
    if (mswin_debugfile == 0) {
	mswin_debug = debug;
	mswin_debugfile = debugfile;
	MemDebug (debug, mswin_debugfile);
    }
}



/*
 * Event handler to deal with File Drop events
 */
LOCAL BOOL  
ProcessTTYFileDrop (HANDLE wDrop)
{
    HDROP hDrop = wDrop;
    POINT pos;
    int   col, row, i, n;
    char  fname[1024];

    if(!gpTTYInfo->dndhandler)
      return(0);

    /* translate drop point to character cell */
    DragQueryPoint(hDrop, &pos);
    col = (pos.x - gpTTYInfo->xOffset) / gpTTYInfo->xChar;
    if (pos.x < gpTTYInfo->xOffset)
	--col;
    row = (pos.y - gpTTYInfo->yOffset) / gpTTYInfo->yChar;
    if (pos.y < gpTTYInfo->yOffset)
	--row;

    for(n = DragQueryFile(hDrop, -1, NULL, 0), i = 0; i < n; i++){
	DragQueryFile(hDrop, i, fname, 1024);
	gpTTYInfo->dndhandler (row, col, fname);
    }

    DragFinish(hDrop);
    return(1);
}

/*
 * Set a callback to deal with Drag 'N Drop events
 */
int
mswin_setdndcallback (int (*cb)())
{
    if(gpTTYInfo->dndhandler)
      gpTTYInfo->dndhandler = NULL;

    if(cb){
	gpTTYInfo->dndhandler = cb;
	DragAcceptFiles(ghTTYWnd, TRUE);
    }

    return(1);
}

/*
 * Clear previously installed callback to handle Drag 'N Drop
 * events
 */
int
mswin_cleardndcallback ()
{
    gpTTYInfo->dndhandler = NULL;
    DragAcceptFiles(ghTTYWnd, FALSE);
    return(1);
}



/*
 * Set a callback for function 'ch'
 */
int
mswin_setresizecallback (int (*cb)())
{
    int		i;
    int		e;
    
    
    /*
     * Look through whole array for this call back function.  Don't
     * insert duplicate.  Also look for empty slot.
     */
    e = -1;
    for (i = 0; i < RESIZE_CALLBACK_ARRAY_SIZE; ++i) {
	if (gpTTYInfo->resizer[i] == cb) 
	    return (0);
        if (e == -1 && gpTTYInfo->resizer[i] == NULL) 
	    e = i;
    }
    
    /*
     * Insert in empty slot or return an error.
     */
    if (e != -1) {
	gpTTYInfo->resizer[e] = cb;
	return (0);
    }
    return (-1);
}

/*
 * Clear all instances of the callback function 'cb'
 */
int
mswin_clearresizecallback (int (*cb)())
{
    int		i;
    int		status;
    
    status = -1;
    for (i = 0; i < RESIZE_CALLBACK_ARRAY_SIZE; ++i) {
	if (gpTTYInfo->resizer[i] == cb) {
	    gpTTYInfo->resizer[i] = NULL;
	    status = 0;
	}
    }
    return (status);
}


void
mswin_beginupdate (void)
{
    gpTTYInfo->fMassiveUpdate = TRUE;
}



void
mswin_endupdate (void)
{
    gpTTYInfo->fMassiveUpdate = FALSE;
    MoveTTYCursor (ghTTYWnd);
}



int
mswin_setwindow (char *fontName, char *fontSize, char *fontStyle, 
	char *windowPosition)
{
    LOGFONT		newFont;
    int			newHeight;
    HDC			hDC;
    int			ppi;
    RECT		wndRect, cliRect;
    char		*c;
    char		*n;
    int			i;
    BOOL		toolBar = FALSE;
    BOOL		toolBarTop = TRUE;
    BOOL		useAccel = FALSE;
    int			wColumns, wRows;
    int			wXPos, wYPos;
    int			wXBorder, wYBorder;
    int			wXSize, wYSize;
    char		wp[WIN_POS_STR_MAX_LEN + 1];
    
    
#ifdef SDEBUG
    if (mswin_debug >= 5) 
	fprintf (mswin_debugfile, "mswin_setwindow:::  entered, minimized:  %d\n",
		gpTTYInfo->fMinimized);
#endif

    /* Require a font name to set font info. */
    if (fontName != NULL && *fontName != '\0' && 
	    strlen (fontName) <= LF_FACESIZE - 1) {
	    
	hDC = GetDC (ghTTYWnd);
	ppi = GetDeviceCaps (hDC, LOGPIXELSY);
	ReleaseDC (ghTTYWnd, hDC);

	/* Default height, then examin the requested fontSize. */
	newFont.lfHeight =  -MulDiv (12, ppi, 72);
	if (ScanInt (fontSize, FONT_MIN_SIZE, FONT_MAX_SIZE, &newHeight)){
	    newHeight = abs (newHeight);
	    newFont.lfHeight = -MulDiv (newHeight, ppi, 72);
        }
	
	/* Default font style, then read requested style. */
	newFont.lfWeight =         0;
	newFont.lfItalic =         0;
	if (fontStyle != NULL) {
	    _strlwr (fontStyle);
	    if (strstr (fontStyle, "bold"))
		newFont.lfWeight = FW_BOLD;
	    if (strstr (fontStyle, "italic"))
		newFont.lfItalic = 1;
	}
	
	/* Everything else takes the default. */
	newFont.lfWidth =          0;
	newFont.lfEscapement =     0;
	newFont.lfOrientation =    0;
	newFont.lfUnderline =      0;
	newFont.lfStrikeOut =      0;
	newFont.lfCharSet =        ANSI_CHARSET;
	newFont.lfOutPrecision =   OUT_DEFAULT_PRECIS;
	newFont.lfClipPrecision =  CLIP_DEFAULT_PRECIS;
	newFont.lfQuality =        DEFAULT_QUALITY;
	newFont.lfPitchAndFamily = FIXED_PITCH;
	strcpy (newFont.lfFaceName, fontName);
	ResetTTYFont (ghTTYWnd, gpTTYInfo, &newFont);
    }
    
    /*
     * Set window position.  String format is:  CxR+X+Y
     * Where C is the number of columns, R is the number of rows,
     * and X and Y specify the top left corner of the window.
     */
    if (windowPosition != NULL && *windowPosition != '\0') {
	if (strlen(windowPosition) > WIN_POS_STR_MAX_LEN) return (0);
	strcpy (wp, windowPosition);
	
	/* Flag characters are at the end of the string.  Strip them
	 * off till we get to a number. */
	i = strlen (wp) - 1;
	while (i > 0 && (*(wp+i) < '0' || *(wp+i) > '9')) {
	    if (*(wp+i) == 't' || *(wp+i) == 'b') {
		toolBar = TRUE;
		toolBarTop = (*(wp+i) == 't');
	    }
	    if (*(wp+i) == 'd')
		gfUseDialogs = TRUE;
#ifdef ACCELERATORS
	    if (*(wp+i) == 'a')
	        AccelCtl (ghTTYWnd, ACCEL_LOAD, FALSE);
#endif	
	    *(wp+i) = 0;
	    --i;
        }
	
	/* Look for Columns, deliminated by 'x'. */
	c = strchr (wp, 'x');
	if (c == NULL) return (0);
	*c = '\0';
	if (!ScanInt (wp, -999, 9999, &wColumns)) return (0);

	/* Look for Rows, deliminated by '+'. */
	n = c + 1;
	c = strchr (n, '+');
	if (c == NULL) return (0);
	*c = '\0';
	if (!ScanInt (n, -999, 9999, &wRows))	return (0);
	
	/* Look for X position, deliminated by '+'. */
	n = c + 1;
	c = strchr (n, '+');
	if (c == NULL) return (0);
	*c = '\0';
	if (!ScanInt (n, -999, 9999, &wXPos))	return (0);
	
	/* And get Y position, deliminated by end of string. */
	n = c + 1;
	if (!ScanInt (n, -999, 9999, &wYPos))	return (0);


	/* Constrain the window position and size. */
	if (wXPos < 0)
	    wXPos = 0;
	if (wYPos < 0)
	    wYPos = 0;
	GetWindowRect (GetDesktopWindow(), &wndRect);
	if (wXPos > wndRect.right - 20)
	    wXPos = wndRect.right - 100;
	if (wYPos > wndRect.bottom - 20)
	    wYPos = wndRect.bottom - 100;

	/* Get the current window rect and client area. */
	GetWindowRect (ghTTYWnd, &wndRect);
	GetClientRect (ghTTYWnd, &cliRect);


	/* Calculate boarder sizes. */
	wXBorder = wndRect.right - wndRect.left - cliRect.right;
	wYBorder = wndRect.bottom - wndRect.top - cliRect.bottom;
	

	/* Show toolbar before calculating content size. */
	if (toolBar) {
	    gpTTYInfo->toolBarTop = toolBarTop;
	    TBShow (ghTTYWnd);
	}
	
	
	/* Calculate new window pos and size. */
	wXSize = wXBorder + (wColumns * gpTTYInfo->xChar) + 
						(2 * gpTTYInfo->xOffset);
	wYSize = wYBorder + (wRows * gpTTYInfo->yChar) + 
				gpTTYInfo->toolBarSize + (2 * MARGINE_TOP);
	if (!gpTTYInfo->fMinimized) 
	    MoveWindow (ghTTYWnd, wXPos, wYPos, wXSize, wYSize, TRUE);
	else {
	    gpTTYInfo->fDesiredSize = TRUE;
	    gpTTYInfo->xDesPos = wXPos;
	    gpTTYInfo->yDesPos = wYPos;
	    gpTTYInfo->xDesSize = wXSize;
	    gpTTYInfo->yDesSize = wYSize;
	}
    }
    return (0);
}



/*
 * Retreive the current font name, font size, and window position
 * These get stored in the pinerc file and will be passed to 
 * mswin_setwindow() when pine starts up.  See pinerc for comments
 * on the format.
 */
int
mswin_getwindow (char *fontName, char *fontSize, char *fontStyle, 
	char *windowPosition)
{
    HDC			hDC;
    int			ppi;
    RECT		wndRect;
    
    if (fontName != NULL) {
	strcpy (fontName, gpTTYInfo->lfTTYFont.lfFaceName);
    }

    if (fontSize != NULL) {
	hDC = GetDC (ghTTYWnd);
	ppi = GetDeviceCaps (hDC, LOGPIXELSY);
	ReleaseDC (ghTTYWnd, hDC);
	sprintf (fontSize, "%d", MulDiv (-gpTTYInfo->lfTTYFont.lfHeight,
					72, ppi));
    }
    if (fontStyle != NULL) {
	char		*sep[] = {"", ", "};
	int		iSep = 0;
	
	*fontStyle = '\0';
	if (gpTTYInfo->lfTTYFont.lfWeight >= FW_BOLD) {
	    strcat (fontStyle, "bold");
	    iSep = 1;
        }
	if (gpTTYInfo->lfTTYFont.lfItalic) {
	    strcat (fontStyle, sep[iSep]);
	    strcat (fontStyle, "italic");
        }
    }


    if (windowPosition != NULL) {
        /*
	 * Get the window position.  Constrain the top left corner
	 * to be on the screen.
	 */
	GetWindowRect (ghTTYWnd, &wndRect);
	if (wndRect.left < 0)
	    wndRect.left = 0;
	if (wndRect.top < 0)
	    wndRect.top = 0;
	sprintf (windowPosition, "%dx%d+%d+%d", gpTTYInfo->actNColumn, 
		gpTTYInfo->actNRow, wndRect.left, wndRect.top);
	if (gpTTYInfo->toolBarSize > 0) 
	    strcat (windowPosition, gpTTYInfo->toolBarTop ? "t" : "b");
	if (gfUseDialogs)
	    strcat (windowPosition, "d");
        if (gpTTYInfo->hAccel)
	    strcat (windowPosition, "a");
    }
    return (0);
}


/*
 * Set the scroll range.
 */
void
mswin_setscrollrange (long max)
{
    if (max != gpTTYInfo->scrollRange) {
	if (max > 0) {
	    if (max > 0x7fff) {
		gpTTYInfo->scrollScale = (float)max / (float)0x7fff;
		EnableScrollBar (ghTTYWnd, SB_VERT, ESB_ENABLE_BOTH);
		SetScrollRange (ghTTYWnd, SB_VERT, 0, 0x7fff, TRUE);
	    }
	    else {
		gpTTYInfo->scrollScale = 1.0;
		EnableScrollBar (ghTTYWnd, SB_VERT, ESB_ENABLE_BOTH);
		SetScrollRange (ghTTYWnd, SB_VERT, 0, (int) max, TRUE);
	    }
	}
	else {
	    max = 0;
	    SetScrollRange (ghTTYWnd, SB_VERT, 0, 1, FALSE);
	    EnableScrollBar (ghTTYWnd, SB_VERT, ESB_DISABLE_BOTH);
	    SetScrollPos (ghTTYWnd, SB_VERT, (int) 0, TRUE);
	    gpTTYInfo->scrollPos = 0;
	    gpTTYInfo->scrollScale = 1.0;
	}
	gpTTYInfo->scrollRange = (int)max;
    }
}



/*
 * Set the current scroll position.
 */
void
mswin_setscrollpos (long pos)
{
    int		ipos;
    
    if (pos != gpTTYInfo->scrollPos) {
	ipos = (WORD) ((float)pos / gpTTYInfo->scrollScale);    
        SetScrollPos (ghTTYWnd, SB_VERT, ipos, TRUE);
	gpTTYInfo->scrollPos = pos;
    }
}



/*
 * retreive the current scroll postion.
 */
long
mswin_getscrollpos (void)
{
   return ((long)((float)GetScrollPos (ghTTYWnd, SB_VERT) 
	   * gpTTYInfo->scrollScale));
}



/*
 * retreive the latest scroll to position.
 */
long
mswin_getscrollto (void)
{
   return (gpTTYInfo->scrollTo);
}



/*
 * install function to deal with LINEDOWN events
 */
void
mswin_setscrollcallback (scroll_t cbfunc)
{
    gScrollCallback = cbfunc;
}




/*
 * Set the printer font
 */
int		
mswin_setprintfont (char *fontName, char *fontSize, char *fontStyle)
{
    /* Require a font name to set font info. */
    if (fontName != NULL && *fontName != '\0' && 
	    strlen (fontName) <= LF_FACESIZE - 1) {
	    
	strncpy (gPrintFontName, fontName, LF_FACESIZE);
	gPrintFontName[LF_FACESIZE] = 0;
	strncpy (gPrintFontStyle, fontStyle, 63);
	gPrintFontStyle[63] = 0;
	_strlwr (gPrintFontStyle);	/* Lower case font style. */
	gPrintFontSize = 12;
	if (ScanInt (fontSize, FONT_MIN_SIZE, FONT_MAX_SIZE, &gPrintFontSize))
	    gPrintFontSize = abs (gPrintFontSize);
	gPrintFontSameAs = FALSE;
    }
    else {
	gPrintFontName[0] = '\0';
	gPrintFontSameAs = TRUE;
    }
}




int
mswin_getprintfont (char *fontName, char *fontSize, char *fontStyle)
{
    if (gPrintFontName[0] == '\0' || gPrintFontSameAs) {
	if (fontName != NULL) 
	    *fontName = '\0';
	if (fontSize != NULL) 
	    *fontSize = '\0';
	if (fontStyle != NULL) 
	    *fontName = '\0';
    }
    else {
	if (fontName != NULL) 
	    strcpy (fontName, gPrintFontName);
	if (fontSize != NULL) 
	    sprintf (fontSize, "%d", gPrintFontSize);
	if (fontStyle != NULL)
	    strcpy (fontStyle, gPrintFontStyle);
    }
}



/*
 * Set the window help text.  Add or delete the Help menu item as needed.
 */
int
mswin_sethelptext (char *title, char *pHelpText, size_t len, char **pHelpLines)
{
    HMENU		hMenu;
    BOOL		brc;
    int			count;
    
    /*
     * Remeber new values. 
     */
    gpHelpTitle = title;
    gpHelpText = pHelpText;
    gpHelpLen = len;
    gpHelpLines = pHelpLines;

    /*
     * Find menu.
     */
    hMenu = GetMenu (ghTTYWnd);
    if (hMenu == NULL) 
	return (1);
    count = GetMenuItemCount (hMenu);
    if (count == -1) 
	return (1);
    
    hMenu = GetSubMenu (hMenu, count - 1);
    if (hMenu == NULL) 
	return (1);
    
    /*
     * Insert or delete.
     */
    if (gpHelpText == NULL && gpHelpLines == NULL) {
	if (gfHelpMenu) {
	    brc = DeleteMenu (hMenu, IDM_HELP, MF_BYCOMMAND);
	    DrawMenuBar (ghTTYWnd);
	}
	gfHelpMenu = FALSE;
    }
    else {
	if (!gfHelpMenu) {
	    brc = InsertMenu (hMenu, 0, MF_BYPOSITION | MF_STRING, IDM_HELP, 
		    "General Help");
	    DrawMenuBar (ghTTYWnd);
	}
	gfHelpMenu = TRUE;
    }
    return (0);
}
    


/*
 * Set the text displayed when someone tries to close the application 
 * the wrong way.
 */
int
mswin_setclosetext (char *pCloseText)
{
    gpCloseText = pCloseText;
}






/*
 * Called when upper layer is in a busy loop.  Allows us to yeild to
 * Windows and perhaps process some events.  Does not yeild control
 * to other applications.
 */
int
mswin_yeild (void)
{
    MSG		msg;
    DWORD	start;
    int		didmsg = FALSE;
    
    if (gScrolling)
	return (TRUE);
    
    start = GetTickCount ();
#ifdef CDEBUG
    if (mswin_debug > 16) 
	fprintf (mswin_debugfile, "mswin_yeild:: Entered\n");
#endif
    if (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE)) {
	if (gpTTYInfo->hAccel == NULL || 
		!TranslateAccelerator (ghTTYWnd, gpTTYInfo->hAccel, &msg)) {
	    TranslateMessage (&msg);
	    DispatchMessage (&msg);
	    didmsg = TRUE;
	}
    }
#ifdef CDEBUG
    if (mswin_debug > 16) 
	fprintf (mswin_debugfile, "mswin_yeild::  Delay %ld msec\n",
		GetTickCount () - start);
#endif
    return (didmsg);
}





/*
 *	Called to see if we can process input. 
 *	We can't process input when we are in a scrolling mode.
 */
int
mswin_caninput ()
{
    return (!gScrolling && !gMouseTracking);
}




/*
 *	Called to see if there is a character available.
 */
int
mswin_charavail (void)
{
    MSG		msg;
    BOOL	ca, pa, ma;
    DWORD	start;
    
    if (gScrolling)
	return (FALSE);

    mswin_setcursor (MSWIN_CURSOR_ARROW);

    /*
     * If there are no windows messages waiting for this app, GetMessage
     * can take a long time.  So before calling GetMessage check if
     * there is anything I should be doing.  If there is, then only
     * call PeekMessage.
     * BUT!  Don't let too much time elapse between calls to GetMessage
     * or we'll shut out other windows.
     */
    ca = CQAvailable ();
    pa = EditPasteAvailable ();
#ifdef CDEBUG
    start = GetTickCount ();
    if (mswin_debug > 16) 
	fprintf (mswin_debugfile, "mswin_charavail::  Entered, ca %d, pa %d\n",ca,pa);
#endif
    if ((ca || pa) && GetTickCount () < gGMLastCall + GM_MAX_TIME) 
        ma = PeekMessage (&msg, NULL, 0, 0, PM_NOYIELD | PM_REMOVE);
    else {
        ma = GetMessage (&msg, NULL, 0, 0);
	gGMLastCall = GetTickCount ();
    }
    if (ma) {
	if (gpTTYInfo->hAccel == NULL || 
		!TranslateAccelerator (ghTTYWnd, gpTTYInfo->hAccel, &msg)) {
	    TranslateMessage (&msg);
	    DispatchMessage (&msg);
	}
    }
#ifdef CDEBUG
    if (mswin_debug > 16) 
	fprintf (mswin_debugfile, "mswin_charavail::  Delay %ld msec\n",
		GetTickCount () - start);
#endif

    return (pa || ca || CQAvailable ());
}



	

/*
 *	Call to get next character.  Dispatch one message.
 */
int
mswin_getc (void)
{
    BOOL	ca, pa, ma;
    MSG		msg;
    DWORD	start;
    
    if (gScrolling)
	return (MSWIN_KEY_NODATA);

    mswin_setcursor (MSWIN_CURSOR_ARROW);

    mswin_flush();


    /*
     * If there are no windows messages waiting for this app, GetMessage
     * can take a long time.  So before calling GetMessage check if
     * there is anything I should be doing.  If there is, then only
     * call PeekMessage.
     */
    ca = CQAvailable ();
    pa = EditPasteAvailable ();
#ifdef CDEBUG
    if (mswin_debug > 16) {
	start = GetTickCount ();
	fprintf (mswin_debugfile, "mswin_getc::  Entered, ca %d pa %d\n", ca, pa);
    }
#endif
    if ((ca || pa) && GetTickCount () < gGMLastCall + GM_MAX_TIME) 
        ma = PeekMessage (&msg, NULL, 0, 0, PM_NOYIELD | PM_REMOVE);
    else {
        ma = GetMessage (&msg, NULL, 0, 0);
	gGMLastCall = GetTickCount ();
    }
    if (ma) {
	if (gpTTYInfo->hAccel == NULL || 
		!TranslateAccelerator (ghTTYWnd, gpTTYInfo->hAccel, &msg)) {
	    TranslateMessage (&msg);
	    DispatchMessage (&msg);
	}
    }
#ifdef CDEBUG
    if (mswin_debug > 16) 
	fprintf (mswin_debugfile, "mswin_getc::  Delay %ld msec\n",
		GetTickCount () - start);
#endif


    if (pa) {
	SelClear ();
	return (EditPasteGet ());
    }
    if (ca || CQAvailable ()) {
	SelClear();
	return (CQGet ());
    }
    return (MSWIN_KEY_NODATA);
}




/*
 *	Like mswin_getc, but don't yeild control.
 */
int
mswin_getc_fast (void)
{
    MSG		msg;
    
    mswin_setcursor (MSWIN_CURSOR_ARROW);
    
    if (EditPasteAvailable ()) {
	SelClear ();
	return (EditPasteGet ());
    }
    if (CQAvailable ()) {
	SelClear ();
	return (CQGet ());
    }
    return (MSWIN_KEY_NODATA);
}







/*
 * ibmopen - open termnal
 */
int
mswin_open (void)
{
    /* This is a no-op.  All of this should have been set up already. */
    revexist = TRUE;
    return (0);
}


/*
 * ibmclose - Close terminal
 */
int
mswin_close (void)
{
    /* Another no-op. */
    return (0);
}




/*
 * ibmmove - Move cursor to...
 */
int
mswin_move (int row, int column)

{
    FlushWriteAccum ();
    if (row < 0 || row >= gpTTYInfo->actNRow)
	return (-1);
    if (column < 0 || column >= gpTTYInfo->actNColumn)
	return (-1);
    gpTTYInfo->nRow = row;
    gpTTYInfo->nColumn = column;
    MoveTTYCursor (ghTTYWnd);
    return (0);
}



int
mswin_getpos (int *row, int *column)
{
    FlushWriteAccum ();
    if (row == NULL || column == NULL)
	return (-1);
    *row = gpTTYInfo->nRow;
    *column = gpTTYInfo->nColumn;
    return (0);
}



int
mswin_getscreensize (int *row, int *column)
{
    if (row == NULL || column == NULL)
	return (-1);
    *row = gpTTYInfo->actNRow;
    *column = gpTTYInfo->actNColumn;
#ifdef SDEBUG
    if (mswin_debug >= 5) 
	fprintf (mswin_debugfile, "mswin_getscreensize::: reported size %d, %d\n",
		*row, *column);
#endif
    return (0);
}




int
mswin_showcursor (int show)
{
    int		wasShow;
    
    
    wasShow = (gpTTYInfo->wCursorState & CS_SHOW) != 0;
	
    if (show) {
	
	/* if the cursor was not already show, show it now. */
	if (!wasShow) {
	    gpTTYInfo->wCursorState |= CS_SHOW;

	    if (gpTTYInfo->wCursorState == CS_VISIBLE) {
		    CreateCaret (ghTTYWnd, NULL, gpTTYInfo->xChar, 
			    gpTTYInfo->yChar);
		    ShowCaret (ghTTYWnd);
	    }
	    MoveTTYCursor (ghTTYWnd);
        }
    }
    else {
	
	/* If the cursor is shown, hide it. */
	if (wasShow) {
	    if (gpTTYInfo->wCursorState == CS_VISIBLE) {
		HideCaret (ghTTYWnd);
		DestroyCaret();
	    }

	    gpTTYInfo->wCursorState &= ~CS_SHOW;
	}
    }

    return (wasShow);
}



int
mswin_puts (char *str)
{
    int			strLen;

    FlushWriteAccum ();
    if (str == NULL)
	return (-1);
    strLen = strlen (str);
    if (strLen > 0)
	WriteTTYText (ghTTYWnd, str, strLen);
    return (0);
}



int
mswin_putblock (char *str, int strLen)
{
    FlushWriteAccum ();
    if (str == NULL)
	return (-1);
    if (strLen > 0)
	WriteTTYText (ghTTYWnd, str, strLen);
    return (0);
}



/*
 * mswin_putc - put a character at the current position in the
 *	     current colors
 */

int
mswin_putc (int c)
{
    BYTE		cc;

    cc = (char)(c & 0xff);

    if (cc >= ' ') {
	/* Not carrage control. */
	gpTTYInfo->writeAccum[gpTTYInfo->writeAccumCount++] = cc;
	if (gpTTYInfo->writeAccumCount == WRITE_ACCUM_SIZE)
		FlushWriteAccum ();
    }
    else {
	/* Carrage control.  Need to flush write accumulator and
	 * write this char. */
	FlushWriteAccum ();
	WriteTTYBlock (ghTTYWnd, &cc, 1);
    }
    return (0);
}



/* 
 * ibmoutc - output a single character with the right attributes, but
 *           don't advance the cursor
 */
int
mswin_outc (char c)
{
    RECT	rect;
    long	offset;
    
    FlushWriteAccum ();
    
    switch (c) {
    case ASCII_BEL:
	MessageBeep (0);
	break;
	
    case ASCII_BS:
    case ASCII_CR:
    case ASCII_LF:
	/* Do nothing for these screen motion characters. */
	break;
	
	
    default:
	/* Paint character to screen. */
	offset = (gpTTYInfo->nRow * gpTTYInfo->actNColumn) + gpTTYInfo->nColumn;
	*(gpTTYInfo->pScreen + offset) = c;
	*(gpTTYInfo->pAttrib + offset) = gpTTYInfo->curAttrib;
	
	/* Invalidate rectange covering singel character. */
	rect.left = (gpTTYInfo->nColumn * gpTTYInfo->xChar) +
		gpTTYInfo->xOffset;
	rect.right = rect.left + gpTTYInfo->xChar;
	rect.top = (gpTTYInfo->nRow * gpTTYInfo->yChar) + 
		gpTTYInfo->yOffset;
	rect.bottom = rect.top + gpTTYInfo->yChar;
	gpTTYInfo->screenDirty = TRUE;
	InvalidateRect (ghTTYWnd, &rect, FALSE);
	break;
    }
    return (0);
}



/*
 * mswin_delchar - delete character at cursor.  Shift end of line left.
 *	Cursor stays in position.
 */
int
mswin_delchar (void)
{
    CHAR	*cStart;
    CharAttrib	*aStart;
    long	length;
    RECT	rect;
    
    FlushWriteAccum ();
    
    /* From position right of cursor to end of line. */
    length = gpTTYInfo->actNColumn - (gpTTYInfo->nColumn + 1);

    /* Shift end of line. */
    if (length > 0) {
        cStart = gpTTYInfo->pScreen + (gpTTYInfo->nRow *gpTTYInfo->actNColumn)
				+ gpTTYInfo->nColumn;
	memmove (cStart, cStart+1, (size_t) length);
        aStart = gpTTYInfo->pAttrib + (gpTTYInfo->nRow *gpTTYInfo->actNColumn)
			+ gpTTYInfo->nColumn;
        memmove (aStart, aStart + 1, (size_t) length);
    }
    
    /* Clear last char in line. */
    *(cStart + length) = ' ';
    *(aStart + length) = CHAR_ATTR_NORM;

    /* Invalidate from cursor to end of line. */
    rect.left = (gpTTYInfo->nColumn * gpTTYInfo->xChar) + gpTTYInfo->xOffset;
    rect.right = gpTTYInfo->xSize;
    rect.top = (gpTTYInfo->nRow * gpTTYInfo->yChar) + gpTTYInfo->yOffset;
    rect.bottom = rect.top + gpTTYInfo->yChar;
    gpTTYInfo->screenDirty = TRUE;
    InvalidateRect (ghTTYWnd, &rect, FALSE);

    return (0);
}



/*
 * mswin_inschar - insert character in current position.  Shift line
 *	to right and drop last char on line. 
 *	Cursor advances one 
 */
int
mswin_inschar (int c)
{
    CHAR	*cStart;
    CharAttrib	*aStart;
    long	length;
    RECT	rect;
    
    FlushWriteAccum ();
    
    /* From cursor to end of line - 1
    length = (gpTTYInfo->actNColumn - gpTTYInfo->nColumn) - 1;

    /* Shift end of line. */
    if (length > 0) {
        cStart = gpTTYInfo->pScreen + (gpTTYInfo->nRow *gpTTYInfo->actNColumn)
				+ gpTTYInfo->nColumn;
	memmove (cStart+1, cStart, (size_t) length);
        aStart = gpTTYInfo->pAttrib + (gpTTYInfo->nRow *gpTTYInfo->actNColumn)
			+ gpTTYInfo->nColumn;
        memmove (aStart+1, aStart, (size_t) length);
    }
    
    /* Insert new char. */
    *(cStart + length) = (char)(c & 0x00ff);
    *(aStart + length) = gpTTYInfo->curAttrib;

    /* Invalidate from cursor to end of line. */
    rect.left = (gpTTYInfo->nColumn * gpTTYInfo->xChar) + gpTTYInfo->xOffset;
    rect.right = gpTTYInfo->xSize;
    rect.top = (gpTTYInfo->nRow * gpTTYInfo->yChar) + gpTTYInfo->yOffset;
    rect.bottom = rect.top + gpTTYInfo->yChar;
    gpTTYInfo->screenDirty = TRUE;
    InvalidateRect (ghTTYWnd, &rect, FALSE);
    
    /* move cursor forward one space. */
    if (gpTTYInfo->nColumn < gpTTYInfo->actNColumn - 1) {
	++gpTTYInfo->nColumn;
	MoveTTYCursor (ghTTYWnd);
    }

    return (0);
}



/*
 * ibmrev - change reverse video state
 */
int
mswin_rev (int state)
{
    int		curState;
    
    curState = (gpTTYInfo->curAttrib & CHAR_ATTR_REV);
    if ((state && !curState) || (!state && curState)) {
	FlushWriteAccum ();
	if (state) 
	    gpTTYInfo->curAttrib |= CHAR_ATTR_REV;
	else
	    gpTTYInfo->curAttrib &= ~CHAR_ATTR_REV;
    }
    return (0);
}
	


/*
 * Get current reverse video state. 
 */
int
mswin_getrevstate (void)
{
    return ((gpTTYInfo->curAttrib & CHAR_ATTR_REV) != 0);
}



/*
 * ibmeeol - erase to the end of the line
 */
int
mswin_eeol (void)
{
    CHAR	*cStart;
    CharAttrib	*aStart;
    long	length;
    RECT	rect;
    
    FlushWriteAccum ();
    
    /* From current position to end of line. */
    length = gpTTYInfo->actNColumn - gpTTYInfo->nColumn;		

    cStart = gpTTYInfo->pScreen + (gpTTYInfo->nRow * gpTTYInfo->actNColumn)
			+ gpTTYInfo->nColumn;
    memset (cStart, ' ', (size_t) length);
    
    aStart = gpTTYInfo->pAttrib + (gpTTYInfo->nRow * gpTTYInfo->actNColumn)
			+ gpTTYInfo->nColumn;
    memset (aStart, CHAR_ATTR_NORM, (size_t) length);

    rect.left = (gpTTYInfo->nColumn * gpTTYInfo->xChar) + 
	    gpTTYInfo->xOffset;
    rect.right = gpTTYInfo->xSize;
    rect.top = (gpTTYInfo->nRow * gpTTYInfo->yChar) + 
	    gpTTYInfo->yOffset;
    rect.bottom = rect.top + gpTTYInfo->yChar;
    gpTTYInfo->screenDirty = TRUE;
    InvalidateRect (ghTTYWnd, &rect, FALSE);

    return (0);
}



/*
 * ibmeeop - clear from cursor to end of page
 */
int
mswin_eeop (void)
{
    CHAR	*cStart;
    CharAttrib	*aStart;
    long	length;
    RECT	rect;
    
    FlushWriteAccum ();
    /* From current position to end of screen. */

    cStart = gpTTYInfo->pScreen + (gpTTYInfo->nRow * gpTTYInfo->actNColumn)
			+ gpTTYInfo->nColumn;
    length = (gpTTYInfo->pScreen + (gpTTYInfo->actNColumn * gpTTYInfo->actNRow))
		    - cStart;
    memset (cStart, ' ', (size_t) length);
    
    aStart = gpTTYInfo->pAttrib + (gpTTYInfo->nRow * gpTTYInfo->actNColumn)
			+ gpTTYInfo->nColumn;
    memset (aStart, CHAR_ATTR_NORM, (size_t) length);

    
    /* Invalidate a rectangle that includes all of the current line down
     * to the bottom of the window. */
    rect.left = 0;
    rect.right = gpTTYInfo->xSize;
    rect.top = (gpTTYInfo->nRow * gpTTYInfo->yChar) + 
	    gpTTYInfo->yOffset;
    rect.bottom = gpTTYInfo->ySize;
    gpTTYInfo->screenDirty = TRUE;
    InvalidateRect (ghTTYWnd, &rect, FALSE);

    return (0);
}



/*
 * ibmbeep - system beep...
 */
int
mswin_beep (void)
{
    MessageBeep (MB_OK);
    return (0);
}


/*
 * pause - wait in function for specified number of seconds.
 */
int
mswin_pause (int seconds)
{
    DWORD	stoptime;
    
    stoptime = GetTickCount () + (DWORD) seconds * 1000;
    while (stoptime > GetTickCount ()) 
	mswin_yeild ();
}
	


/*
 * ibmflush - Flush output to screen.
 *
 */
int
mswin_flush (void)
{

    /*
     * Flush cached changes, then update the window.
     */
    FlushWriteAccum ();
    UpdateWindow (ghTTYWnd);
    
    return (0);
}




/*
 * A replacement for fflush
 * relies on #define fflush mswin_fflush
 */
#undef fflush
int
mswin_fflush (FILE *f)
{
    if (f == stdout) {
	mswin_flush();
    }
    else
	fflush (f);
}




/*
 * Set the cursor
 */
void
mswin_setcursor (int newcursor)
{
    HCURSOR hNewCursor;


    /* There is either the busy currsor or the arrow cursor. */
    if (newcursor == MSWIN_CURSOR_BUSY) 
        hNewCursor = ghCursorBusy;
    else
	hNewCursor = ghCursorArrow;

    /* If new cursor requested, select it. */
    if (hNewCursor != ghCursorCurrent) {
	ghCursorCurrent = hNewCursor;
	SetCursor (ghCursorCurrent);
    }
}
    





/*
 * Print to the screen.
 */
int
printf (const char *fmt, ...)
{
    va_list	marker;
    int		strLen;
    
    va_start (marker, fmt);
    _vsnprintf (TempBuf, MAXLEN_TEMPSTR, fmt, marker);
    
    FlushWriteAccum ();
    strLen = strlen (TempBuf);
    if (strLen > 0) {
        if (TempBuf[strLen-1] == ASCII_LF) {
	    TempBuf[strLen-1] == ASCII_CR;
	    TempBuf[strLen] == ASCII_LF;
	    TempBuf[++strLen] = '\0';
        }
	WriteTTYBlock (ghTTYWnd, TempBuf, strLen);
    }
    return (1);
}




/*
 * Display message in windows dialog box. 
 */
int
mswin_messagebox (char *msg, int err)
{
    MessageBox (NULL, msg, gszAppName,
		MB_OK | ((err) ?  MB_ICONSTOP : MB_ICONINFORMATION));
}




/*
 * Signals whether or not Paste should be turned on in the
 * menu bar.
 */
int
mswin_allowpaste (int on)
{
    HMENU		hMenu;
    
    hMenu = GetMenu (ghTTYWnd);
    gPasteEnabled = on;
    if(!IsClipboardFormatAvailable (CF_TEXT) || on == MSWIN_PASTE_DISABLE)
      EnableMenuItem (hMenu, IDM_EDIT_PASTE, (MF_BYCOMMAND | MF_GRAYED));
    else
      EnableMenuItem (hMenu, IDM_EDIT_PASTE, (MF_BYCOMMAND | MF_ENABLED));

}



/*
 * Signals whether or not Copy/Cut should be turned on in the
 * menu bar.
 */
int
mswin_allowcopy (getc_t copyfunc)
{
    gCopyCutFunction = copyfunc;
    gAllowCopy = (copyfunc != NULL);
}



/*
 * Signals whether or not Copy/Cut should be turned on in the
 * menu bar.
 */
int
mswin_allowcopycut (getc_t copyfunc)
{
    gCopyCutFunction = copyfunc;
    gAllowCopy = gAllowCut = (copyfunc != NULL);
}



/*
 * Signals if the upper layer wants to track the mouse.
 */
int
mswin_allowmousetrack (int b)
{
    gAllowMouseTrack = b;
    if (b) 
	SelClear ();
    MyTimerSet ();
}



int
mswin_newmailicon (void)
{
    if (gpTTYInfo->fMinimized) {
	gpTTYInfo->fNewMailIcon = TRUE;
	gpTTYInfo->screenDirty = TRUE;
	gpTTYInfo->eraseScreen = TRUE;
	InvalidateRect (ghTTYWnd, NULL, FALSE);
    }
}



/*---------------------------------------------------------------------------
 *
 * Client level menu item stuff.
 *
 * These are menu items that activate commands in the "client" program.
 * Generally, the client calls us to tell us which menu items are active
 * and what key stroke they generate.  When such an item is selected it's
 * key stroke is injected into the character queue as if it was typed by
 * the user.
 *
 *-------------------------------------------------------------------------*/

/*
 * Clear active status of all "menu items".
 */
void
mswin_menuitemclear (void)
{
    int			i;
    HWND		hWnd;
    

    for (i = 0; i < KS_COUNT; ++i) {
	gpTTYInfo->menuItems[i].miActive = FALSE;
	if (gpTTYInfo->toolBarSize > 0) {
	    hWnd = GetDlgItem(gpTTYInfo->hTBWnd, i + KS_RANGESTART);
	    if (hWnd != NULL)
		EnableWindow(hWnd, FALSE);
	}
    }
    gpTTYInfo->menuItemsCurrent = FALSE;
}


/*
 * Add an item to the cmdmenu
 */
void
mswin_menuitemadd (int key, char *label, int menuitem, int flags)
{
    int			i;
    HWND		hWnd;
    
    if (menuitem >= KS_RANGESTART && menuitem <= KS_RANGEEND) {
	 
	gpTTYInfo->menuItemsCurrent = FALSE;
	
	i = menuitem - KS_RANGESTART;
	gpTTYInfo->menuItems[i].miActive = TRUE;
	gpTTYInfo->menuItems[i].miKey = key;

	if (gpTTYInfo->toolBarSize > 0) {
	    hWnd = GetDlgItem(gpTTYInfo->hTBWnd, menuitem);
	    if (hWnd != NULL)
		EnableWindow(hWnd, TRUE);
	}
    }
}



/*
 * Called when a menu command arrives with an unknown ID.  If it is
 * within the range of the additional menu items, insert the
 * corresponding character into the char input queue.
 */
void
ProcessMenuItem (HWND hWnd, WPARAM wParam) 
{
    PTTYINFO		pTTYInfo;
    int			i;

    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	return;

    
    if (wParam >= KS_RANGESTART && wParam <= KS_RANGEEND) {
	i = wParam - KS_RANGESTART;
	if (pTTYInfo->menuItems[i].miActive) 
	    CQAdd (pTTYInfo->menuItems[i].miKey, 0);
    }
}





/*
 * Called to set a new menu.
 */
int
mswin_setwindowmenu (int menu)
{
    int		oldmenu;
    HMENU	holdmenu;
    HMENU	hmenu;
    
    
    oldmenu = gpTTYInfo->curWinMenu;
    holdmenu = GetMenu (ghTTYWnd);
    if (gpTTYInfo->curWinMenu != menu) {
	
	hmenu = LoadMenu (ghInstance, MAKEINTRESOURCE (menu));
	if (hmenu != NULL) {
	    if (SetMenu (ghTTYWnd, hmenu) != 0) {
	        DestroyMenu (holdmenu);
		gfHelpMenu = FALSE;
		gpTTYInfo->curWinMenu = menu;
		if (gpHelpText != NULL || gpHelpLines != NULL) 
		    mswin_sethelptext (gpHelpTitle, gpHelpText, gpHelpLen,
				    gpHelpLines);
	    }
	}
	
	TBSwap (ghTTYWnd,
		menu == MENU_DEFAULT ? IDD_TOOLBAR : IDD_COMPOSER_TB);
    }
    return (oldmenu);
}






/*---------------------------------------------------------------------------
 *
 * Printing stuff
 *
 *-------------------------------------------------------------------------*/

/*
 * Printing globals
 */
LOCAL HDC	P_PrintDC;	/* Printer device context. */
LOCAL int	P_PageRows;	/* Number of rows we put on a page. */
LOCAL int	P_PageColumns;	/* Number of columns we put on a page. */
LOCAL int	P_RowHeight;	/* Hight of a row in printer pixels. */
LOCAL int	P_CurRow;	/* Current row, starting at zero */
LOCAL int	P_CurCol;	/* Current col, starting at zero. */
LOCAL int	P_TopOffset;	/* Top Margin offset, in pixels. */
LOCAL int	P_LeftOffset;	/* Top Margin offset, in pixels. */
LOCAL HFONT	P_hFont;	/* Handle to printing font. */
char		*P_LineText;	/* Pointer to line buffer. */




/*
 * Define the margin as number of lines at top and bottom of page. 
 * (might be better to define as a percent of verticle page size)
 */
#define VERTICLE_MARGIN		3	/* lines at top and bottom of page. */
#define HORIZONTAL_MARGIN	1	/* margine at left & right in chars */

/*
 * Several errors that can be reported. 
 */
#define PE_DIALOG_FAILED	1
#define PE_USER_CANCEL		2
#define PE_CANT_START_DOC	3
#define PE_OUT_OF_MEMORY	4
#define PE_GENERAL_ERROR	5
#define PE_OUT_OF_DISK		6
#define PE_PRINTER_NOT_FOUND	7
#define PE_PINE_INTERNAL	8
#define PE_FONT_FAILED		9


LOCAL struct pe_error_message {
	int		error_code;
	char		*error_message;
 } P_ErrorMessages[] = {
	{ PE_DIALOG_FAILED, "Print Dialog Failed"},
        { PE_USER_CANCEL, "User canceled" },
        { PE_CANT_START_DOC,	"Can't start document" },
	{ PE_OUT_OF_MEMORY,	"Out of memory" },
	{ PE_OUT_OF_DISK,	"Out of disk space" },
	{ PE_PRINTER_NOT_FOUND,	"Printer not found" },
	{ PE_PINE_INTERNAL,	"Pine internal error" },
	{ PE_FONT_FAILED,	"Failed to create font" },
	{ 0, NULL }};



/*
 * Send text in the line buffer to the printer.  
 * Advance to next page if necessary.
 */
LOCAL int
_print_send_line (void)
{
    int		status;
    
    status = 0;
    if (P_CurCol > 0) 
	TextOut (P_PrintDC, P_LeftOffset, 
				P_TopOffset + (P_CurRow * P_RowHeight), 
		P_LineText, P_CurCol);
    P_CurCol = 0;
    if (++P_CurRow >= P_PageRows) 
	status = _print_send_page ();
	
    return (status);
}

    

/*
 * Advance one page. 
 */
int
_print_send_page ()
{
    int		status;
    
    
    status = EndPage (P_PrintDC);
    if (status < 0)
	goto PrintError;
    P_CurRow = 0;
    StartPage (P_PrintDC);
    SelectObject (P_PrintDC, P_hFont);
    return (0);
    
    
PrintError:
    switch (status) {
    case SP_USERABORT:	return (PE_USER_CANCEL);
    case SP_OUTOFDISK:  return (PE_OUT_OF_DISK);
    case SP_OUTOFMEMORY:  return (PE_OUT_OF_MEMORY);
    default:
    case SP_ERROR:	return (PE_GENERAL_ERROR);
    }
}



/*
 * Map errors reported to my own error set.
 */
int
_print_map_dlg_error (DWORD error)
{
    switch (error) {
    case 0:			    return (PE_USER_CANCEL);
    case CDERR_MEMALLOCFAILURE:
    case CDERR_MEMLOCKFAILURE:
				    return (PE_OUT_OF_MEMORY);
    case PDERR_PRINTERNOTFOUND:
    case PDERR_NODEVICES:
				    return (PE_PRINTER_NOT_FOUND);
    case CDERR_STRUCTSIZE:
				    return (PE_PINE_INTERNAL);
    default:
				    return (PE_GENERAL_ERROR);
    }
}
	


/*
 * Get the printer ready.  Returns ZERO for success, or an error code that
 * can be passed to mswin_print_error() to get a text message.
 */
int
mswin_print_ready (WINHAND hWnd, char *docDesc)
{
    PRINTDLG		pd;
    DOCINFO		di;
    TEXTMETRIC		tm;
    HDC			hDC;
    int			fontSize;	/* Size in Points. */
    int			ppi;		/* Pixels per inch in device. */
    int			xChar;
    int			status;
    HFONT		oldFont;
    LOGFONT		newFont;
    
    
    status = 0;
    P_PrintDC = NULL;

    
    /*
     * Show print dialog.
     */
    pd.lStructSize = sizeof (pd);
    pd.hwndOwner = (hWnd ? (HWND) hWnd : ghTTYWnd);
    pd.hDevMode = NULL;
    pd.hDevNames = NULL;
    pd.Flags = PD_ALLPAGES | PD_NOSELECTION | PD_NOPAGENUMS | 
	    PD_HIDEPRINTTOFILE | PD_RETURNDC;
    pd.nCopies = 1;
    if (PrintDlg (&pd) == 0) 
	return (_print_map_dlg_error (CommDlgExtendedError()));

    
    /*
     * Returns the device name which we could use to remember what printer 
     * they selected.  But instead, we just toss them.
     */
    if (pd.hDevNames)
	GlobalFree (pd.hDevNames);
    if (pd.hDevMode)
	GlobalFree (pd.hDevMode);

    /*
     * Get the device drawing context.
     * (does PringDlg() ever return success but fail to return a DC?)
     */
    if (pd.hDC != NULL) 
	P_PrintDC = pd.hDC;
    else {
        status = PE_DIALOG_FAILED;
	goto Done;
    }
    
    

    
    /*
     * Start Document
     */
    di.cbSize = sizeof (DOCINFO);
    di.lpszDocName = docDesc;		/* This appears in the print manager*/
    di.lpszOutput = NULL;		/* Could suply a file name to print
					   to. */
    if (StartDoc (P_PrintDC, &di) < 0) {
	DeleteDC (P_PrintDC);
	P_PrintDC = NULL;
	status = PE_CANT_START_DOC;
	goto Done;
    }
    
    
    
    /*
     * Printer font is either same as window font, or is it's own
     * font.
     */
    if (gPrintFontSameAs) {

	/*
	 * Get the current font size in points, then create a new font
	 * of same size for printer.  Do the calculation using the actual
	 * screen resolution instead of the logical resolution so that
	 * we get pretty close to the same font size on the printer
	 * as we see on the screen.
	 */
	hDC = GetDC (ghTTYWnd);			/* Temp screen DC. */
	ppi = (int) ((float)GetDeviceCaps (hDC, VERTRES) / 
		    ((float) GetDeviceCaps (hDC, VERTSIZE) / 25.3636));
#ifdef FDEBUG
	if (mswin_debug >= 8) {
	    fprintf (mswin_debugfile, "mswin_print_ready:  Screen res %d ppi, font height %d pixels\n",
		ppi, -gpTTYInfo->lfTTYFont.lfHeight);
	    fprintf (mswin_debugfile, "                    Screen height %d pixel, %d mm\n",
		    GetDeviceCaps (hDC, VERTRES), GetDeviceCaps (hDC, VERTSIZE));
	}
#endif
	ReleaseDC (ghTTYWnd, hDC);

	/* Convert from screen pixels to points. */
	fontSize = MulDiv (-gpTTYInfo->lfTTYFont.lfHeight, 72, ppi);
	++fontSize;		/* Fudge a little. */


	/* Get printer resolution and convert form points to printer pixels. */
	ppi = GetDeviceCaps (P_PrintDC, LOGPIXELSY);
	newFont.lfHeight =  -MulDiv (fontSize, ppi, 72);
	strcpy (newFont.lfFaceName, gpTTYInfo->lfTTYFont.lfFaceName);
	newFont.lfItalic = gpTTYInfo->lfTTYFont.lfItalic;
	newFont.lfWeight = gpTTYInfo->lfTTYFont.lfWeight;
	

#ifdef FDEBUG
	if (mswin_debug >= 8) {
	    fprintf (mswin_debugfile, "                    font Size %d points\n",
		    fontSize);
	    fprintf (mswin_debugfile, "                    printer res %d ppi, font height %d pixels\n",
		ppi, -newFont.lfHeight);
	    fprintf (mswin_debugfile, "                    paper height %d pixel, %d mm\n",
		    GetDeviceCaps (P_PrintDC, VERTRES), 
		    GetDeviceCaps (P_PrintDC, VERTSIZE));
	}
#endif
    }
    else {
	ppi = GetDeviceCaps (P_PrintDC, LOGPIXELSY);
	newFont.lfHeight =  -MulDiv (gPrintFontSize, ppi, 72);
	strcpy (newFont.lfFaceName, gPrintFontName);
	newFont.lfWeight = 0;
	if (strstr (gPrintFontStyle, "bold"))
	    newFont.lfWeight = FW_BOLD;
	newFont.lfItalic = 0;
	if (strstr (gPrintFontStyle, "italic"))
	    newFont.lfItalic = 1;
    }

	
    
    /* Fill out rest of font description and request font. */
    newFont.lfWidth =          0;
    newFont.lfEscapement =     0;
    newFont.lfOrientation =    0;
    newFont.lfUnderline =      0;
    newFont.lfStrikeOut =      0;
    newFont.lfCharSet =        ANSI_CHARSET;
    newFont.lfOutPrecision =   OUT_DEFAULT_PRECIS;
    newFont.lfClipPrecision =  CLIP_DEFAULT_PRECIS;
    newFont.lfQuality =        DEFAULT_QUALITY;
    newFont.lfPitchAndFamily = FIXED_PITCH;
    P_hFont = CreateFontIndirect (&newFont);
    if (P_hFont == NULL) {
	status = PE_FONT_FAILED;
	DeleteDC (P_PrintDC);
	goto Done;
    }
    
    
    /*
     * Start page.  
     * Must select font for each page or it returns to default.
     * Windows seems good about maping selected font to a font that 
     * will actually print on the printer.
     */
    StartPage (P_PrintDC);
    oldFont = SelectObject (P_PrintDC, P_hFont);
    
    
    /*
     * Find out about the font we got and set up page size and margins.
     * This assumes all pages are the same size - which seems reasonable.
     */
    GetTextMetrics (P_PrintDC, &tm);
    xChar = tm.tmAveCharWidth;			
    P_RowHeight = tm.tmHeight + tm.tmExternalLeading;
    
    /* HORZRES and VERTRES report size of page in printer pixels. */
    P_PageColumns = GetDeviceCaps (P_PrintDC, HORZRES) / xChar;
    P_PageRows = GetDeviceCaps (P_PrintDC, VERTRES) / P_RowHeight;
    
    /* We allow a margin at top and bottom measured in text rows. */
    P_PageRows -= VERTICLE_MARGIN * 2;
    P_TopOffset = VERTICLE_MARGIN * P_RowHeight;
    
    /* And allow for a left and right margine measured in characters. */
    P_PageColumns -= HORIZONTAL_MARGIN * 2;
    P_LeftOffset = HORIZONTAL_MARGIN * xChar;
    
    P_CurRow = 0;			/* Start counting at row 0. */
    P_CurCol = 0;			/* At character 0. */
    P_LineText = MemAlloc (P_PageColumns + 1);
    if (P_LineText == NULL) {
	EndDoc (P_PrintDC);
	DeleteObject (P_hFont);
	P_hFont = NULL;
	DeleteDC (P_PrintDC);
	P_PrintDC = NULL;
	status = PE_OUT_OF_MEMORY;
	goto Done;
    }
    
    
Done:
    return (status);
}



/* 
 * Called when printing is done.
 * xxx what happens if there is an error?  Will this get called?
 */
int
mswin_print_done (void)
{
    if (P_PrintDC != NULL) {
	if (P_LineText != NULL)
		MemFree (P_LineText);
	EndPage (P_PrintDC);
	EndDoc (P_PrintDC);
	DeleteObject (P_hFont);
	P_hFont = NULL;
	DeleteDC (P_PrintDC);
	P_PrintDC = NULL;
    }
    return (0);
}



/*
 * Return ponter to a text string that describes the erorr.
 */
char *
mswin_print_error (int error_code)
{
    int		i;
    
    for (i = 0; P_ErrorMessages[i].error_message != NULL; ++i) {
	if (P_ErrorMessages[i].error_code == error_code) 
	    return (P_ErrorMessages[i].error_message);
    }
    return ("(Unknow error)");
}




/*
 * Add a single character to the current line.  
 * Only handles CRLF carrage control.
 */
int
mswin_print_char (int c)
{
    int		status;
    
    status = 0;
    switch (c) {
    case ASCII_CR:
	break;

    case ASCII_LF:
	status = _print_send_line ();
	break;
	
    case ASCII_TAB:
	if (P_CurCol == P_PageColumns)
	    status = _print_send_line ();
	do {
		*(P_LineText + P_CurCol++) = ' ';
	} while (P_CurCol % PRINT_TAB_SIZE != 0 && P_CurCol < P_PageColumns);
	break;

    default:
	if (P_CurCol == P_PageColumns)
	    status = _print_send_line ();
        *(P_LineText + P_CurCol++) = (char) c;
	break;
    }
    return (status);
}
    



/*
 * Send a string to the printer.
 */
int
mswin_print_text (char *text)
{
    if (text != NULL) {
	while (*text) 
	    mswin_print_char (*(text++));
    }
}



#if 0
/*
 * Send a whole line to the printer.
 * Assume no carrage control in the line.
 */
int
mswin_print_line (char *line)
{
	
    int		status;
    int		linePos;
    int		lineLen;
    int		count;
    
    status = 0;
    lineLen = strlen (line);
    linePos = 0;
    
    /* Any text already in P_LineText is kept and appended to. */
    if (lineLen == 0) {
	/* If the line is empty, send that. */
	_print_send_line ();
    }
    else {
	/* Send the line to the printer.  Appending to anything that
	 * was already there, and wrapping to subsequent lines if
	 * there is more that will fit in one line. */
	while (lineLen > 0) {
	    count = min (lineLen - linePos, P_PageColumns - P_CurCol);
	    memcpy (P_LineText + P_CurCol, line + linePos, count);
	    P_CurCol += count;
	    linePos += count;
	    lineLen -= count;
	    _print_send_line ();
	}
    }
    return (0);
}
#endif








/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *        File dialog boxes.
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

LOCAL char gHomeDir[PATH_MAX];
LOCAL char gLastDir[PATH_MAX];



/*
 * Keep track of the last dir visited.  Most of the time pine just passes us
 * the "home directory", which usually is not where the user wants to start.
 * Assume that the first time we are called we are being passed the home
 * direcory.
 */
static void
FillInitialDir (LPCSTR *iDir, char *targDir) 
{
    if (lstrlen (gHomeDir) == 0) {
	lstrcpy (gHomeDir, targDir);
	*iDir = targDir;
    }
    else if (lstrcmp (gHomeDir, targDir) == 0) 
	    *iDir = gLastDir;
	else
	    *iDir = targDir;
}



/*
 * Display a save file dialog box.
 *
 *	dir	>	directory to start search in
 *		<	directory finished in.
 *	fName	<	Name of file selectec
 *	nMaxFName	length of dir and fName.
 */
int
mswin_savefile (char *dir, char *fName, int nMaxFName)
{
    OPENFILENAME	ofn;
    char		filters[128];
    DWORD		rc;
    char		*p;
    size_t		l;


    /* Set filters array.  (pairs of null terminated strings, terminated
     * by a double null). */
    strcpy (filters, "Text Files (*.txt)#*.txt#All Files (*.*)#*.*#");
    for (p = filters; *p != '\0'; ++p) {
	if (*p == '#')
	    *p = '\0';
    }



    /* Set up the BIG STRUCTURE. */
    memset (&ofn, 0, sizeof(ofn));
    ofn.lStructSize = sizeof (OPENFILENAME);
    ofn.hwndOwner = ghTTYWnd;
    ofn.lpstrFilter = filters;
    ofn.lpstrCustomFilter = NULL;
    ofn.nFilterIndex = 1;
    ofn.lpstrFile = fName;
    ofn.nMaxFile = nMaxFName;
    ofn.lpstrFileTitle = NULL;
    ofn.nMaxFileTitle = 0;
    FillInitialDir (&ofn.lpstrInitialDir, dir);
    ofn.lpstrTitle = "Save To File";
    ofn.Flags = OFN_NOREADONLYRETURN | 
		    OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST;
    ofn.lpstrDefExt = "txt";

    if (GetSaveFileName (&ofn)) {
	    
	/* Copy directory name to dir. */
	strcpy (dir, fName);
	if (dir[ofn.nFileOffset-1] == '\\')
	    dir[ofn.nFileOffset-1] = '\0';
        else
	    dir[ofn.nFileOffset] = '\0';
	
	/* Remember last dir visited. */
	lstrcpy (gLastDir, dir);
	
	/* Move file name portion to beginning of fName buffer. */
	p = fName + ofn.nFileOffset;
	l = strlen (p) + 1;
	memmove (fName, p, l);
	return (0);
    }
    else {
	rc = CommDlgExtendedError ();
	return (-1);
    }
}




/*
 * Display an open file dialog box.
 *
 *	dir	>	directory to start search in
 *		<	directory finished in.
 *	fName	<	Name of file selectec
 *	nMaxFName	length of dir and fName.
 */
int
mswin_openfile (char *dir, char *fName, int nMaxFName)
{
    OPENFILENAME	ofn;
    char		filters[128];
    DWORD		rc;
    char		*p;
    size_t		l;


    /* Set filters array.  (pairs of null terminated strings, terminated
     * by a double null). */
    strcpy (filters, "Text Files (*.txt)#*.txt#All Files (*.*)#*.*#");
    for (p = filters; *p != '\0'; ++p) {
	if (*p == '#')
	    *p = '\0';
    }
    
    

    /* Set up the BIG STRUCTURE. */
    memset (&ofn, 0, sizeof(ofn));
    ofn.lStructSize = sizeof (OPENFILENAME);
    ofn.hwndOwner = ghTTYWnd;
    ofn.lpstrFilter = filters;
    ofn.lpstrCustomFilter = NULL;
    ofn.nFilterIndex = 1;
    ofn.lpstrFile = fName;
    ofn.nMaxFile = nMaxFName;
    ofn.lpstrFileTitle = NULL;
    ofn.nMaxFileTitle = 0;
    FillInitialDir (&ofn.lpstrInitialDir, dir);
    ofn.lpstrTitle = "Select File";
    ofn.Flags = OFN_HIDEREADONLY | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST;
    ofn.lpstrDefExt = "txt";

    if (GetOpenFileName (&ofn)) {
	    
	/* Copy directory name to dir. */
	strcpy (dir, fName);
	if (dir[ofn.nFileOffset-1] == '\\')
	    dir[ofn.nFileOffset-1] = '\0';
        else
	    dir[ofn.nFileOffset] = '\0';
	
	/* Remember last dir visited. */
	lstrcpy (gLastDir, dir);
	
	/* Move file name portion to beginning of fName buffer. */
	p = fName + ofn.nFileOffset;
	l = strlen (p) + 1;
	memmove (fName, p, l);
	return (0);
    }
    else {
	rc = CommDlgExtendedError ();
	return (-1);
    }
}
	
	




/*---------------------------------------------------------------------------
 */

/*
 * pico_XXcolor() - each function sets a particular attribute
 */
pico_nfcolor(s)
char *s;
{
    SetColorAttribute (&gpTTYInfo->rgbFGColor, s);
}

pico_nbcolor(s)
char *s;
{
    SetColorAttribute (&gpTTYInfo->rgbBGColor, s);
}

pico_rfcolor(s)
char *s;
{
    SetColorAttribute (&gpTTYInfo->rgbRFGColor, s);
}

pico_rbcolor(s)
char *s;
{
    SetColorAttribute (&gpTTYInfo->rgbRBGColor, s);
}





/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *        Signal and alarm functions
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*
 * Provide a rough implementation of the SIGALRM and alarm functions
 */



/*
 * Set a new handler for a signal.
 */
void (__cdecl * __cdecl signal (int sig,void (__cdecl *hndlr)(int)))(int)

{
    SignalType	oldValue;
    
    if (sig == SIGALRM) {
	oldValue = gSignalAlarm;
	gSignalAlarm = hndlr;
	return (oldValue);
    }
    if (sig == SIGHUP) {
	oldValue = gSignalHUP;
	gSignalHUP = hndlr;
	return (oldValue);
    }
    
    /* All other's are always ignored. */
    return (SIG_IGN);
}




/*
 * Set the alarm expiration time (in seconds)
 */
int
alarm (int seconds)
{
    int		prevtime;
    
    prevtime = gAlarmTimeout ? (gAlarmTimeout - (GetTickCount () / 1000)): 0;
    gAlarmTimeout = seconds ? (GetTickCount() / 1000) + seconds : 0;
    MyTimerSet ();
    return (prevtime);
}



/*
 * Deliver and clear the alarm.
 */
void
AlarmDeliver ()
{
    if (gSignalAlarm != SIG_DFL && gSignalAlarm != SIG_IGN) {
	/* Clear AlarmTimeout BEFORE calling handler.  handler may call back
	 * to reset timeout. */
	gAlarmTimeout = 0;
	MyTimerSet ();
	gSignalAlarm (SIGALRM);
    }
}



void
HUPDeliver ()
{
    if (gSignalHUP) {
	gSignalHUP (SIGHUP);
	exit (0);
    }
}




/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *        Printer font selection menu
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*
 * Set the print font to be the same as the window font.
 * Toggle setting.
 */
void
PrintFontSameAs (HWND hWnd)
{
    HDC			hDC;
    int			ppi;
    PTTYINFO		pTTYInfo;
    
    
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	return;
    
    if (gPrintFontSameAs) {
	    
	/* No longer same as window font.  Use window font as starting point
	 * for new printer font.  User may later modify printer font. */
	hDC = GetDC (hWnd);
	ppi = GetDeviceCaps (hDC, LOGPIXELSY);
	ReleaseDC (ghTTYWnd, hDC);
	ExtractFontInfo (&pTTYInfo->lfTTYFont, gPrintFontName, 
			&gPrintFontSize, gPrintFontStyle, ppi);
	gPrintFontSameAs = FALSE;
    }
    else {
	    
	/* Set to be same as the printer font.  Destroy printer font info
	 * and set "sameAs" flag to TRUE. */
	gPrintFontName[0] = '\0';
	gPrintFontSameAs = TRUE;
    }
    DidResize (gpTTYInfo);
}





void
PrintFontSelect (HWND hWnd)
{
    CHOOSEFONT		cfTTYFont;
    LOGFONT		newFont;
    DWORD		drc;
    int			ppi;
    HDC			hDC;

    

    hDC = GetDC (hWnd);
    ppi = GetDeviceCaps (hDC, LOGPIXELSY);
    ReleaseDC (ghTTYWnd, hDC);

    
    newFont.lfHeight =  -MulDiv (gPrintFontSize, ppi, 72);
    strcpy (newFont.lfFaceName, gPrintFontName);
    newFont.lfWeight = 0;
    if (strstr (gPrintFontStyle, "bold"))
	newFont.lfWeight = FW_BOLD;
    newFont.lfItalic = 0;
    if (strstr (gPrintFontStyle, "italic"))
	newFont.lfItalic = 1;

    newFont.lfWidth =          0;
    newFont.lfEscapement =     0;
    newFont.lfOrientation =    0;
    newFont.lfUnderline =      0;
    newFont.lfStrikeOut =      0;
    newFont.lfCharSet =        ANSI_CHARSET;
    newFont.lfOutPrecision =   OUT_DEFAULT_PRECIS;
    newFont.lfClipPrecision =  CLIP_DEFAULT_PRECIS;
    newFont.lfQuality =        DEFAULT_QUALITY;
    newFont.lfPitchAndFamily = FIXED_PITCH;
    

    cfTTYFont.lStructSize    = sizeof (CHOOSEFONT);
    cfTTYFont.hwndOwner      = hWnd ;
    cfTTYFont.hDC            = NULL ;
    cfTTYFont.rgbColors      = 0;
    cfTTYFont.lpLogFont      = &newFont;
    cfTTYFont.Flags          = CF_BOTH | CF_FIXEDPITCHONLY |
	    CF_INITTOLOGFONTSTRUCT | CF_ANSIONLY | 
	    CF_FORCEFONTEXIST | CF_LIMITSIZE;
    cfTTYFont.nSizeMin	     = FONT_MIN_SIZE;
    cfTTYFont.nSizeMax	     = FONT_MAX_SIZE;
    cfTTYFont.lCustData      = 0 ;
    cfTTYFont.lpfnHook       = NULL ;
    cfTTYFont.lpTemplateName = NULL ;
    cfTTYFont.hInstance      = GET_HINST (hWnd);


    if (ChooseFont (&cfTTYFont)) {
	ExtractFontInfo (&newFont, gPrintFontName, &gPrintFontSize, 
					gPrintFontStyle, ppi);
	DidResize (gpTTYInfo);
    }
    else
	/* So I can see with the debugger. */
	drc = CommDlgExtendedError();
}


void
ExtractFontInfo (LOGFONT *pFont, char *fontName, int *fontSize, 
					char *fontStyle, int ppi)
{
    char		*sep[] = {"", ", "};
    int			iSep = 0;

    
    strcpy (fontName, pFont->lfFaceName);

    *fontStyle = '\0';
    if (pFont->lfWeight >= FW_BOLD) {
	strcat (fontStyle, "bold");
	iSep = 1;
    }
    if (pFont->lfItalic) {
	strcat (fontStyle, sep[iSep]);
	strcat (fontStyle, "italic");
    }

    *fontSize = MulDiv (-pFont->lfHeight, 72, ppi);
}





    
	
LOCAL void
DidResize (PTTYINFO pTTYInfo)
{
    int			i;
    
    for (i = 0; i < RESIZE_CALLBACK_ARRAY_SIZE; ++i) {
	if (pTTYInfo->resizer[i] != NULL) 
	    pTTYInfo->resizer[i] (pTTYInfo->actNRow, pTTYInfo->actNColumn);
    }
    /*
     * Put a null character into the input queue so that the data input
     * loops stop and return to their callers who will then re-calculate the
     * mouse regions so that the user can click on the new regions of the
     * screen and have the right thing happen.
     */
    CQAdd (MSWIN_KEY_NODATA, 0);
}


	
    
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *        Cut, Copy, and Paste operations
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


/*
 * Gets called right before the menu is displayed so we can make
 * any last minute adjustments.
 */
LOCAL void
UpdateMenu (HWND hWnd)
{
    HMENU		hMenu;
    HMENU		hCmdMenu;
    BOOL		brc;
    PTTYINFO		pTTYInfo;
    int			i;
    
    pTTYInfo = (PTTYINFO) GetWindowLong (hWnd, GWL_PTTYINFO);
    if (pTTYInfo == NULL)
	return;

    hMenu = GetMenu (hWnd);
    if (hMenu == NULL)
	return;
    
    if (ghPaste == NULL) {
	/* 
	 * Not pasting.  If text is available on clipboard and we are
	 * at a place where we can paste, enable past menu option.
	 * Also check if we currently have a selection that can be copied
	 * or cut.  If so, we don't want to paste into a selection - it
	 * works but it is slow and probably not what the user intended.
	 */
	if (IsClipboardFormatAvailable (CF_TEXT) && gPasteEnabled && 
		gCopyCutFunction == NULL)
	    EnableMenuItem (hMenu, IDM_EDIT_PASTE, MF_BYCOMMAND | MF_ENABLED);
	else
	    EnableMenuItem (hMenu, IDM_EDIT_PASTE, MF_BYCOMMAND | MF_GRAYED);
	EnableMenuItem (hMenu, IDM_EDIT_CANCEL_PASTE, MF_BYCOMMAND | MF_GRAYED);
    }
    else {
	/* Currently pasting so disable paste and enable cancel paste. */
	EnableMenuItem (hMenu, IDM_EDIT_PASTE, MF_BYCOMMAND | MF_GRAYED);
	EnableMenuItem (hMenu, IDM_EDIT_CANCEL_PASTE, MF_BYCOMMAND | MF_ENABLED);
    }
    
    if (SelAvailable ()) {
	EnableMenuItem (hMenu, IDM_EDIT_CUT, MF_BYCOMMAND | MF_GRAYED);
	EnableMenuItem (hMenu, IDM_EDIT_COPY, MF_BYCOMMAND | MF_ENABLED);
	EnableMenuItem (hMenu, IDM_EDIT_COPY_APPEND, 
				MF_BYCOMMAND | MF_ENABLED);
    } else {
	if (gAllowCut)
	    EnableMenuItem (hMenu, IDM_EDIT_CUT, MF_BYCOMMAND | MF_ENABLED);
        else
	    EnableMenuItem (hMenu, IDM_EDIT_CUT, MF_BYCOMMAND | MF_GRAYED);

        if (gAllowCopy) {
	    EnableMenuItem (hMenu, IDM_EDIT_COPY, MF_BYCOMMAND | MF_ENABLED);
	    EnableMenuItem (hMenu, IDM_EDIT_COPY_APPEND, 
				MF_BYCOMMAND | MF_ENABLED);	
	}
        else {
	    EnableMenuItem (hMenu, IDM_EDIT_COPY, MF_BYCOMMAND | MF_GRAYED);
	    EnableMenuItem (hMenu, IDM_EDIT_COPY_APPEND, 
				MF_BYCOMMAND | MF_GRAYED);	
	}
    }



    /*
     * Set up Font selection menu
     */
    if (gPrintFontName[0] == '\0') {
	CheckMenuItem (hMenu, IDM_OPT_FONTSAMEAS, MF_BYCOMMAND | MF_CHECKED);
	EnableMenuItem (hMenu, IDM_OPT_SETPRINTFONT, 
						MF_BYCOMMAND | MF_GRAYED);
    }
    else {
	CheckMenuItem (hMenu, IDM_OPT_FONTSAMEAS, 
						MF_BYCOMMAND | MF_UNCHECKED);
	EnableMenuItem (hMenu, IDM_OPT_SETPRINTFONT, 
						MF_BYCOMMAND | MF_ENABLED);
    }

    
    /*
     * Check toolbar menu.
     */
    EnableMenuItem (hMenu, IDM_OPT_TOOLBAR, MF_BYCOMMAND | MF_ENABLED);
    CheckMenuItem (hMenu, IDM_OPT_TOOLBAR, MF_BYCOMMAND | 
	    (pTTYInfo->toolBarSize > 0 ? MF_CHECKED : MF_UNCHECKED));
    EnableMenuItem (hMenu, IDM_OPT_TOOLBARPOS, MF_BYCOMMAND | MF_ENABLED);
    CheckMenuItem (hMenu, IDM_OPT_TOOLBARPOS, MF_BYCOMMAND | 
	    (pTTYInfo->toolBarTop > 0 ? MF_CHECKED : MF_UNCHECKED));



    /*
     * Check the dialogs menu.
     */
    /* xxx EnableMenuItem (hMenu, IDM_OPT_USEDIALOGS, MF_BYCOMMAND | MF_ENABLED);*/
    CheckMenuItem (hMenu, IDM_OPT_USEDIALOGS, MF_BYCOMMAND | 
	    (gfUseDialogs ? MF_CHECKED : MF_UNCHECKED));
    CheckMenuItem (hMenu, IDM_OPT_USEACCEL, MF_BYCOMMAND | 
	    (pTTYInfo->hAccel ? MF_CHECKED : MF_UNCHECKED));


    /*
     * Set up command menu.
     */
    if (!pTTYInfo->menuItemsCurrent) {
	for (i = 0; i < KS_COUNT; ++i) {
#if 0
	    EnableMenuItem (hMenu, i + KS_RANGESTART, MF_BYCOMMAND | 
		 (pTTYInfo->menuItems[i].miActive ? MF_ENABLED : MF_GRAYED));
#else
	    if (pTTYInfo->menuItems[i].miActive)
		EnableMenuItem (hMenu, i + KS_RANGESTART, MF_BYCOMMAND | MF_ENABLED);
	    else
		EnableMenuItem (hMenu, i + KS_RANGESTART, MF_BYCOMMAND | MF_GRAYED);
#endif
	}
	pTTYInfo->menuItemsCurrent = TRUE;
    }
}



/*
 * Cut region to kill buffer.
 */
LOCAL void
EditCut (void)
{
    HANDLE		hCB;
    
    if(gCopyCutFunction == kremove){
	hCB = GlobalAlloc (GMEM_MOVEABLE, 0);
	if (hCB != NULL) {
	    kdelete();		/* Clear current kill buffer. */
	    killregion (1, 0);	/* Kill Region (and copy to clipboard). */
	    update ();		/* And update the screen */
        }
    }
}



/*
 * This function copies the kill buffer to the window's clip board.
 * (actually, it can copy any buffer for which a copyfunc is provided).
 * Called from ldelete().
 */
void
mswin_killbuftoclip (getc_t copyfunc)
{
    HANDLE		hCB;
    getc_t		oldfunc;
   
    /* Save old copy function. */
    oldfunc = gCopyCutFunction;
    gCopyCutFunction = copyfunc;
    
    /* Allocate clip buffer. */
    hCB = GlobalAlloc (GMEM_MOVEABLE, 0);
    if (hCB != NULL) {
	EditDoCopyData (hCB, 0);
    }
    
    /* restore copy function. */
    gCopyCutFunction = oldfunc;
}
	


/*
 * Copy region to kill buffer. 
 */
LOCAL void
EditCopy (void)
{
    HANDLE		hCB;
    
    if (SelAvailable()) {
	/* This is a copy of the windows selection. */
	hCB = GlobalAlloc (GMEM_MOVEABLE, 0);
	if (hCB != NULL) 
	    SelDoCopy (hCB, 0);
    } 
    else {
	    
	/* Otherwise, it's a Pico/Pine copy. */
	if(gCopyCutFunction == kremove){
	    kdelete();		/* Clear current kill buffer. */
	    copyregion (1, 0);
	}

	hCB = GlobalAlloc (GMEM_MOVEABLE, 0);
	if (hCB != NULL) 
	    EditDoCopyData (hCB, 0);
    }
}



/*
 * Called in responce to "Copy Append" menu command, when there is an active
 * Windows selection on the screen.
 */
LOCAL void
EditCopyAppend (void)
{
    HANDLE	hCB;
    HANDLE	hMyCopy;
    char	*pCB;
    char	*pMyCopy;
    size_t	cbSize;

    /* Attempt to copy clipboard data to my own handle. */
    hMyCopy = NULL;
    if (OpenClipboard (ghTTYWnd)) {		/* And can get clipboard. */
	hCB = GetClipboardData (CF_TEXT);
	if (hCB != NULL) {			/* And can get data. */
	    pCB = GlobalLock (hCB);
	    cbSize = strlen (pCB);		/* It's a null term string. */
	    hMyCopy = GlobalAlloc (GMEM_MOVEABLE, cbSize);
	    if (hMyCopy != NULL) {		/* And can get memory. */
		pMyCopy = GlobalLock (hMyCopy);
		if (pMyCopy != NULL) {
		    memcpy (pMyCopy, pCB, cbSize);  /* Copy data. */
		    GlobalUnlock (hMyCopy);
		}
		else {
		    GlobalFree (hMyCopy);
		    hMyCopy = NULL;
		}
	    }
	    GlobalUnlock (hCB);
	}					/* GetClipboardData. */
	CloseClipboard ();
    }					/* OpenClipboard. */
    


    /* Now, if I got a copy, append current selection to that
     * and stuff it back into the clipboard. */
    if (hMyCopy != NULL) {
	if (SelAvailable ()) {
	    SelDoCopy (hMyCopy, cbSize);
	}
	else {
	    if(gCopyCutFunction == kremove) {
		kdelete();		/* Clear current kill buffer. */
		copyregion (1, 0);
	    }
	    EditDoCopyData (hMyCopy, cbSize);
	}
    }
}









/*
 * Copy data from the kill buffer to the clipboard.  Handle LF->CRLF
 * translation if necessary.
 */
LOCAL void
EditDoCopyData (HANDLE hCB, DWORD lenCB)
{
    char		*pCB;
    char		*p;
    char		c;
    char		lastc = '\0';
    DWORD		cbSize;			/* Allocated size of hCB. */
    DWORD		i;
#define	BUF_INC	4096

    if (gCopyCutFunction != NULL) {		/* If there really is data. */
	if (OpenClipboard (ghTTYWnd)) {		/* ...and we get the CB. */
	    if (EmptyClipboard ()) {		/* ...and clear previous CB.*/
		pCB = GlobalLock (hCB);
		p = pCB + lenCB;
		cbSize = lenCB;
		/* Copy it. (BUG: change int arg) */
		for(i = 0L; (c = (*gCopyCutFunction)((int)i)) != -1; i++){
		    /*
		     * Rather than fix every function that might
		     * get called for character retrieval to supply
		     * CRLF EOLs, let's just fix it here.  The downside
		     * is a much slower copy for large buffers, but
		     * hey, what do they want?
		     */
		    if(lenCB + 2L >= cbSize){
			cbSize += BUF_INC;
			GlobalUnlock (hCB);
			hCB = GlobalReAlloc (hCB, cbSize, GMEM_MOVEABLE);
			if (hCB == NULL)
			  return;

			pCB = GlobalLock (hCB);
			p = pCB + lenCB;
		    }

		    if(c == ASCII_LF && lastc != ASCII_CR) {
		      *p++ = ASCII_CR;	/* insert CR before LF */
		      lenCB++;
		    }

		    *p++ = lastc = c;
		    lenCB++;
		}

		/* Only if we got some data. */
		if (lenCB > 0) {
		    *p = '\0';
		    GlobalUnlock (hCB);

		    if (SetClipboardData (CF_TEXT, hCB) == NULL)
		      /* Failed!  Free the data. */
		      GlobalFree (hCB);
		}
		else {
		    /* There was no data copied. */
		    GlobalUnlock (hCB);
		    GlobalFree (hCB);
		}
	    }
	    CloseClipboard (); 
        }
    }
}



/*
 * Get a handle to the current (text) clipboard and make my own copy.
 * Keep my copy locked because I'll be using it to read bytes from.
 */
LOCAL void
EditPaste (void)
{
    HANDLE	hCB;
    char	*pCB;
    char	*pPaste;
    size_t	cbSize;
   
    if (ghPaste == NULL) {		/* If we are not already pasting. */
	if (OpenClipboard (ghTTYWnd)) {		/* And can get clipboard. */
	    hCB = GetClipboardData (CF_TEXT);
	    if (hCB != NULL) {			/* And can get data. */
		pCB = GlobalLock (hCB);
		cbSize = strlen (pCB);		/* It's a null term string. */
		ghPaste = GlobalAlloc (GMEM_MOVEABLE, cbSize+1);
		if (ghPaste != NULL) {		/* And can get memory. */
		    gpPasteNext = GlobalLock (ghPaste);
		    memcpy (gpPasteNext, pCB, cbSize+1);  /* Copy data. */
		    /* Keep ghPaste locked. */

		    /*
		     * If we're paste is enabled but limited to the first
		     * line of the clipboard, prune the paste buffer...
		     */
		    if(gPasteEnabled == MSWIN_PASTE_LINE
		       && (pPaste = strchr(gpPasteNext, ASCII_CR))){
			*pPaste = '\0';
			cbSize  = strlen(gpPasteNext);
		    }

		    gPasteBytesRemain = cbSize;
		    gPasteWasCR = FALSE;
#ifdef FDEBUG
		    if (mswin_debug > 8) 
			fprintf (mswin_debugfile, "EditPaste::  Paste %d bytes\n",
				    gPasteBytesRemain);
#endif
		}
		GlobalUnlock (hCB);
	    }
	    CloseClipboard ();
        }
    }
}






/*
 * Cancel an active paste operation.
 */
LOCAL void
EditCancelPaste (void)
{
    HANDLE	hCB;
    char	*pCB;
    char	*pPaste;
    size_t	cbSize;
   
    if (ghPaste != NULL) {	/* Must be pasting. */
	GlobalUnlock (ghPaste);	/* Then Unlock... */
	GlobalFree (ghPaste);	/* ...and free the paste buffer. */
	ghPaste = NULL;		/* Indicates no paste data. */
	gpPasteNext = NULL;		/* Just being tidy. */
	gPasteBytesRemain = 0;	/* ditto. */
#ifdef FDEBUG
	if (mswin_debug > 8) 
	    fprintf (mswin_debugfile, "EditCancelPaste::  Free Paste Data\n");
#endif
    }
}


/*
 * Get the next byte from the paste buffer.  If all bytes have been
 * retreived, free the paste buffer.
 * Map all CRLF sequence to a single CR.
 */
LOCAL WORD
EditPasteGet (void)
{
    int	b = MSWIN_KEY_NODATA;

    if (ghPaste != NULL) {		/* ghPaste tells if we are pasting. */
	if (gPasteBytesRemain > 0) {	/* Just in case... */
					/* Get one byte and move pointer. */
	    b = (unsigned char) *gpPasteNext++;
	    --gPasteBytesRemain;	/*    one less. */
	    if (gPasteWasCR && b == ASCII_LF) {
		if (gPasteBytesRemain) {
					/* Skip of LF. */
		    b = (unsigned char) *gpPasteNext++;
		    --gPasteBytesRemain;
	        }
		else 
		    b = MSWIN_KEY_NODATA;  /* Ignore last LF. */
	    }
	    gPasteWasCR = (b == ASCII_CR);
#ifdef FDEBUG
	    if (mswin_debug > 8) 
		fprintf (mswin_debugfile, "EditPasteGet::  char %c, gPasteWasCR %d, gPasteBytesRemain %d\n",
			b, gPasteWasCR, gPasteBytesRemain);
#endif
        }
	if (gPasteBytesRemain <= 0) {	/* All Done? */
	    GlobalUnlock (ghPaste);	/* Then Unlock... */
	    GlobalFree (ghPaste);	/* ...and free the paste buffer. */
	    ghPaste = NULL;		/* Indicates no paste data. */
	    gpPasteNext = NULL;		/* Just being tidy. */
	    gPasteBytesRemain = 0;	/* ditto. */
#ifdef FDEBUG
	    if (mswin_debug > 8) 
		fprintf (mswin_debugfile, "EditPasteGet::  Free Paste Data\n");
#endif
        }
    }
    return (b);
}


/*
 * Return true if Paste data is available.  If gpPaste != NULL then there
 * is paste data.
 */
LOCAL BOOL
EditPasteAvailable (void)
{
    return (ghPaste != NULL);
}





LOCAL void
ShowHelp (void)
{
    size_t	len;
    
    if (gpHelpText != NULL || gpHelpLines != NULL) {
	mswin_displaytext (gpHelpTitle, gpHelpText, gpHelpLen,
			   gpHelpLines, 0, MSWIN_DT_NODELETE);
    }
}





/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *                 Adjust the timer fewquency as needed.
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

LOCAL void
MyTimerSet (void)
{
    UINT	period;
    /* Decide on period to use. */
    if (gAllowMouseTrack)
	period = MY_TIMER_EXCEEDINGLY_SHORT_PERIOD;
    else if (gAlarmTimeout != 0)
	period = MY_TIMER_VERY_SHORT_PERIOD;
    else if (gOnTaskList != NULL)
	period = MY_TIMER_SHORT_PERIOD;
    else
	period = MY_TIMER_PERIOD;

    if (period != gTimerCurrentPeriod) {
	if (SetTimer (ghTTYWnd, MY_TIMER_ID, period, NULL) == 0) 
		MessageBox (ghTTYWnd, TIMER_FAIL_MESSAGE, NULL, 
			     MB_OK | MB_ICONINFORMATION);
        else
	    gTimerCurrentPeriod = period;
    }
}





void
mswin_setperiodiccallback (callback_t periodiccb, long period)
{
    if (periodiccb != NULL && period > 0) {
	gPeriodicCallback = periodiccb;
	gPeriodicCBTime = period;
	gPeriodicCBTimeout = GetTickCount () / 1000 + gPeriodicCBTime;
    }
    else {
	gPeriodicCallback = NULL;
    }
}





/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *                  On Task processing
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


WINHAND
mswin_inst2task (WINHAND hModule)
{
#ifndef	WIN32
    TASKENTRY		te;
    MODULEENTRY		me;
    BOOL		brc;
    

    memset (&te, 0, sizeof (te));
    te.dwSize = sizeof (te);
    
#ifdef FDEBUG
    if (mswin_debug >= 8) 
	fprintf (mswin_debugfile, "mswin_inst2task:  look for x%x\n", hModule);
#endif

    brc = TaskFirst (&te);
    while (brc) {
#ifdef FDEBUG
	if (mswin_debug >= 8)
	    fprintf (mswin_debugfile, "  task:  '%s', hTask x%x, module x%x, inst x%x\n", 
		    te.szModule, (UINT) te.hTask, (UINT) te.hModule, 
		    (UINT) te.hInst);
#endif
	if (te.hModule == (HMODULE)hModule)
	    return ((WINHAND)te.hTask);
	if (te.hInst == (HINSTANCE)hModule)
	    return ((WINHAND)te.hTask);
	brc = TaskNext (&te);
    }
#endif
    return (0);
}
    
    


/*
 * Register a file deletion operation when hTask goes away.
 */
int		
mswin_ontask_del (WINHAND hTask, char *path)
{
    OnTaskItem		*ot;
    BOOL		wasEmpty;
    
    ot = MemAlloc (sizeof (OnTaskItem));
    if (ot == NULL)
	return (-1);

    wasEmpty = (gOnTaskList == NULL);
    ot->hTask = (HTASK) hTask;
    strncpy (ot->path, path, PATH_MAX);
    ot->path[PATH_MAX] = '\0';
    ot->next = gOnTaskList;
    gOnTaskList = ot;
    MyTimerSet ();
    return (0);
}


/*
 * Execute command and wait for the 
 */
int
mswin_exec_and_wait (char *whatsit, char *command)
{
    MEvent		mouse;
    BOOL		brc;
    int			rc;
    char		waitingFor[256];
#ifdef	WIN32
    STARTUPINFO		start_info;
    PROCESS_INFORMATION	proc_info;
    DWORD		exit_code;

    mswin_flush ();

    memset(&proc_info, 0, sizeof(proc_info));
    memset(&start_info, 0, sizeof(start_info));
    start_info.dwFlags	    = STARTF_FORCEONFEEDBACK;
    start_info.wShowWindow  = SW_SHOWNORMAL;

    if(CreateProcess(NULL, command, NULL, NULL, FALSE,
		     CREATE_NEW_CONSOLE | CREATE_NEW_PROCESS_GROUP,
		     NULL, NULL, &start_info, &proc_info) == TRUE){

	sprintf (waitingFor, "%s is currently waiting for the %s (%s) to complete.  Click \"Cancel\" to stop waiting, or \"OK\" to continue waiting.",
		 gszAppName, whatsit, command);

	/*
	 * Go into holding pattern until the other application terminates
	 * or we are told to stop waiting.
	 */
	while(GetExitCodeProcess(proc_info.hProcess, &exit_code) == TRUE){
	    if(exit_code == STILL_ACTIVE){
		rc = mswin_getc();
		brc = mswin_getmouseevent (&mouse);

		if (rc != MSWIN_KEY_NODATA || 
		    (brc && mouse.event == M_EVENT_DOWN)) {

		    rc = MessageBox (ghTTYWnd, waitingFor, whatsit, 
				     MB_ICONSTOP | MB_OKCANCEL);
		    SelClear ();
		    if (rc == IDCANCEL){
			/* terminate message to child ? */
			return (-2);
		    }
		}
	    }
	    else{
		/* do something about child's exit status */
		break;
	    }
	}

	if (gpTTYInfo->fMinimized) 
	  ShowWindow (ghTTYWnd, SW_SHOWNORMAL);

	BringWindowToTop (ghTTYWnd);
	return (0);
    }
    else{
	return((rc = (int) GetLastError()) ? rc : -1);		/* hack */
    }
#else
    HTASK	hTask;
    UINT	urc;
    
    
    mswin_flush ();
    
    urc = WinExec (command, SW_SHOW);
#ifdef FDEBUG
    if (mswin_debug >= 8) {
	fprintf (mswin_debugfile, "mswin_exec_and_wait:  command '%s'\n", command);
	fprintf (mswin_debugfile, "                      WinExec returns module x%x\n",
		urc);
    }
#endif

    if (urc < 32) 
	return ((int)urc);

    hTask = (HTASK) mswin_inst2task (urc);

#ifdef FDEBUG
    if (mswin_debug >= 8) 
	fprintf (mswin_debugfile, "mswin_exec_and_wait:  module maps to task x%x, wait for it to finish\n",
		(UINT) hTask);
#endif

    if (hTask == NULL)
	return (-1);
    
    sprintf (waitingFor, "%s is currently waiting for the %s (%s) to complete.  Click \"Cancel\" to stop waiting, or \"OK\" to continue waiting.",
	    gszAppName, whatsit, command);
    

    /*
     * Go into holding pattern until the other application terminates
     * or we are told to stop waiting.
     */
    while (IsTask (hTask)) {
	rc = mswin_getc();
	brc = mswin_getmouseevent (&mouse);

	if (rc != MSWIN_KEY_NODATA || 
		(brc && mouse.event == M_EVENT_DOWN)) {
	
	    rc = MessageBox (ghTTYWnd, waitingFor, whatsit, 
		    MB_ICONSTOP | MB_OKCANCEL);
	    SelClear ();
	    if (rc == IDCANCEL)
		 return (-2);
	}
    }
    if (gpTTYInfo->fMinimized) 
	ShowWindow (ghTTYWnd, SW_SHOWNORMAL);
    BringWindowToTop (ghTTYWnd);
    return (0);
#endif
}




/*
 * Generate an error message for a failed windows exec or loadlibrary.
 */
void
mswin_exec_err_msg (char *what, int status, char *buf, int buflen)
{
    switch (status) {
    case 2:
    case 3:
	wsprintf (buf, "%s not found.", what);
	break;
	
    case 8:
	wsprintf (buf, "Not enough memory to run %s.", what);
	break;
	
    default:
	wsprintf (buf, "Error %d starting %s.", status, what);
	break;
    }
}

	    




LOCAL void
ProcessOnTask (void)
{
    OnTaskItem		*ot, *pot, *not;
    BOOL		wasEmpty, isRunning;
    static BOOL		InOnTask = FALSE;
#ifdef	WIN32
    DWORD		exit_code;
#endif
    
    if (gOnTaskList == NULL) 
	return;

    if (InOnTask)
	return;
    InOnTask = TRUE;

    /* Scann through list. */
    wasEmpty = (gOnTaskList == NULL);
    ot = gOnTaskList;
    while (ot != NULL) {
	not = ot->next;
	
	/* 
	 *  If ot->hTask is gone then perform the action.
	 */
#ifdef	WIN32
	if((isRunning = GetExitCodeProcess (ot->hTask, &exit_code))
	   && exit_code != STILL_ACTIVE)
	  isRunning = FALSE;
#else
	isRunning = IsTask (ot->hTask);
#endif
	if (!isRunning) {

	    /* Perform action.*/
	    unlink (ot->path);
	    
	    /* Remove item. */
	    if (ot == gOnTaskList) {
		/* Remve from head of list. */
		gOnTaskList = not;
	    } else {
		/* Remove from middle of list - find previous. */
		for (pot = gOnTaskList; pot != NULL && pot->next != ot; 
							pot = pot->next);
		if (pot != NULL) 					
		    pot->next = not;
	    }
	    MemFree (ot);
        }
		
	ot = not;
    }
    MyTimerSet ();
    InOnTask = FALSE;
}






/*
 * Register a file deletion operation when hTask goes away.
 */
int		
mswin_onexit_del (char *path)
{
    OnTaskItem		*ot;
    BOOL		wasEmpty;
    
    ot = MemAlloc (sizeof (OnTaskItem));
    if (ot == NULL)
	return (-1);

    ot->hTask = NULL;
    strncpy (ot->path, path, PATH_MAX);
    ot->path[PATH_MAX] = '\0';
    ot->next = gOnExitList;
    gOnExitList = ot;
    return (0);
}






/*
 * Called when exiting.  Perform any on-exit actions.
 *
 * (This was originally implemented to delete temp files that got left
 *  around when the user ended the windows session, which closed pine
 *  with no shutdown.  See WM_ENDSESSION.)
 */
LOCAL void
ProcessOnExit (void)
{
    OnTaskItem		*ot, *pot, *not;
    static BOOL		InOnExit = FALSE;
    
    if (gOnExitList == NULL) 
	return;

    if (InOnExit)
	return;
    InOnExit = TRUE;

    /* Scann through list. */
    ot = gOnExitList;
    while (ot != NULL) {
	not = ot->next;
	
	/* Perform action.*/
	unlink (ot->path);

	/* Remove item (always from head). */
	gOnExitList = not;
	MemFree (ot);
	ot = not;
    }
    InOnExit = FALSE;
}



int
mswin_set_quit_confirm (int confirm)
{
    gConfirmExit = (confirm != 0);
    return (confirm);
}



/*
 * Called when Windows is in shutting down.  Before actually shutting down
 * Windows goes around to all the applications and asks if it is OK with
 * them to shut down (WM_QUERYENDSESSION).  
 * If gConfirmExit is set, ask the user if they want to exit.
 * Returning zero will stop the shutdown, non-zero allows it to proceed.
 */
LOCAL LRESULT
ConfirmExit (void)
{
    char	msg[256];
    int		rc;
    
    if (gConfirmExit) {
	sprintf (msg, "Exiting may cause you to loose work in %s, Exit?",
		gszAppName);
	rc = MessageBox (ghTTYWnd, msg, gszAppName, 
		MB_ICONSTOP | MB_OKCANCEL);
	if (rc == IDCANCEL)
	    return (0);
    }
    return (1);
}

	     



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *                  Text display Windows.
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#define TW_TEXTBLOCK	1
#define TW_TEXTLINES	2


/*
 * TextWndInfo is used to keep track of each text window.
 *
 * Selections:
 *  The "dot" and the "mark" are used for the selection.  When the user
 *  pushes the mouse button down that sets the "dot".  As the user
 *  drags the mouse across text, that moves the "mark" Text between the
 *  two points is the selection.  dot and mark are not orderd.  The
 *  selection starts with the character pointed to by the first, and
 *  ends BEFORE the character pointed to be the second.
 *
 *  Each line has a logical line terminator character.  When the
 *  selection ends at the end of a line, the logical line terminator is
 *  NOT included When the selection ends at the beginning of the next
 *  line, the logical line terminator IS included.  For text with lines
 *  0 to N, a selection ending at line N+1, character 0 would include
 *  the last line and its logical line terminator.
 *
 */

typedef struct text_wnd_info {
    char	*text;		/* Pointer to big block of text. */
    char	**lines;	/* Pointer to array of line starts. */
    UINT	lineCount;	/* Count of lines. */
    int		textAs;		/* How text stored in memory. */
    int		flags;		/* Flag special behavior. */
    long	curLine;	/* Current line (scroll position). */
    int		xChar, yChar;	/* Size of a character. */
    int		xSize, ySize;	/* Window size. */
    int		nRows;		/* Number of rows fit on screen. */
    int		nCols;		/* Number of columns fit on screen. */
    long	dotLine;	/* Line on which dot is located. */
    long	dotChar;	/* Char in line on which dot is located. */
    long	markLine;	/* Line on which mark is located. */
    long	markChar;	/* Char in line on which mark is located. */
    BOOL	tracking;	/* TRUE when tracking mouse. */
    int		scrollDirect;	/* Direction to scroll. */
    HFONT	hFont;		/* Font in use. */
    DWORD	rgbFGColor;	/* Normal forground color. */
    DWORD	rgbBGColor;	/* Normal background color. */
    DWORD	rgbRFGColor;	/* Reverse forground color. */
    DWORD	rgbRBGColor;	/* Reverse background color */
} TextWndInfo;





#define TWS_UP		-1
#define TWS_OFF		0
#define TWS_DOWN	1
#define TWS_TIMERID	1
#define TWS_TIMEOUT	50


/*
 * Free text data associated with a TextWindInfo structure, but not the
 * structure itself.
 */
LOCAL void
TWFreeData (TextWndInfo *ptwInfo)
{
    char **l;
    
    if (!(ptwInfo->flags & MSWIN_DT_NODELETE)) {
	if (ptwInfo->textAs == TW_TEXTBLOCK) 
	    MemFree (ptwInfo->text);
	else {
	    for (l = ptwInfo->lines; *l != NULL; ++l)
		MemFree (*l);
	}
	MemFree (ptwInfo->lines);
    }
}


    
    
    
    
/*
 * Show a help message.
 * Help text comes as a null terminated array of pointers to lines of 
 * text.  Stuff these into a buffer and pass that to MessageBox.
 */
void
mswin_showhelpmsg (WINHAND wnd, char **helplines)
{
    char	**l;
    char	*helptext;
    int		buflen;
    HWND	hWnd;
    
    hWnd = (HWND) wnd;
    if (hWnd == NULL) 
	hWnd = ghTTYWnd;
    
    
    buflen = 0;
    for (l = helplines; *l != NULL; ++l) 
	buflen += lstrlen (*l);

    helptext = MemAlloc (buflen + 1);
    if (helptext == NULL)
	return;
    *helptext = '\0';
    for (l = helplines; *l != NULL; ++l)
	strcat (helptext, *l);   

    MessageBox (hWnd, helptext, "Help", 
		MB_APPLMODAL | MB_ICONINFORMATION | MB_OK);
    MemFree (helptext);
}

    




/*
 * Display text in a window.
 *
 * Parameters:
 *	title		- Title of window.
 *	pText		- address of text to display.
 *	textLen		- Length of text, in bytes.  Limited to 64K.
 *	pLines		- Array of pointers to lines of text.  Each
 *			  line is a sepreate allocation block.  The
 *			  entry in the array of pointers should be a 
 *			  NULL.
 *			  
 * The text can be supplied as a buffer (pText and textLen) in which
 * lines are terminated by CRLF (including the last line in buffer).
 * Or it can be supplied as a NULL terminated array of pointers to
 * lines.  Each entry points to a seperatly allocated memory block
 * containing a null terminated string.
 *
 * If the function succeeds the memory containing the text will be
 * used until the user closes the window, at which point it will be
 * freed.
 *
 * Returns:
 *	handle to the created window - SUCCESS
 *	-1			     - Failed.
 */ 
int
mswin_displaytext (char *title, char *pText, size_t textLen, char **pLines, 
	int windRef, int flags)
{
    TextWndInfo		*ptwInfo;
    HWND		hWnd;
    HDC			hDC;
    TEXTMETRIC		tm;
    char		*p;
    char		**l;
    UINT		lineCount;
    int			textAs;
    UINT		i;
    RECT		rSize;
    DWORD		dwStyle;
    

    if (pText == NULL && pLines == NULL)
	return (-1);

    /* 
     * How was text supplied?
     */
    if (pLines != NULL) {
	    
	/* Array of pointers to lines supplied. Count lines. */
	lineCount = 0;
	for (l = pLines; *l != NULL; ++l)
	    ++lineCount;
	if (lineCount == 0)
	    return (-1);
        textAs = TW_TEXTLINES;
    }
    else {
	    
	/* Pointer to block of text supplied. */
	if (textLen == 0)
	    return (-1);
	lineCount = 0;
	for (p = pText+1, i = textLen - 1; i > 0; ++p, --i) {
	    if (*(p-1) == ASCII_CR && *p == ASCII_LF) 
		++lineCount;
	}

	if (lineCount == 0) 
	    return (-1);


	pLines = (char **) MemAlloc (sizeof (char *) * (lineCount+1));
	if (pLines == NULL) 
	    return (-1);


	/* Fill the lines array. */
	l = pLines;
	*l = pText;
	for (p = pText+1, i = textLen - 1; i > 0; ++p, --i) {
	    if (*(p-1) == ASCII_CR && *p == ASCII_LF) {
		*(p-1) = '\0';
		*(++l) = p+1;
	    }
	}
	
	/* Add a NULL terminator just for form. */
	*(pLines + lineCount) = NULL;

	textAs = TW_TEXTBLOCK;
    }

    
    /* Was a valid existing window supplied? */
    if (IsWindow((HWND)windRef)) {
	/* Get associated structure. */
	ptwInfo = (TextWndInfo *) GetWindowLong ((HWND)windRef, GWL_PTEXTINFO);
	if (ptwInfo != NULL) 
	    hWnd = (HWND) windRef;	/* Valid window. */
	else
	    windRef = 0;		/* Invalid window. */
    }
    else 
	windRef = 0;			/* Invalid window. */
    

    /* Allocate a control structrue for window, or free contents of
     * existing structure. */
    if (windRef == 0) {
	ptwInfo = (TextWndInfo *) MemAlloc (sizeof (TextWndInfo));
	if (ptwInfo == NULL) {
	    if (textAs == TW_TEXTBLOCK)
		MemFree (pLines);
	    return (-1);
	}
	memset (ptwInfo, 0, sizeof (TextWndInfo));
    }
    else {
	TWFreeData (ptwInfo);
	ptwInfo->dotLine = 0;
	ptwInfo->dotChar = 0;
	ptwInfo->markLine = 0;
	ptwInfo->markChar = 0;
	ptwInfo->tracking = FALSE;
    }
	
	
    
    ptwInfo->flags = flags;
    ptwInfo->text = pText;
    ptwInfo->lines = pLines;
    ptwInfo->lineCount = lineCount;
    ptwInfo->textAs = textAs;
    ptwInfo->curLine = 0;


    /* Create a new window or use existing. */
    if (windRef == 0) {
	rSize.left = 0;
	rSize.right = (MARGINE_LEFT * 2) + (gpTTYInfo->xChar * 80);
	rSize.top = 0;
	rSize.bottom = gpTTYInfo->ySize;
	dwStyle = WS_OVERLAPPEDWINDOW | WS_VSCROLL;
	AdjustWindowRect (&rSize, dwStyle, TRUE);
	rSize.right += 16;
	hWnd = CreateWindow (gszTextClass, title,
			   dwStyle,
			   CW_USEDEFAULT, CW_USEDEFAULT,
			   rSize.right - rSize.left, rSize.bottom - rSize.top,
			   HWND_DESKTOP, NULL, ghInstance, ptwInfo);


	if (hWnd == NULL) {
	    MemFree (ptwInfo);
	    if (textAs == TW_TEXTBLOCK)
		MemFree (pLines);
	    return (-1);
	}
	ptwInfo->hFont = gpTTYInfo->hTTYFont;

	hDC = GetDC (hWnd);
	SelectObject (hDC, ptwInfo->hFont);
	GetTextMetrics (hDC, &tm);
	ReleaseDC (hWnd, hDC);
	ptwInfo->xChar = tm.tmAveCharWidth;
	ptwInfo->yChar = tm.tmHeight + tm.tmExternalLeading;

	ptwInfo->rgbFGColor = gpTTYInfo->rgbFGColor;	
	ptwInfo->rgbBGColor = gpTTYInfo->rgbBGColor;	
	ptwInfo->rgbRFGColor = gpTTYInfo->rgbRFGColor;
	ptwInfo->rgbRBGColor = gpTTYInfo->rgbRBGColor;
    }
    else {
	/* Invalidate whole window, change title, and move to top. */
	InvalidateRect (hWnd, NULL, TRUE);
	SetWindowText (hWnd, title);
	SetWindowPos (hWnd, HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
        SetScrollPos (hWnd, SB_VERT,  (int)(gpTTYInfo->scrollPos = 0L), TRUE);
    }
    
    
    SetWindowLong (hWnd, GWL_PTEXTINFO, (LPARAM) ptwInfo);
    SetScrollRange (hWnd, SB_VERT, 0, (int)ptwInfo->lineCount - 1, FALSE);
    SetScrollPos (hWnd, SB_VERT, 0, FALSE);

    ShowWindow (hWnd, SW_SHOW);
    UpdateWindow (hWnd);
    return ((int)hWnd);
}






LRESULT FAR PASCAL __export 
TWWndProc (HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    TextWndInfo		*ptwInfo;
    char		**l;
    
    
    switch (uMsg) {
    case WM_CREATE:
	break;
	
    case WM_COMMAND:
	switch ((WORD) wParam) {
	case IDM_FILE_CLOSE:
	    DestroyWindow (hWnd);
	    break;
	    
	case IDM_FILE_PRINT:
	    TWPrint (hWnd);
	    break;
	    
	case IDM_EDIT_COPY:
	    TWEditCopy (hWnd);
	    break;

	default:
	    return (DefWindowProc (hWnd, uMsg, wParam, lParam));
        }
	break;
	    
	 
    case WM_VSCROLL:
#ifdef	WIN32
	TWScroll (hWnd, LOWORD(wParam), HIWORD(wParam));
#else
	TWScroll (hWnd, wParam, LOWORD (lParam));
#endif
	break;
	
    case WM_KEYDOWN:
	if (TWKeyDown (hWnd, LOBYTE (wParam), (DWORD)lParam))
	    return (0);
        return( DefWindowProc( hWnd, uMsg, wParam, lParam ) ) ;
	
    case WM_CHAR:
	TWChar (hWnd, wParam, lParam);
	break;

    case WM_LBUTTONDOWN:
	TWMouseDown (hWnd, 1, LOWORD (lParam), HIWORD (lParam), wParam);
	break;

    case WM_LBUTTONUP:
	TWMouseUp (hWnd, 1, LOWORD (lParam), HIWORD (lParam), wParam);
	break;

    case WM_MOUSEMOVE:
	TWMouseTrack (hWnd, LOWORD (lParam), HIWORD (lParam));
	break;

    case WM_ERASEBKGND:
	TWErase (hWnd, (HDC) wParam);
	break;
	
    case WM_PAINT:
	TWPaint (hWnd);
	break;

    case WM_SIZE:
	TWSetSize (hWnd, wParam, HIWORD(lParam), LOWORD(lParam));
        break ;
	
    case WM_TIMER:
	TWScrollTimer (hWnd);
	break;
	
    case WM_CLOSE:
	DestroyWindow (hWnd);
	break;
	
    case WM_DESTROY:
	ptwInfo = (TextWndInfo *) GetWindowLong (hWnd, GWL_PTEXTINFO);
	if (ptwInfo != NULL) {
	    TWFreeData (ptwInfo);
	    MemFree (ptwInfo);
        }
	break;
	 
    default:
        return (DefWindowProc (hWnd, uMsg, wParam, lParam));
    }
    return (0);
}



LOCAL BOOL
TWErase (HWND hWnd, HDC hDC)
{
    RECT		erect;
    HBRUSH		hBrush;
    TextWndInfo		*ptwInfo;

    ptwInfo = (TextWndInfo *) GetWindowLong (hWnd, GWL_PTEXTINFO);
    if (ptwInfo == NULL) 
	return (FALSE);
    

    GetClientRect (hWnd, &erect);
    hBrush = CreateSolidBrush (ptwInfo->rgbBGColor);
    if (hBrush != NULL) {
	FillRect (hDC, &erect, hBrush);
	DeleteObject (hBrush);
    }
    return (TRUE);
}



LOCAL void
TWPaint (HWND hWnd)
{
    TextWndInfo		*ptwInfo;
    PAINTSTRUCT		ps;
    HDC			hDC;
    HFONT		hOldFont;
    HBRUSH		hBrush;
    int			nRow, nEndRow;		/* screen row being painted.*/
    int			nCol;			/* position in current line */
    long		nLine;			/* Line number being painted*/
#define LINE_BUF_SIZE  256
#define TAB_SIZE       8
    char		lineBuf[LINE_BUF_SIZE];
    char		*text;			/* text being painted. */
    int			c, t;
    RECT		rect;			/* Rect surrounding line. */
    int			lineLen;		/* # chars in line. */
    int			writeLen;		/* # chars being painted. */
    UINT		topLine;
    int			nVertPos;
    BOOL		selend;
    long		selStartLine, selEndLine;
    long		selStartChar, selEndChar;
    
    
    /* If I got the window set up right I don't expect to be called to
     * paint the ICON, but... */
    if (IsIconic (hWnd))
	return;
    
   
    ptwInfo = (TextWndInfo *) GetWindowLong (hWnd, GWL_PTEXTINFO);
    if (ptwInfo == NULL) 
	return;


    /* Scroll Position is top line in window */
    topLine = ptwInfo->curLine;
    
    
    hDC = BeginPaint (hWnd, &ps);
    
    
    hOldFont = SelectObject (hDC, ptwInfo->hFont);
    SetTextColor (hDC, ptwInfo->rgbFGColor);
    SetBkColor (hDC, ptwInfo->rgbBGColor);
    SetBkMode (hDC, OPAQUE);
    
    /* Get the Paint rectange and calculate start and end rows. */
    rect = ps.rcPaint;
    nRow = max (0, (rect.top - MARGINE_TOP) / ptwInfo->yChar);
    nEndRow = max (0, (rect.bottom - MARGINE_TOP - 1) / ptwInfo->yChar);
    nCol = 0;
    
    
    /* Order the dot and mark. */
    if (ptwInfo->dotLine < ptwInfo->markLine || 
	    (ptwInfo->dotLine == ptwInfo->markLine  &&
	     ptwInfo->dotChar < ptwInfo->markChar)) {
	selStartLine = ptwInfo->dotLine;
	selStartChar = ptwInfo->dotChar;
	selEndLine = ptwInfo->markLine;
	selEndChar = ptwInfo->markChar;
    }
    else {
	selStartLine = ptwInfo->markLine;
	selStartChar = ptwInfo->markChar;
	selEndLine = ptwInfo->dotLine;
	selEndChar = ptwInfo->dotChar;
    }
    
    
    /*
     * xxx erase top and left margine.
     */


    text = NULL;
    for (; nRow <= nEndRow && topLine + nRow < ptwInfo->lineCount; ) {
	    
	/* Which line? */
	nLine = topLine + nRow;

	/* Expand tabs by copying line. */
	if (text == NULL) {
	    text = *(ptwInfo->lines + nLine);
	    lineLen = strlen (text);
	    c = 0;
	    t = 0;
	    while (c < LINE_BUF_SIZE - TAB_SIZE - 1 && t < lineLen) {
	        if (*text == '\t') {
		    do {
			lineBuf[c++] = ' ';
	            } while (c % TAB_SIZE != 0);
	        }
		else
		    lineBuf[c++] = *text;
	        ++text;
		++t;
	    }
	    lineBuf[c] = '\0';
	    lineLen = c;
	    text = lineBuf;
	}
		

	/* 
	 * Calculate the run length of this write.  run length extends
	 * to the next change in selection or (usualy) the end of the 
	 * line. 
	 */
	selend = FALSE;
	writeLen = lineLen - nCol;
	if (selEndLine == nLine && selEndChar > nCol) {
	    writeLen = selEndChar - nCol;
	    selend = TRUE;
        }
	if (selStartLine == nLine && selStartChar > nCol) 
	    writeLen = selStartChar - nCol;

    
	/*
	 * Calculate the bounding rectangle.  
	 * When the text includes the end of the line the bounding
	 * rectange extends to the right side of the window so that the
	 * end of the line gets drawn with the correct colors.
	 * The exception is when the selection ends at the end of the line.
	 * This special case is also handled below.
	 */
	nVertPos = (nRow * ptwInfo->yChar) + MARGINE_TOP;
	rect.top = nVertPos;
	rect.bottom = min (nVertPos + ptwInfo->yChar, 
				ptwInfo->ySize - FRAME_3D_SIZE);
	rect.left = (nCol * ptwInfo->xChar) + MARGINE_LEFT;
	if (nCol + writeLen >= lineLen && !selend) 
	    rect.right = ptwInfo->xSize - FRAME_3D_SIZE;
        else
	    rect.right = ((nCol + writeLen) * ptwInfo->xChar) + MARGINE_LEFT;
	
	

	/*
	 * Select normal or inverted colors.
	 */
	if ((nLine > selStartLine || 
			(nLine == selStartLine && nCol >= selStartChar)) && 
	    (nLine < selEndLine ||
			(nLine == selEndLine && nCol < selEndChar))) {
	    /* Inverted. */
	    SetTextColor (hDC, ptwInfo->rgbRFGColor);
	    SetBkColor (hDC, ptwInfo->rgbRBGColor);
	}
	else {
	    /* Normal. */
	    SetTextColor (hDC, ptwInfo->rgbFGColor);
	    SetBkColor (hDC, ptwInfo->rgbBGColor);
	}

	
	/*
	 * Draw the text.
	 */
	ExtTextOut (hDC, rect.left, nVertPos, ETO_OPAQUE | ETO_CLIPPED, 
		&rect, text+nCol, writeLen, NULL);
	
	
	/*
	 * If the selection ends at the end of a line I need to erase
	 * the blank space after the line.
	 */
	if (selend) {
	    rect.left = ((nCol + lineLen) * ptwInfo->xChar) + MARGINE_LEFT;
	    rect.right = ptwInfo->xSize - FRAME_3D_SIZE;
	    hBrush = CreateSolidBrush (ptwInfo->rgbBGColor);
	    if (hBrush != NULL) {
		    FillRect (hDC, &rect, hBrush);
		    DeleteObject (hBrush);
	    }
        }
	    
	
	nCol += writeLen;
	if (nCol >= lineLen) {
	   ++nRow;
	   nCol = 0;
	   text = NULL;
	}
    }
    
    
    /* Erase any section of the screen that did not have a line draw
     * on it. */
    if (nRow <= nEndRow) {
	rect.top = (nRow * ptwInfo->yChar) + MARGINE_TOP;
	rect.right = FRAME_3D_SIZE;
	rect.left = ptwInfo->xSize - FRAME_3D_SIZE;
	rect.bottom = ptwInfo->ySize - FRAME_3D_SIZE;
	FillRectColor (hDC, &rect, ptwInfo->rgbBGColor);
    }
	
    
    
    /* In Windows 95 draw an inset 3d frame. */
    if (gUse3DFrame) {
	rect.top = 0;
	rect.bottom = ptwInfo->ySize;
	rect.left = 0;
	rect.right = ptwInfo->xSize;
	FrameRect3D (hDC, &rect, FRAME_3D_SIZE, FALSE);
    }
    
    
    
    
    SelectObject (hDC, hOldFont);
    EndPaint (hWnd, &ps);
    return;
}



/*
 * Scroll the text window.
 */
LOCAL void
TWScroll (HWND hWnd, int wScrollCode, int nPos)
{
    TextWndInfo		*ptwInfo;
    BOOL		fRepaint;
    RECT		rect;

    ptwInfo = (TextWndInfo *) GetWindowLong (hWnd, GWL_PTEXTINFO);
    if (ptwInfo == NULL) 
	return;

    rect.top = 0 + FRAME_3D_SIZE;
    rect.bottom =  ptwInfo->ySize - FRAME_3D_SIZE;
    rect.left = 0 + FRAME_3D_SIZE;
    rect.right = ptwInfo->xSize - FRAME_3D_SIZE;



    fRepaint = FALSE;
    
    switch (wScrollCode) {
    case SB_BOTTOM:
	ptwInfo->curLine = ptwInfo->lineCount - 1;
	fRepaint = TRUE;
	break;
	
    case SB_TOP:
	ptwInfo->curLine = 0;
	fRepaint = TRUE;
	break;
	
    case SB_LINEDOWN:
	if (ptwInfo->curLine < ptwInfo->lineCount - 1) {
	    ++ptwInfo->curLine;
	    ScrollWindow (hWnd, 0, -ptwInfo->yChar, NULL, &rect);
        }
        break;

    case SB_LINEUP:
	if (ptwInfo->curLine > 0) {
	    --ptwInfo->curLine;
	    ScrollWindow (hWnd, 0, ptwInfo->yChar, NULL, &rect);

	    /*
	     * ScrollWindow() invalidates part of the window, but does not
	     * invalidate enough.  Do that here.
	     */
	    rect.top = 0;
	    rect.bottom =  ptwInfo->yChar + MARGINE_TOP;
	    rect.left = 0;
	    rect.right = ptwInfo->xSize;
	    InvalidateRect (hWnd, &rect, FALSE);
        }
        break;

    case SB_PAGEDOWN:
	ptwInfo->curLine += ptwInfo->nRows;
	if (ptwInfo->curLine > ptwInfo->lineCount - 1)
	    ptwInfo->curLine = ptwInfo->lineCount - 1;
	fRepaint = TRUE;
        break;

    case SB_PAGEUP:
	ptwInfo->curLine -= ptwInfo->nRows;
	if (ptwInfo->curLine < 0)
	    ptwInfo->curLine = 0;
	fRepaint = TRUE;
        break;
	
    case SB_THUMBPOSITION:
    case SB_THUMBTRACK:
	ptwInfo->curLine = nPos;
	fRepaint = TRUE;
        break;

    }

    SetScrollPos (hWnd, SB_VERT, (int)ptwInfo->curLine, TRUE);
    if (fRepaint)
	InvalidateRect (hWnd, NULL, TRUE);
}


/*
 * When the user presses the mouse button down to drag a selection, then
 * moves above or below the window we need to scroll the window.  
 * Mouse track events only occur when the mouse moves - they are not
 * adequate.  So, I install a timer, which sends a message to the window
 * which calls this function.
 *
 * ptwInfo->scrollDirect  indicates which direction the scrolling should
 * be done.
 */
LOCAL BOOL
TWScrollTimer (HWND hWnd)
{
    TextWndInfo		*ptwInfo;
    long		newcurLine;
    RECT		rect;
    long		lineLen;
    long		oldmarkLine, oldmarkChar;
    RECT		frame;
    
    

    ptwInfo = (TextWndInfo *) GetWindowLong (hWnd, GWL_PTEXTINFO);
    if (ptwInfo == NULL) {
	KillTimer (hWnd, TWS_TIMERID);
	return (FALSE);
    }
    
    if (ptwInfo->scrollDirect == TWS_OFF) {
	/* Timer should be off. */
	KillTimer (hWnd, TWS_TIMERID);
	return (FALSE);
    }
    
    frame.top = 0 + FRAME_3D_SIZE;
    frame.bottom =  ptwInfo->ySize - FRAME_3D_SIZE;
    frame.left = 0 + FRAME_3D_SIZE;
    frame.right = ptwInfo->xSize - FRAME_3D_SIZE;

    
    /*
     * Remember old mark.
     */
    oldmarkLine = ptwInfo->markLine;
    oldmarkChar = ptwInfo->markChar;

    
    /* 
     * Is scrolling going up or down?
     */
    if (ptwInfo->scrollDirect == TWS_UP) {
	/* 
	 * Find new top line and move mark to left of top line. 
	 */
	newcurLine = ptwInfo->curLine - 1;
	if (newcurLine < 0)
	    newcurLine = 0;
	ptwInfo->markLine = newcurLine;
	ptwInfo->markChar = 0;
    }
    else if (ptwInfo->scrollDirect == TWS_DOWN) {
	/* 
	 * Fine new top line and move mark to right of bottom line.
	 */
	newcurLine = ptwInfo->curLine + 1;
	if (newcurLine > ptwInfo->lineCount - 1) 
	    newcurLine = ptwInfo->lineCount - 1;
	ptwInfo->markLine = newcurLine + ptwInfo->nRows;
	
	/*
	 * Handle the last line correctly.
	 */
	if (ptwInfo->markLine >= ptwInfo->lineCount) {
	    ptwInfo->markLine = ptwInfo->lineCount;
	    ptwInfo->markChar = 0;
	}
	else 
	    ptwInfo->markChar = TWMeasureLine (*(ptwInfo->lines+ptwInfo->markLine));
    }
    
    /*
     * If window can be scrolled do it here.
     */
    if (newcurLine != ptwInfo->curLine) {
	    
	/*
	 * Update scroll bar and scroll the window.
	 */
	SetScrollPos (hWnd, SB_VERT, (int)newcurLine, TRUE);
	ScrollWindow (hWnd, 0, 
		(int)(ptwInfo->curLine - newcurLine) * ptwInfo->yChar, 
		NULL, &frame);
	ptwInfo->curLine = newcurLine;


	/*
	 * ScrollWindow() invalidates part of the window, but does not
	 * invalidate enough.  Do that here.
	 */
	if (oldmarkLine < ptwInfo->markLine ||
		(oldmarkLine == ptwInfo->markChar && 
			oldmarkChar < ptwInfo->markChar)) {
	    rect.top = ((oldmarkLine - ptwInfo->curLine) * ptwInfo->yChar) + 
			    MARGINE_TOP;
	    rect.bottom = ((ptwInfo->markLine - ptwInfo->curLine + 1) * 
					    ptwInfo->yChar) + MARGINE_TOP;
	}
	else {
	    rect.top = ((ptwInfo->markLine - ptwInfo->curLine) * 
					    ptwInfo->yChar) + MARGINE_TOP;
	    rect.bottom = ((oldmarkLine - ptwInfo->curLine + 1) * 
					    ptwInfo->yChar) + MARGINE_TOP;
	}
		
	rect.left = 0;
	rect.right = ptwInfo->xSize;
	InvalidateRect (hWnd, &rect, FALSE);

	UpdateWindow (hWnd);
    }
}





/*
 * Process a WM_CHAR message.
 * Allow the standard scrolling keys.
 */
LOCAL void
TWChar (HWND hWnd, WORD key, DWORD keyData)
{
    switch (key) {
	case 'k':
	    TWScroll (hWnd, SB_LINEUP, 0);
	    break;
	    
	case 'j':
	    TWScroll (hWnd, SB_LINEDOWN, 0);
	    break;
	    
	case '-':
	case 'b':
	    TWScroll (hWnd, SB_PAGEUP, 0);
	    break;
	
	case ' ':
	case 'f':
	    TWScroll (hWnd, SB_PAGEDOWN, 0);
	    break;
    }
}





/*
 * Process a key down message.  Handle only virtual keys which can be
 * maped to scrolling operatons.
 */
LOCAL BOOL  
TWKeyDown (HWND hWnd, WORD key, DWORD keyData)
{
    BOOL	handled = TRUE;
    
    /* Special keys. */
    if (keyData & 0X20000000)
	return (FALSE);			/* Message NOT handled. */

    switch (key) {
	case VK_UP:
	    TWScroll (hWnd, SB_LINEUP, 0);
	    break;
	    
	case VK_DOWN:
	    TWScroll (hWnd, SB_LINEDOWN, 0);
	    break;
	    
	case VK_PRIOR:
	    TWScroll (hWnd, SB_PAGEUP, 0);
	    break;
	
	case VK_NEXT:
	    TWScroll (hWnd, SB_PAGEDOWN, 0);
	    break;
	
	case VK_HOME:
	    TWScroll (hWnd, SB_TOP, 0);
	    break;
		
	case VK_END:
	    TWScroll (hWnd, SB_BOTTOM, 0);
	    break;

	default:
	    handled = FALSE;
	    break;
    }
    return (handled);
}



/*
 * Count how many screen cells a line will occupie with expanded tabs.
 */
LOCAL int
TWMeasureLine (char *text)
{
    int		c;

    c = 0;
    while (*text) {
	if (*(text++) == '\t') {
	    do {
		++c;
            } while (c % TAB_SIZE != 0);
        }
	else
	    ++c;
    }
    return (c);
}
    



/*
 * Convert a windows point to a Line and character.
 */
LOCAL void
TWPointToLC (TextWndInfo *ptwInfo, CORD xPos, CORD yPos, 
				long *nLine, long *nChar)
{
    int			nRow, nCol;
    int			lineLen;
    BOOL		pastLast = FALSE;
    
    /*
     * Convert to row and column, staying out of top and left margines.
     */
    nRow = max (0, (yPos - MARGINE_TOP) / ptwInfo->yChar);
    nCol = max (0, (xPos - MARGINE_LEFT) / ptwInfo->xChar);
    
    /*
     * Convert to line.   If mouse is past bottom then point to one
     * past last line.
     */
    *nLine = ptwInfo->curLine + nRow;
    if (*nLine >= ptwInfo->lineCount) {
	*nLine = ptwInfo->lineCount;
	*nChar = 0;
	return;
    }
    lineLen = TWMeasureLine (*(ptwInfo->lines + *nLine));

    
    /* If past right end of line, then start at first char of next */
    if (nCol > lineLen) {
	++*nLine;
	*nChar = 0;
    }
    else
	*nChar = nCol;
}



/*
 * Mouse down.  Start selection.
 */
LOCAL BOOL  
TWMouseDown (HWND hWnd, int button, CORD xPos, CORD yPos, WPARAM keys)
{
    TextWndInfo		*ptwInfo;
    long		nLine;
    long		nChar;
    BOOL		wasPrevSel;

    
    ptwInfo = (TextWndInfo *) GetWindowLong (hWnd, GWL_PTEXTINFO);
    if (ptwInfo == NULL) 
	return (FALSE);
    
    /*
     * Only look at button 1.
     */
    if (button == 1) {
	wasPrevSel = (ptwInfo->markLine != ptwInfo->dotLine) ||
			(ptwInfo->markChar != ptwInfo->dotChar);
	TWPointToLC (ptwInfo, xPos, yPos, &nLine, &nChar);
	ptwInfo->markLine = nLine;
	ptwInfo->markChar = nChar;
	if (!(keys & MK_SHIFT)) {
	    ptwInfo->dotLine = nLine;
	    ptwInfo->dotChar = nChar;
        }
	SetCapture (hWnd);
	ptwInfo->tracking = TRUE;
	if (wasPrevSel || (keys & MK_SHIFT))
	    InvalidateRect (hWnd, NULL, FALSE);
	return (TRUE);
    }
    return (FALSE);
}





/*
 * Mouse up, end selection
 */
LOCAL BOOL  
TWMouseUp (HWND hWnd, int button, CORD xPos, CORD yPos, WPARAM keys)
{
    TextWndInfo		*ptwInfo;
    long		nLine;
    long		nChar;

    
    ptwInfo = (TextWndInfo *) GetWindowLong (hWnd, GWL_PTEXTINFO);
    if (ptwInfo == NULL) 
	return (FALSE);
    
    /*
     * Only look at button 1.
     */
    if (button == 1) {
	TWPointToLC (ptwInfo, xPos, yPos, &nLine, &nChar);
	ptwInfo->markLine = nLine;
	ptwInfo->markChar = nChar;
	ReleaseCapture ();
	if (ptwInfo->scrollDirect != TWS_OFF) {
	    ptwInfo->scrollDirect = TWS_OFF;
	    KillTimer (hWnd, TWS_TIMERID);
        }
	ptwInfo->tracking = FALSE;
	return (TRUE);
    }
    return (FALSE);
}



/*
 * Track mouse down.  
 * If the mouse had gone above or below the window, enable the timer which
 * automatically scrolls the window.
 * If the mouse is in the window, move the mark and update the window.
 */
LOCAL BOOL  
TWMouseTrack (HWND hWnd, CORD xPos, CORD yPos)
{
    TextWndInfo		*ptwInfo;
    int			nRow, nCol;
    long		nLine, nChar;
    long		oldmarkLine, oldmarkChar;
    int			lineLen;
    RECT		rect;

    ptwInfo = (TextWndInfo *) GetWindowLong (hWnd, GWL_PTEXTINFO);
    if (ptwInfo == NULL) 
	return (FALSE);

    if (!ptwInfo->tracking)
	return (FALSE);

    
    
    
    /* 
     * Decide if the mouse in ABOVE, IN, or BELOW the window.
     */
    if (yPos < 0) {
	/* Mouse Above. */
	if (ptwInfo->scrollDirect != TWS_UP) {
	    if (SetTimer (hWnd, TWS_TIMERID, TWS_TIMEOUT, NULL) != 0) 
		ptwInfo->scrollDirect = TWS_UP;
        }
    }
    else if (yPos > ptwInfo->ySize) {
	/* Mouse below. */
	if (ptwInfo->scrollDirect != TWS_DOWN) {
	    if (SetTimer (hWnd, TWS_TIMERID, TWS_TIMEOUT, NULL) != 0) 
		ptwInfo->scrollDirect = TWS_DOWN;
        }
    }
    else {
	/* Mouse in window. */
	if (ptwInfo->scrollDirect != TWS_OFF) {
	    ptwInfo->scrollDirect = TWS_OFF;
	    KillTimer (hWnd, TWS_TIMERID);
        }
	oldmarkLine = ptwInfo->markLine;
	oldmarkChar = ptwInfo->markChar;
	TWPointToLC (ptwInfo, xPos, yPos, &nLine, &nChar);
	ptwInfo->markLine = nLine;
	ptwInfo->markChar = nChar;


	/*
	 * Update just the line that changed. 
	 */
	if (oldmarkLine < nLine ||
		(oldmarkLine == nLine && oldmarkChar < nChar)) {
	    rect.top = ((oldmarkLine - ptwInfo->curLine) * ptwInfo->yChar) + 
			    MARGINE_TOP;
	    rect.bottom = ((nLine - ptwInfo->curLine + 1) * ptwInfo->yChar) + 
			    MARGINE_TOP;
	}
	else {
	    rect.top = ((nLine - ptwInfo->curLine) * ptwInfo->yChar) + 
			    MARGINE_TOP;
	    rect.bottom = ((oldmarkLine - ptwInfo->curLine + 1) * ptwInfo->yChar)+
			    MARGINE_TOP;
	}
	rect.left = 0;
	rect.right = ptwInfo->xSize - FRAME_3D_SIZE;
	InvalidateRect (hWnd, &rect, FALSE);
	UpdateWindow (hWnd);
    }
    return (TRUE);
}





/*
 * Convert a column position to a character offset in that line
 * taking tabs into account.
 */
long
TWCharInCol (char *line, long c)
{
    long	charPos;
    long	colPos;

    charPos = -1;
    colPos = 0;
    do {
	if (*(line + ++charPos) == '\t') {
	    do {
	        ++colPos;
	    } while (colPos % TAB_SIZE != 0);
        }
	else {
	    ++colPos;
        }
    } while (colPos <= c);
    return (charPos);
}




/*
 * Copy selection to clipboard.
 */
LOCAL BOOL  
TWEditCopy (HWND hWnd)
{
    TextWndInfo		*ptwInfo;
    long		selStartLine, selEndLine;
    long		selStartChar, selEndChar;
    long		selSize;
    long		len;
    HANDLE		hCB;
    char		*pCB;
    long		l;

    
    ptwInfo = (TextWndInfo *) GetWindowLong (hWnd, GWL_PTEXTINFO);
    if (ptwInfo == NULL) 
	return (FALSE);


    if (ptwInfo->dotLine < ptwInfo->markLine || 
	    (ptwInfo->dotLine == ptwInfo->markLine  &&
	     ptwInfo->dotChar < ptwInfo->markChar)) {
	selStartLine = ptwInfo->dotLine;
	selStartChar = TWCharInCol (*(ptwInfo->lines+ptwInfo->dotLine),
					ptwInfo->dotChar);
	selEndLine = ptwInfo->markLine;
	selEndChar = TWCharInCol (*(ptwInfo->lines + ptwInfo->markLine),
					ptwInfo->markChar);
#if 0		
	selStartLine = ptwInfo->dotLine;
	selStartChar = ptwInfo->dotChar;
	selEndLine = ptwInfo->markLine;
	selEndChar = ptwInfo->markChar;
#endif
    }
    else {
	selStartLine = ptwInfo->markLine;
	selStartChar = TWCharInCol (*(ptwInfo->lines + ptwInfo->markLine),
					ptwInfo->markChar);
	selEndLine = ptwInfo->dotLine;
	selEndChar = TWCharInCol (*(ptwInfo->lines + ptwInfo->dotLine),
					ptwInfo->dotChar);
#if 0	
	selStartLine = ptwInfo->markLine;
	selStartChar = ptwInfo->markChar;
	selEndLine = ptwInfo->dotLine;
	selEndChar = ptwInfo->dotChar;
#endif
    }
    /*
     * Count bytes in selection.
     */
    if (selStartLine == selEndLine) {
      selSize = selEndChar - selStartChar;
    }
    else {
	selSize = strlen (*(ptwInfo->lines + selStartLine)) - selStartChar + 2;
	for (l = selStartLine + 1; l < selEndLine; ++l) 
	    selSize += strlen (*(ptwInfo->lines + l)) + 2;
        selSize += selEndChar;
    }
    
    if (selSize == 0)
	return (TRUE);

    if (OpenClipboard (ghTTYWnd)) {		/* ...and we get the CB. */
	if (EmptyClipboard ()) {		/* ...and clear previous CB.*/
	    hCB = GlobalAlloc (GMEM_MOVEABLE, selSize+2);
	    if (hCB != NULL) {
		pCB = GlobalLock (hCB);

		if (selStartLine == selEndLine) {
		    /* Singe line, no CRLF. */
		    len = selEndChar - selStartChar;
		    memcpy (pCB, 
			    *(ptwInfo->lines + selStartLine) + selStartChar,
			    (size_t)len);
		    pCB += len;
		}
		else {
		    /* Copy first line with CRLF. */
		    len = strlen (*(ptwInfo->lines + selStartLine)) - 
							    selStartChar;
		    memcpy (pCB, 
			    *(ptwInfo->lines + selStartLine) + selStartChar,
			    (size_t)len);
		    pCB += len;
		    *pCB++ = ASCII_CR;
		    *pCB++ = ASCII_LF;
		    
		    /* Copy middle lines with CRLF. */
		    for (l = selStartLine + 1; l < selEndLine; ++l) {
			len = strlen (*(ptwInfo->lines + l));
			memcpy (pCB, *(ptwInfo->lines + l), (size_t)len);
			pCB += len;
			*pCB++ = ASCII_CR;
			*pCB++ = ASCII_LF;
		    }
		    
		    /* Copy last line without CRLF. */
		    memcpy (pCB, *(ptwInfo->lines+selEndLine), 
						    (size_t)selEndChar);
		    pCB += selEndChar;
		}
		
		/* Append null terminator. */
		*pCB++ = '\0';
		
		GlobalUnlock (hCB);

		if (SetClipboardData (CF_TEXT, hCB) == NULL)
		  /* Failed!  Free the data. */
		  GlobalFree (hCB);
	    }
	}
	CloseClipboard (); 
    }

    return (FALSE);
}




LOCAL void
TWSetSize (HWND hWnd, UINT wParam, UINT height, UINT width)
{
    TextWndInfo		*ptwInfo;
    
    
    if (wParam == SIZE_MINIMIZED)
	return;
    
    ptwInfo = (TextWndInfo *) GetWindowLong (hWnd, GWL_PTEXTINFO);
    if (ptwInfo == NULL) 
	return;


    /* Calculate new number of rows and columns. */
    ptwInfo->xSize = width;
    ptwInfo->ySize = height;
    ptwInfo->nCols = (width  - (2 * MARGINE_LEFT)) / ptwInfo->xChar;
    ptwInfo->nRows = (height - (2 * MARGINE_TOP))  / ptwInfo->yChar;
    
    InvalidateRect (hWnd, NULL, FALSE);
    return;
}



LOCAL void
TWPrint (HWND hWnd)
{
    TextWndInfo		*ptwInfo;
    int			rc;
#define DESC_LEN	180
    char		description[DESC_LEN+1];
    char		**line;
    UINT		i;
    
    
    ptwInfo = (TextWndInfo *) GetWindowLong (hWnd, GWL_PTEXTINFO);
    
    GetWindowText (hWnd, description, DESC_LEN);

    rc = mswin_print_ready ((WINHAND)hWnd, description);
    if (rc != 0) {
	if (rc != PE_USER_CANCEL) {
	    strcpy (description, "Printing failed:  ");
	    strcat (description, mswin_print_error (rc));
	    MessageBox (hWnd, description, "Print Failed", 
			    MB_OK | MB_ICONEXCLAMATION);
	}
	return;
    }
    
    
    for (line = ptwInfo->lines, i = 0; i < ptwInfo->lineCount; ++line, ++i) {
	mswin_print_text (*line);
	mswin_print_text ("\r\n");
    }
    
    mswin_print_done ();
}
		






/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *                  Character Queue
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


typedef struct {
	WORD	flags;
	WORD	c;
} CQEntry;

LOCAL CQEntry CQBuffer [CHARACTER_QUEUE_LENGTH];
LOCAL int CQHead;
LOCAL int CQTail;
LOCAL int CQCount;


/*---------------------------------------------------------------------------
 *  BOOL  CQInit ()
 *
 *  Description:
 *		Initialize the Character queue.
 *
 *  Parameters:
 *
 *
/*--------------------------------------------------------------------------*/
LOCAL void
CQInit (void)
{
	CQHead = 0;
	CQTail = 0;
	CQCount = 0;
}
 
 
/*---------------------------------------------------------------------------
 *  BOOL  CQAvailable (void)
 *
 *  Description:
 *		Return TRUE if there are characters in the queue.
 *
 *  Parameters:
 *
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL
CQAvailable (void)
{
	return (CQCount > 0);
}
 

 
/*---------------------------------------------------------------------------
 *  BOOL  CQAdd (WORD c, DWORC keyData)
 *
 *  Description:
 *		Add 'c' to the end of the character queue.
 *
 *  Parameters:
 *		return true if successfull.
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL
CQAdd (WORD c, DWORD keyData)
{
	if (CQCount == CHARACTER_QUEUE_LENGTH)
		return (FALSE);
	
	
	CQBuffer[CQTail].flags = 0;
	if ((keyData & 0x80000000) == 0)
	    CQBuffer[CQTail].flags |= CQ_FLAG_DOWN;
	if (keyData & 0x01000000)
	    CQBuffer[CQTail].flags |= CQ_FLAG_EXTENDED;
	if (keyData & 0x20000000)
	    CQBuffer[CQTail].flags |= CQ_FLAG_ALT;
	CQBuffer[CQTail].c = c;
	CQTail = (CQTail + 1) % CHARACTER_QUEUE_LENGTH;
	++CQCount;
	return (TRUE);
}



/*---------------------------------------------------------------------------
 *  BOOL  CQAddUniq (WORD c, DWORC keyData)
 *
 *  Description:
 *		Add 'c' to the end of the character queue, only if
 *		there is no other 'c' in the queue
 *
 *  Parameters:
 *		return true if successfull.
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL
CQAddUniq (WORD c, DWORD keyData)
{
	int		i;
	int		pos;
	
	if (CQCount == CHARACTER_QUEUE_LENGTH)
		return (FALSE);
	
	pos = CQHead;
	for (i = 0; i < CQCount; ++i) {
	    if (CQBuffer[pos].c == c)
		return (FALSE);
	    pos = (pos + 1) % CHARACTER_QUEUE_LENGTH;
	}
	return (CQAdd (c, keyData));
}
 
 

 
/*---------------------------------------------------------------------------
 *  int  CQGet ()
 *
 *  Description:
 *		Return the next byte from the head of the queue.  If there is
 *		no byte available, returns 0, which is indistinquishable from 
 *		'\0'.  So it is a good idea to call CQAvailable first.
 *
 *  Parameters:
 *		none.
 *
/*--------------------------------------------------------------------------*/

LOCAL WORD
CQGet ()
{
    WORD	c;

    if (CQCount == 0)
	return (0);

    c = CQBuffer[CQHead].c;
    CQHead = (CQHead + 1) % CHARACTER_QUEUE_LENGTH;
    --CQCount;
    return (c);
}


#if 0
/*---------------------------------------------------------------------------
 *
 *  LOCAL int MapVKtoMS (WORD c, WORD flags);
 *
 * Description:
 *	Map key received in WM_CHAR message to intermediate character code.
 *      which latter gets maped to a pico or pine character code.
 */
LOCAL int
MapVKtoMS (WORD c, WORD flags)
{
    /* Special keys. */
    if (flags & CQ_FLAG_ALT)
	return (MSWIN_KEY_NODATA);

    if (flags & CQ_FLAG_EXTENDED) {
	switch (c) {
	    case VK_UP:			return (MSWIN_KEY_UP);
	    case VK_DOWN:		return (MSWIN_KEY_DOWN);
	    case VK_RIGHT:		return (MSWIN_KEY_RIGHT);
	    case VK_LEFT:		return (MSWIN_KEY_LEFT);
	    case VK_PRIOR:		return (MSWIN_KEY_PREVPAGE);
	    case VK_NEXT:		return (MSWIN_KEY_NEXTPAGE);
	    case VK_HOME:		return (MSWIN_KEY_HOME);
	    case VK_END:		return (MSWIN_KEY_END);
	    case VK_DELETE:		return (MSWIN_KEY_DELETE);
	    case VK_F1:			return (MSWIN_KEY_F1);
	    case VK_F2:			return (MSWIN_KEY_F2);
	    case VK_F3:			return (MSWIN_KEY_F3);
	    case VK_F4:			return (MSWIN_KEY_F4);
	    case VK_F5:			return (MSWIN_KEY_F5);
	    case VK_F6:			return (MSWIN_KEY_F6);
	    case VK_F7:			return (MSWIN_KEY_F7);
	    case VK_F8:			return (MSWIN_KEY_F8);
	    case VK_F9:			return (MSWIN_KEY_F9);
	    case VK_F10:		return (MSWIN_KEY_F10);
	    case VK_F11:		return (MSWIN_KEY_F11);
	    case VK_F12:		return (MSWIN_KEY_F12);
	    default:			return (MSWIN_KEY_NODATA);
        }
    }
    
    /* Normal keys. */
    return (c);
}
#endif




/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *                  Mouse Event Queue
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/



LOCAL MEvent MQBuffer [MOUSE_QUEUE_LENGTH];
LOCAL int MQHead;
LOCAL int MQTail;
LOCAL int MQCount;


/*---------------------------------------------------------------------------
 *  BOOL  MQInit ()
 *
 *  Description:
 *		Initialize the Character queue.
 *
 *  Parameters:
 *
 *
/*--------------------------------------------------------------------------*/
LOCAL void
MQInit (void)
{
	MQHead = 0;
	MQTail = 0;
	MQCount = 0;
}
 
 
/*---------------------------------------------------------------------------
 *  BOOL  MQAvailable (void)
 *
 *  Description:
 *		Return TRUE if there are characters in the queue.
 *
 *  Parameters:
 *
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL
MQAvailable (void)
{
	return (MQCount > 0);
}
 

 
/*---------------------------------------------------------------------------
 *  BOOL  MQAdd ()
 *
 *  Description:
 *		Add 'c' to the end of the character queue.
 *
 *  Parameters:
 *		return true if successfull.
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL
MQAdd (int mevent, int button, int nRow, int nColumn, int keys, int flags)
{
    int		i;
    int		c;
    BOOL	found = FALSE;

    
    /*
     * Find a queue insertion point.
     */
    if (flags & MSWIN_MF_REPLACING) {
	/* Search for same event on queue. */
	for (   i = MQHead, c = MQCount; 
	        c > 0; 
		i = (i + 1) % MOUSE_QUEUE_LENGTH, --c) {
	    if (MQBuffer[i].event == mevent) {
		found = TRUE;
		break;
	    }
        }
    }
    if (!found) {
	if (MQCount == MOUSE_QUEUE_LENGTH)
	    return (FALSE);
        i = MQTail;
	MQTail = (MQTail + 1) % MOUSE_QUEUE_LENGTH;
	++MQCount;
    }
    

    /*
     * Record data.
     */
    MQBuffer[i].event = mevent;
    MQBuffer[i].button = button;
    MQBuffer[i].nRow = nRow;
    MQBuffer[i].nColumn = nColumn;
    MQBuffer[i].keys = keys;
    MQBuffer[i].flags = flags;
    
    /*
     * Keep record of last mouse position.
     */
    gMTEvent = MQBuffer[i];
    
    return (TRUE);
}
 




/*---------------------------------------------------------------------------
 *  BOOL  MQGet ()
 *
 *  Description:
 *		Return the next byte from the head of the queue.  If there is
 *		no byte available, returns 0, which is indistinquishable from 
 *		'\0'.  So it is a good idea to call MQAvailable first.
 *
 *  Parameters:
 *		none.
 *
/*--------------------------------------------------------------------------*/

LOCAL BOOL
MQGet (MEvent * pMouse)
{
    if (MQCount == 0)
	return (FALSE);

    
    *pMouse = MQBuffer[MQHead];
    MQHead = (MQHead + 1) % MOUSE_QUEUE_LENGTH;
    --MQCount;
    return (TRUE);
}






void 
AssertFail	(char *str, char *file, int line, int msgbox)
{
    /* static to avoid risk of stack overflow */
    static int	inAssert	= 0;
    static int	doBreak		= 1;
    char	*	filename;
    int			ret;



    /* for now, strip off path from filename */
    filename = strrchr(file, '\\');
    if (filename)
	    filename++;
    else
	    filename = file;

    wsprintf(TempBuf, "Assert(%s) failed!  %s:%d\n", 
			    str, filename, line);

    inAssert++;


retry:

    /*	Unfortunately, there are certain times when attempting to
     *	display a message box will cause the system to crash (e.g.,
     *	when handling certain messages in a WndProc).
     *
     *	Message box was previously TaskModal, but this didn't work
     *	well because the client AIM could keep sending requests.
     *	SystemModal shuts the whole system down but at least it
     *	guarantees some degree of consistency, and makes debugging
     *	a bit easier.
     */
    ret = MessageBox (NULL, TempBuf, NULL, 
				    MB_ABORTRETRYIGNORE | MB_SYSTEMMODAL );


    if (ret == IDABORT) {
	    ret = MessageBox(NULL, 
			    "AbortIng may not properly free resources.  Are you sure?",
			    "Assertion Abort",
			    MB_YESNO | MB_TASKMODAL | MB_ICONSTOP);

	    if (ret == IDYES) {
		    /*
		     *	Cause a GPF in case DrWatson is running
		     */
		    char *p = NULL;
		    *p = 1;
	    }
	    else 
		    goto retry;
    }

    /* retry is not (and will never be) hooked up, but it's
     * easier to use the standard dialog box than create
     * our own.  if retry is selected, just report the
     * error again.
     */
    if (ret == IDRETRY)
	    goto retry;
    inAssert--;
}
