/*
 * Here we check a bulletin board for recent messages for a user.
 *     We look at:
 *        .imap_RO_bboardname in the user's mail directory. It contains
 *        the date of last read.
 *
 *     We then write headers of recent messages to stdout in the following
 *     format:
 * 
N    136)  3-Nov Harinder Singh  Followup to article on meat eatin (1954 chars)
FFFFNNNN)XXDDDDDxFFFFFFFFFFFFFFXXSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSX(LLLLLLLLLL)
123412345XX12345X12345678901234XX123456789012345678901234567890123XVVVVVVVVVVVV
 *
 *  Calling sequence:
 *
 *  bbcheck(bboardname,homedir)
 *      char *bboardname;         Name of bulletin board with or without .txt
 *      char *homedir;            User's home directory(we need to look at 
 *                                .mminit.
 */
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <pwd.h>
#include <grp.h>
#include <strings.h>
#include <stdio.h>
#include <ctype.h>
#include "sin.h"
#include "requests.h"
#include "memory.h"
#include "envelope.h"`
#include "mailcache.h"
#include "mbox.h"
#include "bbcheck.h"

HDRHDR selectedHeader;
MSGHDR selectedMhdrs[MAXMESSAGES];
ROHDR readonlyHeader;
int mboxLastReadDate = 0;
MAILBOX mbox;
char *clearwhitespace();

main(argc,argv)
     int argc;
     char *argv[];
{
  UNIXPATH homedir;
  char *sptr;
  int nmsgs;
  int msgnum;
  
  if (argc < REQUIREDARGS) {
    fprintf(stdout,"\nToo few arguments passed\n");
    exit(1);
  }
  /*
   * Create a mailbox
   */
  bzero(&mbox,sizeof(MAILBOX));
  strcpy(mbox.dir,BBOARDSPOOLDIR);		  /* Where it is found */
  strcpy(mbox.name,mbox.dir);			  /* The directory */
  strcat(mbox.name,argv[1]);			  /* copy the name */
  strcpy(homedir,argv[2]);			  /* and home directory */
  /*
   *  Look for .txt and if not there, append it, ie, bboards
   *  are stored in files ending in ".txt".
   */
  sptr = rindex(mbox.name,'.');
  if (sptr)					  /* Found "." */
    if (strcmp(sptr,".txt") != 0) sptr = 0;	  /* Not ".txt" */
  if (!sptr) strcat(mbox.name,".txt");		  /* Append ".txt" */
  sptr = rindex(mbox.name,'/');			  /* last "/" */
  if (!sptr) sptr = mbox.name;
  else
    ++sptr;					  /* skip "/" */
  strcpy(mbox.iname,mbox.dir);			  /* Now the index file path */
  strcat(mbox.iname,DEFAULTIPREFIX);		  /* index prefix for imap */
  strcat(mbox.iname,sptr);			  /* complete index name */
  /*
   *  Open the bulletin board and read in its index file
   */
  mbox.stream = fopen(mbox.name,"r");
  if (!mbox.stream) {
    fprintf(stdout,"\nCould not open %s for input\n",mbox.name);
    exit(1);
  }
  mbox.istream = fopen(mbox.iname,"r");
  if (!mbox.istream) {
    fprintf(stdout,"\nCould not open %s for input\n",mbox.iname);
    exit(1);
  }
  /*
   * See if the bulletin board is write-locked.
   */
  if (!setlock(&mbox)) exit(0);
  /*
   *  Now open the saved read date file, if no such file exists,
   *  then create one and set the read_date to NULL.
   */
  mbox.flags = M_RO;
  setrofilename(&mbox,homedir,sptr);
  mbox.rstream = (FILE *)openROfile(mbox.rname);
  nmsgs = readIndexFile(&mbox);
  if (nmsgs == 0) {
    verbosewrite("\n bulletin board is empty.\n");
    fclose(mbox.stream);
    fclose(mbox.istream);
    if (mbox.rstream) fclose(mbox.rstream);
    exit(0);
  }
  /*
   * find first unread message.
   */
  if (mboxLastReadDate == 0) msgnum = 0;	  /* has not read */
  else
    msgnum = firstunseenmsg(nmsgs);		  /* 0 <= msgnum < nmsgs */
  /*
   * Display one line for each unread message
   */
  if (msgnum < nmsgs) {
    displaymsglines(&mbox,msgnum,nmsgs);
    updateReaddate(&mbox);
    verbosewrite("\n");
  } else {
    fprintf(stdout,"\n%d messages(",selectedHeader.Number_Of_Messages);
    verbosewrite(" No unseen messages )\n");
  }
  fclose(mbox.stream);
  fclose(mbox.istream);
  if (mbox.rstream) fclose(mbox.rstream);
}
updateReaddate(mbox)
     MAILBOX *mbox;
{
  struct timeval tp;
  struct timezone tzp;
 
  if (!mbox->rstream) return;
  if (fseek(mbox->rstream,0L,0) < 0) return;
  gettimeofday(&tp,&tzp);
  readonlyHeader.Last_Read = tp.tv_sec;
  fwrite(&readonlyHeader,sizeof(ROHDR),1,mbox->rstream);
  fprintf(stdout,"\n\nRead date updated to %s",ctime(&readonlyHeader));
  fflush(stdout);
}
/*
 * display header information about unseen messages
 * Format
N    136)  3-Nov Harinder Singh  Followup to article on meat eatin (1954 chars)
FFFFNNNN)XXDDDDDxFFFFFFFFFFFFFFXXSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSX(LLLLLLLLLL)
123412345XX12345X12345678901234XX123456789012345678901234567890123XVVVVVVVVVVVV
 */
#define LBUFSIZE 80
displaymsglines(mbox,firstmsg,nmsgs)
     MAILBOX *mbox;
     int firstmsg,
         nmsgs;
{
  int msgnum= firstmsg+1;
  MSGHDR *hp= &selectedMhdrs[firstmsg];
  char *lp,lbuf[2*LBUFSIZE];
  char *bp;
  char *cpos;
  int readmessages= 0;
  int i;

  fprintf(stdout,"\n Unseen messages are %d - %d\n",msgnum,nmsgs);
  /*
   * Read in the messages under a shared lock
   */
  if (fseek(mbox->stream,hp->Header,0) < 0) return; /* seek first message */
  for (i=firstmsg; i<nmsgs; ++i,++hp,++readmessages) {
    /*
     * Map in the message
     */
    if (!get_memory(&hp->memmap,get_mem_size(hp->Size+1))) break;
    /*
     *  read in the text itself
     */
    bp = hp->memmap.memloc;
    if (1 != fread(bp,hp->Size,1,mbox->stream)) break;
    *(bp + hp->Size) = '\0';
  }
  /*
   * Now, scan the read messages.
   */
  unlockmbox(mbox);				  /* Free the lock */
  hp = &selectedMhdrs[firstmsg];
  if (fseek(mbox->stream,hp->Header,0) < 0) return; /* seek first message */
  for (i=0; i<readmessages; ++i,++msgnum,++hp) {
    char *subject,*from;
    char lenbuf[LBUFSIZE];
    int nfound, tmp;

    lp = lbuf;
    bp = hp->memmap.memloc;			  /* the message itself */
    sprintf(lp,"\nN   %4d) ",msgnum);
    strncat(lp,bp,6);				  /* dd-MMM */
    /*
     *  Find subject and from fields
     */
    bp += hp->Header_Size;			  /* skip header line */
    from = subject = 0;
    nfound = 0;
    while (1) {
      if (*bp == '\n') break;			  /* EOL EOL Found the body */
      if (strncmp(bp,"From:",5) == 0) {
	from = bp + 5;
	nfound += 1;
      }
      if (strncmp(bp,"Subject:",8) == 0) {
	nfound += 1;
	subject = bp + 8;
      }
      if (nfound == 2) break;			  /* have em both */
      bp = index(bp,'\n');			  /* next line */
      if (!bp) break;				  /* end of message */
      else
	++bp;					  /* skip EOL */
    }
    cpos = lp + strlen(lp);
    sprintf(lenbuf," (%d chars)",hp->Size - hp->Header_Size);   
    tmp = strlen(lenbuf);
    if (from) copyfrom(&cpos,from,LBUFSIZE-(int)(cpos-lp)-tmp);
    if (subject) 
      copysubject(&cpos,subject,LBUFSIZE-(int)(cpos-lp)-tmp);
    strcat(cpos,lenbuf);
    fprintf(stdout,"%s",lp);
  }
  fflush(stdout);
}
copyfrom(pos,from,maxc)
     char **pos;
     char *from;
     int maxc;
{
  char *cp= *pos;
  char c;
  int done= 0;
  while (maxc-- > 0) {
    c = *from++;
    switch (c) {
        case '\n': case '\0': case '@': case '<':
          done = 1;
          break;
	default: *cp++ = c; break;
	}
    if (done) break;
  }
  *cp = '\0';
  *pos = cp;
}
copysubject(pos,subject,maxc)
     char **pos;
     char *subject;
     int maxc;
{
  char *cp= *pos;
  char c;

  while (maxc-- > 0) {
    c = *subject++;
    if (c == '\n' || c == '\0') break;
    *cp++ = c;
  }
  *cp = '\0';
  *pos = cp;
}
    
/*
 * compare mboxLastReadDate to each date the the messages in
 * the bulletin board. Return when mboxLastReadDate < date.
 *
 *     return value:  msg number of first unseen message.
 *                    or nmsgs if all seen;
 */
firstunseenmsg(nmsgs)
     int nmsgs;					  /* total number of msgs */
{
  int i;

  MSGHDR *hp= &selectedMhdrs[0];

  for (i=0; i<nmsgs; ++i,++hp)
    if (mboxLastReadDate < hp->Date) return(i);
  return(nmsgs);
}

/*
 * Look for .mminit to find out where the mail files are kept,
 * and set the "last read date" file name.
 */
setrofilename(mbox,homedir,mname)
     MAILBOX *mbox;
     char *homedir;
     char *mname;
{
  char *lastbyte= homedir + strlen(homedir) - 1;
  UNIXNAME initfile;
  FILE *ifile;

  if (*lastbyte++ != '/') {
    *lastbyte++ = '/';
    *lastbyte = '\0';
  }
  strcpy(initfile,homedir);
  strcat(initfile,".mminit");
  strcpy(mbox->rname,homedir);
  if (ifile = fopen(initfile,"r")) {
    appendmaildir(ifile,mbox->rname);
    fclose(ifile);
  }
  strcat(mbox->rname,DEFAULTRPREFIX);
  strcat(mbox->rname,mname);
}
openROfile(rname)
     char *rname;
{
  FILE *rstream;
  char *omode;
  int create;
  /*
   * If the file doesn't exist then open "w+" else "r+"
   * Since it belongs to the user, we assume r/w access to
   * the file's path and the file itself.
   */
  if (access(rname,F_OK) < 0) {
    omode = "w+";				  /* does not exist */
    create = 1;
  }
  else						  /* read/write */
    {
      omode = "r+";
      create = 0;
    }
  rstream = fopen(rname,omode);
  if (!rstream) return(0);			  /* something wrong */
  if (create) {
    bzero(&readonlyHeader,sizeof(ROHDR));
    fwrite(&readonlyHeader,sizeof(ROHDR),1,rstream);
  }
  return((int)rstream);
}
/*
 * scan .mminit for "set mail-directory"
 * and append it appropriately to rname.
 * Terminate with "/" if we append something.
 *   rname is of form "$home/"
 */
#define MAXLINE 256
appendmaildir(ifile,rname)
     FILE *ifile;
     char *rname;
{
  char line[MAXLINE];
  int mdlen= strlen("mail-directory");

  while (fgets(line,MAXLINE,ifile)) {
    char *lp= clearwhitespace(line);

    if (strncmp(lp,"set",3) != 0) continue;
    lp += 3;
    lp = clearwhitespace(lp);
    if (strncmp(lp,"mail-directory",mdlen) != 0) continue;
    else
      {
	char *ep;

	lp += mdlen;				  /* skip over text */
	lp = clearwhitespace(lp);
	if (*lp == '\0') return;		  /* non rien */
	if (*lp == '~') ++lp;			  /* skip home */
	if (*lp == '/') ++lp;			  /* skip leading / */
	ep = rindex(lp,'\n');			  /* should be a NL */
	if (!ep) return;			  /* Bad line format */
	*ep-- = '\0';				  /* backover NL */
	if (*ep == '.') *ep-- = '\0';		  /* trash "."s */
	if (*ep++ != '/') {			  /* must end with "/" */
	  *ep++ = '/';
	  *ep = '\0';
	}
	strcat(rname,lp);
	break;
      }
  }
}
readIndexFile(mbox)
  register MAILBOX *mbox;
  {
    register nitems;
    register HDRHDR *h= &selectedHeader;
    register i,offset;

    /*
     *	Seek beginning of file(it may be open and at any position).
     */
    if (fseek(mbox->istream,0,FROMBEGINNINGOFFILE) < 0) return(0);
    nitems = fread(h,sizeof(*h),1,mbox->istream);
    if (nitems != 1) return(0);
    /*
     *  Could be an empty mail box.
     */
    if (h->Number_Of_Messages == 0)
        return(1);
    if (h->Number_Of_Messages < 0 || 
	h->Number_Of_Messages > MAXMESSAGES) 
	return(0);
    /*
     *	read in the message headers
     */
    nitems = fread(&selectedMhdrs[0],sizeof(MSGHDR),
		   h->Number_Of_Messages,mbox->istream);
    if (nitems != h->Number_Of_Messages) return(0);
    /*
     *	Now calculate the offset of each message and stash
     *	it in the cache. Then, clear memory cache info.
     *  Also, update the number of unseen messages.
     */
    offset = 0;
    for (i=0; i<nitems; ++i) {
        register MSGHDR *mhp= &selectedMhdrs[i];	

	mhp->Header = (char *)offset;
	mhp->memmap.inited = mhp->memmap.size = 0;
	mhp->ehp = 0;
	offset += mhp->Size;
      }
    if (!mbox->rstream || (fseek(mbox->rstream,0,FROMBEGINNINGOFFILE) < 0))
	mboxLastReadDate = 0;
    else 
      if (1 != fread(&readonlyHeader,sizeof(readonlyHeader),1,mbox->rstream))
	mboxLastReadDate = 0;
      else
	mboxLastReadDate = readonlyHeader.Last_Read;
    verbosewrite("\nLast read on ");
    verbosewrite(ctime(&mboxLastReadDate));
    return(h->Number_Of_Messages);
  }
verbosewrite(str)
     char *str;
{
  fprintf(stdout,str);
  fflush(stdout);
}
debugwrite(str)
{
  verbosewrite(str);
}
char *clearwhitespace(line)
     char *line;
{
  char c;

  while (c = *line)
    if (c == ' ' || c == '\011') ++line;
    else
      break;
  return(line);
}
setlock(mbox)
     MAILBOX *mbox;
{
  int key= 0;

  while (!sharedlockmbox(mbox)) {
    sleep(1);
    if (++key == 5) {
      verbosewrite("\nBulletin board update in progress, try again\n");
      return(0);
    }
  }
  return(1);
}
/*
 *	Some mbox lock functions
 */
unlockmbox(mbox)
  register MAILBOX *mbox;
  {
    if (!unlockfile(mbox->stream) || !unlockfile(mbox->istream))
    	return(0);
    else
	return(1);
  }
sharedlockmbox(mbox)
  register MAILBOX *mbox;
  {
    if (!setsharedlock(mbox->stream) || !setsharedlock(mbox->istream))
    	return(0);
    else
	return(1);
  }

setsharedlock(s)
  FILE *s;
  {
     if (flock(fileno(s),LOCK_SH|LOCK_NB) < 0) {
	return(0);
      }
     else
	return(1);
  }
setexclusivelock(s)
  FILE *s;
  {
     if (flock(fileno(s),LOCK_EX|LOCK_NB) < 0) {
	 return(0);
       }
     else
	return(1);
  }
unlockfile(s)
  FILE *s;
  {
     if (flock(fileno(s),LOCK_UN) < 0) {
	 return(0);
       }
     else
	return(1);
  }
