#!/usr/local/bin/tclsh

############## Defaults
set faces(sets) {users usenix misc domains unknown}
set faces(base) /usr/local/faces/
set faces(suffix) {gif xbm xpm}
set faces(wwwroot) "http://www/faces/"
############## Defaults end


proc FacePathlist { from } {
    set path {}
    set prefix {}
    set pathlist {}
    for {set i [expr [llength $from]-1]} {$i>=0} {incr i -1} {
        append path $prefix [lindex $from $i]
        set prefix /
        set pathlist [concat $path $pathlist]
    }
    lappend pathlist {}
    return $pathlist
}

puts "Content-type: text/plain"
puts ""
#puts $env(QUERY_STRING)

set fromwho $env(QUERY_STRING)

set parts [string tolower [split $fromwho @]]
set user [lindex $parts 0]
set machine [lindex $parts 1]

 
set from [split $machine .]
set pathlist [FacePathlist $from]
 
set matches {}
foreach set $faces(sets) {
#    puts "$set $pathlist"
    foreach part $pathlist {
	set path $part
	#       Exmh_Debug $path
	# skip non-existent directories
	if ![file exists $faces(base)$set/$path] continue
	foreach name "$user unknown" {
#	    	puts "$faces(base)$set/$path/$name"
	    foreach suf $faces(suffix) {
		if [file exists $faces(base)$set/$path/$name/face.$suf] {
#		    puts "hit $faces(base)$set/$path/$name/face.$suf"
		    puts "$faces(wwwroot)$set/$path/$name/face.$suf"
		    break
		}
	    }
	}
	}
    }



