/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1996 */
/* See the file NOTICE for conditions of use and distribution. */

/* Private structure for the private options. */

typedef struct {
  char *cmd; 
  char *path; 
  char *prefix;
  char *suffix;  
  char *expand_uid;
  char *expand_gid;  
  char *directory; 
  int   local_smtp; 
  int   uid; 
  int   gid;
  int   umask; 
  int   max_output; 
  BOOL  from_hack; 
  BOOL  ignore_status; 
  BOOL  pipe_as_creator; 
  BOOL  return_path_add; 
  BOOL  delivery_date_add; 
  BOOL  return_output; 
  BOOL  restrict_to_path; 
} pipe_transport_options_block;

/* Data for reading the private options. */

extern optionlist pipe_transport_options[];
extern int pipe_transport_options_count;

/* Block containing default values. */

extern pipe_transport_options_block pipe_transport_option_defaults;

/* The main and init entry points for the transport */

extern void pipe_transport_entry(transport_instance *, address_item *);

extern void pipe_transport_init(transport_instance *);

/* End of transports/pipe.h */
