/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1996 */
/* See the file NOTICE for conditions of use and distribution. */

/* All the global variables are defined together in this one module, so that
they are easy to find. */

#include "exim.h"


/* The OSF1 linker puts out a worrying warning if any sections contain no
executable code. It says

Warning: Linking some objects which contain exception information sections
        and some which do not. This may cause fatal runtime exception handling
        problems.

As this may cause people to worry needlessly, include a dummy function here
to stop the message from appearing. */

static void dummy(void) {}


/* For comments on these variables, see globals.h. I'm too idle to
duplicate them here... */

int    accept_timeout         = 0;
char  *address_file_transport = "address_file";
char  *address_pipe_transport = "address_pipe";
char  *address_reply_transport = "address_reply";
BOOL   admin_user             = FALSE;
int    auto_thaw              = 0;

char  *big_buffer             = NULL;

BOOL   config_changed         = FALSE;
FILE  *config_file            = NULL;
char  *config_filename        = CONFIGURE_FILE
			"\0<-----------Space to patch configure_filename->";
int    config_lineno          = 0;
char  *continue_hostname      = NULL;
int    continue_sequence      = 1;
char  *continue_transport     = NULL;

BOOL   daemon_listen          = FALSE;
FILE  *debug_file             = NULL;
int    debug_level            = 0;
BOOL   debug_trace_memory     = FALSE;
transport_info *debug_transport = NULL;
char  *debug_transport_file   = NULL;
int    delay_warning          = 24*60*60;
BOOL   delivery_date_remove   = TRUE;
char  *deliver_in_buffer      = NULL;
char  *deliver_out_buffer     = NULL;
int    deliver_datafile       = -1;
char  *deliver_domain         = NULL;
BOOL   deliver_force          = FALSE;
BOOL   deliver_freeze         = FALSE;
int    deliver_frozen_at      = 0;
char  *deliver_home           = NULL;
char  *deliver_host           = NULL;
char  *deliver_localpart      = NULL;
char  *deliver_selectstring   = NULL;
director_instance *directors  = NULL;

director_instance director_defaults = {
   NULL,                      /* chain pointer */
   NULL,                      /* name */
   NULL,                      /* info */
   NULL,                      /* private options block pointer */
   NULL,                      /* driver name */
   NULL,                      /* prefix */
   NULL,                      /* suffix */
   NULL,                      /* domains */ 
   NULL,                      /* require_files */ 
   NULL,                      /* re_domains */ 
   NULL,                      /* transport */ 
   TRUE,                      /* more */ 
   FALSE,                     /* unseen */ 
   FALSE,                     /* prefix_optional */
   FALSE,                     /* suffix_optional */  
   TRUE,                      /* verify */ 
   FALSE                      /* fail_verify */
};

BOOL   dont_deliver           = FALSE;
BOOL   dot_ends               = TRUE;

int    errno_quota            = ERRNO_QUOTA;
char  *errors_copy            = NULL;
int    error_handling         = ERRORS_SENDER;
char  *errors_address         = "postmaster";
char  *errors_reply_to        = NULL;
int    exim_gid               = EXIM_GID;
char  *exim_path              = BIN_DIRECTORY "/exim"
			"\0<---------------Space to patch exim_path->";
int    exim_uid               = EXIM_UID;
int    expand_nlength[EXPAND_MAXN+1];
int    expand_nmax            = -1;
char  *expand_nstring[EXPAND_MAXN+1];
BOOL   expand_string_forcedfail = FALSE;
char  *expand_string_message;
tree_node *expand_tree        = NULL;

char  *filter_test            = NULL;
int    finduser_retries       = 0;
BOOL   freeze_tell_mailmaster = FALSE;

char  *gecos_name             = NULL;
char  *gecos_pattern          = NULL;

BOOL   have_nis               = HAVE_NIS;
BOOL   have_seteuid           = HAVE_SETEUID || HAVE_SETRESUID;
BOOL   header_changed         = FALSE;
header_line *header_last      = NULL;
header_line *header_list      = NULL;
header_name *header_names     = NULL;

header_name header_names_normal[] = {
  { "Bcc",         3 },       /* This data must be in the correct */
  { "Cc",          2 },       /* order as defined by the enum for */
  { "Date",        4 },       /* the hn_xxx offsets. */
  { "From",        4 },
  { "Message-Id", 10 },
  { "Sender",      6 },
  { "To",          2 },
  { "Reply-To",    8 }  
};

header_name header_names_resent[] = {
  { "Resent-Bcc",        10 }, /* This data must be in the correct */
  { "Resent-Cc",          9 }, /* order as defined by the enum for */
  { "Resent-Date",       11 }, /* the hn_xxx offsets. */
  { "Resent-From",       11 },
  { "Resent-Message-Id", 17 },
  { "Resent-Sender",     13 },
  { "Resent-To",          9 },
  { "Resent-Reply-To",   15 } 
};

char  *hex_digits             = "0123456789abcdef";

BOOL   ignore_errmsg_errors   = FALSE;

int    keep_malformed         = 4*24*60*60;    /* 4 days */

char  *local_domains          = NULL;
BOOL   local_domains_include_host = FALSE;
BOOL   local_error_message    = FALSE;
ip_address_item *local_interfaces = NULL;
char  *log_buffer             = NULL;
BOOL   log_received_recipients = FALSE;

/* The first argument in this vector is set to exim_path after the 
configuration file has been read and exim_path is fixed. */

char  *mailer_argv[]          = { NULL, "-t", "-oem", "-oi", "-E", "-f", "<>", 
               (char *)0, (char *)0, (char *)0 };  /* -d & -N can be added */
char  *message_body           = NULL;
int    message_body_visible   = 500;                               
char  *message_id;
char  *message_id_text        = NULL;
char   message_id_external[MESSAGE_ID_LENGTH + 2];
FILE  *message_log            = NULL;
int    message_size           = 0;
int    message_size_limit     = 0;

int   *never_users            = NULL;
int    nobody_gid             = -1;
int    nobody_uid             = -1;

int    originator_gid;
char  *originator_login;
int    originator_uid;

char  *percent_hack_domains   = NULL;
BOOL   preserve_message_logs  = FALSE;
char  *primary_hostname       = NULL;

char  *qualify_domain_recipient = NULL;
char  *qualify_domain_sender  = NULL;
int    queue_interval         = -1;
BOOL   queue_only             = FALSE;
int    queue_run_max          = 5;
BOOL   queue_smtp             = FALSE;

char **raw_recipients         = NULL;

re_block *re_local_domains    = NULL;
re_block *re_percent_hack_domains = NULL;
re_block *re_sender_reject    = NULL;

int    real_gid               = -1;
int    real_uid               = -1;
BOOL   really_exim            = FALSE;
int    received_count         = 0;

/* This is the default text for Received headers generated by Exim. The
date will be automatically added on the end. */

char  *received_header_text   =
             "Received: "
             "${if def:sender_fullhost {from ${sender_fullhost} "
             "${if def:sender_ident {(${sender_ident})}}\n\t}"
             "{${if def:sender_ident {from ${sender_ident} }}}}"
             "by ${primary_hostname} "
             "${if def:received_protocol {with ${received_protocol}}} " 
             "(Exim ${version_number} #${compile_number})\n\t"
             "id ${message_id}"
	     "\0<---------------Space to patch received_header_text->";

int    received_headers_max   = 30;
char  *received_protocol      = NULL;
int    received_time          = 0;
BOOL   receiver_try_verify    = FALSE;
char  *receiver_unqualified_hosts = NULL;
host_item *receiver_unqualified_hostlist = NULL;
char  *receiver_unqualified_nets = NULL;
ip_net_item *receiver_unqualified_netlist = NULL;
BOOL   receiver_verify        = FALSE;
int    recipients_max         = 0;
int    recipients_count       = 0;
char **recipients_list        = NULL;
char **regcomp_error_pointer  = NULL;
char  *regexp_compiling       = NULL;
regexp *regexp_From           = NULL;
regexp *regexp_ip_address;
regexp *regexp_spoolfile;
int    retry_interval_max     = 24*60*60;
int    retry_maximum_timeout  = 0;        /* set from retry config */
retry_config *retries         = NULL;
char  *return_path            = NULL;
BOOL   return_path_remove     = TRUE;
int    return_size_limit      = 100*1024;
int    rewrite_existflags     = 0;
rewrite_rule *rewrite_rules   = NULL;
char  *rfc1413_except_hosts   = NULL;
host_item *rfc1413_except_hostlist = NULL;
char  *rfc1413_except_nets    = NULL;
ip_net_item *rfc1413_except_netlist = NULL;
int    rfc1413_query_timeout  = 60;
int    root_uid               = ROOT_UID;

router_instance *routers  = NULL;
router_instance router_defaults = {
   NULL,                      /* chain pointer */
   NULL,                      /* name */
   NULL,                      /* info */
   NULL,                      /* private options block pointer */
   NULL,                      /* driver name */
   NULL,                      /* transport instance */
   NULL,                      /* domains */
   NULL,                      /* require_files */
   NULL,                      /* re_domains */   
   TRUE,                      /* more */ 
   FALSE,                     /* unseen */ 
   TRUE,                      /* verify */ 
   FALSE                      /* fail_verify */ 
};

int    security_level         = 0;
char  *security_type          = NULL;
char  *sender_address         = NULL;
char  *sender_fullhost        = NULL;
char  *sender_host_accept     = NULL;
host_item *sender_host_accept_hosts = NULL;
char  *sender_host_address    = NULL;
char  *sender_host_name       = NULL;
char  *sender_host_reject     = NULL;
host_item *sender_host_reject_hosts = NULL;
BOOL   sender_host_unknown    = FALSE;
char  *sender_ident           = NULL;
BOOL   sender_local           = FALSE;
char  *sender_net_accept      = NULL;
ip_net_item *sender_net_accept_nets = NULL;
char  *sender_net_reject      = NULL;
ip_net_item *sender_net_reject_nets = NULL;
char  *sender_reject          = NULL;
BOOL   sender_try_verify      = FALSE;
char  *sender_unqualified_hosts = NULL;
host_item *sender_unqualified_hostlist = NULL;
char  *sender_unqualified_nets = NULL;
ip_net_item *sender_unqualified_netlist = NULL;
BOOL   sender_verify          = FALSE;
char  *sender_verify_except_hosts = NULL;
host_item *sender_verify_except_hostlist = NULL;
char  *sender_verify_except_nets = NULL;
ip_net_item *sender_verify_except_netlist = NULL;
BOOL   sender_verify_fixup    = FALSE;
BOOL   sender_verify_log_details = FALSE;
BOOL   sender_verify_reject   = TRUE;
char **sighup_argv            = NULL;
int    smtp_accept_count      = 0;
int    smtp_accept_max        = 20;
int    smtp_accept_queue      = 0;
int    smtp_accept_reserve    = 0;
char  *smtp_banner            = "${primary_hostname} Exim ${version_number} "
                            "#${compile_number} ready at ${tod_full}"
			    "\0<---------------Space to patch smtp_banner->";
BOOL   smtp_batched_input     = FALSE;
int    smtp_connect_backlog   = 5;
BOOL   smtp_input             = FALSE;
int    smtp_port              = -1;
int    smtp_receive_timeout   = 5*60;
host_item *smtp_reserve_hostlist = NULL;
char  *smtp_reserve_hosts     = NULL;
ip_net_item *smtp_reserve_netlist = NULL;
char  *smtp_reserve_nets      = NULL;
BOOL   smtp_verify            = FALSE;
char  *spool_directory        = SPOOL_DIRECTORY
			  "\0<--------------Space to patch spool_directory->";
char  *stderr_filename        = 
#ifdef STDERR_FILE
  STDERR_FILE             "\0<--------------Space to patch stderr_filename->";
#else
  NULL;
#endif
 
tree_node *stringmatch_tree   = NULL;

transport_instance *transport_address_file = NULL;
transport_instance *transport_address_pipe = NULL;
transport_instance *transport_address_reply = NULL;
transport_instance *transports = NULL;

transport_instance transport_defaults = {
   NULL,                     /* chain pointer */
   NULL,                     /* name */
   NULL,                     /* info */
   NULL,                     /* private options block pointer */
   NULL,                     /* driver name */
   local_smtp_off,           /* local_smtp */ 
   -1,                       /* uid */
   -1,                       /* gid */
   NULL,                     /* expand_uid */
   NULL,                     /* expand_gid */  
   NULL,                     /* home_dir */ 
   FALSE,                    /* deliver_as_creator */ 
   TRUE,                     /* multi-domain */ 
   FALSE                     /* return_output */ 
};

int    transport_chunk_timeout= 0;
BOOL   transport_sigalrm_seen = FALSE;

tree_node *tree_duplicates    = NULL;
tree_node *tree_nonrecipients = NULL;
tree_node *tree_unusable      = NULL;

BOOL   trusted_caller         = FALSE;
int   *trusted_groups         = NULL;
int   *trusted_users          = NULL;

char  *unknown_login          = NULL;
char  *unknown_username       = NULL;
char  *user_login             = NULL;
char  *user_name              = NULL;
BOOL   user_null_sender       = FALSE;

char  *version_copyright      = "Copyright (c) University of Cambridge 1996";
char  *version_date           = "?";
char  *version_cnumber        = "????";
char  *version_string         = "?";

int    warning_count          = 0;

/* End of globals.c */
