/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1996 */
/* See the file NOTICE for conditions of use and distribution. */


/* Prototypes for functions that appear in various modules. Gathered
together to avoid having a lot of tiddly little headers with only a
couple of lines in them. */

extern void  accept_add_recipient(char *);
extern void  accept_free_recipients(void);
extern BOOL  accept_msg(FILE *, FILE *, BOOL);

extern int   child_close(int);
extern int   child_open(char **, char **, int, int, int, int *, int);

extern void  daemon_go(void);
extern void  debug_printf(char *, ...);
extern address_item *deliver_make_addr(char *);
extern BOOL  deliver_message(char *, BOOL, BOOL);
extern void  deliver_setlocal(address_item *);
extern int   direct_address(address_item *, address_item **, address_item **,
               address_item **, BOOL);
extern struct group *direct_findgroup(char *, int *);
extern struct passwd *direct_finduser(char *, int *);
extern struct group *direct_find_expanded_group(char *, char *, char *, int *);
extern struct passwd *direct_find_expanded_user(char *, char *, char *, int *);
extern void  direct_init(void);
extern void  direct_tidyup(void);
extern void  directory_make(char *, char *, int);

extern char *expand_getkeyed(char *, char *);
extern char *expand_string(char *);

extern BOOL  filter_interpret(char *, address_item **, BOOL *, char **);
extern BOOL  filter_runtest(int);

extern void  header_add(int, char *, ...);
extern BOOL  header_checkname(header_line *, char *, int);

extern char *host_find_byaddr(char *);
extern BOOL  host_find_byname(host_item *, char **);
extern BOOL  host_find_bydns(host_item *, BOOL, BOOL, BOOL, BOOL, char **);
extern ip_address_item *host_find_interfaces(void);

extern void  log_close(void);
extern void  log_write(int, char *format, ...);

extern BOOL  match_exists(char *);
extern BOOL  match_isinlist(char *, char *, re_block **);
extern BOOL  match_string(char *, char *, re_block **);
extern char *moan_check_errorcopy(char *);
extern BOOL  moan_send_message(char *, int, error_block *, header_line *,
               FILE *);
extern void  moan_smtp_batch(char *, ...);
extern void  moan_tell_mailmaster(char *, char *, ...);
extern BOOL  moan_to_sender(int, error_block *, header_line *, FILE *);

extern void  os_restarting_signal(int, void (*)(int));

extern char *parse_extract_address(char *, char **, int *, int *, int *, BOOL);
extern int   parse_extract_addresses(char *, address_item **, char **, BOOL,
               char *);
extern char *parse_find_address_end(char *);
extern char *parse_find_at(char *);
extern char *parse_fix_phrase(char *);

extern BOOL  queue_action(char *, int, FILE *, char **, int, int);
extern queue_filename *queue_get_spool_list(BOOL);
extern void  queue_list(void);
extern void  queue_run(char *, char *);

extern BOOL  readconf_depends(driver_instance *, char *);
extern void  readconf_driver_init(char *, driver_instance **,
               driver_info *, int, void *, int, optionlist *, int);
extern void  readconf_main(void);
extern void  readconf_print(char *, char *);
extern char *readconf_printtime(int);
extern char *readconf_readname(char *, int, char *);
extern int   readconf_readtime(char *, int);
extern void  readconf_retries(void);
extern void  readconf_rewrites(void);
extern void  retry_add_item(address_item *, char *, BOOL, char *, BOOL);
extern char *retry_check_address(host_item *);
extern void  retry_update(address_item **, address_item **, address_item **);
extern char *rewrite_address(char *, BOOL, BOOL);
extern char *rewrite_address_for_filter(char *, int);
extern char *rewrite_address_qualify(char *, BOOL);
extern header_line *rewrite_header(header_line *, char *, char *);
extern int   route_address(address_item *, address_item **, address_item **, 
               address_item **, BOOL);
extern void  route_init(void);
extern void  route_tidyup(void);

extern void  search_close(void *, int);
extern char *search_find(void *, char *, char *, int);
extern void *search_open(char *, int, int, int *, int *, char **, tree_node **);
extern void  search_tidyup(tree_node **);
extern void  set_process_info(char *, ...);
extern int   smtp_setup_msg(FILE *, FILE *, BOOL);
extern BOOL  spool_open_datafile(char *);
extern int   spool_open_temp(char *);
extern int   spool_read_header(char *, BOOL);
extern int   spool_write_header(char *);
extern void  store_free_3(void *, char *, int);
extern void *store_malloc_3(size_t, char *, int);
extern char *string_base62(unsigned long int);
extern char *string_cat(char *, int *, int *, char *, int);
extern char *string_copy(char *);
extern char *string_copylc(char *);
extern char *string_copyn(char *, int);
extern char *string_copynlc(char *, int);
extern char *string_nextinlist(char *, int);
extern char *string_printing(char *, BOOL);
extern char *string_sprintf(char *, ...);
extern int   strcmpic(char *, char *);
extern int   strncmpic(char *, char *, int);
extern char *strstric(char *, char *, BOOL);

extern char *tod_stamp(int);
extern BOOL  transport_check_waiting(char *, char *, int, int, int);
extern void  transport_timeout_handler(int);
extern void  transport_update_waiting(host_item *, char *);
extern BOOL  transport_write_message(int, BOOL, BOOL, BOOL, BOOL, BOOL,
               char *, int);
extern void  tree_add_duplicate(char *);
extern void  tree_add_nonrecipient(char *);
extern void  tree_add_unusable(char *, int);
extern void  tree_free(tree_node *);
extern int   tree_insertnode(tree_node **, tree_node *);
extern void  tree_print(tree_node *);
extern tree_node *tree_search(tree_node *, char *);
extern tree_node *tree_search_addr(tree_node *, char *);
extern void  tree_write(tree_node *, FILE *);

extern int  verify_address(char *, BOOL, BOOL, FILE *, BOOL *, char **, BOOL,
              BOOL);
extern BOOL verify_check_host(char *, host_item **);
extern BOOL verify_check_net(char *, ip_net_item **);
extern void verify_get_ident(int);
extern BOOL verify_sender(int *, char **);
extern BOOL verify_sender_preliminary(int *, char **);
extern void verify_setup_hostlist(char *, host_item **);
extern void verify_setup_netlist(char *, ip_net_item **);
extern void version_init(void);

/* End of functions.h */
