/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1996 */
/* See the file NOTICE for conditions of use and distribution. */

/* Private structure for the private options. */

typedef struct {
  char *directory;
  char *file;
  char *errors_to;
  char *expand_uid;
  char *expand_gid;
  int   uid;
  int   gid;
  int   modemask;
  int  *owners;
  int  *owngroups;
  BOOL  check_local_user;
  BOOL  check_group; 
  BOOL  filter; 
  BOOL  forbid_file;
  BOOL  forbid_include; 
  BOOL  forbid_pipe;
  BOOL  forbid_reply; 
  BOOL  use_seteuid;
  BOOL  freeze_missing_include; 
} forwardfile_director_options_block;

/* Data for reading the private options. */

extern optionlist forwardfile_director_options[];
extern int forwardfile_director_options_count;

/* Block containing default values. */

extern forwardfile_director_options_block forwardfile_director_option_defaults;

/* The main and initialization entry points for the director */

extern int forwardfile_director_entry(director_instance *, address_item *,
  address_item **, address_item **, address_item **, BOOL);

extern void forwardfile_director_init(director_instance *);

/* End of directors/forwardfile.h */
