/*************************************************
*               Exim Monitor                     *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1996. */
/* See the file NOTICE for conditions of use and distribution. */


#include "em_hdr.h"


/* This module contains functions for displaying text in a
text widget. It is not used for the log widget, because that
is dynamically updated and has special scrolling requirements. */


/*************************************************
*               Empty the widget                 *
*************************************************/

void text_empty(Widget w)
{
XawTextBlock b;
b.firstPos = 0;
b.ptr = (char *)(&b);
b.format = FMT8BIT;
b.length = 0;
XawTextReplace(w, 0, 999999, &b);
}


/*************************************************
*           Cause position to be displayed       *
*************************************************/

void text_position(Widget w, int position)
{
XawTextSetInsertionPoint(w, position);
}


/*************************************************
*               Display text                     *
*************************************************/

void text_show(Widget w, char *s, ...)
{
va_list ap;
XawTextBlock b;
char buffer[1024];
va_start(ap, s);
vsprintf(buffer, s, ap);
va_end(ap);
b.firstPos = 0;
b.ptr = buffer;
b.format = FMT8BIT;
b.length = (int)strlen(buffer);
XawTextReplace(w, 999999, 999999, &b);
XawTextSetInsertionPoint(w, 99999);
}

/* End of em_text.c */
