	/* getoption.c */

#pragma	alloca	/* For AIX */

#include	<assert.h>
#include	"emil.h"

#ifndef	NO_FNMATCH
#include	<fnmatch.h>
#ifndef	FNM_NOMATCH
#define	FNM_NOMATCH	1	/* This MAY work!  941223/TW */
#endif
#else
static	int	ematch(char * p, char * s)
{
	/* Returns 0 if match, 1 else. '*' is a wildcard */
	/* Suggest that you install fnmatch instead...   */
#ifdef DEBUG
  if (edebug)
    fprintf(stderr, "-   ematch (no fnmatch).\n");
#endif
  for (;*p;p++) 
    if (*p == '*') 
      {
	p++; 
	if (*p=='\0') 
	  return 0;
	while (*s != '\0') 
	  {
	    if (ematch(p, s) == 0) 
	      return 0; 
	    else 
	      s++;
	  }
	return	1;
      } 
    else 
      if (*p != *(s++)) 
	return 1;
  return *s;
}
#endif

static	int	line_count;
static	int	error_count;	/* used in lex */
static	int	should_load_config_file	= 1;
extern	FILE *	conf_fd;

void	* Yalloc(int siz)
{
	void	* Y;
	static	off_t	len	= 0,	/* Of allocated segment */
			offset	= 0;	/* Amount used thereof	*/
	static	char	* where;
        char ebuf[256];

	assert(siz > 0); siz     = ((siz + 3) / 4) * 4;	/* Word align */
	if ((len - offset) < siz) {

		if (len==0)	len	= pz;
		else		len	+= pz;
		if (len < siz)	len	= siz;
		/*
		 sprintf(ebuf,"Yalloc: len=%d offset=%d l-d=%d siz=%d",
			len, offset, len-offset, siz);
		 logger(LOG_DEBUG,ebuf);
		*/
		where	= malloc(len);
		if (where == NULL) {
			sprintf(ebuf,"getoption cannot get memory (%d) %m",len);
			logger(LOG_ERR,ebuf);
			fprintf(stderr, "Emil: Yalloc cannot get memory\n");
			exit(EX_OSERR);
		}
		Y	= where;
		offset	= siz;
	}
	else {
		Y	= &where[offset];
		offset	+= siz;
	}
	bzero(Y,siz);
	return	Y;
}

#define	N_CONTEXT_TYPES	3	/* Mime, UUencode, Applefile */

struct	member_struct	{
	struct	member_struct	* mm;	/* Points to next      */
	char	*	name;	/* Of the config group	       */
	char	*	r;	/* Receiver selection criteria */
	char	*	s;	/* Sender   selection criteria */
	char	*	rmx;	/* Receiver MX        criteria */
};

struct	lookup_struct {
	struct	lookup_struct	* ll;
	char	* matchstring;
	char	* out;
};

struct mailer_struct {
  char    *name;
  char    *mailer[15];
  struct mailer_struct *next;
};
  

struct	lookup_struct	* table_start[N_CONTEXT_TYPES], 
			* table_end[N_CONTEXT_TYPES];

static	struct	config_struct	* g_start, /* Points to first group structure  */
				* g_end,   /* Points to the last group structure */	
				* gtmp;

static	struct	member_struct	* m_start, /* first member in chain */
				* m_end,   /* Last member in chain  */
				* mtmp;
static int                      ma_count;
static struct   mailer_struct   * ma_start,
                                * ma_end,
                                * matmp;

static	char	* group_name;

static	int	Ycmp(char * pattern, char * string)
{
	char	p[255], s[255]; char	* c, *d, *t; int i;
	int	cc;

	/* Copy / fold */

	for (c=pattern,d=p,i=(sizeof(p)-2); *c && i > 0; c++,d++,i--)
	  *d = tolower(*c);
	*d = 0;

	for (c=string, d=s,i=(sizeof(s)-2); *c && i > 0; c++,d++,i--) 
	  *d = tolower(*c);
	*d = 0;


	/* Compare */
	
#ifndef	NO_FNMATCH
	cc = fnmatch(p, s, 0) != FNM_NOMATCH; /* 941223/TW */
#else
	cc = ematch(p, s) == 0;
#endif
#ifdef DEBUG
	if (edebug)
	  {
	    if (cc)
	      fprintf(stderr, "+   Ycmp: %s matches %s.\n", string, pattern);
	    else
	      fprintf(stderr, "+   Ycmp: %s does not match %s.\n", string, pattern);
	  }
#endif
	return	cc;
}

extern 	char	* yytext;	/* defined by flex */

/* static	int	yywrap()
	{
		return	1;
	}
*/

#define	yywrap()	1

static	void	yyerror(char * msg)
{
	char	ebuf[2048];
	sprintf(ebuf,"Config file: %s at line %d around '%s'\n",msg,line_count+1, yytext);
	logger(LOG_ERR,ebuf);
	error_count++;
}
typedef union  {
	char * string;
	int	val;
} YYSTYPE;
#ifdef __cplusplus
#  include <stdio.h>
#  include <yacc.h>
#endif	/* __cplusplus */ 
# define COLON 257
# define COMMA 258
# define EQUALS 259
# define CHARSET 260
# define TEXTENC 261
# define HENC 262
# define FORMAT 263
# define BIN 264
# define GROUP 265
# define MAILER 266
# define MEMBER 267
# define EOR 268
# define MATCH 269
# define STRING 270
# define QSTRING 271
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif

/* __YYSCLASS defines the scoping/storage class for global objects
 * that are NOT renamed by the -p option.  By default these names
 * are going to be 'static' so that multi-definition errors
 * will not occur with multiple parsers.
 * If you want (unsupported) access to internal names you need
 * to define this to be null so it implies 'extern' scope.
 * This should not be used in conjunction with -p.
 */
#ifndef __YYSCLASS
# define __YYSCLASS static
#endif
YYSTYPE yylval;
__YYSCLASS YYSTYPE yyval;
typedef int yytabelem;
# define YYERRCODE 256


#include	"lex.yy.c"

struct	config_struct *	getoption(char * r, char * s, char * rmx)
{
	struct	member_struct	* mm;
	struct	config_struct	* gg;

#ifdef	YYDEBUG
	extern	int	yydebug;
	yydebug	= 1;
#endif

	if (should_load_config_file) {
		should_load_config_file = 0;
		if ((yyin = conf_fd)          == NULL &&
		    (yyin = fopen(MAINCF,"r"))==NULL) {
			char	ebuf[512];
			strcpy(ebuf,"Cannot open '");
			strcat(ebuf,MAINCF);
			strcat(ebuf,"' ");
			logger(LOG_ALERT,ebuf);
			return NULL;
		}
		if (yyparse())	return	NULL;
		fclose(yyin);
	}

	/* Look for member */

	for (mm = m_start; mm; mm = mm->mm)		/* Lookup member */
		if (Ycmp(mm->r,r) && Ycmp(mm->s,s) && Ycmp(mm->rmx,rmx))
			for (gg = g_start; gg; gg = gg->gg) /* Lookup group */
				if (strcasecmp(gg->name,mm->name)==0) 
					return gg;
	return	NULL;	/* group or member not found */
}

static	void	confextr_error(char * txt, char * context, char * match, char * output)
{
	char	buf[255];
	strcpy(buf,txt);
	strcat(buf," confextr(\"");
	if (context) strcat(buf,context); else strcat(buf,"<NULL>");
	strcat(buf,"\", \"");
	if (match) strcat(buf,match); else strcat(buf,"<NULL>");
	strcat(buf,"\", \"");
	if (output) strcat(buf,output); else strcat(buf,"<NULL>");
	strcat(buf,"\")");
	yyerror(buf);
}

char	* confextr(char * context, char * match, char * output)
{
	int	context_type;
	struct	lookup_struct	* l;

	if (should_load_config_file) {
		should_load_config_file = 0;
		if ((yyin = conf_fd)          == NULL &&
		    (yyin = fopen(MAINCF,"r"))==NULL) {
			perror("cannot open config file");
			return NULL;
		}
		if (yyparse())	return	NULL;
		fclose(yyin);
	}

	if 	(context == NULL || 
		(match == NULL && output == NULL) ||
		(match != NULL && output != NULL))	{
		confextr_error("Confextr: Invalid parameter combination",
			context,match,output);
		return NULL;
	}

	if	(strcasecmp(context,"MIME")==0)		context_type	= 0;
	else if	(strcasecmp(context,"UUENCODE")==0)	context_type	= 1;
	else if	(strcasecmp(context,"APPLEFILE")==0)	context_type	= 2;
	else	{
		confextr_error("Confextr: invalid context", context, match, output);
		return NULL;
	}

	if (match == NULL) {
		if (output == NULL)	return NULL;
		for (l = table_start[context_type]; l; l = l->ll)
			if (strcasecmp(l->out,output)==0) return	l->matchstring;
		confextr_error("Confextr: Info: Match not found", context, match, output);
		return	NULL;
	}
	else if (output == NULL) {
		if (match == NULL)	return NULL;
		for (l = table_start[context_type]; l; l = l->ll)
			if (strcasecmp(l->matchstring,match)==0) return	l->out;
		confextr_error("Confextr: Info: Output not found", context, match, output);
		return	NULL;
	}
	else	{
		confextr_error("Confextr: both match & output set", context, match, output);
		return	NULL;
	}
}



char **	get_mailer(char * mailer)
{
	struct	mailer_struct	* mm;

#ifdef	YYDEBUG
	extern	int	yydebug;
	yydebug	= 1;
#endif

	if (should_load_config_file) {
		should_load_config_file = 0;
		if ((yyin = conf_fd)          == NULL &&
		    (yyin = fopen(MAINCF,"r"))==NULL) {
			char	ebuf[512];
			strcpy(ebuf,"Cannot open '");
			strcat(ebuf,MAINCF);
			strcat(ebuf,"' ");
			logger(LOG_ALERT,ebuf);
			return NULL;
		}
		if (yyparse())	return	NULL;
		fclose(yyin);
	}

	/* Look for member */

	for (mm = ma_start; mm != NULL; mm = mm->next)		/* Lookup mailer */
	  {
	    if (cmatch(mm->name, mailer))
	      {
		char *c;
		int i;
		for (i = 0; mm->mailer[i] != NULL; i++)
		  {
		    c = mm->mailer[i];
		    if (*c == '$')
		      {
			c++;
			switch (*c) {
			case 's':
			case 'S':
			  mm->mailer[i] = sender;
			  break;
			case 'r':
			case 'R':
			  mm->mailer[i] = recipient;
			  break;
			default:
			  break;
			}
		      }
		  }
		return(mm->mailer);
	      }
	  }
	return NULL;
}

__YYSCLASS yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 23
# define YYLAST 83
__YYSCLASS yytabelem yyact[]={

     3,     5,     4,    14,     6,    29,    31,    52,    28,    50,
    49,    48,    47,    46,    42,    18,    10,     9,     8,     7,
    41,    21,    24,    25,    22,    23,    43,    33,    32,    39,
    40,    38,    37,    36,    35,    44,    34,    13,    12,    11,
    27,    19,    30,    20,    17,    26,    16,    15,     2,     1,
    53,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    45,     0,     0,     0,
     0,     0,    51 };
__YYSCLASS yytabelem yypact[]={

 -3000,  -265, -3000,  -251,  -252,  -253,  -254,  -218,  -219,  -220,
  -268, -3000, -3000, -3000,  -255,  -239,  -262,  -264,  -240,  -241,
  -222,  -225,  -226,  -227,  -228,  -230,  -238, -3000,  -256,  -242,
  -223, -3000, -3000, -3000,  -239,  -257,  -258,  -259,  -260,  -261,
 -3000,  -262,  -263, -3000,  -264, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000 };
__YYSCLASS yytabelem yypgo[]={

     0,    49,    48,    47,    41,    46,    45,    44,     5,    43,
    42,    40 };
__YYSCLASS yytabelem yyr1[]={

     0,     1,     1,     3,     2,     5,     2,     7,     2,     2,
     4,     4,     9,     9,     9,     9,     9,     8,     8,    10,
     6,     6,    11 };
__YYSCLASS yytabelem yyr2[]={

     0,     0,     4,     1,    12,     1,    12,     1,    12,    11,
     2,     6,     7,     7,     7,     7,     7,     2,     6,     3,
     2,     6,     7 };
__YYSCLASS yytabelem yychk[]={

 -3000,    -1,    -2,   265,   267,   266,   269,   270,   270,   270,
   270,   257,   257,   257,   271,    -3,    -5,    -7,   270,    -4,
    -9,   260,   263,   264,   261,   262,    -6,   -11,   270,    -8,
   -10,   270,   268,   268,   258,   259,   259,   259,   259,   259,
   268,   258,   270,   268,   258,    -4,   270,   270,   270,   270,
   270,   -11,   270,    -8 };
__YYSCLASS yytabelem yydef[]={

     1,    -2,     2,     0,     0,     0,     0,     0,     0,     0,
     0,     3,     5,     7,     0,     0,     0,     0,     0,     0,
    10,     0,     0,     0,     0,     0,     0,    20,     0,     0,
    17,    19,     9,     4,     0,     0,     0,     0,     0,     0,
     6,     0,     0,     8,     0,    11,    12,    13,    14,    15,
    16,    21,    22,    18 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

__YYSCLASS yytoktype yytoks[] =
{
	"COLON",	257,
	"COMMA",	258,
	"EQUALS",	259,
	"CHARSET",	260,
	"TEXTENC",	261,
	"HENC",	262,
	"FORMAT",	263,
	"BIN",	264,
	"GROUP",	265,
	"MAILER",	266,
	"MEMBER",	267,
	"EOR",	268,
	"MATCH",	269,
	"STRING",	270,
	"QSTRING",	271,
	"-unknown-",	-1	/* ends search */
};

__YYSCLASS char * yyreds[] =
{
	"-no such reduction-",
	"expressions : /* empty */",
	"expressions : expressions expression",
	"expression : GROUP STRING COLON",
	"expression : GROUP STRING COLON varvals EOR",
	"expression : MEMBER STRING COLON",
	"expression : MEMBER STRING COLON users EOR",
	"expression : MAILER STRING COLON",
	"expression : MAILER STRING COLON mailers EOR",
	"expression : MATCH STRING QSTRING STRING EOR",
	"varvals : varval",
	"varvals : varval COMMA varvals",
	"varval : CHARSET EQUALS STRING",
	"varval : FORMAT EQUALS STRING",
	"varval : BIN EQUALS STRING",
	"varval : TEXTENC EQUALS STRING",
	"varval : HENC EQUALS STRING",
	"mailers : mailera",
	"mailers : mailera COMMA mailers",
	"mailera : STRING",
	"users : user_definition",
	"users : users COMMA user_definition",
	"user_definition : STRING STRING STRING",
};
#endif /* YYDEBUG */
#define YYFLAG  (-3000)
/* @(#) $Revision: 70.7 $ */    

/*
** Skeleton parser driver for yacc output
*/

#if defined(NLS) && !defined(NL_SETN)
#include <msgbuf.h>
#endif

#ifndef nl_msg
#define nl_msg(i,s) (s)
#endif

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab

#ifndef __RUNTIME_YYMAXDEPTH
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#else
#define YYACCEPT	{free_stacks(); return(0);}
#define YYABORT		{free_stacks(); return(1);}
#endif

#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( (nl_msg(30001,"syntax error - cannot backup")) );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
/* define for YYFLAG now generated by yacc program. */
/*#define YYFLAG		(FLAGVAL)*/

/*
** global variables used by the parser
*/
# ifndef __RUNTIME_YYMAXDEPTH
__YYSCLASS YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
__YYSCLASS int yys[ YYMAXDEPTH ];		/* state stack */
# else
__YYSCLASS YYSTYPE *yyv;			/* pointer to malloc'ed value stack */
__YYSCLASS int *yys;			/* pointer to malloc'ed stack stack */

#if defined(__STDC__) || defined (__cplusplus)
#include <stdlib.h>
#else
	extern char *malloc();
	extern char *realloc();
	extern void free();
#endif /* __STDC__ or __cplusplus */


static int allocate_stacks(); 
static void free_stacks();
# ifndef YYINCREMENT
# define YYINCREMENT (YYMAXDEPTH/2) + 10
# endif
# endif	/* __RUNTIME_YYMAXDEPTH */
long  yymaxdepth = YYMAXDEPTH;

__YYSCLASS YYSTYPE *yypv;			/* top of value stack */
__YYSCLASS int *yyps;			/* top of state stack */

__YYSCLASS int yystate;			/* current state */
__YYSCLASS int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
__YYSCLASS int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - yyparse may be called more than once
	*/
# ifdef __RUNTIME_YYMAXDEPTH
	if (allocate_stacks()) YYABORT;
# endif
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
# ifndef __RUNTIME_YYMAXDEPTH
			yyerror( (nl_msg(30002,"yacc stack overflow")) );
			YYABORT;
# else
			/* save old stack bases to recalculate pointers */
			YYSTYPE * yyv_old = yyv;
			int * yys_old = yys;
			yymaxdepth += YYINCREMENT;
			yys = (int *) realloc(yys, yymaxdepth * sizeof(int));
			yyv = (YYSTYPE *) realloc(yyv, yymaxdepth * sizeof(YYSTYPE));
			if (yys==0 || yyv==0) {
			    yyerror( (nl_msg(30002,"yacc stack overflow")) );
			    YYABORT;
			    }
			/* Reset pointers into stack */
			yy_ps = (yy_ps - yys_old) + yys;
			yyps = (yyps - yys_old) + yys;
			yy_pv = (yy_pv - yyv_old) + yyv;
			yypv = (yypv - yyv_old) + yyv;
# endif

		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( (nl_msg(30003,"syntax error")) );
				yynerrs++;
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 3:{
			/* this backward method is becase we want to look at first hit */
			gtmp	= g_end;
			g_end  	= Yalloc(sizeof(struct config_struct));
			if (g_start == NULL) 	g_start	= g_end;
			else			gtmp->gg= g_end;
			strcpy((g_end->name=Yalloc(strlen(yypvt[-1].string)+1)),yypvt[-1].string);
		  } break;
case 5:{
			strcpy((group_name=Yalloc(strlen(yypvt[-1].string)+1)),yypvt[-1].string);
		  } break;
case 7:{
                        
                        matmp = ma_end;
                        ma_end = (struct mailer_struct *)Yalloc(sizeof(struct mailer_struct));                         
                        ma_end->name = NEWSTR(yypvt[-1].string);
                        if (ma_start == NULL)  ma_start = ma_end;
                        else                   matmp->next = ma_end;
                        ma_count = 0;
                  } break;
case 9:{
			/* Add a entry to match table */
			int	ctyp;
			struct	lookup_struct	* ttmp, ** ts, ** te;
			if	(strcasecmp(yypvt[-3].string,"MIME")==0)	ctyp	= 0;
			else if	(strcasecmp(yypvt[-3].string,"UUENCODE")==0)	ctyp	= 1;
			else if	(strcasecmp(yypvt[-3].string,"APPLEFILE")==0)	ctyp	= 2;
			else	{
				yyerror("Wrong context type for match");
				YYERROR;
			}
			ts = &table_start[ctyp]; te = &table_end[ctyp];
			ttmp		= *te;
			*te		= Yalloc(sizeof(struct lookup_struct));
			if (*ts == NULL)  *ts	= *te;
			else		ttmp->ll= *te;
			strcpy(((*te)->matchstring=Yalloc(strlen(yypvt[-2].string)+1)),yypvt[-2].string);
			strcpy(((*te)->out=Yalloc(strlen(yypvt[-1].string)+1)),yypvt[-1].string);
		} break;
case 12:{
			strcpy((g_end->charset	= Yalloc(strlen(yypvt[-0].string)+1)),yypvt[-0].string);
		  } break;
case 13:{
			strcpy((g_end->format	= Yalloc(strlen(yypvt[-0].string)+1)),yypvt[-0].string);
		  } break;
case 14:{
			strcpy((g_end->bin	= Yalloc(strlen(yypvt[-0].string)+1)),yypvt[-0].string);
		  } break;
case 15:{
			strcpy((g_end->text	= Yalloc(strlen(yypvt[-0].string)+1)),yypvt[-0].string);
		  } break;
case 16:{
			strcpy((g_end->header	= Yalloc(strlen(yypvt[-0].string)+1)),yypvt[-0].string);
		  } break;
case 19:{
                         ma_end->mailer[ma_count] = NEWSTR(yypvt[-0].string);
                         ma_count++;
                } break;
case 22:{
			mtmp	= m_end;
			m_end	= Yalloc(sizeof(struct	member_struct));
			if (m_start == NULL)	m_start	= m_end;
			else			mtmp->mm= m_end;
			m_end->name		= group_name;
			strcpy((m_end->r	= Yalloc(strlen(yypvt[-2].string)+1)),yypvt[-2].string);
			strcpy((m_end->s	= Yalloc(strlen(yypvt[-1].string)+1)),yypvt[-1].string);
			strcpy((m_end->rmx	= Yalloc(strlen(yypvt[-0].string)+1)),yypvt[-0].string);
		  } break;
	}
	goto yystack;		/* reset registers in driver code */
}

# ifdef __RUNTIME_YYMAXDEPTH

static int allocate_stacks() {
	/* allocate the yys and yyv stacks */
	yys = (int *) malloc(yymaxdepth * sizeof(int));
	yyv = (YYSTYPE *) malloc(yymaxdepth * sizeof(YYSTYPE));

	if (yys==0 || yyv==0) {
	   yyerror( (nl_msg(30004,"unable to allocate space for yacc stacks")) );
	   return(1);
	   }
	else return(0);

}


static void free_stacks() {
	if (yys!=0) free((char *) yys);
	if (yyv!=0) free((char *) yyv);
}

# endif  /* defined(__RUNTIME_YYMAXDEPTH) */

