/*
 *
 * Copyright (C) 1993 Swedish University Network (SUNET)
 *
 *
 * This program is developed by UDAC, Uppsala University by commission
 * of the Swedish University Network (SUNET). 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *                                          Martin.Wendel@udac.uu.se
 *
 *                                          Martin Wendel
 *                                          UDAC	
 *                                          Box 174
 *                                          S-751 04 Uppsala
 *                                          Sweden
 */






#include "mk.h"


long getlong();
bool all_text();


void
clearendspace(p)
     char *p;
{
  char *s;
  if (p != NULL && *p != '\0') 
    {    
      s = p;
      s += (strlen(p) - 1);
      while (*s == ' ' || *s == '\t') {
	if (s = p)
	  break;
	*s = '\0';
	s--;
      }
    }
}

int
clearend(p)
     char *p;
{
  char *s;
  int i = 0;
  if (p != NULL && *p != '\0') 
    {    
      s = p;
      s += (strlen(p) - 1);
      while (isspace(*s) && s >= p) {
	*s = '\0';
	s--;
	i++;
      }
    }
  return(i);
}

int
clearendlf(p)
     char *p;
{
  char *s;
  int i = 0;
  if (p != NULL && *p != '\0') 
    {    
      s = p;
      s += (strlen(p) - 1);
      while (s >= p && (*s == NL || *s == CR)) {
	*s = '\0';
	s--;
	i++;
      }
    }
  return(i);
}


int
getbits(a, b ,c)
     unsigned long a;
     unsigned long b;
     unsigned long c;
{
  int inp;
  inp = a;
  return(inp >> ((b - c) & ~(~0 << c)));
}


long
getlong(str, l)
char *str;
int l;
{
  int i;
  long outp = 0;
  for (i = 0; i < l; i++)
    {
      outp = outp << 8;
      outp = outp | (255 & *str++);
    }
  return(outp);
}



int
count_lfs(buf)
     char *buf;
{
  int i = 0;
  for (; *buf != '\0'; buf++)
    if (*buf == '\n')
      i++;
  return(i);
}

int
  count_high_char(buf)
char *buf;
{
  int c;
  c = 0;
  if (buf != NULL)
    for (; *buf != '\0'; buf++)
      if (*buf & 0x80)
	c++;
  return(c);
}



int
fixfilename(name)
char *name;
{
  char p;
  while (p = *++name)
    if (p <= ' ' || p == '/' || p >= '~')
      *name = '_';
}

int
setfilename(p)
char *p;
{
  char *s;
  fixfilename(p);
  if ((s = (char *)rindex(p, '.')) != NULL && s != p)
    {
      *s = '\0';
      s++;
      MkMess_Curr->extension = (char *)newstr(s);
      Mk_Log(LOG_DEBUG, "doing extension");
      
    }
  MkMess_Curr->filename = (char *)newstr(p);
  MkMess_Curr->filenamelen = strlen(p);
  Mk_Log(LOG_DEBUG, "filename set to %s", MkMess_Curr->filename);
}

int
joinextension()
{
  char *s;
  if (MkMess_Curr->filename && MkMess_Curr->extension)
    {
      s = rindex(MkMess_Curr->filename, '.');
      s++;
      if (!strcasecmp(s, MkMess_Curr->extension)) 
	return(0);
      s = (char *)xalloc(strlen(MkMess_Curr->filename) +
			 strlen(MkMess_Curr->extension) + 2);
      sprintf(s, "%s.%s", MkMess_Curr->filename,
	      MkMess_Curr->extension);
      free(MkMess_Curr->extension);
      free(MkMess_Curr->filename);
      MkMess_Curr->extension = NULL;
      MkMess_Curr->filename = s;
      MkMess_Curr->filenamelen = strlen(MkMess_Curr->filename);
    }
  if (MkMess_Curr->filename)  
    Mk_Log(LOG_DEBUG, "Filename set to %s", MkMess_Curr->filename);
}

