/* conv.c
 *
 * Reads a character set from stdin converts and outputs to stdout.
 */

#ifndef lint
static char *Rcsid = "@(#)$Header$";

#endif

/*
 *
 * $Log: conv.c,v $
 * Revision 1.4  1993-01-14 keld
 * Adapted to use the quoted-printable and base64 rutines.
 *
 * Revision 1.3  1991/04/05  17:06:30  paul
 * Eliminated constant strings passed as arguments.
 *
 * Revision 1.2  1991/04/05  15:56:39  paul
 * Adapted to use the new strcnv.c
 *
 */

/* #include "sendmail.h" /* */

#include <stdio.h>
#include <errno.h>
#include "iso646.h"
#include "charset.h"

#define SLEN	256		/* max length in octets of images */
#define Char   unsigned char
static CHARSET *in;
static CHARSET *out;

FILE *dfopen();
char *xalloc();
int getopt(), bincl2base();
Char *bin2qp(), *bin2base(), *binc2base(), *qp2bin(), *base2bin();

int bopt=0, uopt= 0, qopt=0, popt=0, errflg=0, ic;
int ipos;
Char oc ARRAY(SLEN),*op;

void
outqb(b,bm)
Char *b, *bm;
begin
	Char *i=b;
	if (qopt) do begin
            i= bin2qp(i,oc,bm); 
            fputs ((char *)oc, stdout); 
        end while (i<bm);
        else if (bopt) begin
	    for (;i<bm;i++) if (!(op=binc2base(*i,op,ipos++)))
	    begin
	        fputs ((char *)oc, stdout); 
                ipos=0; op=oc;
	    end
	end else fwrite ((char *)b, bm-b, 1, stdout); 
end


void
main (argc, argv)
	int	 argc;
	Char   **argv;
begin
	Char s ARRAY(SLEN), r ARRAY(SLEN), *opt=NULL, *o=r, c;
	char dk ARRAY(3), us ARRAY(3);
	int len;

	op= oc; ipos= 0;
	(void) strcpy(dk, "DK");
	(void) strcpy(us, "us");

	while ((ic = getopt(argc, argv, "buqp")) != EOF) {
		c = ic & 0377;
		switch(c) {
		case 'b': bopt++; break; /* encode base64 */
		case 'u': uopt++; break; /* uncode base64 */
		case 'q': qopt++; break; /* quote - make qp */
		case 'p': popt++; break; /* print - unmake qp */
		default: errflg++;
		}
	}

	if (errflg) {
		fprintf(stderr, "Usage: conv -buqp chset1 chset2\n");
		exit(1);
	}
	switch (argc) begin
	    case 1:
		in = getchset (dk, '&');
		out = getchset (us, DEFAULT_ESCAPE);
		break;

	    case 2: opt = *(argv+1) ; break;

	    case 3:
		in = getchset (*(argv+1), DEFAULT_ESCAPE);
		out = getchset (*(argv+2), DEFAULT_ESCAPE);
		break;

	    case 5:
		in = getchset (*(argv+1), (INT16S) atoi(*(argv+2)));
		out = getchset (*(argv+3), (INT16S) atoi(*(argv+4)));
		break;

	    default:
		printf ("\n\nUsage: %s charset-in   (esc-in)  charset-out  (esc-out)\n\n", *argv);
		exit (1);
	end

    if (not opt) begin
	if (in == NULL or out == NULL) begin
		printf ("\n\n*** Error: Unknown Charset/s\n\n");
		exit (1);
	end
	/*
	 * Should output records of unlimited length by outputting one part at
	 * a time.
	 */
	while (fgets ((char *)s, SLEN, stdin)) begin
		strncnv (out, in, r, s, SLEN);
		fputs ((char *)r, stdout);
	end
    end else if (popt or uopt or qopt)
    while (fgets((char *)s, SLEN, stdin)) begin
	len= strlen(s);
        if (popt) begin
		*(s+len-1) = 0;
		o= qp2bin(s,o);
		if (! *o) begin
		    outqb(r,o);
                    o= r;
		end
        end else if (uopt) begin
		o= base2bin(s,o);
		if (! *o) begin
		    outqb(r,o);
                    o= r;
		end
	end else outqb(s,s+len-1);
    end 
    else while ((len=fread((char *)s, 1, SLEN, stdin)) diff 0) outqb(s,s+len);
    if (uopt) outqb(r,o);
    if (bopt and ipos) begin
        bincl2base(op,ipos);
        fputs ((char *)oc, stdout); 
    end

    exit (0);
end
