/*
 *
 * Copyright (C) 1993 Swedish University Network (SUNET)
 *
 *
 * This program is developed by UDAC, Uppsala University by commission
 * of the Swedish University Network (SUNET). 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *                                          Martin.Wendel@udac.uu.se
 *
 *                                          Martin Wendel
 *                                          UDAC	
 *                                          Box 174
 *                                          S-751 04 Uppsala
 *                                          Sweden
 */






#include "mk.h"

int
  mkqueueup(fp, mk)
register FILE *fp;
MessageStruct *mk;
{
  int mkcount;
  HDR *hdr;
  SpecHeaderStruct *spec;
  mkcount = 0;
#ifdef EMILDEBUG
  Mk_Log(LOG_DEBUG, "Queueing message");
#endif
  for (; mk != NULL; mk = mk->next, mkcount++)
    {
      /* Mark count start */
      fprintf(fp, "M%i\n", mkcount);
      fflush(fp);
      
      /* Put the headers */
      for (hdr = mk->header; hdr != NULL; hdr = hdr->h_link)
	{
	  
	  if (hdr->h_field && hdr->h_value && *(hdr->h_field)) 
	    fprintf(fp, "H%s: %s\n", hdr->h_field, hdr->h_value);
	}

      /* Put the specheaders */
      for (spec = mk->specheader; spec != NULL; spec = spec->next)
	{
	  
	  if (spec->name)
	    fprintf(fp, "S%s\n", spec->name);
	  
	}
      /* Put maintype if root */
      
      if (!mkcount) {
	if (mk->maintype != NULL)
	  fprintf(fp, "m%s\n", mk->maintype);
      }
      
      if (mk->subtype != NULL)
	fprintf(fp, "A%s\n", mk->subtype);
      /* Put the booleans */
      fprintf(fp, "B");
      
      if (mk->dosubheaders)
	fprintf(fp, "T");
      else
	fprintf(fp, "F");
      if (mk->washeaders)
	fprintf(fp, "T");
      else
	fprintf(fp, "F");
      if (mk->dotunnel)
	fprintf(fp, "T");
      else
	fprintf(fp, "F");
      if (mk->ismulti)
	fprintf(fp, "T");
      else
	fprintf(fp, "F");
      fprintf(fp, "\n");
      
      
      /* Put start_line & end_line */
      fprintf(fp, "s%ld\n", mk->start_line);
      fprintf(fp, "e%ld\n", mk->end_line);
      
      
      /* Put charsets */
      
      if (mk->fcharset) 
	{
	  fprintf(fp, "Cf%s\n", mk->fcharset); 
	}
      
      fprintf(fp, "Ch%.8X\n", mk->highchars);
      
      /* Put filename */
      if (mk->filename != NULL)
	fprintf(fp, "F%.2X%s\n", mk->filenamelen, mk->filename);
      if (mk->extension != NULL)
	fprintf(fp, "f%s\n", mk->extension);
	
      /* Put filelength */
      if (mk->totlen)
	fprintf(fp, "t%.8X\n", mk->totlen);
      
      /* Put type */
      fprintf(fp, "T%.2X\n", mk->type);
      
      /* Put Encoding */
      fprintf(fp, "E%.2X:", mk->enc);
      if (mk->encoding)
	fprintf(fp, "%s", mk->encoding);
      fprintf(fp, "\n");
      
    }
  fflush(fp);
#ifdef EMILDEBUG
  Mk_Log(LOG_DEBUG, "Message queued");
#endif
}


/*
 * Read the Mk queue file and set a new message structure
 */

int
  mkreadqf(fp, mk)
FILE *fp;
MessageStruct *mk;
{
  char line[BUFSIZE];
  char tmp[BUFSIZE];
  int tmplen = 0;
  int linelen;
  int copylen;
#ifdef EMILDEBUG
  Mk_Log(LOG_DEBUG, "Reading queuefile");
#endif

  while (fgets(line, BUFSIZE, fp) != NULL)
    {
      clearend(line);
      if (line[0] == ' ' || line[0] == '\t' || tmplen == 0) 
	{
	  linelen = strlen(line);
	  copylen = ((tmplen + linelen) >= BUFSIZE) ? 
	    BUFSIZE - tmplen - 1 : linelen;
	  strncpy(&tmp[tmplen], line, copylen);
	  tmplen += copylen;
	}
      else
	{
	  tmp[tmplen] = '\0';
	  if(mkswitchqf(tmp, mk)) {
	    mk->next = (MessageStruct *)mkmessalloc();
	    mk = mk->next;
	  }
	  linelen = strlen(line);
	  copylen = (linelen >= BUFSIZE) ? 
	    BUFSIZE - 1 : linelen;
	  strncpy(tmp, line, copylen);
	  tmplen = copylen;
	}
    }
  if (tmplen != 0)
    {
      tmp[tmplen] = '\0';
      if (mkswitchqf(tmp, mk))
	{
	  mk->next = (MessageStruct *)mkmessalloc();
	  mk = mk->next;
	}
    }
#ifdef EMILDEBUG
  Mk_Log(LOG_DEBUG, "Done");
#endif
  
}


int
  mkswitchqf(line, mk)
char line[BUFSIZE];
MessageStruct *mk;
{
  char *part;

  switch (line[0]) 
    {
    case 'A':
      mk->subtype = newstr(&line[1]);
      break;
    case 'B':
      if (line[1] == 'T')
	mk->dosubheaders = TRUE;
      if (line[2] == 'T')
	mk->washeaders = TRUE;
      if (line[3] == 'T')
	mk->dotunnel = TRUE;
      if (line[4] == 'T')
	mk->ismulti = TRUE;
      break;
    case 'C': 
      {
	switch (line[1]) 
	  {
	  case 'f':
	    mk->fcharset = newstr(&line[2]);
	    break;
	  case 't':
	    mk->tcharset = newstr(&line[2]);
	    break;
	  case 'h':
	    mk->highchars = strtol(&line[2], (char **)NULL, 16);
	    break;
	  default:
	    break;
	  }
      }
      break;
    case 'E':
      part = (char *)index(line, ':');
      *part++ = '\0';
      mk->enc = strtol(&line[1], (char **)NULL, 16);
      if (*part)
	mk->encoding = newstr(part);
      break;
    case 'e':
      mk->end_line = strtol(&line[1], (char **)NULL, 10);
      Mk_Log(LOG_DEBUG, "end_line %i", mk->end_line);
      break;
    case 'F':
      mk->filename = newstr(&line[3]);
      line[3] = '\0';
      mk->filenamelen =(signed short) strtol(&line[1], (char **)NULL, 16);
      break;
    case 'f':
      mk->extension = newstr(&line[1]);
      break;
    case 'H':
#ifdef SENDMAIL
      if (MkMess_Root != mk)
#endif
	storeheader(&line[1], mk);
      break;
    case 'M': 
      if (line[1] != '0')
	{
	  return(1);
	}
      break;
    case 'm':
      mk->maintype = newstr(&line[1]);
      break;
    case 'S':
      storespecheader(&line[1], mk);
      break;
    case 's':
      mk->start_line = strtol(&line[1], (char **)NULL, 10);
      Mk_Log(LOG_DEBUG, "start_line %i", mk->start_line);
      break;
    case 'T':
      mk->type = strtol(&line[1], (char **)NULL, 16);
      break;
    case 't':
      mk->totlen = strtol(&line[1], (char **)NULL, 16);
      break;
    default:
      break;
    }
  return(0);
}


